/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom;

import jet.JSvrResource;
import jet.cs.jacl.JPrivilege;
import jet.server.jrc.security.PermissionUtil;

public class SecurityUtil {
    public static String createAclName(String string, int n) {
        if (n < 0) {
            n = -1;
        }
        String string2 = "JAcl[" + string + "@" + n + "]";
        return string2;
    }

    public static String getStringFromPermissionCode(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.VISIBLE)) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.READ)) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.WRITE)) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.EXECUTE)) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.SCHEDULE)) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.DELETE)) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.GRANT)) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    public static int getPermissionCodeFromString(String string) throws NumberFormatException {
        if (string.length() != 7) {
            throw new NumberFormatException(JSvrResource.getMessage("SECURITY_M_03015"));
        }
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            switch (c) {
                case '0': {
                    break;
                }
                case '1': {
                    n |= SecurityUtil.bit(n2);
                    break;
                }
            }
            ++n2;
        }
        return n;
    }

    public static String getStringFromPrivilegeCode(int n) {
        String string = Integer.toBinaryString(n);
        return string;
    }

    public static int getPrivilegeCodeFromString(String string) throws NumberFormatException {
        if (string.length() > 3) {
            throw new NumberFormatException(JSvrResource.getMessage("SECURITY_M_03009"));
        }
        int n = Integer.parseInt(string, 2);
        return n;
    }

    private static int bit(int n) {
        return 1 << (n & 0x1F);
    }
}

