/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db;

import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.SecurityListener;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserTable;
import jet.server.intf.security.User;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.Realm;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.custom.db.SecurityDBBasic;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.util.ServerUtil;

public class AuthenticationProviderDBImpl
implements AuthenticationProvider {
    private SecurityListener QOIV;

    public boolean isValidUser(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return false;
        }
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        User user = exCachedSecurityDataImpl.getIntegrityUser(string2);
        if (user == null) {
            return false;
        }
        if (user.isAccountDisable()) {
            return false;
        }
        if (this.QOIV(user)) {
            return false;
        }
        String string4 = user.getPassword();
        if (string3 == null) {
            string3 = "";
        }
        return string3.equals(string4);
    }

    private boolean QOIV(User user) {
        boolean bl = user.isNeverExpire();
        Date date = user.getLastModifyTime();
        long l = date.getTime();
        int n = user.getExpireTime();
        int n2 = user.getAuthType();
        if (n2 == 1) {
            return false;
        }
        if (bl) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(l);
        ((Calendar)gregorianCalendar2).add(5, n);
        return gregorianCalendar.after(gregorianCalendar2);
    }

    public boolean isAdminUser(String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        Vector vector = this.add(string, string2);
        return vector != null && vector.contains("administrators");
    }

    private Vector add(String string, String string2) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return vector;
        }
        BaseUser baseUser = exCachedSecurityDataImpl.getUser(string2);
        if (baseUser == null) {
            return vector;
        }
        Vector vector2 = baseUser.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            vector.add(object);
            this.getAllRoleNames(string, (String)object, vector);
        }
        object = baseUser.getGroupNames();
        int n = 0;
        while (n < ((Vector)object).size()) {
            String string3 = (String)((Vector)object).elementAt(n);
            this.after(string, string3, vector);
            ++n;
        }
        return vector;
    }

    private void after(String string, String string2, Vector vector) {
        Object object;
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return;
        }
        BaseGroup baseGroup = exCachedSecurityDataImpl.getGroup(string2);
        Vector vector2 = baseGroup.getRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            vector.add(object);
            this.getAllRoleNames(string, (String)object, vector);
        }
        object = baseGroup.getParentGroupNames();
        int n = 0;
        while (n < ((Vector)object).size()) {
            String string3 = (String)((Vector)object).elementAt(n);
            this.after(string, string3, vector);
            ++n;
        }
    }

    private void getAllRoleNames(String string, String string2, Vector vector) {
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return;
        }
        BaseRole baseRole = exCachedSecurityDataImpl.getRole(string2);
        if (baseRole == null) {
            return;
        }
        Vector vector2 = baseRole.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            vector.add(string3);
            this.getAllRoleNames(string, string3, vector);
        }
    }

    public String changePassword(String string, String string2, String string3, String string4, String string5) {
        boolean bl;
        Vector vector;
        if (string == null || string.length() == 0) {
            return JSvrResource.getMessage("SECURITY_M_05001");
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            return JSvrResource.getMessage("SECURITY_M_05002", string);
        }
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return JSvrResource.getMessage("SECURITY_M_05002", string);
        }
        if (string2 == null || string2.length() == 0) {
            return JSvrResource.getMessage("SECURITY_M_00006");
        }
        if (string3 == null || string3.length() == 0) {
            return JSvrResource.getMessage("SECURITY_M_00006");
        }
        UserTable userTable = securityDBBasic.getUserTable();
        User user = exCachedSecurityDataImpl.getIntegrityUser(string3);
        if (user == null) {
            return JSvrResource.getMessage("SVR_93", string3);
        }
        User user2 = exCachedSecurityDataImpl.getIntegrityUser(string2);
        if (user2 == null) {
            return JSvrResource.getMessage("SVR_93", string2);
        }
        String string6 = user.getPassword();
        String string7 = user2.getPassword();
        if (string4 == null) {
            string4 = "";
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string6 == null) {
            string6 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        String string8 = null;
        boolean bl2 = user.isEnableNullPS();
        if (!bl2) {
            if (string5.trim().length() == 0) {
                string8 = JSvrResource.getMessage("SVR_27");
            } else {
                int n = user.getMinPSLength();
                if (string5.length() < n) {
                    string8 = JSvrResource.getMessage("SVR_32", "" + n);
                }
            }
        }
        if (string8 != null) {
            return string8;
        }
        UserProfileTable userProfileTable = securityDBBasic.getUserProfileTable();
        boolean bl3 = false;
        if (!string2.equals(string3) && (vector = userProfileTable.getParentRolesName(string2)) != null && vector.contains("administrators")) {
            bl3 = true;
        }
        if (!bl3) {
            if (string2.equals("guest")) {
                return JSvrResource.getMessage("SECURITY_ERR_26_GUEST_NO_POWER_CHANGE_PS");
            }
            if (!string2.equals(string3)) {
                return JSvrResource.getMessage("SECURITY_ERR_27_USER_NO_POWER_CHANGE_PS");
            }
        }
        if (bl = userTable.updatePassword(string3, string5 = string5 == null || string5.length() == 0 ? ServerUtil.encode("NullPassword.jinfonet") : ServerUtil.encode(string5))) {
            return null;
        }
        return JSvrResource.getMessage("SECURITY_ERR_42_USER_CHANGE_PS_DB_FAILED");
    }

    public Iterator getRealmNames() {
        return Realm.getRealmNames();
    }

    public void addSecurityListener(SecurityListener securityListener) {
        this.QOIV = securityListener;
    }

    public boolean isEnableEdit() {
        return true;
    }
}

