/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db;

import java.io.IOException;
import java.util.Date;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.db.UpdateDetailsTableImpl;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.AclEntryTableImpl;
import jet.server.db.security2.AclTableImpl;
import jet.server.db.security2.AclsWithResourceRecord;
import jet.server.db.security2.AclsWithResourceTable;
import jet.server.db.security2.AclsWithResourceTableImpl;
import jet.server.db.security2.ExtendAclEntryRecord;
import jet.server.db.security2.ExtendAclEntryTable;
import jet.server.db.security2.ExtendAclEntryTableImpl;
import jet.server.db.security2.GUProfileTable;
import jet.server.db.security2.GUProfileTableImpl;
import jet.server.db.security2.GroupProfileTable;
import jet.server.db.security2.GroupProfileTableImpl;
import jet.server.db.security2.GroupTable;
import jet.server.db.security2.GroupTableImpl;
import jet.server.db.security2.RGProfileTable;
import jet.server.db.security2.RGProfileTableImpl;
import jet.server.db.security2.RoleProfileTable;
import jet.server.db.security2.RoleProfileTableImpl;
import jet.server.db.security2.RoleRecord;
import jet.server.db.security2.RoleTable;
import jet.server.db.security2.RoleTableImpl;
import jet.server.db.security2.UserProfileRecord;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserProfileTableImpl;
import jet.server.db.security2.UserRecord;
import jet.server.db.security2.UserTable;
import jet.server.db.security2.UserTableImpl;
import jet.server.jrc.JRDataService;
import jet.server.jrc.security.custom.SecurityUtil;
import jet.server.util.ServerUtil;
import jet.util.Base64;

public class SecurityDBBasic {
    public static final String NULL_PASSWORD = "NullPassword.jinfonet";
    private UserTable QOIV = null;
    private UserProfileTable addRecord = null;
    private RoleTable createAclName = null;
    private AclsWithResourceTable currentTimeMillis;
    private AclEntryTable decode;
    private RoleProfileTable encode = null;
    private GroupTable equals = null;
    private GroupProfileTable getAclEntryTable = null;
    private RGProfileTable getAclID = null;
    private GUProfileTable getAclsWithResourceTable = null;
    private ExtendAclEntryTable getAdminUser = null;
    public int defaultAclID;
    private String getAdminUserNameAndPS;

    public int getDefaultAclID() {
        return this.defaultAclID;
    }

    public SecurityDBBasic(JRDataService jRDataService, String string) {
        this.getAdminUserNameAndPS = string;
        this.addRecord(jRDataService);
        this.createAclName();
        this.currentTimeMillis();
        this.decode();
    }

    public SecurityDBBasic(Database database, String string) {
        this.getAdminUserNameAndPS = string;
        this.QOIV(database);
        this.createAclName();
        this.currentTimeMillis();
        this.I();
        this.decode();
    }

    private void QOIV(Database database) {
        UpdateDetailsTableImpl updateDetailsTableImpl = UpdateDetailsTableImpl.newInstance(database);
        this.QOIV = UserTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addRecord = UserProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.createAclName = RoleTableImpl.newInstance(database, updateDetailsTableImpl);
        this.currentTimeMillis = AclsWithResourceTableImpl.newInstance(database, updateDetailsTableImpl, AclTableImpl.newInstance(database, updateDetailsTableImpl));
        this.decode = AclEntryTableImpl.newInstance(database, updateDetailsTableImpl);
        this.equals = GroupTableImpl.newInstance(database);
        this.getAclEntryTable = GroupProfileTableImpl.newInstance(database);
        this.getAclID = RGProfileTableImpl.newInstance(database);
        this.getAclsWithResourceTable = GUProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.encode = RoleProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.getAdminUser = ExtendAclEntryTableImpl.newInstance(database, updateDetailsTableImpl);
    }

    private void addRecord(JRDataService jRDataService) {
        this.QOIV = jRDataService.getUserTable();
        this.addRecord = jRDataService.getUserProfileTable();
        this.createAclName = jRDataService.getRoleTable();
        this.currentTimeMillis = jRDataService.getAclsWithResourceTable();
        this.decode = jRDataService.getAclEntryTable();
        this.equals = jRDataService.getGroupTable();
        this.getAclEntryTable = jRDataService.getGroupProfileTable();
        this.getAclID = jRDataService.getRGProfileTable();
        this.getAclsWithResourceTable = jRDataService.getGUProfileTable();
        this.encode = jRDataService.getRoleProfileTable();
        this.getAdminUser = jRDataService.getExtendAclEntryTable();
    }

    private void createAclName() {
        String string = this.getAdminUserNameAndPS();
        if (string != null) {
            int n = string.indexOf(":");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if (string2 == null || string2.length() == 0) {
                string2 = "admin";
            }
            string3 = string3 == null || string3.length() == 0 ? ServerUtil.encode(NULL_PASSWORD) : ServerUtil.encode(string3);
            UserRecord userRecord = this.QOIV.getUserRecordbyUN(string2);
            UserRecord userRecord2 = this.QOIV.getAdminUser();
            boolean bl = false;
            if (userRecord2 == null) {
                bl = true;
            } else {
                String string4 = userRecord2.getName();
                if (string4.equals("guest")) {
                    bl = true;
                }
            }
            if (userRecord == null && bl) {
                this.QOIV.addRecord(string2, "JReport Administrator", "SystemBuild", "", new Date(System.currentTimeMillis()), string3, true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
            }
        } else {
            UserRecord userRecord = this.QOIV.getAdminUser();
            boolean bl = false;
            if (userRecord == null) {
                bl = true;
            } else {
                String string5 = userRecord.getName();
                if (string5.equals("guest")) {
                    bl = true;
                }
            }
            if (bl) {
                this.QOIV.addRecord("admin", "JReport Administrator", "SystemBuild", "", new Date(System.currentTimeMillis()), ServerUtil.encode("admin"), true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
            }
        }
        UserRecord userRecord = this.QOIV.getUserRecordbyUN("guest");
        if (userRecord == null) {
            this.QOIV.addRecord("guest", "guest", "SystemBuild", "", new Date(System.currentTimeMillis()), ServerUtil.encode(NULL_PASSWORD), true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
        }
    }

    public String getAdminUserNameAndPS() {
        String string;
        ExProperties exProperties = ServerEnv.getInstallProps();
        if (exProperties == null) {
            return "admin:admin";
        }
        String string2 = exProperties.getProperty("server.securityInfo");
        if (string2 == null || string2.length() == 0) {
            return "admin:admin";
        }
        try {
            byte[] byArray = Base64.decode((byte[])string2.getBytes());
            string = new String(byArray, "UTF8");
        }
        catch (IOException iOException) {
            string = "admin:admin";
        }
        return string;
    }

    private void currentTimeMillis() {
        UserProfileRecord userProfileRecord;
        RoleRecord roleRecord;
        UserRecord userRecord = this.QOIV.getAdminUser();
        String string = userRecord.getName();
        RoleRecord roleRecord2 = this.createAclName.getRole("administrators");
        if (roleRecord2 == null) {
            this.createAclName.addRecord("administrators", true, "SystemBuild", 0);
        }
        if ((roleRecord = this.createAclName.getRole("everyone")) == null) {
            this.createAclName.addRecord("everyone", true, "SystemBuild", 0);
            userProfileRecord = this.addRecord.getRecord("guest", "everyone");
            if (userProfileRecord == null) {
                this.addRecord.addRecord("guest", "everyone");
            }
            if (string != null && string.length() != 0 && (userProfileRecord = this.addRecord.getRecord(string, "everyone")) == null) {
                this.addRecord.addRecord(string, "everyone");
            }
        }
        if (string != null && string.length() != 0 && (userProfileRecord = this.addRecord.getRecord(string, "administrators")) == null) {
            this.addRecord.addRecord(string, "administrators");
        }
    }

    void I() {
        int n = this.currentTimeMillis.getRecordIDByResourcePath("/", -1);
        if (n >= 0) {
            return;
        }
        String string = SecurityUtil.createAclName("/", -1);
        AclsWithResourceRecord aclsWithResourceRecord = this.currentTimeMillis.addRecord("/", -1, string, "System", new Date(System.currentTimeMillis()));
        this.defaultAclID = aclsWithResourceRecord.getAclID();
        byte by = 2;
        this.decode.addRecord(this.defaultAclID, by, "everyone", true, 3);
    }

    private void decode() {
        ExtendAclEntryRecord extendAclEntryRecord = this.getAdminUser.getExtendAclEntryRecord("administrators", (byte)2);
        if (extendAclEntryRecord == null) {
            this.getAdminUser.addRecord("administrators", (byte)2, 7);
        }
    }

    public AclsWithResourceTable getAclsWithResourceTable() {
        return this.currentTimeMillis;
    }

    public AclEntryTable getAclEntryTable() {
        return this.decode;
    }

    public ExtendAclEntryTable getExAclEntrTable() {
        return this.getAdminUser;
    }

    public GroupProfileTable getGroupProfileTable() {
        return this.getAclEntryTable;
    }

    public GroupTable getGroupTable() {
        return this.equals;
    }

    public GUProfileTable getGuProfileTable() {
        return this.getAclsWithResourceTable;
    }

    public RGProfileTable getRgProfileTable() {
        return this.getAclID;
    }

    public RoleProfileTable getRoleProfileTable() {
        return this.encode;
    }

    public RoleTable getRoleTable() {
        return this.createAclName;
    }

    public UserProfileTable getUserProfileTable() {
        return this.addRecord;
    }

    public UserTable getUserTable() {
        return this.QOIV;
    }

    public String getRealmName() {
        return this.getAdminUserNameAndPS;
    }
}

