/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db.group;

import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.group.GroupProvider;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.GUProfileTable;
import jet.server.db.security2.GroupProfileRecord;
import jet.server.db.security2.GroupProfileTable;
import jet.server.db.security2.GroupRecord;
import jet.server.db.security2.GroupTable;
import jet.server.db.security2.RGProfileTable;
import jet.server.jrc.security.custom.db.SecurityDBBasic;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.log.ServiceLogger;

public class GroupProviderDBImpl
implements GroupProvider {
    public static String TAG_GROUP_DB_TYPE = "role_db_type";

    public Iterator getAllGroups(String string) throws JRCustomerException {
        Iterator iterator = null;
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        GroupTable groupTable = securityDBBasic.getGroupTable();
        Vector vector = groupTable.getAllGroups();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            GroupRecord groupRecord = (GroupRecord)vector.elementAt(n);
            String string2 = groupRecord.getName();
            vector2.add(string2);
            ++n;
        }
        iterator = vector2.iterator();
        return iterator;
    }

    public Properties getGroupProperties(String string, String string2) throws NoSuchGroupException, JRCustomerException {
        Properties properties = null;
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        GroupTable groupTable = securityDBBasic.getGroupTable();
        GroupRecord groupRecord = groupTable.getGroup(string2);
        if (groupRecord == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        properties = new Properties();
        properties.setProperty("group_name", string2);
        properties.setProperty("group_description", groupRecord.getDescription());
        String string3 = "false";
        if (groupRecord.getType() == 1) {
            string3 = "true";
        }
        properties.put(TAG_GROUP_DB_TYPE, string3);
        return properties;
    }

    public Iterator getSubGroups(String string, String string2) throws NoSuchGroupException, JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        GroupTable groupTable = securityDBBasic.getGroupTable();
        GroupProfileTable groupProfileTable = securityDBBasic.getGroupProfileTable();
        GroupRecord groupRecord = groupTable.getGroup(string2);
        if (groupRecord == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        Vector vector = groupProfileTable.getSubGroups(string2);
        return vector.iterator();
    }

    public void addGroup(String string, Properties properties) throws GroupExistsException, JRCustomerException {
        GroupRecord groupRecord;
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (properties == null || properties.size() == 0) {
            throw new JRCustomerException(630078);
        }
        String string2 = properties.getProperty("group_name");
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        GroupTable groupTable = securityDBBasic.getGroupTable();
        GroupRecord groupRecord2 = groupTable.getGroup(string2);
        if (groupRecord2 != null) {
            throw new GroupExistsException(630042, (Object[])new String[]{string2}, null);
        }
        String string3 = properties.getProperty("group_description", "");
        boolean bl = false;
        int n = 0;
        String string4 = properties.getProperty(TAG_GROUP_DB_TYPE);
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException, 3);
        }
        if (n == 1) {
            n = 1;
        }
        if ((groupRecord = groupTable.addRecord(string2, bl, string3, n)) == null) {
            throw new JRCustomerException(630077, (Object[])new String[]{string2}, null);
        }
    }

    public void removeGroup(String string, String string2) throws NoSuchGroupException, JRCustomerException {
        byte by;
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        GroupTable groupTable = securityDBBasic.getGroupTable();
        GroupProfileTable groupProfileTable = securityDBBasic.getGroupProfileTable();
        GUProfileTable gUProfileTable = securityDBBasic.getGuProfileTable();
        RGProfileTable rGProfileTable = securityDBBasic.getRgProfileTable();
        AclEntryTable aclEntryTable = securityDBBasic.getAclEntryTable();
        GroupRecord groupRecord = groupTable.getGroup(string2);
        if (groupRecord == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        boolean bl = groupTable.deleteGroup(string2);
        if (!bl) {
            throw new JRCustomerException(630076, (Object[])new String[]{string2}, null);
        }
        boolean bl2 = groupProfileTable.deleteRecordByGroupName(string2);
        boolean bl3 = groupProfileTable.deleteRecordBySubGroupName(string2);
        if (!bl2 || !bl3) {
            ServiceLogger.logError(3630050, string2, 3);
        }
        if (!gUProfileTable.deleteRecordByGroupName(string2)) {
            ServiceLogger.logError(3630051, string2, 3);
        }
        if (!rGProfileTable.deleteRecordByGroupName(string2)) {
            ServiceLogger.logError(3630052, string2, 3);
        }
        if (!aclEntryTable.deleteRecord(string2, by = 3)) {
            ServiceLogger.logError(3630053, string2, 3);
        }
    }

    public void addSubGroup(String string, String string2, String string3) throws NoSuchGroupException, GroupExistsException, JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        if (string3 == null || string3.length() == 0) {
            throw new JRCustomerException(630069);
        }
        GroupTable groupTable = securityDBBasic.getGroupTable();
        GroupRecord groupRecord = groupTable.getGroup(string2);
        if (groupRecord == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        GroupRecord groupRecord2 = groupTable.getGroup(string3);
        if (groupRecord2 == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        GroupProfileTable groupProfileTable = securityDBBasic.getGroupProfileTable();
        GroupProfileRecord groupProfileRecord = groupProfileTable.getRecord(string2, string3);
        if (groupProfileRecord != null) {
            Object[] objectArray = new String[]{string2, string3};
            ServiceLogger.logDebug(6630054, objectArray, 6);
            return;
        }
        GroupProfileRecord groupProfileRecord2 = groupProfileTable.addRecord(string2, string3);
        if (groupProfileRecord2 == null) {
            Object[] objectArray = new String[]{string3, string2};
            throw new JRCustomerException(630075, objectArray, null);
        }
    }

    public void removeSubGroup(String string, String string2, String string3) throws NoSuchGroupException, JRCustomerException {
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        if (string3 == null || string3.length() == 0) {
            throw new JRCustomerException(630069);
        }
        GroupTable groupTable = securityDBBasic.getGroupTable();
        GroupRecord groupRecord = groupTable.getGroup(string2);
        if (groupRecord == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        GroupRecord groupRecord2 = groupTable.getGroup(string3);
        if (groupRecord2 == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        GroupProfileTable groupProfileTable = securityDBBasic.getGroupProfileTable();
        boolean bl = groupProfileTable.deleteRecord(string2, string3);
        if (!bl) {
            Object[] objectArray = new String[]{string3, string2};
            throw new JRCustomerException(630074, objectArray, null);
        }
    }

    public boolean isEnableEdit() {
        return true;
    }
}

