/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db.user;

import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.user.UserProvider;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UserExistsException;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.GUProfileTable;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserRecord;
import jet.server.db.security2.UserTable;
import jet.server.jrc.security.custom.db.SecurityDBBasic;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.util.MiscTools;

public class UserProviderDBImpl
implements UserProvider {
    public static final String NULL_PASSWORD = "NullPassword.jinfonet";
    public static final String TAG_USER_DB_BUILDIN = "user_db_buildin";
    public static final String TAG_USER_DB_ACCESSED_EVENT_SUC = "user_db_access_event_suc";
    public static final String TAG_USER_DB_ACCESSED_EVENT_FAIL = "user_db_access_event_fail";
    public static final String TAG_USER_DB_MANAGEMENT_EVENT_SUC = "user_db_management_event_suc";
    public static final String TAG_USER_DB_MANAGEMENT_EVNET_FAIL = "user_db_management_event_fail";
    public static final String TAG_USER_DB_NOAUDIT = "user_db_noAudit";
    public static final String TAG_USER_DB_AUTHTYPE = "user_db_authType";
    public static final String TAG_USER_DB_LDAPTYPE = "user_db_ldapType";

    public Iterator getAllUsers(String string) throws JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        Iterator iterator = null;
        UserTable userTable = securityDBBasic.getUserTable();
        Vector vector = userTable.getAllUsersName();
        iterator = vector.iterator();
        return iterator;
    }

    public Properties getUserProperties(String string, String string2) throws NoSuchUserException, JRCustomerException {
        Properties properties = new Properties();
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630046);
        }
        if (!SecurityDBEnv.isBuiltinAPI) {
            properties.put("user_name", string2);
            return properties;
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        UserTable userTable = securityDBBasic.getUserTable();
        UserRecord userRecord = userTable.getUserRecordbyUN(string2);
        if (userRecord == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string2}, null);
        }
        properties.put("user_name", string2);
        properties.put("user_fullname", userRecord.getFullName());
        properties.put("user_description", userRecord.getDescription());
        properties.put("user_email", userRecord.getEmail());
        properties.put("user_create_time", userRecord.getCreateTime());
        String string3 = userRecord.getPassword();
        String string4 = ServerUtil.decode(string3);
        if (string4.equals(NULL_PASSWORD)) {
            string4 = "";
        }
        properties.put("user_password", string4);
        properties.put("user_enable_null_pwd", String.valueOf(userRecord.isEnableNullPS()));
        properties.put("user_last_modify_time", userRecord.getLastModifyTime());
        properties.put("user_never_expire", String.valueOf(userRecord.isNeverExpire()));
        properties.put("user_expire_time", String.valueOf(userRecord.getExpireTime()));
        properties.put("user_min_pwd_length", String.valueOf(userRecord.getMinPSLength()));
        properties.put("user_disabled_account", String.valueOf(userRecord.isAccountDisable()));
        properties.put(TAG_USER_DB_BUILDIN, String.valueOf(userRecord.isBuiltin()));
        properties.put(TAG_USER_DB_ACCESSED_EVENT_SUC, String.valueOf(userRecord.isAccessedEventSuc()));
        properties.put(TAG_USER_DB_ACCESSED_EVENT_FAIL, String.valueOf(userRecord.isAccessedEventFail()));
        properties.put(TAG_USER_DB_MANAGEMENT_EVENT_SUC, String.valueOf(userRecord.isManagementEventSuc()));
        properties.put(TAG_USER_DB_MANAGEMENT_EVNET_FAIL, String.valueOf(userRecord.isManagementEventFail()));
        properties.put(TAG_USER_DB_NOAUDIT, String.valueOf(userRecord.isNoAudit()));
        String string5 = "false";
        if (userRecord.getAuthType() == 1) {
            string5 = "true";
        }
        properties.put(TAG_USER_DB_AUTHTYPE, string5);
        properties.put(TAG_USER_DB_LDAPTYPE, string5);
        return properties;
    }

    public void addUser(String string, Properties properties) throws UserExistsException, JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (properties == null || properties.size() == 0) {
            throw new JRCustomerException(630048);
        }
        String string2 = properties.getProperty("user_name");
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630046);
        }
        UserTable userTable = securityDBBasic.getUserTable();
        UserRecord userRecord = userTable.getUserRecordbyUN(string2);
        if (userRecord != null) {
            throw new UserExistsException(630083, (Object[])new String[]{string2}, null);
        }
        String string3 = properties.getProperty("user_password", "");
        int n = 0;
        int n2 = 0;
        String string4 = properties.getProperty(TAG_USER_DB_LDAPTYPE);
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException, 3);
        }
        if (n == 1) {
            n2 = 1;
        }
        String string5 = properties.getProperty("user_fullname");
        String string6 = properties.getProperty("user_description", "");
        String string7 = properties.getProperty("user_email", "");
        Date date = (Date)properties.get("user_create_time");
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        boolean bl = false;
        String string8 = properties.getProperty("user_enable_null_pwd");
        if (string8 != null && string8.equalsIgnoreCase("true")) {
            bl = true;
        }
        int n3 = 6;
        String string9 = properties.getProperty("user_min_pwd_length");
        try {
            n3 = Integer.parseInt(string9);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRCustomerException(630049);
        }
        Date date2 = (Date)properties.get("user_last_modify_time");
        if (date2 == null) {
            date2 = new Date(System.currentTimeMillis());
        }
        boolean bl2 = false;
        String string10 = properties.getProperty("user_never_expire");
        if (string10 != null && string10.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        int n4 = 30;
        String string11 = properties.getProperty("user_expire_time");
        try {
            n4 = Integer.parseInt(string11);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRCustomerException(630050);
        }
        boolean bl3 = false;
        String string12 = properties.getProperty("user_disabled_account");
        if (string12 != null && string12.equalsIgnoreCase("true")) {
            bl3 = true;
        }
        String string13 = null;
        if (string2 == null || string2.trim().length() == 0) {
            string13 = JSvrResource.getMessage("SVR_21");
        } else if (!this.QOIV(string2)) {
            string13 = "Invalid user name:" + string2 + "\n" + "Valid name can contains only '_0-9a-zA-Z , . $ blankspace'";
        } else if (MiscTools.containChar((String)string5, (String)":")) {
            string13 = JSvrResource.getMessage("SVR_23", "\":\"");
        } else if (MiscTools.containChar((String)string6, (String)":")) {
            string13 = JSvrResource.getMessage("SVR_24", "\":\"");
        } else if (MiscTools.containChar((String)string7, (String)":")) {
            string13 = JSvrResource.getMessage("SVR_73", "\":\"");
        } else if (!bl2 && n4 < 0) {
            string13 = JSvrResource.getMessage("SVR_29");
        } else if (!bl) {
            if (string3 == null || string3.length() == 0) {
                string13 = JSvrResource.getMessage("SVR_27");
            }
            if (n3 < 0) {
                string13 = JSvrResource.getMessage("SVR_31");
            }
            if (string3.length() < n3) {
                string13 = JSvrResource.getMessage("SVR_32", "" + n3);
            }
        }
        if (string13 != null) {
            throw new JRCustomerException(string13);
        }
        UserRecord userRecord2 = userTable.addRecord(string2, string5, string6, string7, date, string3 = string3 == null || string3.length() == 0 ? ServerUtil.encode(NULL_PASSWORD) : ServerUtil.encode(string3), false, bl, n3, date2, bl2, n4, bl3, true, true, true, true, false, n, n2);
        if (userRecord2 == null) {
            throw new JRCustomerException(630051);
        }
    }

    public void setUser(String string, Properties properties) throws NoSuchUserException, JRCustomerException {
        boolean bl;
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (properties == null || properties.size() == 0) {
            throw new JRCustomerException(630048);
        }
        String string2 = properties.getProperty("user_name");
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630046);
        }
        UserTable userTable = securityDBBasic.getUserTable();
        UserRecord userRecord = userTable.getUserRecordbyUN(string2);
        if (userRecord == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string2}, null);
        }
        String string3 = userRecord.getPassword();
        if (string3 == null) {
            string3 = "";
        }
        int n = 0;
        int n2 = 0;
        String string4 = properties.getProperty(TAG_USER_DB_LDAPTYPE);
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException, 3);
        }
        if (n == 1) {
            n2 = 1;
        }
        String string5 = properties.getProperty("user_fullname");
        String string6 = properties.getProperty("user_description");
        String string7 = properties.getProperty("user_email");
        boolean bl2 = false;
        String string8 = properties.getProperty("user_enable_null_pwd");
        if (string8 != null && string8.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        int n3 = 6;
        String string9 = properties.getProperty("user_min_pwd_length");
        try {
            n3 = Integer.parseInt(string9);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRCustomerException(630049);
        }
        Date date = (Date)properties.get("user_last_modify_time");
        boolean bl3 = false;
        String string10 = properties.getProperty("user_never_expire");
        if (string10 != null && string10.equalsIgnoreCase("true")) {
            bl3 = true;
        }
        int n4 = 30;
        String string11 = properties.getProperty("user_expire_time");
        try {
            n4 = Integer.parseInt(string11);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRCustomerException(630050);
        }
        boolean bl4 = false;
        String string12 = properties.getProperty("user_disabled_account");
        if (string12 != null && string12.equalsIgnoreCase("true")) {
            bl4 = true;
        }
        String string13 = null;
        if (string2 == null || string2.trim().length() == 0) {
            string13 = JSvrResource.getMessage("SVR_21");
        } else if (!this.QOIV(string2)) {
            string13 = "Invalid user name:" + string2 + "\n" + "Valid name can contains only '_0-9a-zA-Z , . $ blankspace'";
        } else if (MiscTools.containChar((String)string5, (String)":")) {
            string13 = JSvrResource.getMessage("SVR_23", "\":\"");
        } else if (MiscTools.containChar((String)string6, (String)":")) {
            string13 = JSvrResource.getMessage("SVR_24", "\":\"");
        } else if (MiscTools.containChar((String)string7, (String)":")) {
            string13 = JSvrResource.getMessage("SVR_73", "\":\"");
        } else if (!bl3 && n4 < 0) {
            string13 = JSvrResource.getMessage("SVR_29");
        } else if (!bl2) {
            if (string3 == null || string3.length() == 0) {
                string13 = JSvrResource.getMessage("SVR_27");
            }
            if (n3 < 0) {
                string13 = JSvrResource.getMessage("SVR_31");
            }
            if (string3.length() < n3) {
                string13 = JSvrResource.getMessage("SVR_32", "" + n3);
            }
        }
        if (string13 != null) {
            throw new JRCustomerException(string13);
        }
        string3 = string3 == null || string3.length() == 0 ? ServerUtil.encode(NULL_PASSWORD) : ServerUtil.encode(string3);
        boolean bl5 = userTable.updateAttibutes(string2, string5, string6, string7, bl2, n3, date, bl3, n4, bl4, n, n2);
        if (!bl5) {
            throw new JRCustomerException(630052);
        }
        boolean bl6 = true;
        String string14 = properties.getProperty(TAG_USER_DB_ACCESSED_EVENT_SUC);
        if (string14 == null || !string14.equalsIgnoreCase("true")) {
            bl6 = false;
        }
        boolean bl7 = true;
        String string15 = properties.getProperty(TAG_USER_DB_ACCESSED_EVENT_FAIL);
        if (string15 == null || !string15.equalsIgnoreCase("true")) {
            bl7 = false;
        }
        boolean bl8 = true;
        String string16 = properties.getProperty(TAG_USER_DB_MANAGEMENT_EVENT_SUC);
        if (string16 == null || !string16.equalsIgnoreCase("true")) {
            bl8 = false;
        }
        boolean bl9 = true;
        String string17 = properties.getProperty(TAG_USER_DB_MANAGEMENT_EVNET_FAIL);
        if (string17 == null || !string17.equalsIgnoreCase("true")) {
            bl9 = false;
        }
        boolean bl10 = true;
        String string18 = properties.getProperty(TAG_USER_DB_NOAUDIT);
        if (string18 == null || !string18.equalsIgnoreCase("true")) {
            bl10 = false;
        }
        if (!(bl = userTable.updataEvent(string2, bl6, bl7, bl8, bl9, bl10))) {
            throw new JRCustomerException(630053, (Object[])new String[]{string2}, null);
        }
    }

    public void removeUser(String string, String string2) throws NoSuchUserException, JRCustomerException {
        byte by;
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630046);
        }
        UserTable userTable = securityDBBasic.getUserTable();
        UserProfileTable userProfileTable = securityDBBasic.getUserProfileTable();
        GUProfileTable gUProfileTable = securityDBBasic.getGuProfileTable();
        AclEntryTable aclEntryTable = securityDBBasic.getAclEntryTable();
        UserRecord userRecord = userTable.getUserRecordbyUN(string2);
        if (userRecord == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string2}, null);
        }
        if (!userTable.deleteRecord(string2)) {
            throw new JRCustomerException(630054, (Object[])new String[]{string2}, null);
        }
        if (!userProfileTable.deleteRecord(string2)) {
            ServiceLogger.logError(3630076, string2, 3);
        }
        if (!gUProfileTable.deleteRecordByUserName(string2)) {
            ServiceLogger.logError(3630077, string2, 3);
        }
        if (!aclEntryTable.deleteRecord(string2, by = 1)) {
            ServiceLogger.logError(3630078, string2, 3);
        }
    }

    public boolean isEnableEdit() {
        return true;
    }

    private boolean QOIV(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == ',' || c == '.' || c == ' ' || c == '$')) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

