/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.ldap.group;

import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.group.GroupProvider;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.custom.db.group.GroupProviderDBImpl;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPManager;

public class GroupProviderLDAPImpl
implements GroupProvider {
    LDAPManager QOIV = UserDataToolkit.getLdapManager();

    public Iterator getAllGroups(String string) throws JRCustomerException {
        Vector<String> vector = new Vector<String>();
        try {
            Vector vector2 = this.QOIV.getAllLDAPGroups();
            int n = 0;
            while (n < vector2.size()) {
                LDAPGroup lDAPGroup = (LDAPGroup)vector2.elementAt(n);
                vector.add(lDAPGroup.getName());
                ++n;
            }
        }
        catch (NamingException namingException) {
            throw new JRCustomerException(namingException);
        }
        return vector.iterator();
    }

    public Properties getGroupProperties(String string, String string2) throws NoSuchGroupException, JRCustomerException {
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        Vector[] vectorArray = null;
        try {
            vectorArray = this.QOIV.getLDAPGroup(string2);
        }
        catch (NamingException namingException) {
            throw new JRCustomerException(namingException);
        }
        if (vectorArray == null || vectorArray[0] == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        LDAPGroup lDAPGroup = (LDAPGroup)vectorArray[0].elementAt(0);
        if (lDAPGroup == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        Properties properties = new Properties();
        properties.setProperty("group_name", string2);
        properties.setProperty("group_description", lDAPGroup.getProperty("description"));
        properties.put(GroupProviderDBImpl.TAG_GROUP_DB_TYPE, "true");
        return properties;
    }

    public Iterator getSubGroups(String string, String string2) throws NoSuchGroupException, JRCustomerException {
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        Vector[] vectorArray = null;
        try {
            vectorArray = this.QOIV.getLDAPGroup(string2);
        }
        catch (NamingException namingException) {
            throw new JRCustomerException(namingException);
        }
        if (vectorArray == null || vectorArray[0] == null || vectorArray[0].elementAt(0) == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string2}, null);
        }
        LDAPGroup lDAPGroup = (LDAPGroup)vectorArray[0].elementAt(0);
        Vector vector = lDAPGroup.getSubGroupNames();
        return vector.iterator();
    }

    public void addGroup(String string, Properties properties) throws GroupExistsException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"GroupProviderLDAPImpl:addGroup()"}, null);
    }

    public void removeGroup(String string, String string2) throws NoSuchGroupException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"GroupProviderLDAPImpl:removeGroup()"}, null);
    }

    public void addSubGroup(String string, String string2, String string3) throws NoSuchGroupException, GroupExistsException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"GroupProviderLDAPImpl:addSubGroup()"}, null);
    }

    public void removeSubGroup(String string, String string2, String string3) throws NoSuchGroupException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"GroupProviderLDAPImpl:removeSubGroup()"}, null);
    }

    public boolean isEnableEdit() {
        return false;
    }
}

