/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import jet.server.jrc.security.ldap.LDAPData;
import jet.server.jrc.security.ldap.RelaxedX509TrustManager;
import jet.server.log.ServiceLogger;

public class JSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory QOIV;

    public JSocketFactory() throws Exception {
        TrustManager[] trustManagerArray = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
        sSLContext.init(null, trustManagerArray, new SecureRandom());
        this.QOIV = sSLContext.getSocketFactory();
    }

    public String[] getDefaultCipherSuites() {
        return this.QOIV.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.QOIV.getSupportedCipherSuites();
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        Socket socket = this.QOIV.createSocket(string, n);
        socket.setSoLinger(true, this.QOIV());
        return socket;
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = this.QOIV.createSocket(inetAddress, n);
        socket.setSoLinger(true, this.QOIV());
        return socket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        Socket socket = this.QOIV.createSocket(string, n, inetAddress, n2);
        socket.setSoLinger(true, this.QOIV());
        return socket;
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        Socket socket = this.QOIV.createSocket(inetAddress, n, inetAddress2, n2);
        socket.setSoLinger(true, this.QOIV());
        return socket;
    }

    public static SocketFactory getDefault() {
        try {
            return new JSocketFactory();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return SSLSocketFactory.getDefault();
        }
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        Socket socket2 = this.QOIV.createSocket(socket, string, n, bl);
        socket2.setSoLinger(true, this.QOIV());
        return socket;
    }

    private int QOIV() {
        int n = 0;
        String string = LDAPData.getProperty("socketTime");
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            n = 10;
        }
        return n * 1000;
    }
}

