/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.jrc.security.ldap.LDAPXMLReader;
import jet.server.jrc.security.ldap.LDAPXMLWriter;
import jet.server.jrc.security.ldap.NoSuchRoleMapException;
import jet.server.jrc.security.ldap.RoleMapImpl;
import jet.server.jrc.security.ldap.intf.RoleMap;
import jet.server.log.ServiceLogger;
import org.xml.sax.SAXException;

public class LDAPData {
    public static final String ENV_ENABLE_NONE_IMPORTED_LDAP_SUPPORT = "enableNoneImportedLDAPSupport";
    public static final String ENV_ENABLE_SUPPORT = "enableLDAPSupport";
    public static final String ENV_LDAP_VERSION = "ldapVersion";
    public static final String ENV_ENABLE_AUTO_IMPORT_LDAP_USER = "enableAutoImportLDAPUser";
    public static final String ENV_URL = "url";
    public static final String ENV_PASSWORD = "password";
    public static final String ENV_PORT = "serverPort";
    public static final String ENV_DIRECTORY_MANAGER_DN = "directoryManagerDN";
    public static final String ENV_ROOT = "rootEntry";
    public static final String ENV_SSL = "isUsingSSL";
    public static final String ENV_SOCKETTIME = "socketTime";
    public static final String ENV_IMPORT_GROUP_TYPE = "importGroupType";
    public static final String ENV_USER_SCHEME_USERID = "userAN";
    public static final String ENV_USER_SCHEME_COMMONNAME = "userCN";
    public static final String ENV_USER_SCHEME_PASSWROD = "userPassword";
    public static final String ENV_USER_SCHEME_DN = "userDN";
    public static final String ENV_USER_SCHEME_FILTER = "userFilter";
    public static final String ENV_GROUP_SCHEME_COMMONNAME = "groupCN";
    public static final String ENV_GROUP_SCHEME_MEMBERTYPE = "groupMemeberType";
    public static final String ENV_GROUP_SCHEME_DN = "groupDN";
    public static final String ENV_GROUP_SCHEME_FILTER = "groupFilter";
    public static final String ENV_GROUP_SCHEME_ADMINGROUP = "groupAdminGroup";
    public static final String OPT_USER_SETTING = "Current Settings";
    public static final String OPT_NDS_SETTING = "Novell Directory Server";
    public static final String OPT_IPLANET_SETTING = "iPlanet Directory Server";
    public static final String OPT_MS_SITE_SETTING = "Microsoft Site Server";
    public static final String OPT_OPENLDAP_SETTING = "OpenLDAP Directory Server";
    public static final String OPT_WIN2000AD_SETTING = "Win2000 Active Directory";
    public static final String OPT_LOTUSDOMINO_SETTING = "Lotus Domino on NT";
    private static Hashtable QOIV = new Hashtable();
    private static Hashtable add = new Hashtable();
    private static String addNewRoleMap = "";
    private static String contains = "";

    public static void setPath(String string) {
        LDAPXMLWriter.setPath(string);
        LDAPXMLReader.setPath(string);
        LDAPData.QOIV();
    }

    private static void QOIV() {
        try {
            LDAPXMLReader.read();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ServiceLogger.logError(parserConfigurationException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        catch (SAXException sAXException) {
            ServiceLogger.logError(sAXException);
        }
        QOIV = LDAPXMLReader.getLDAPConfig();
        addNewRoleMap = LDAPXMLReader.getTaskID();
        contains = LDAPXMLReader.getEncode();
        add = LDAPXMLReader.getRoleMaps();
    }

    public static Hashtable getLDAPProperties() {
        return QOIV;
    }

    public static String getProperty(String string) {
        return (String)QOIV.get(string);
    }

    public static boolean editLDAPProperties(String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        if (LDAPXMLWriter.setLDAPProperties(string, string2)) {
            QOIV.put(string, string2);
            return true;
        }
        return false;
    }

    public static boolean replaceProperties(Hashtable hashtable) {
        if (LDAPXMLWriter.writeLDAPConfigInfo(hashtable)) {
            LDAPData.refresh();
            return true;
        }
        return false;
    }

    public static String getTaskID() {
        return addNewRoleMap;
    }

    public static boolean editTaskID(String string) {
        if (string == null) {
            return false;
        }
        if (LDAPXMLWriter.editTaskID(string)) {
            addNewRoleMap = string;
            return true;
        }
        return false;
    }

    public static String getEncode() {
        return contains;
    }

    public static boolean editEncode(String string) {
        if (string == null) {
            return false;
        }
        if (LDAPXMLWriter.editEncode(string)) {
            contains = string;
            return true;
        }
        return false;
    }

    public static Vector getRoleMaps() {
        Vector<RoleMap> vector = new Vector<RoleMap>();
        Enumeration enumeration = add.elements();
        while (enumeration.hasMoreElements()) {
            RoleMap roleMap = (RoleMap)enumeration.nextElement();
            if (vector.contains(roleMap)) continue;
            vector.add(roleMap);
        }
        return vector;
    }

    public static RoleMap getRoleMap(String string) throws NoSuchRoleMapException {
        if (!add.containsKey(string)) {
            throw new NoSuchRoleMapException(630081, (Object[])new String[]{string}, null);
        }
        RoleMap roleMap = (RoleMap)add.get(string);
        return roleMap;
    }

    public static boolean addRoleMap(String string, String string2, String string3) {
        RoleMapImpl roleMapImpl = new RoleMapImpl(string, string2, string3);
        if (LDAPXMLWriter.addNewRoleMap(roleMapImpl)) {
            add.put(roleMapImpl.getName(), roleMapImpl);
            return true;
        }
        return false;
    }

    public static boolean eidtRoleMap(String string, String string2, String string3) throws NoSuchRoleMapException {
        if (!add.containsKey(string)) {
            throw new NoSuchRoleMapException(630081, (Object[])new String[]{string}, null);
        }
        RoleMap roleMap = (RoleMap)add.get(string);
        if (LDAPXMLWriter.editRoleMap(string, string2, string3)) {
            roleMap.setRoleName(string3);
            roleMap.setSearchFilter(string2);
            return true;
        }
        return false;
    }

    public static boolean removeRoleMap(String string) throws NoSuchRoleMapException {
        if (!add.containsKey(string)) {
            throw new NoSuchRoleMapException(630081, (Object[])new String[]{string}, null);
        }
        if (LDAPXMLWriter.removeRoleMap(string)) {
            add.remove(string);
            return true;
        }
        return false;
    }

    public static void refresh() {
        LDAPData.QOIV();
    }
}

