/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import jet.JSvrResource;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.admin.cfg.SynchronizationResult;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.security.ldap.LDAPConnectionImpl;
import jet.server.jrc.security.ldap.LDAPData;
import jet.server.jrc.security.ldap.LDAPEnvironments;
import jet.server.jrc.security.ldap.LDAPSynResultXMLReader;
import jet.server.jrc.security.ldap.LDAPSynResultXMLWriter;
import jet.server.jrc.security.ldap.NoSuchRoleMapException;
import jet.server.jrc.security.ldap.RoleMapExistException;
import jet.server.jrc.security.ldap.SynchronizationResultImpl;
import jet.server.jrc.security.ldap.intf.LDAPConnection;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.jrc.security.ldap.intf.RoleMap;
import jet.server.log.ServiceLogger;
import org.xml.sax.SAXException;

public class LDAPManagerImpl
implements LDAPManager {
    private LDAPEnvironments QOIV = new LDAPEnvironments();
    private LDAPConnection ReaderFile;
    private SynchronizationResult add;
    String addElement = "";
    boolean addRoleMap = false;
    boolean append = false;
    String class$ = "role";
    static Class class$jet$server$jrc$security$ldap$LDAPSynchronizeTask;

    public LDAPManagerImpl() {
        String string;
        String string2 = this.QOIV.getProperty("enableLDAPSupport");
        if (string2 != null) {
            this.addRoleMap = string2.equals("true");
        }
        if ((string = this.QOIV.getProperty("enableNoneImportedLDAPSupport")) != null) {
            this.append = string.equals("true");
        }
        this.ReaderFile = new LDAPConnectionImpl(this.QOIV);
        this.addElement = LDAPData.getTaskID();
        String string3 = this.QOIV.getProperty("importGroupType");
        this.class$ = string3 == null || string3.length() == 0 ? "role" : string3;
        if (this.addRoleMap) {
            this.ReaderFile.connect();
        }
        String string4 = ServerEnv.propertiesPath + "LDAPSynResult.xml";
        this.add = this.ReaderFile(string4);
    }

    private void QOIV() {
        String string;
        this.QOIV.refresh();
        String string2 = this.QOIV.getProperty("enableLDAPSupport");
        if (string2 != null) {
            this.addRoleMap = string2.equals("true");
        }
        this.class$ = (string = this.QOIV.getProperty("importGroupType")) == null || string.length() == 0 ? "role" : string;
        if (this.addRoleMap) {
            this.ReaderFile.reconnect(this.QOIV);
        } else {
            this.ReaderFile.disconnect();
        }
    }

    public boolean editProperty(String string, String string2) {
        if (LDAPData.editLDAPProperties(string, string2)) {
            this.QOIV();
            return true;
        }
        return false;
    }

    public Hashtable getLDAPProperties() {
        return this.QOIV.getLDAPProperties();
    }

    public boolean isImportToRole() {
        return this.class$.equalsIgnoreCase("role");
    }

    public boolean isLDAPEnable() {
        return this.addRoleMap;
    }

    public boolean isEnableNoneImportedLDAPSupport() {
        return this.append;
    }

    public boolean isConnect() {
        if (!this.addRoleMap) {
            return false;
        }
        return this.ReaderFile.connect();
    }

    public boolean isConnect(LDAPEnvironments lDAPEnvironments) {
        this.QOIV = lDAPEnvironments;
        String string = lDAPEnvironments.getProperty("enableLDAPSupport");
        boolean bl = false;
        if (string != null) {
            bl = string.equals("true");
        }
        if (!bl) {
            return false;
        }
        return this.ReaderFile.reconnect(lDAPEnvironments);
    }

    public boolean savePropertiese(Hashtable hashtable) {
        if (this.QOIV.replaceProperties(hashtable)) {
            this.QOIV();
            return true;
        }
        return false;
    }

    public boolean isValidLdapUser(String string, String string2) {
        if (!this.addRoleMap) {
            return false;
        }
        return this.ReaderFile.isValidLDAPUser(string, string2);
    }

    public boolean isValidLdapUserByDN(String string, String string2, String string3) {
        if (!this.addRoleMap) {
            return false;
        }
        return this.ReaderFile.isValidLDAPUserByDN(string, string2, string3);
    }

    public LDAPUser getLDAPUser(String string) throws NamingException {
        if (!this.addRoleMap) {
            throw new NamingException("LDAP support disable!");
        }
        return this.ReaderFile.getLDAPUser(string);
    }

    public Vector[] getLDAPGroup(String string) throws NamingException {
        if (!this.addRoleMap) {
            throw new NamingException("LDAP support disable!");
        }
        return this.ReaderFile.getLDAPGroup(string);
    }

    public Vector getAllLDAPUsers() throws NamingException {
        Vector<LDAPUser> vector = new Vector<LDAPUser>();
        if (!this.addRoleMap) {
            throw new NamingException("LDAP support disable!");
        }
        Enumeration enumeration = this.ReaderFile.getAllLDAPUsers().elements();
        while (enumeration.hasMoreElements()) {
            LDAPUser lDAPUser = (LDAPUser)enumeration.nextElement();
            vector.addElement(lDAPUser);
        }
        return vector;
    }

    public Vector getAllLDAPGroups() throws NamingException {
        Vector vector = new Vector();
        if (!this.addRoleMap) {
            throw new NamingException("LDAP support disable!");
        }
        Enumeration enumeration = this.ReaderFile.getAllLDAPGroups().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Hashtable getAllLDAPUsersHT() throws NamingException {
        if (!this.addRoleMap) {
            throw new NamingException("LDAP support disable!");
        }
        return this.ReaderFile.getAllLDAPUsers();
    }

    public Hashtable getAllLDAPGroupsHT() throws NamingException {
        if (!this.addRoleMap) {
            throw new NamingException("LDAP support disable!");
        }
        return this.ReaderFile.getAllLDAPGroups();
    }

    public Vector getRoleMaps() {
        return LDAPData.getRoleMaps();
    }

    public RoleMap getRoleMap(String string) throws NoSuchRoleMapException {
        return LDAPData.getRoleMap(string);
    }

    public boolean editRoleMap(String string, String string2, String string3) throws NoSuchRoleMapException {
        return LDAPData.eidtRoleMap(string, string2, string3);
    }

    public boolean removeRoleMap(String string) throws NoSuchRoleMapException {
        return LDAPData.removeRoleMap(string);
    }

    public boolean addRoleMap(String string, String string2) throws RoleMapExistException {
        String string3 = "RoleMap: [" + string.hashCode() + string2.hashCode() + System.currentTimeMillis() + "]";
        return LDAPData.addRoleMap(string3, string, string2);
    }

    public String addNewRoleMap(String string, String string2) throws RoleMapExistException {
        String string3 = "RoleMap: [" + string.hashCode() + string2.hashCode() + System.currentTimeMillis() + "]";
        boolean bl = LDAPData.addRoleMap(string3, string, string2);
        if (bl) {
            return string3;
        }
        return null;
    }

    public Vector getRoleNamsByFilter(String string) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.getRoleMaps();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            RoleMap roleMap = (RoleMap)enumeration.nextElement();
            String string2 = roleMap.getSearchFilter();
            String string3 = roleMap.getRoleName();
            boolean bl = this.isInFilter(string2, string);
            if (!bl) continue;
            vector.add(string3);
        }
        return vector;
    }

    public String testFilter(String string) {
        if (!this.addRoleMap) {
            return "LDAP support is disabled.";
        }
        try {
            return this.ReaderFile.testFilter(string);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return JSvrResource.getMessage("SECURITY_ERR_57_LDAP_ROLEMAP_TEST_FAILED");
        }
    }

    public boolean isInFilter(String string, String string2) {
        if (!this.addRoleMap) {
            ServiceLogger.logError(3630055, 3);
            return false;
        }
        try {
            return this.ReaderFile.isInFilter(string, string2);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    public boolean isLDAPScheduleEnable() {
        if (this.addElement == null || this.addElement.length() == 0) {
            return false;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        Properties properties = httpRptServer.getScheduledTask(this.addElement);
        if (properties == null) {
            return false;
        }
        String string = (String)properties.get("jrs.is_enabled");
        return string.equals("true");
    }

    public Properties getSynchronizeSchedule() {
        if (this.addElement == null || this.addElement.trim().length() == 0) {
            return null;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        Properties properties = httpRptServer.getScheduledTask(this.addElement);
        return properties;
    }

    public boolean disableSynSchedule() {
        if (this.addElement == null || this.addElement.length() == 0) {
            return false;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        return httpRptServer.disableScheduledTask(this.addElement);
    }

    public boolean enableSynSchedule() {
        if (this.addElement == null || this.addElement.length() == 0) {
            return false;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        return httpRptServer.enableScheduledTask(this.addElement);
    }

    public boolean deleteSynSchedule() {
        if (this.addElement == null || this.addElement.length() == 0) {
            return false;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        if (httpRptServer.removeScheduledTask(this.addElement)) {
            if (LDAPData.editTaskID("")) {
                this.addElement = null;
                return true;
            }
            ServiceLogger.logDebug(6630056, 6);
        } else {
            ServiceLogger.logDebug(6630057, 6);
        }
        return false;
    }

    public boolean exportSynResultToXMLFile(String string, SynchronizationResult synchronizationResult) {
        LDAPSynResultXMLWriter lDAPSynResultXMLWriter = new LDAPSynResultXMLWriter(synchronizationResult);
        try {
            lDAPSynResultXMLWriter.writeSynInfo();
            lDAPSynResultXMLWriter.writeXMLToFile(string);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
            return false;
        }
        this.add = synchronizationResult;
        return true;
    }

    private SynchronizationResult ReaderFile(String string) {
        LDAPSynResultXMLReader lDAPSynResultXMLReader = new LDAPSynResultXMLReader();
        File file = new File(string);
        if (file.exists()) {
            try {
                return lDAPSynResultXMLReader.ReaderFile(string);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            catch (SAXException sAXException) {
                ServiceLogger.logError(sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ServiceLogger.logError(parserConfigurationException);
            }
        }
        return new SynchronizationResultImpl();
    }

    public boolean submitSynchronizeSchedule(Properties properties, String string) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        properties.put("jrs.task_class", (class$jet$server$jrc$security$ldap$LDAPSynchronizeTask == null ? (class$jet$server$jrc$security$ldap$LDAPSynchronizeTask = LDAPManagerImpl.class$("jet.server.jrc.security.ldap.LDAPSynchronizeTask")) : class$jet$server$jrc$security$ldap$LDAPSynchronizeTask).getName());
        if (this.addElement == null || this.addElement.length() == 0) {
            try {
                this.addElement = httpRptServer.submitScheduledTask(string, properties);
                return LDAPData.editTaskID(this.addElement);
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError(rptServerException);
                return false;
            }
        }
        properties.put("jrs.task_id", this.addElement);
        try {
            httpRptServer.submitScheduledTask(string, properties);
            return true;
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError(rptServerException);
            return false;
        }
    }

    public SynchronizationResult getLastSynScheduleResult() {
        return this.add;
    }

    public Vector getLDAPGroupsNameByUser(String string) throws NamingException {
        return this.ReaderFile.getLDAPUserParentGroupNames(string);
    }

    public String getSocketTimeStr() {
        String string = this.QOIV.getProperty("socketTime");
        if (string == null || string.length() == 0) {
            return "10";
        }
        return string;
    }

    public String getAdminGroupName() {
        String string = this.QOIV.getProperty("groupAdminGroup");
        if (string == null) {
            return "";
        }
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

