/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.jrc.security.ldap.RoleMapImpl;
import jet.server.util.ServerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LDAPXMLReader {
    private static String QOIV;
    private static Node append;
    private static Hashtable close;
    private static Hashtable containsKey;
    private static String decode;
    private static String equals;
    public static final String LDAP = "LDAP";
    public static final String LDAP_CONFIGURATION = "LDAP-configuration";
    public static final String LDAP_NAME = "LDAP-name";
    public static final String LDAP_BASEINFO = "LDAP-baseInfo";
    public static final String LDAP_USERINFO = "LDAP-userSchemaInfo";
    public static final String LDAP_GROUPINFO = "LDAP-groupSchemaInfo";
    public static final String LDAP_ROLEMAPS = "LDAP-roleMaps";
    public static final String ROLEMAP = "roleMap";
    public static final String ROLEMAP_NAME = "roleMap-name";
    public static final String ROLEMAP_SEARCHFILTER = "roleMap-searchFilter";
    public static final String ROLEMAP_BINDINGROLENAME = "roleMap-bindingRoleName";
    public static final String LDAP_SCHEDULE_TASK_ID = "LDAP-scheduleTaskID";
    public static final String LDAP_ENCODE = "LDAP-encode";
    public static final String NULL_LDAP_PASSWORD = "jinfonet_ldap_null";

    public static void setPath(String string) {
        QOIV = string + "LDAPProperties.xml";
    }

    public static Hashtable getLDAPConfig() {
        return close;
    }

    public static String getTaskID() {
        return decode;
    }

    public static Hashtable getRoleMaps() {
        return containsKey;
    }

    public static void read() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(QOIV)));
        Document document = documentBuilder.parse(bufferedInputStream);
        bufferedInputStream.close();
        append = document.getDocumentElement();
        LDAPXMLReader.getProperties();
    }

    private static void getProperties() {
        NodeList nodeList = append.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (string != null && string.equals(LDAP_CONFIGURATION)) {
                LDAPXMLReader.QOIV(node);
            }
            if (string != null && string.equals(LDAP_SCHEDULE_TASK_ID)) {
                LDAPXMLReader.setTaskID(node);
            }
            if (string != null && string.equals(LDAP_ENCODE)) {
                LDAPXMLReader.setEncode(node);
            }
            if (string != null && string.equals(LDAP_ROLEMAPS)) {
                LDAPXMLReader.append(node);
            }
            ++n;
        }
    }

    private static void QOIV(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if (string.equals(LDAP_NAME) || string.equals(LDAP_BASEINFO) || string.equals(LDAP_USERINFO) || string.equals(LDAP_GROUPINFO)) {
                LDAPXMLReader.QOIV(node2);
            } else if (node2.getNodeType() == 1) {
                Node node3 = node2.getFirstChild();
                string = string.substring(4);
                if (node3 != null) {
                    String string2 = node3.getNodeValue();
                    if (string.equals("password") && (string2 = ServerUtil.decode(string2)).equals(NULL_LDAP_PASSWORD)) {
                        string2 = "";
                    }
                    close.put(string, string2);
                } else {
                    close.put(string, "");
                }
            }
            ++n;
        }
    }

    private static void setTaskID(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return;
        }
        decode = node2.getNodeValue();
    }

    private static void append(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2 != null && node2.getNodeName().equals(ROLEMAP)) {
                LDAPXMLReader.close(node2);
            }
            ++n;
        }
    }

    private static void close(Node node) {
        NodeList nodeList = node.getChildNodes();
        RoleMapImpl roleMapImpl = new RoleMapImpl();
        int n = 0;
        while (n < nodeList.getLength()) {
            block5: {
                block8: {
                    String string;
                    Node node2;
                    String string2;
                    Node node3;
                    block7: {
                        block6: {
                            node3 = nodeList.item(n);
                            if (node3 == null || node3.getNodeType() != 1) break block5;
                            string2 = node3.getNodeName();
                            if (!string2.equals(ROLEMAP_NAME)) break block6;
                            node2 = node3.getFirstChild();
                            if (node2 == null || (string = node2.getNodeValue()) == null || string.length() == 0) break block5;
                            roleMapImpl.setName(string);
                        }
                        if (!string2.equals(ROLEMAP_SEARCHFILTER)) break block7;
                        node2 = node3.getFirstChild();
                        if (node2 == null || (string = node2.getNodeValue()) == null || string.length() == 0) break block5;
                        roleMapImpl.setSearchFilter(string);
                    }
                    if (!string2.equals(ROLEMAP_BINDINGROLENAME)) break block8;
                    node2 = node3.getFirstChild();
                    if (node2 == null || (string = node2.getNodeValue()) == null || string.length() == 0) break block5;
                    roleMapImpl.setRoleName(string);
                }
                if (!containsKey.containsKey(roleMapImpl.getName())) {
                    containsKey.put(roleMapImpl.getName(), roleMapImpl);
                }
            }
            ++n;
        }
    }

    public static String getEncode() {
        return equals;
    }

    public static void setEncode(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return;
        }
        equals = node2.getNodeValue();
    }

    static {
        close = new Hashtable();
        containsKey = new Hashtable();
        decode = "";
        equals = "";
    }
}

