/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLException;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;

public class RelaxedX509TrustManager
implements X509TrustManager {
    private TrustManager QOIV = null;
    private static boolean add = false;
    private static boolean aliases = false;
    private char[] append;
    private String close = System.getProperty("javax.net.ssl.trustStore");
    private static String delete = null;
    private static char[] equals;
    private FileInputStream exists = null;
    private KeyStore getAcceptedIssuers = null;

    RelaxedX509TrustManager() throws Exception {
        Properties properties;
        File file;
        String string = System.getProperty("javax.net.ssl.trustStorePassword");
        if (this.close == null) {
            this.close = ServerEnv.propertiesPath + "LDAPKeyStore.keystore";
        }
        this.append = string == null ? "jinfonet".toCharArray() : string.toCharArray();
        if (this.close != "") {
            delete = this.close;
            equals = this.append;
        }
        try {
            file = new File(this.close);
            if (!file.exists()) {
                properties = System.getProperties();
                properties.remove("javax.net.ssl.trustStore");
                properties.remove("javax.net.ssl.trustStorePassword");
                System.setProperties(properties);
            }
        }
        catch (SecurityException securityException) {
            ServiceLogger.logError(securityException, 3);
        }
        try {
            file = TrustManagerFactory.getInstance((String)"SunX509", (String)"SunJSSE");
            file.init(null);
            this.QOIV = file.getTrustManagers()[0];
        }
        catch (Exception exception) {
            properties = System.getProperties();
            properties.remove("javax.net.ssl.trustStore");
            properties.remove("javax.net.ssl.trustStorePassword");
            System.setProperties(properties);
            File file2 = new File(this.close);
            file2.delete();
        }
        if (this.QOIV == null) {
            throw new SSLException("Could not get default TrustManager instance.");
        }
        try {
            this.exists = new FileInputStream(this.close);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.exists = null;
        }
        try {
            this.getAcceptedIssuers = KeyStore.getInstance(KeyStore.getDefaultType());
            this.getAcceptedIssuers.load(this.exists, this.append);
        }
        catch (KeyStoreException keyStoreException) {
            this.getAcceptedIssuers = null;
        }
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
        return this.isClientTrusted(x509CertificateArray);
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
        if (!((X509TrustManager)this.QOIV).isClientTrusted(x509CertificateArray)) {
            if ("false".equals(System.getProperty("RelaxedX509TrustManager"))) {
                Properties properties = System.getProperties();
                properties.remove("RelaxedX509TrustManager");
                System.setProperties(properties);
                aliases = false;
                add = false;
            }
            if (aliases) {
                return false;
            }
            if (this.getAcceptedIssuers == null || x509CertificateArray == null || x509CertificateArray.length == 0) {
                return false;
            }
            if (add) {
                return true;
            }
            try {
                boolean bl = false;
                if (bl) {
                    add = true;
                } else {
                    int n = 0;
                    while (n < x509CertificateArray.length) {
                        this.getAcceptedIssuers.setCertificateEntry(x509CertificateArray[n].getSubjectDN().toString(), x509CertificateArray[n]);
                        ++n;
                    }
                    File file = new File(delete.substring(0, delete.lastIndexOf(File.separator)));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(delete);
                    this.getAcceptedIssuers.store(fileOutputStream, equals);
                    fileOutputStream.close();
                    fileOutputStream = null;
                    Properties properties = System.getProperties();
                    properties.put("javax.net.ssl.trustStore", delete);
                    properties.put("javax.net.ssl.trustStorePassword", new String(equals));
                    System.setProperties(properties);
                }
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray;
        X509Certificate[] x509CertificateArray2 = x509CertificateArray = ((X509TrustManager)this.QOIV).getAcceptedIssuers();
        if (this.getAcceptedIssuers != null) {
            try {
                Enumeration<String> enumeration = this.getAcceptedIssuers.aliases();
                Vector<Certificate> vector = new Vector<Certificate>();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    vector.add(this.getAcceptedIssuers.getCertificate(string.toString()));
                }
                int n = x509CertificateArray.length + vector.size();
                x509CertificateArray2 = new X509Certificate[n];
                Iterator iterator = vector.iterator();
                int n2 = 0;
                while (n2 < n) {
                    x509CertificateArray2 = n2 < x509CertificateArray.length ? x509CertificateArray : (X509Certificate[])iterator.next();
                    ++n2;
                }
            }
            catch (KeyStoreException keyStoreException) {
                ServiceLogger.logError(keyStoreException, 3);
            }
        }
        return x509CertificateArray2;
    }
}

