/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.track;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.track.TaskStatus;
import jet.server.jrc.track.TrackerMBean;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.util.Queue;
import jet.server.util.ThreadQueueController;

public class Tracker
implements TrackerMBean,
Runnable {
    private static volatile boolean QOIV = true;
    private static volatile long append = 10000L;
    private static long dump = 0L;
    private static Tracker getAcceleratedRunningReportsCount = null;
    private TaskStatus getActiveAndWaiting = null;
    private Map getActiveReportsCount = Collections.synchronizedMap(new HashMap());
    private ThreadQueueController getAllMembers;
    private Queue getHost;
    private boolean getLong;
    private ClusterService getNormalRunningReportsCount;
    private int getNormalWaitingReportsCount = 0;
    private int getPort = 0;
    private int getQueuingOnDemandReports = 0;

    public long getDumpInterval() {
        return append;
    }

    public void setDumpInterval(long l) {
        if (l < 1000L) {
            l = 1000L;
        }
        append = l;
    }

    public void setDump(boolean bl) {
        if (bl && !QOIV && getAcceleratedRunningReportsCount != null) {
            new Thread((Runnable)getAcceleratedRunningReportsCount, "DumpThread").start();
        }
        QOIV = bl;
    }

    public boolean isDump() {
        return QOIV;
    }

    public Tracker() {
        this.getActiveAndWaiting = new TaskStatus();
        long l = Long.getLong("jreport.dump_interval", 60000L);
        this.setDumpInterval(l);
    }

    public void dump() {
        if (ServiceLogger.isLoggable(6, 6)) {
            if (this.getAllMembers != null) {
                int n = this.getAllMembers.getActiveReportsCount();
                int n2 = this.getHost.size();
                int n3 = this.getAllMembers.getWaitReportsCount();
                this.getNormalWaitingReportsCount = n;
                this.getPort = n2;
                this.getQueuingOnDemandReports = n3;
                if (this.getLong) {
                    this.QOIV();
                    ServiceLogger.logDump(5600161, new Object[]{String.valueOf(this.getNormalWaitingReportsCount), String.valueOf(this.getQueuingOnDemandReports), String.valueOf(this.getPort), n + "(normalRunning:" + this.getAllMembers.getNormalRunningReportsCount() + ", acceleratedRunning:" + this.getAllMembers.getAcceleratedRunningReportsCount() + ")", n3 + "(normalWaiting:" + this.getAllMembers.getNormalWaitingReportsCount() + ", readyWaiting:" + this.getAllMembers.getReadyWaitingReportsCount() + ")", String.valueOf(n2), "" + this.getActiveAndWaiting.getRunningOnDemandReports(), "" + this.getActiveAndWaiting.getQueuingOnDemandReports(), "" + this.getActiveAndWaiting.getWaitingOnDemandReports(), "" + this.getActiveAndWaiting.getRunningScheduleReports(), "" + this.getActiveAndWaiting.getQueuingScheduleReports(), "" + this.getActiveAndWaiting.getWaitingScheduleReports()}, 6);
                } else {
                    ServiceLogger.logDump(5600160, new Object[]{n + "(normalRunning:" + this.getAllMembers.getNormalRunningReportsCount() + ", acceleratedRunning:" + this.getAllMembers.getAcceleratedRunningReportsCount() + ")", n3 + "(normalWaiting:" + this.getAllMembers.getNormalWaitingReportsCount() + ", readyWaiting:" + this.getAllMembers.getReadyWaitingReportsCount() + ")", String.valueOf(n2), "" + this.getActiveAndWaiting.getRunningOnDemandReports(), "" + this.getActiveAndWaiting.getQueuingOnDemandReports(), "" + this.getActiveAndWaiting.getWaitingOnDemandReports(), "" + this.getActiveAndWaiting.getRunningScheduleReports(), "" + this.getActiveAndWaiting.getQueuingScheduleReports(), "" + this.getActiveAndWaiting.getWaitingScheduleReports()}, 6);
                }
            } else {
                ServiceLogger.logDump(5600159, new Object[]{"" + this.getActiveAndWaiting.getRunningOnDemandReports(), "" + this.getActiveAndWaiting.getQueuingOnDemandReports(), "" + this.getActiveAndWaiting.getWaitingOnDemandReports(), "" + this.getActiveAndWaiting.getRunningScheduleReports(), "" + this.getActiveAndWaiting.getQueuingScheduleReports(), "" + this.getActiveAndWaiting.getWaitingScheduleReports()}, 6);
            }
        }
    }

    private void QOIV() {
        Member[] memberArray;
        try {
            memberArray = this.getNormalRunningReportsCount.getAllMembers();
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError(clusterException, 2);
            return;
        }
        boolean bl = true;
        int n = 0;
        while (n < memberArray.length) {
            if (!memberArray[n].isAdmin()) {
                try {
                    MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(memberArray[n].getHost(), Integer.parseInt(memberArray[n].getPort()), "MemberMonitor");
                    int[] nArray = memberMonitor.getActiveAndWaiting();
                    if (nArray[0] < 0) {
                        bl = false;
                    } else {
                        this.getNormalWaitingReportsCount += nArray[0];
                    }
                    this.getPort += nArray[1];
                    if (nArray[2] < 0) {
                        bl = false;
                    } else {
                        this.getQueuingOnDemandReports += nArray[2];
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 2);
                }
            }
            ++n;
        }
        if (!bl && ServiceLogger.isLoggable(6, 6)) {
            ServiceLogger.logDump(6600240, 6);
        }
    }

    public void init(ThreadQueueController threadQueueController, Queue queue, boolean bl, ClusterService clusterService) {
        this.getAllMembers = threadQueueController;
        this.getHost = queue;
        this.getLong = bl;
        this.getNormalRunningReportsCount = clusterService;
    }

    public void release() {
        this.setDump(false);
        this.getActiveAndWaiting.release();
        this.getActiveAndWaiting = null;
        getAcceleratedRunningReportsCount = null;
        this.getAllMembers = null;
        this.getHost = null;
        this.getNormalRunningReportsCount = null;
    }

    public void run() {
        while (QOIV) {
            this.dump();
            try {
                Thread.sleep(append);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException, 3);
            }
        }
    }

    public TaskStatus getTaskStatus() {
        return this.getActiveAndWaiting;
    }

    public void registerToMBeanServer() {
    }

    public static synchronized Tracker getInstance() {
        if (getAcceleratedRunningReportsCount == null) {
            getAcceleratedRunningReportsCount = new Tracker();
            new Thread((Runnable)getAcceleratedRunningReportsCount, "DumpThread").start();
        }
        return getAcceleratedRunningReportsCount;
    }

    public static synchronized long getSequenceId() {
        return ++dump;
    }

    public static void dump(String string) {
        ServiceLogger.logDump(string);
    }

    public static void dump(String string, int n) {
        ServiceLogger.logDump(string, n);
    }

    public static void dump(int n, Object[] objectArray, int n2) {
        ServiceLogger.logDump(n, objectArray, n2);
    }
}

