/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrrmisvr.cluster;

import java.rmi.RemoteException;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.LoadBalancer;
import jet.server.api.cluster.Member;
import jet.server.api.rmi.cluster.RemoteClusterService;
import jet.server.jrrmisvr.ServiceLogger;
import jet.server.jrrmisvr.cluster.JRLoadBalancer;
import jet.server.jrserver.rmi.cluster.JRRemoteLoadBalancer;

public class JRClusterService
implements ClusterService {
    private RemoteClusterService QOIV = null;

    public JRClusterService(RemoteClusterService remoteClusterService) {
        this.QOIV = remoteClusterService;
    }

    public String getClusterName() {
        try {
            return this.QOIV.getClusterName();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Member[] getAllMembers() throws ClusterException {
        try {
            return this.QOIV.getAllMembers();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new ClusterException(remoteException);
        }
    }

    public Member getLocalMember() {
        try {
            return this.QOIV.getLocalMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Member getAdminMember() throws ClusterException {
        try {
            return this.QOIV.getAdminMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new ClusterException(remoteException);
        }
    }

    public LoadBalancer getDefaultLoadBalancer() {
        try {
            return new JRLoadBalancer(this.QOIV.getDefaultLoadBalancer());
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public void setDefaultLoadBalancer(LoadBalancer loadBalancer) {
        try {
            this.QOIV.setDefaultLoadBalancer(new JRRemoteLoadBalancer(loadBalancer));
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public synchronized Member getMember() {
        try {
            return this.QOIV.getMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public void registerLocalMember() throws ClusterException {
        try {
            this.QOIV.registerLocalMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new ClusterException(remoteException);
        }
    }

    public void removeLocalMember() throws ClusterException {
        try {
            this.QOIV.removeLocalMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new ClusterException(remoteException);
        }
    }

    public boolean isAdminServerCrashed() {
        try {
            return this.QOIV.isAdminServerCrashed();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return true;
        }
    }

    public boolean isTaskQueueFull(int n) {
        try {
            return this.QOIV.isTaskQueueFull(n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError(clusterException);
        }
        return false;
    }
}

