/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrrmisvr.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.server.api.Authenticator;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.http.BaseHttpUtil;
import jet.server.api.http.HttpExternalAuthorized;
import jet.server.api.http.HttpUserSessionManager;
import jet.server.api.http.TooManyTimesException;
import jet.server.api.rmi.RemoteUserSessionManager;
import jet.server.intf.security.SecurityAdapter;
import jet.server.jrrmisvr.JRUserSessionManager;
import jet.server.jrrmisvr.ServiceLogger;
import jet.server.jrrmisvr.http.AuthInfo;
import jet.server.jrrmisvr.http.LogoutReg;
import jet.server.jrrmisvr.http.MD5Info;
import jet.server.jrrmisvr.http.RawUserSession;
import jet.server.rmi.RemoteObjectFactory;
import jet.util.Base64;

public class JRHttpUserSessionManager
extends JRUserSessionManager
implements HttpUserSessionManager {
    public static final String TAG_JRSESSION = "jrs.userssn";
    public static final String TAG_RAWSESSION = "jrs.rawssn";
    private int QOIV = 5;
    private Hashtable append = new Hashtable();
    private long askInvalidate = 86400000L;
    private int checkAdminLogin = 1024;
    private HttpExternalAuthorized checkLogin = null;
    private boolean clear = true;
    private SecurityAdapter containsKey = null;

    public JRHttpUserSessionManager(RemoteUserSessionManager remoteUserSessionManager, String string, String string2) {
        super(remoteUserSessionManager);
        try {
            this.containsKey = (SecurityAdapter)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "securityAdapter");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        String string3 = System.getProperty("jrs.httpExternalAuthorized");
        if (string3 != null && string3.trim().length() > 0) {
            try {
                this.checkLogin = (HttpExternalAuthorized)Class.forName(string3.trim()).newInstance();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("Error in loading user's HttpExternalAuthorized class: " + string3);
                ServiceLogger.logError(throwable);
            }
        }
    }

    public String getUser(HttpServletRequest httpServletRequest) {
        String string = null;
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession != null) {
            string = userSession.getUserID();
        }
        return string == null ? "" : string;
    }

    public UserSession getUserSession(HttpServletRequest httpServletRequest) {
        UserSession userSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            try {
                userSession = this.getUserSession((String)httpSession.getValue(TAG_JRSESSION));
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return userSession;
    }

    public void setHttpExternalAuthorized(HttpExternalAuthorized httpExternalAuthorized) {
        this.checkLogin = httpExternalAuthorized;
    }

    public HttpExternalAuthorized getHttpExternalAuthorized() {
        return this.checkLogin;
    }

    public synchronized void removeExpiredUserSessions(HttpServletRequest httpServletRequest) {
        try {
            UserSession userSession = null;
            String string = null;
            Enumeration enumeration = this.getAllUserSessions();
            while (enumeration.hasMoreElements()) {
                userSession = (UserSession)enumeration.nextElement();
                string = userSession.getID();
                if (!this.htSessions.containsKey(string) || System.currentTimeMillis() - this.getLastAccessTime(string) <= (long)userSession.getMaxInactiveInterval()) continue;
                if (this.checkLogin != null) {
                    boolean bl = this.checkLogin.askInvalidate(userSession);
                    if (userSession.isExternalAuthorized() && !bl) continue;
                    this.logout(httpServletRequest, userSession);
                    continue;
                }
                this.logout(httpServletRequest, userSession);
            }
            Enumeration enumeration2 = this.getAllWaitUserSessions();
            while (enumeration2.hasMoreElements()) {
                userSession = (UserSession)enumeration2.nextElement();
                string = userSession.getID();
                if (!this.htSessions.containsKey(string) || System.currentTimeMillis() - this.getLastAccessTime(userSession.getID()) <= (long)userSession.getMaxInactiveInterval()) continue;
                if (this.checkLogin != null) {
                    boolean bl = this.checkLogin.askInvalidate(userSession);
                    if (userSession.isExternalAuthorized() && !bl) continue;
                    this.logout(httpServletRequest, userSession);
                    continue;
                }
                this.logout(httpServletRequest, userSession);
            }
            userSession = this.getUserSession(httpServletRequest);
            if (userSession != null) {
                this.putSessions(userSession);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    public UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6, Object object) throws TooManyUsersException {
        return this.loginMD5(string, string2, string3, string4, string5, string6, object, false);
    }

    public UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6, Object object, boolean bl) throws TooManyUsersException {
        UserSession userSession = null;
        String string7 = null;
        try {
            if (this.containsKey != null) {
                string7 = this.containsKey.getPassword(string, string2);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            string7 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        if (string3.equals(CSUtil.getH(CSUtil.getH(string2 + ":" + string + ":", string7) + ":" + string4 + ":" + CSUtil.getH(string6 + ":" + string5, null), null))) {
            userSession = this.login(string, string2, string7, object, false, bl);
        }
        return userSession;
    }

    public boolean checkLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            RawUserSession rawUserSession = this.currentTimeMillis(httpServletRequest);
            if (rawUserSession != null && rawUserSession.retry >= this.QOIV) {
                throw new TooManyTimesException(630085);
            }
            if (!this.needSecurity()) {
                String string2 = (String)properties.get("isWait");
                boolean bl = string2 == null ? false : string2.equals("true");
                userSession = this.login(string, "", "", userSession, false, bl);
            } else {
                userSession = this.equalsIgnoreCase(httpServletRequest, string, properties);
            }
            if (userSession != null) {
                this.clear(httpServletRequest, userSession);
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean checkAdminLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            RawUserSession rawUserSession = this.currentTimeMillis(httpServletRequest);
            if (rawUserSession != null && rawUserSession.retry >= this.QOIV) {
                throw new TooManyTimesException(630085);
            }
            properties.setProperty("isAdmin", "true");
            userSession = this.equalsIgnoreCase(httpServletRequest, string, properties);
            if (userSession != null) {
                if (this.containsKey.isAdminUser(string, userSession.getUserID())) {
                    this.clear(httpServletRequest, userSession);
                    return true;
                }
                HttpSession httpSession = httpServletRequest.getSession(true);
                if (httpSession != null) {
                    this.append(httpSession);
                }
            }
            return false;
        }
        if (userSession.getID() == null) {
            throw new TooManyUsersException(630088);
        }
        if (this.containsKey.isAdminUser(string, userSession.getUserID())) {
            return true;
        }
        if (this.clear) {
            httpServletRequest.getSession().invalidate();
        }
        return false;
    }

    public void sendUnauthorizedResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        this.containsKey(httpServletRequest);
        RawUserSession rawUserSession = this.currentTimeMillis(httpServletRequest);
        rawUserSession.realm = string2;
        if (string.equals("Digest")) {
            rawUserSession.md5 = new MD5Info(httpServletRequest);
        }
        if (this.checkLogin != null && !this.checkLogin.handleUnAuthenticatedRequest(httpServletRequest, httpServletResponse, string, string2)) {
            return;
        }
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("WWW-Authenticate", rawUserSession.makeAuthHeader());
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>" + JCliResource.getMessage("CS_MSG_110") + "</title>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<H1>401 " + JCliResource.getMessage("CS_MSG_110") + "</H1><h2>");
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    public void logout(HttpServletRequest httpServletRequest) {
        this.checkLogin();
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            UserSession userSession = this.getUserSession(httpServletRequest);
            if (userSession != null) {
                // empty if block
            }
            this.logout(httpServletRequest, userSession, true);
        }
    }

    private void QOIV(HttpSession httpSession) {
        try {
            if (httpSession != null) {
                String string = httpSession.getId();
                this.append.remove(string);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    private void append(HttpSession httpSession) {
        block5: {
            try {
                if (httpSession == null) break block5;
                try {
                    String string = httpSession.getId();
                    LogoutReg logoutReg = (LogoutReg)this.append.get(string);
                    if (logoutReg != null) {
                        logoutReg.C();
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private boolean askInvalidate(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            try {
                String string = httpSession.getId();
                LogoutReg logoutReg = (LogoutReg)this.append.get(string);
                if (logoutReg != null && !logoutReg.Z()) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return bl;
    }

    private void checkAdminLogin(HttpServletRequest httpServletRequest, String string) {
        try {
            if (string != null && !BaseHttpUtil.isJRClient(httpServletRequest, null)) {
                this.append.put(string, new LogoutReg());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLogin() {
        try {
            Hashtable hashtable = this.append;
            synchronized (hashtable) {
                if (this.append.size() >= this.checkAdminLogin) {
                    String string;
                    Enumeration enumeration = this.append.keys();
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        if (System.currentTimeMillis() - ((LogoutReg)this.append.get(string)).I() <= this.askInvalidate) continue;
                        this.append.remove(string);
                    }
                    if (this.append.size() >= this.checkAdminLogin) {
                        int n = 0;
                        int n2 = this.checkAdminLogin / 2;
                        enumeration = this.append.keys();
                        while (enumeration.hasMoreElements() && n < n2) {
                            string = (String)enumeration.nextElement();
                            this.append.remove(string);
                            ++n;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            try {
                Hashtable hashtable = this.append;
                synchronized (hashtable) {
                    if (this.append.size() > this.checkAdminLogin) {
                        this.append.clear();
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
        }
    }

    public void logout(HttpServletRequest httpServletRequest, UserSession userSession) {
        this.logout(httpServletRequest, userSession, false);
    }

    private void logout(HttpServletRequest httpServletRequest, UserSession userSession, boolean bl) {
        if (userSession != null) {
            HttpSession httpSession = (HttpSession)this.getExtObj(userSession.getID());
            if (httpSession != null) {
                try {
                    httpSession.removeValue(TAG_JRSESSION);
                    if (this.clear) {
                        httpSession.invalidate();
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
                httpSession = httpServletRequest.getSession(true);
                if (bl) {
                    try {
                        this.checkAdminLogin(httpServletRequest, httpSession.getId());
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                    }
                }
            }
            super.logout(userSession);
            if (userSession.isExternalAuthorized() && this.checkLogin != null) {
                this.checkLogin.notifyLogout(userSession);
            }
        }
    }

    private void clear(HttpServletRequest httpServletRequest, UserSession userSession) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        try {
            httpSession.putValue(TAG_JRSESSION, (Object)userSession.getID());
            httpSession.removeValue(TAG_RAWSESSION);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    private void containsKey(HttpServletRequest httpServletRequest) {
        if (this.currentTimeMillis(httpServletRequest) == null) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            try {
                httpSession.putValue(TAG_RAWSESSION, (Object)new RawUserSession());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private RawUserSession currentTimeMillis(HttpServletRequest httpServletRequest) {
        RawUserSession rawUserSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            try {
                rawUserSession = (RawUserSession)httpSession.getValue(TAG_RAWSESSION);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return rawUserSession;
    }

    private AuthInfo decode(HttpServletRequest httpServletRequest, String string, Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string2 = httpServletRequest.getHeader("Authorization");
        if (string2 != null && string2.length() > 0) {
            if (this.askInvalidate(httpServletRequest)) {
                this.append(httpServletRequest.getSession(true));
                return null;
            }
            HttpSession httpSession = httpServletRequest.getSession(false);
            if ((httpSession == null || httpSession.isNew()) && (authInfo = this.equals(properties)) == null) {
                this.append(httpServletRequest.getSession(true));
                return null;
            }
            int n = (string2 = string2.trim()).indexOf(" ");
            if (n > 0) {
                if (string2.startsWith("Basic")) {
                    string2 = string2.substring(n).trim();
                    String string3 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string2), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string2), "ISO-8859-1");
                    n = string3.indexOf(":");
                    if (n > 0) {
                        authInfo = new AuthInfo();
                        authInfo.I = string3.substring(0, n);
                        authInfo.Z = string3.substring(n + 1);
                    }
                } else if (string2.startsWith("Digest")) {
                    Object object;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    string2 = string2.substring("Digest".length() + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken().trim();
                        int n2 = ((String)object).indexOf("=");
                        if (n2 <= 0) continue;
                        String string9 = ((String)object).substring(0, n2).trim();
                        String string10 = ((String)object).substring(n2 + 1).trim();
                        if (string9.equalsIgnoreCase("username")) {
                            string4 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("realm")) {
                            string5 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("nonce")) {
                            string6 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("response")) {
                            string7 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (!string9.equalsIgnoreCase("opaque")) continue;
                        string8 = CSUtil.removeQuotes(string10);
                    }
                    object = new MD5Info();
                    ((MD5Info)object).nonce = string6;
                    ((MD5Info)object).opaque = string8;
                    ((MD5Info)object).response = string7;
                    authInfo = new AuthInfo();
                    authInfo.I = string4;
                    authInfo.C = object;
                }
            }
        } else {
            authInfo = this.equals(properties);
        }
        return authInfo;
    }

    private AuthInfo equals(Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string = null;
        String string2 = null;
        String string3 = (String)properties.get("jrs.authorization");
        if (string3 != null && string3.trim().length() > 0) {
            String string4 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string3), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string3), "ISO-8859-1");
            int n = string4.indexOf(":");
            if (n > 0) {
                string = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
        } else {
            string = (String)properties.get("jrs.auth_uid");
            string2 = (String)properties.get("jrs.auth_pwd");
            if (string2 == null) {
                string2 = "";
            }
        }
        if (string != null) {
            authInfo = new AuthInfo();
            authInfo.I = string;
            authInfo.Z = string2;
        }
        return authInfo;
    }

    private UserSession equalsIgnoreCase(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, IOException {
        Object object;
        UserSession userSession = null;
        if (this.checkLogin != null && (object = this.checkLogin.getExternalAuthorizedUser(string, httpServletRequest)) != null) {
            userSession = this.loginExternalAuthorized(string, (String)object, httpServletRequest.getSession(true));
        }
        if (userSession == null) {
            object = this.decode(httpServletRequest, string, properties);
            String string2 = (String)properties.get("isWait");
            boolean bl = string2 == null ? false : string2.equals("true");
            if (object != null) {
                RawUserSession rawUserSession = this.currentTimeMillis(httpServletRequest);
                if (rawUserSession != null && ((AuthInfo)object).C != null && rawUserSession.md5 != null && ((AuthInfo)object).I != null && ((AuthInfo)object).C.response != null && ((AuthInfo)object).C.nonce != null && ((AuthInfo)object).C.nonce.equals(rawUserSession.md5.nonce) && (((AuthInfo)object).C.opaque == null || ((AuthInfo)object).C.opaque.equals(rawUserSession.md5.opaque))) {
                    return this.loginMD5(rawUserSession.realm, ((AuthInfo)object).I, ((AuthInfo)object).C.response, ((AuthInfo)object).C.nonce, rawUserSession.md5.uri, httpServletRequest.getMethod(), httpServletRequest.getSession(true), bl);
                }
                HttpSession httpSession = httpServletRequest.getSession(true);
                if (properties.getProperty("isAdmin", "false").equals("true")) {
                    Authenticator authenticator = super.getAuthenticator();
                    if (authenticator.isValidAdminUser(string, ((AuthInfo)object).I, ((AuthInfo)object).Z)) {
                        userSession = this.login(string, ((AuthInfo)object).I, ((AuthInfo)object).Z, httpSession, false, bl);
                    }
                } else {
                    userSession = this.login(string, ((AuthInfo)object).I, ((AuthInfo)object).Z, httpSession, false, bl);
                }
                if (userSession != null) {
                    this.QOIV(httpSession);
                } else if (httpSession != null) {
                    this.append(httpSession);
                }
            }
        }
        return userSession;
    }

    public boolean isExtraChannel(HttpServletRequest httpServletRequest) {
        return false;
    }

    public boolean checkLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        return this.checkLogin(httpServletRequest, string, properties);
    }

    public boolean checkAdminLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        return this.checkAdminLogin(httpServletRequest, string, properties);
    }
}

