/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.TaskIntf;
import jet.server.ServerEnv;
import jet.server.api.LargeReportManager;
import jet.server.api.LargeReportRecord;
import jet.server.api.OndemandReportManager;
import jet.server.api.OndemandReportRecord;
import jet.server.api.ReportSheetInfo;
import jet.server.intf.jrs.RemoteOndemandManager;
import jet.server.jrserver.JRLargeReportRecord;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.ViewRptTask;
import toolkit.db.DbTools;
import toolkit.db.MiniSort;
import toolkit.db.SortCompareInterface;

public class JROndemandReportManager
implements OndemandReportManager,
LargeReportManager,
SortCompareInterface {
    private RemoteOndemandManager QOIV = null;
    private boolean TIMEOUT = false;
    private String addElement = null;
    private int append;
    long changeStatus = SchdTools.TIMEOUT;
    Hashtable clearUserOndemandList = new Hashtable();

    public JROndemandReportManager(RemoteOndemandManager remoteOndemandManager, boolean bl, String string, int n) {
        this.QOIV = remoteOndemandManager;
        this.TIMEOUT = bl;
        this.addElement = string;
        this.append = n;
    }

    public Vector getOndemandReports(String string) {
        try {
            return this.QOIV.getOndemandReports(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public OndemandReportRecord getOndemandReportRecord(String string) {
        try {
            return this.QOIV.getOndemandReportRecord(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public OndemandReportRecord notifyOndemandCompleted(String string) {
        try {
            return this.QOIV.notifyCompleted(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public OndemandReportRecord changeStatus(String string, String string2) {
        try {
            return this.QOIV.changeStatus(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public void removeOndemandReport(String string, boolean bl) {
        try {
            this.QOIV.removeOndemandReport(string, bl);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void removeOndemandReport(String string) {
        try {
            this.QOIV.removeOndemandReport(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void removeAllOndemandReport(String string) {
        try {
            this.QOIV.removeAllOndemandReport(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public String registerOndemandReport(String string, String string2, String string3, int n, String string4, ReportSheetInfo reportSheetInfo, int n2, Properties properties, String string5, boolean bl, String string6, String string7, int n3) {
        try {
            if (this.TIMEOUT) {
                return this.QOIV.registerOndemandReport(string, string2, string3, n, string4, reportSheetInfo, n2, properties, string5, bl, string6, string7, n3);
            }
            return this.QOIV.registerOndemandReport(string, string2, string3, n, string4, reportSheetInfo, n2, properties, string5, bl, string6, string7, this.addElement, String.valueOf(this.append), n3);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public void setOndemandErrorMessage(String string, String string2) {
        try {
            this.QOIV.setErrorMessage(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void setTimeout(long l) {
        this.changeStatus = l;
    }

    public void registerLargeReport(String string, String string2, String string3, String string4, Properties properties, String string5, Thread thread, TaskIntf taskIntf) {
        String string6;
        JRLargeReportRecord jRLargeReportRecord;
        if (string4 != null && (jRLargeReportRecord = (JRLargeReportRecord)this.clearUserOndemandList.get(string6 = string4)) == null) {
            jRLargeReportRecord = new JRLargeReportRecord(string, string2, string3, string4, properties, string5, thread, taskIntf);
            this.clearUserOndemandList.put(string6, jRLargeReportRecord);
        }
    }

    public Vector getLargeReports(String string) {
        Vector<JRLargeReportRecord> vector = new Vector<JRLargeReportRecord>();
        Enumeration enumeration = this.clearUserOndemandList.elements();
        while (enumeration.hasMoreElements()) {
            JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)enumeration.nextElement();
            if (jRLargeReportRecord == null || !DbTools.isStringSameNull((String)string, (String)jRLargeReportRecord.getUserID())) continue;
            vector.addElement(jRLargeReportRecord);
        }
        MiniSort.sort(vector, this);
        return vector;
    }

    public LargeReportRecord getLargeReportRecord(String string) {
        JRLargeReportRecord jRLargeReportRecord = null;
        if (string != null) {
            jRLargeReportRecord = (JRLargeReportRecord)this.clearUserOndemandList.get(string);
        }
        return jRLargeReportRecord;
    }

    public LargeReportRecord notifyCompleted(String string) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.getLargeReportRecord(string);
        if (jRLargeReportRecord != null) {
            ViewRptTask viewRptTask;
            TaskIntf taskIntf = jRLargeReportRecord.getTask();
            if (taskIntf != null && taskIntf instanceof ViewRptTask && (viewRptTask = (ViewRptTask)taskIntf).isHtmlPipeLine() && !viewRptTask.isPipeLineFinished()) {
                return null;
            }
            jRLargeReportRecord.notifyCompleted();
        }
        return jRLargeReportRecord;
    }

    public void removeLargeReport(String string, boolean bl) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.clearUserOndemandList.get(string);
        if (jRLargeReportRecord != null && !jRLargeReportRecord.isCompleted()) {
            if (!bl) {
                ViewRptTask viewRptTask;
                TaskIntf taskIntf = jRLargeReportRecord.getTask();
                if (taskIntf != null && taskIntf instanceof ViewRptTask && (viewRptTask = (ViewRptTask)taskIntf).isHtmlPipeLine() && viewRptTask.getTaskListener() != null && !viewRptTask.isPipeLineFinished()) {
                    return;
                }
            } else {
                try {
                    jRLargeReportRecord.getTask().stopExec();
                    if (jRLargeReportRecord.getRptThread().isAlive()) {
                        jRLargeReportRecord.getRptThread().stop();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
        if (jRLargeReportRecord != null) {
            this.clearUserOndemandList.remove(string);
        }
    }

    public void removeLargeReportIfTimeout() {
        Enumeration enumeration = this.clearUserOndemandList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.clearUserOndemandList.get(string);
            if (jRLargeReportRecord == null || System.currentTimeMillis() - jRLargeReportRecord.getStartedTime() <= this.changeStatus) continue;
            this.clearUserOndemandList.remove(string);
        }
    }

    public boolean isExchangeSortOrder(Object object, Object object2) {
        return object != null && object2 != null && (((JRLargeReportRecord)object).getCatalog() + ((JRLargeReportRecord)object).getReportName() + ((JRLargeReportRecord)object).getStartedTime()).toUpperCase().compareTo((((JRLargeReportRecord)object2).getCatalog() + ((JRLargeReportRecord)object2).getReportName() + ((JRLargeReportRecord)object2).getStartedTime()).toUpperCase()) < 0;
    }

    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }

    public void setErrorMessage(String string, String string2) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.clearUserOndemandList.get(string);
        if (jRLargeReportRecord != null) {
            jRLargeReportRecord.setErrorMessage(string2);
        }
    }

    public String getErrorMessage(String string) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.clearUserOndemandList.get(string);
        if (jRLargeReportRecord != null) {
            return jRLargeReportRecord.getErrorMessage();
        }
        return null;
    }

    public void clearUserOndemandList(String string, boolean bl) {
        try {
            this.QOIV.clearUserOndemandList(string, bl);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getOndemandID(String string, String string2) {
        try {
            return this.QOIV.getOndemandID(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return "";
    }

    public void removeOndemandReport(String string, String string2, boolean bl) {
        try {
            this.QOIV.removeOndemandReport(string, string2, bl);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void clearMem() {
    }
}

