/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.ReportEnv;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.ProfileManager;
import jet.server.api.RemoteFileService;
import jet.server.api.RptServerException;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.JRRemoteFileService;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;

public class JRProfileManager
implements ProfileManager {
    private String QOIV;
    private String add;
    private Properties append;
    private Map containsKey;
    private RemoteFileService createNewFile;

    public JRProfileManager(String string, String string2) throws Exception {
        this.QOIV = string2;
        this.add = string + string2 + File.separator;
        try {
            this.createNewFile = new JRRemoteFileService(ServerEnv.getClusterAdminHost(), APIUtil.parseInt(ServerEnv.getClusterAdminRMIPort()));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        this.containsKey = new Hashtable();
        this.append = new Properties();
        String string3 = this.add + "profile_cfg" + ".properties";
        if (!this.createNewFile.exists(string3)) {
            File file = new File(string3);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        this.append.load(this.createNewFile.readFile(string3));
    }

    private boolean isAdminUser(String string, String string2) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            return "admin".equals(string2);
        }
        return securityService.isAdminUser(string2);
    }

    private String encode(String string) {
        int n = string.hashCode();
        return Integer.toHexString(n);
    }

    public void addProfile(String string, Properties properties, String string2) throws RptServerException {
        if (!this.isAdminUser(this.QOIV, string2)) {
            throw new RptServerException(600036);
        }
        if (string == null || string.trim().length() == 0) {
            throw new RptServerException(600037);
        }
        String string3 = this.encode(string) + "_profile";
        if (this.append.containsKey(string3)) {
            throw new RptServerException(600038, new Object[]{string}, null);
        }
        try {
            Object object;
            String string4 = this.add + string3 + ".properties";
            if (!this.createNewFile.exists(string4)) {
                object = new File(string4);
                if (!((File)object).getParentFile().exists()) {
                    ((File)object).getParentFile().mkdirs();
                }
                ((File)object).createNewFile();
            }
            object = new ByteArrayOutputStream();
            properties.put("jrs.profile_last_modified", new Date().toString());
            properties.store((OutputStream)object, null);
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.createNewFile.writeFile(byteArrayInputStream, string4);
            String string5 = this.add + "profile_cfg" + ".properties";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.append.put(string3, string);
            this.append.put(this.encode(string) + "_name", string);
            this.append.store(byteArrayOutputStream, null);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
            this.createNewFile.writeFile(byteArrayInputStream2, string5);
            this.containsKey.put(string3, properties);
        }
        catch (IOException iOException) {
            throw new RptServerException(iOException);
        }
    }

    public String[] getAllProfileNames() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration<Object> enumeration = this.append.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).endsWith("_name")) continue;
            vector.add(this.append.get(object));
        }
        object = new String[vector.size()];
        int n = vector.size() - 1;
        while (n >= 0) {
            object[n] = "" + vector.get(n);
            --n;
        }
        return object;
    }

    public Properties getProfile(String string) {
        if (string == null || string.trim().length() == 0) {
            return this.getDefaultProfile();
        }
        if ("Default".equals(string.trim())) {
            return this.getDefaultProfile();
        }
        String string2 = this.encode(string) + "_profile";
        if (this.append.containsKey(string2)) {
            Properties properties = (Properties)this.containsKey.get(string2);
            if (properties == null) {
                properties = new Properties();
                try {
                    String string3 = this.add + string2 + ".properties";
                    properties.load(this.createNewFile.readFile(string3));
                    this.containsKey.put(string2, properties);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return properties;
        }
        return null;
    }

    public void removeProfile(String string, String string2) throws RptServerException {
        if (!this.isAdminUser(this.QOIV, string2)) {
            throw new RptServerException(600036);
        }
        String string3 = this.encode(string) + "_profile";
        String string4 = this.add + string3 + ".properties";
        try {
            if (this.createNewFile.exists(string4)) {
                this.createNewFile.delete(string4);
            }
            this.append.remove(string3);
            this.append.remove(this.encode(string) + "_name");
            String string5 = this.add + "profile_cfg" + ".properties";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.append.store(byteArrayOutputStream, null);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.createNewFile.writeFile(byteArrayInputStream, string5);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    public void updateProfile(String string, Properties properties, String string2) throws RptServerException {
        if (!this.isAdminUser(this.QOIV, string2)) {
            throw new RptServerException(600036);
        }
        if (string == null || string.trim().length() == 0) {
            throw new RptServerException(600037);
        }
        String string3 = this.encode(string) + "_profile";
        if (!this.append.containsKey(string3)) {
            throw new RptServerException(600038, new Object[]{string}, null);
        }
        try {
            String string4 = this.add + string3 + ".properties";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.put("jrs.profile_last_modified", new Date().toString());
            properties.store(byteArrayOutputStream, null);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.createNewFile.writeFile(byteArrayInputStream, string4);
            this.containsKey.put(string3, properties);
        }
        catch (IOException iOException) {
            throw new RptServerException(iOException);
        }
    }

    public Properties getDefaultProfile() {
        return JRProfileManager.getDefaultProfile(true, ReportEnv.isWebAdHoc(), true);
    }

    public static Properties getDefaultProfile(boolean bl, boolean bl2, boolean bl3) {
        Properties properties = new Properties();
        properties.put("dhtml.userbar", String.valueOf(bl));
        properties.put("dhtml.reportsetbar", String.valueOf(bl));
        properties.put("dhtml.toolbar", String.valueOf(bl));
        properties.put("dhtml.toc", String.valueOf(bl));
        properties.put("dhtml.menu", String.valueOf(bl));
        properties.put("dhtml.popup", String.valueOf(bl));
        properties.put("dhtml.contextmenu.displayname", "true");
        properties.put("dhtml.contextmenu.filter", "true");
        properties.put("dhtml.contextmenu.sort", "true");
        properties.put("dhtml.contextmenu.goto", "true");
        properties.put("dhtml.contextmenu.drill", "true");
        properties.put("dhtml.contextmenu.show_or_hide", "true");
        properties.put("dhtml.contextmenu.rotate", "true");
        properties.put("dhtml.contextmenu.reset", "true");
        properties.put("dhtml.contextmenu.refresh", "true");
        properties.put("dhtml.contextmenu.search", "true");
        properties.put("dhtml.contextmenu.charttype", "true");
        properties.put("dhtml.contextmenu.tochart", "true");
        properties.put("dhtml.contextmenu.tocrosstab", "true");
        properties.put("dhtml.contextmenu.linkreport", "true");
        properties.put("dhtml.contextmenu.detailreport", "true");
        properties.put("dhtml.contextmenu.delete", "true");
        properties.put("dhtml.contextmenu.bcFilter", "true");
        properties.put("dhtml.contextmenu.properties", "true");
        properties.put("dhtml.contextmenu.expand", "true");
        properties.put("dhtml.contextmenu.style", "true");
        properties.put("dhtml.dso", String.valueOf(bl2));
        properties.put("dhtml.toolbox", String.valueOf(bl2));
        properties.put("dhtml.adhoc", String.valueOf(bl2));
        properties.put("dhtml.tochart", String.valueOf(bl2));
        properties.put("dhtml.tocrosstab", String.valueOf(bl2));
        properties.put("dhtml.rotatecrosstab", String.valueOf(bl2));
        properties.put("dhtml.split", String.valueOf(bl2));
        properties.put("dhtml.merge", String.valueOf(bl2));
        properties.put("dhtml.create", String.valueOf(bl2));
        properties.put("dhtml.preview", String.valueOf(bl2));
        properties.put("dhtml.charttype", String.valueOf(bl2));
        properties.put("dhtml.bcfilter", String.valueOf(bl2));
        properties.put("dhtml.drill", String.valueOf(bl2));
        properties.put("dhtml.grid", String.valueOf(bl2));
        properties.put("dhtml.pivot", String.valueOf(bl2));
        properties.put("dhtml.insert_or_remove", String.valueOf(bl2));
        properties.put("dhtml.create_reportset", String.valueOf(bl2));
        properties.put("dhtml.create_report", String.valueOf(bl2));
        properties.put("dhtml.resize", String.valueOf(bl2));
        properties.put("dhtml.move", String.valueOf(bl2));
        properties.put("dhtml.save", String.valueOf(bl3));
        properties.put("dhtml.saveas", String.valueOf(bl3));
        properties.put("dhtml.filter", String.valueOf(bl3));
        properties.put("dhtml.sort", String.valueOf(bl3));
        properties.put("dhtml.saveresult", String.valueOf(bl3));
        properties.put("dhtml.print", String.valueOf(bl3));
        properties.put("dhtml.search", String.valueOf(bl3));
        properties.put("dhtml.style", String.valueOf(bl3));
        properties.put("dhtml.zoom", String.valueOf(bl3));
        properties.put("dhtml.skin", String.valueOf(bl3));
        properties.put("dhtml.refresh", String.valueOf(bl3));
        properties.put("dhtml.reset", String.valueOf(bl3));
        properties.put("dhtml.unredo", String.valueOf(bl3));
        properties.put("dhtml.nav", String.valueOf(bl3));
        properties.put("dhtml.pagesetup", String.valueOf(bl3));
        properties.put("dhtml.group", String.valueOf(bl3));
        properties.put("dhtml.help", String.valueOf(bl3));
        properties.put("dhtml.open", String.valueOf(bl3));
        properties.put("dhtml.goto", String.valueOf(bl3));
        properties.put("dhtml.recordnumber", String.valueOf(bl3));
        return properties;
    }
}

