/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.connect.DbBigInt;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.cs.CSUtil;
import jet.server.api.ResultFiles;
import jet.server.api.ResultVersionRecord;
import jet.server.schedule.JRResultFiles;

public class JRResultVersionRecord
implements ResultVersionRecord {
    private DbValue[] QOIV = null;
    protected Vector reportSheets = new Vector();

    public JRResultVersionRecord(DbValue[] dbValueArray) {
        this.QOIV = new DbValue[dbValueArray.length];
        int n = 0;
        while (n < dbValueArray.length) {
            this.QOIV[n] = (DbValue)dbValueArray[n].clone();
            ++n;
        }
    }

    public String getVersionID() {
        return this.QOIV[1].isNull() ? null : this.QOIV[1].toString();
    }

    public Properties toProperties(Properties properties) {
        Date date;
        String string;
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if ((string = this.getVersionID()) != null) {
            properties2.put("jrs.version_id", string);
        }
        if ((string = this.getCatalogFile()) != null) {
            properties2.put("jrs.catalog", string);
        }
        if ((string = this.getReportFile()) != null) {
            properties2.put("jrs.report", string);
        }
        JRResultFiles jRResultFiles = (JRResultFiles)this.getAllResultFiles();
        if (string != null) {
            properties2.put("jrs.result", jRResultFiles.getResultFileNames());
        }
        if ((string = this.getParamFile()) != null) {
            properties2.put("jrs.param_file", string);
        }
        if ((date = this.getCreatedTime()) != null) {
            properties2.put("jrs.created_time", String.valueOf(date.getTime()));
        }
        if ((date = this.getExpirationTime()) != null) {
            properties2.put("jrs.expired_time", String.valueOf(date.getTime()));
        }
        if ((string = this.getSubmitter()) != null) {
            properties2.put("jrs.uid", string);
        }
        return properties2;
    }

    public String getCatalogFile() {
        return this.QOIV[2].isNull() ? null : this.QOIV[2].toString();
    }

    public String getReportFile() {
        return this.QOIV[3].isNull() ? null : this.QOIV[3].toString();
    }

    public String getResultFile() {
        ResultFiles resultFiles = this.getAllResultFiles();
        Vector vector = resultFiles.getResultFileNames();
        return (String)vector.elementAt(0);
    }

    public ResultFiles getAllResultFiles() {
        Hashtable hashtable = this.getAllReportResultFiles();
        Enumeration enumeration = hashtable.keys();
        if (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            return (ResultFiles)hashtable.get(string);
        }
        return null;
    }

    public Hashtable getAllReportResultFiles() {
        String string = "";
        if (this.QOIV[5].isNull()) {
            string = this.QOIV[5].toString();
        }
        Hashtable hashtable = new Hashtable();
        if (string.indexOf(";") < 0) {
            this.QOIV(hashtable, string);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                this.QOIV(hashtable, string2);
            }
        }
        return hashtable;
    }

    private void QOIV(Hashtable hashtable, String string) {
        long l = this.QOIV[13].isNull() ? 0L : ((DbBigInt)this.QOIV[13]).get();
        int n = string.indexOf("=");
        JRResultFiles jRResultFiles = null;
        if (n < 0) {
            String string2 = string.length() == 0 ? null : string;
            jRResultFiles = l != 0L ? new JRResultFiles(string2, l, 0L, 0L, 0L, -1) : new JRResultFiles(CSUtil.getNameWithoutExt(string), CSUtil.getExtName(string));
            hashtable.put("jrs.report_result", jRResultFiles);
        } else {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            if (string3.equalsIgnoreCase("jrs.rst_result")) {
                jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string4), ".rst");
            } else if (string3.equalsIgnoreCase("jrs.rsd_result")) {
                jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string4), ".rsd");
            } else {
                this.reportSheets.add(string3);
                if (l != 0L) {
                    jRResultFiles = new JRResultFiles(string4, l, 0L, 0L, 0L, -1);
                    jRResultFiles.removeFormat(0);
                    jRResultFiles.removeFormat(12);
                } else {
                    jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string4), CSUtil.getExtName(string4));
                }
            }
            hashtable.put(string3, jRResultFiles);
        }
    }

    public String getParamFile() {
        return this.QOIV[4].isNull() ? null : this.QOIV[4].toString();
    }

    public Date getCreatedTime() {
        return ((DbTimestamp)this.QOIV[6]).isNull() ? null : ((DbTimestamp)this.QOIV[6]).toUtilDate();
    }

    public Date getExpirationTime() {
        if (this.QOIV[9].isNull()) {
            return null;
        }
        return ((DbTimestamp)this.QOIV[9]).toUtilDate();
    }

    public String getSubmitter() {
        return this.QOIV[7].isNull() ? null : this.QOIV[7].toString();
    }

    public int getVersionNumber() {
        return 0;
    }

    public String getVersionName() {
        return null;
    }

    public String getCreator() {
        return this.QOIV[7].isNull() ? null : this.QOIV[7].toString();
    }

    public String getResourcePath() {
        return null;
    }

    public String getRealPath() {
        return null;
    }

    public int getExpirationMethod() {
        return 1;
    }
}

