/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.RemoteFileService;
import jet.server.api.UserPreferenceManager;
import jet.server.jrc.JRRemoteFileService;
import jet.server.log.ServiceLogger;

public class JRUserDHTMLPreferenceManager
implements UserPreferenceManager {
    String QOIV;
    String addElement;
    Properties append;
    Hashtable close;
    RemoteFileService containsKey;
    private String delete = "dhtmlPreference.properties";
    private static String elements = "dhtmlprefer.default.properties";

    JRUserDHTMLPreferenceManager(String string, String string2) throws Exception {
        this.QOIV = string2;
        this.addElement = string + string2 + File.separator;
        this.close = new Hashtable();
        try {
            this.containsKey = new JRRemoteFileService(ServerEnv.getClusterAdminHost(), APIUtil.parseInt(ServerEnv.getClusterAdminRMIPort()));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        this.append = this.setDefaultPref();
        this.loadDefaultPref();
        ExProperties exProperties = ServerEnv.getInstallProps();
        try {
            if (exProperties != null) {
                try {
                    Enumeration<Object> enumeration = this.append.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        String string4 = exProperties.getProperty(string3);
                        if (string4 == null) continue;
                        this.append.setProperty(string3, string4);
                    }
                    this.saveDefaultUserPreference(this.append);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    JRUserDHTMLPreferenceManager(String string, RemoteFileService remoteFileService) throws Exception {
        this.addElement = string;
        if (!this.addElement.endsWith(File.separator)) {
            this.addElement = this.addElement + File.separator;
        }
        this.close = new Hashtable();
        this.containsKey = remoteFileService;
        this.append = this.setDefaultPref();
        this.loadDefaultPref();
    }

    public void loadDefaultPref() {
        String string = this.addElement + this.delete;
        try {
            if (this.containsKey.exists(string)) {
                try {
                    this.append.load(this.containsKey.readFile(string));
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    public void loadPreference(String string) {
        String string2 = this.addElement + string + File.separator;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!this.close.containsKey(string)) {
            Properties properties = new Properties(this.append);
            string2 = this.addElement + string + File.separator + this.delete;
            try {
                if (this.containsKey.exists(string2) && !this.QOIV(string)) {
                    try {
                        properties.load(this.containsKey.readFile(string2));
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException);
                    }
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            this.close.put(string, properties);
        }
    }

    public Properties getDefaultUserPreference() {
        return this.append;
    }

    public Properties getUserPreference(String string) {
        Properties properties;
        this.loadPreference(string);
        if (this.close.containsKey(string)) {
            properties = (Properties)this.close.get(string);
            if (properties.size() == 0) {
                properties = this.append;
            }
        } else {
            properties = this.append;
        }
        return properties;
    }

    public void removePreference(String string) {
        this.close.remove(string);
    }

    public void removePreferencesByValidUserNames(Enumeration enumeration) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration2 = this.close.keys();
        while (enumeration2.hasMoreElements()) {
            vector.addElement((String)enumeration2.nextElement());
        }
        while (enumeration.hasMoreElements()) {
            vector.removeElement((String)enumeration.nextElement());
        }
        Enumeration enumeration3 = vector.elements();
        while (enumeration3.hasMoreElements()) {
            this.close.remove((String)enumeration3.nextElement());
        }
    }

    public void saveDefaultUserPreference(Properties properties) throws IOException {
        String string = this.addElement + this.delete;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.addElement(this.append, properties);
        this.append.save(byteArrayOutputStream, null);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.containsKey.writeFile(byteArrayInputStream, string);
    }

    public void saveUserPreference(String string, Properties properties) throws IOException {
        if (!this.QOIV(string)) {
            this.loadPreference(string);
            Properties properties2 = (Properties)this.close.get(string);
            this.addElement(properties2, properties);
            String string2 = this.addElement + string + File.separator + this.delete;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties2.save(byteArrayOutputStream, null);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.containsKey.writeFile(byteArrayInputStream, string2);
        }
    }

    public boolean useDefaultUserPreference(String string) {
        if (this.QOIV(string)) {
            return true;
        }
        String string2 = this.addElement + string + File.separator + this.delete;
        boolean bl = true;
        try {
            if (this.containsKey.exists(string2)) {
                bl = this.containsKey.delete(string2);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        if (bl) {
            this.removePreference(string);
        }
        return bl;
    }

    private boolean QOIV(String string) {
        return string.equalsIgnoreCase("");
    }

    protected Properties setDefaultPref() {
        return JRUserDHTMLPreferenceManager.getProperties(elements);
    }

    private void addElement(Properties properties, Properties properties2) {
        String string = null;
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!this.append.containsKey(string)) continue;
            properties.setProperty(string, properties2.getProperty(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties getProperties(String string) {
        Properties properties;
        block10: {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(stackTraceElementArray[1].getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            InputStream inputStream = clazz.getResourceAsStream(string);
            properties = new Properties();
            properties.load(inputStream);
            Object var7_6 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            break block10;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var7_7 = null;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }
}

