/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.util.Hashtable;
import jet.server.api.ExpiryListener;
import jet.server.api.InvalidUserSessionException;
import jet.server.api.UserSession;
import jet.server.log.ServiceLogger;

public class JRUserSession
implements UserSession {
    public static final String HTTP_SESSTION = "jrs.httpSession";
    public static int TIMEOUT = 1800000;
    private String QOIV = null;
    private String append = null;
    private String arraycopy = null;
    private Object currentTimeMillis = null;
    private long expire;
    private long get = this.expire = System.currentTimeMillis();
    private boolean hashCode = true;
    private int indexOf = TIMEOUT;
    private boolean logError = false;
    private boolean put = false;
    private Hashtable remove = new Hashtable(8);
    private int toString;
    private transient ExpiryListener[] valueOf;
    private static final long serialVersionUID = 7942626092916686036L;

    public JRUserSession() {
    }

    public JRUserSession(String string, String string2, boolean bl) {
        this.QOIV = this.QOIV();
        this.append = string;
        this.arraycopy = string2;
        this.logError = bl;
        this.indexOf = TIMEOUT;
    }

    public String getID() {
        return this.QOIV;
    }

    public String getRealm() {
        return this.append;
    }

    public String getUserID() {
        return this.arraycopy;
    }

    public boolean isExternalAuthorized() {
        return this.logError;
    }

    public Object getExternalObject() {
        return this.currentTimeMillis;
    }

    public void setExternalObject(Object object) {
        this.currentTimeMillis = object;
    }

    public Object getValue(String string) {
        return this.remove.get(string);
    }

    public void putValue(String string, Object object) {
        this.remove.put(string, object);
    }

    public void removeValue(String string) {
        this.remove.remove(string);
    }

    public boolean isValid() {
        return this.hashCode;
    }

    public void invalidate() {
        this.hashCode = false;
        int n = this.toString;
        while (--n >= 0) {
            try {
                this.valueOf[n].expire(this);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
        }
    }

    public long getCreationTime() {
        return this.expire;
    }

    public long getLastAccessTime() {
        return this.get;
    }

    public void refreshLastAccessTime() throws InvalidUserSessionException {
        if (!this.hashCode) {
            throw new InvalidUserSessionException(630086, (Object[])new String[]{this.QOIV, this.arraycopy}, null);
        }
        this.get = System.currentTimeMillis();
    }

    public int getMaxInactiveInterval() {
        return this.indexOf;
    }

    public void setMaxInactiveInterval(int n) {
        this.indexOf = n;
    }

    private String QOIV() {
        String string = String.valueOf(this.hashCode());
        switch (string.length() % 3) {
            case 1: {
                string = "00" + string;
                break;
            }
            case 2: {
                string = "0" + string;
            }
        }
        return string;
    }

    public void addExpiryListener(ExpiryListener expiryListener) {
        if (this.indexOf(expiryListener) == -1) {
            if (this.valueOf == null) {
                this.valueOf = new ExpiryListener[1];
            }
            if (this.toString == this.valueOf.length) {
                ExpiryListener[] expiryListenerArray = new ExpiryListener[this.toString + this.toString];
                System.arraycopy(this.valueOf, 0, expiryListenerArray, 0, this.toString);
                this.valueOf = expiryListenerArray;
            }
            if (this.valueOf.length > 0) {
                this.valueOf[this.toString++] = expiryListener;
            }
        }
    }

    public void removeExpiryListener(ExpiryListener expiryListener) {
        int n = this.indexOf(expiryListener);
        if (n != -1) {
            if (n < this.toString - 1) {
                System.arraycopy(this.valueOf, n + 1, this.valueOf, n, this.toString - n - 1);
            }
            --this.toString;
            if (this.toString <= this.valueOf.length / 2) {
                ExpiryListener[] expiryListenerArray = new ExpiryListener[this.valueOf.length / 2];
                System.arraycopy(this.valueOf, 0, expiryListenerArray, 0, this.toString);
                this.valueOf = expiryListenerArray;
            }
        }
    }

    public int getExpiryListenerCount() {
        return this.toString;
    }

    public ExpiryListener getExpiryListener(int n) {
        return n < 0 || n >= this.toString ? null : this.valueOf[n];
    }

    public int indexOf(ExpiryListener expiryListener) {
        if (this.valueOf != null) {
            int n = this.valueOf.length;
            while (--n >= 0) {
                if (this.valueOf[n] != expiryListener) continue;
                return n;
            }
        }
        return -1;
    }

    public boolean isTimeOut() {
        long l = System.currentTimeMillis() - this.get;
        return l > (long)this.indexOf;
    }

    public String toString() {
        return super.toString() + "[id=" + this.QOIV + ", realm=" + this.append + ", userID=" + this.arraycopy + ", extObj=" + this.currentTimeMillis + ", creationTime=" + this.expire + ", lastAccessedTime=" + this.get + ", isValid=" + this.hashCode + ", maxInactiveInterval=" + this.indexOf + ", isExternalAuthorized=" + this.logError + "]";
    }
}

