/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import jet.ReportEnv;
import jet.server.ServerEnv;
import jet.server.api.Authenticator;
import jet.server.api.InvalidUserSessionException;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.UserSessionManager;
import jet.server.jrc.security.SecurityServiceImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRUserDHTMLPreferenceManager;
import jet.server.jrserver.JRUserPreferenceManager;
import jet.server.jrserver.JRUserSession;
import jet.server.jrserver.LoginQueue;
import jet.server.jrserver.OndemandListClearer;
import jet.server.log.ServiceLogger;

public class JRUserSessionManager
implements UserSessionManager {
    protected static final String TAG_EXTRASESSION = "jrs.extraSession";
    protected static final String TAG_KICKOUT = "jrs.kickOutOldSsn";
    protected static final String TAG_REQ = "jrs.extraReq";
    protected static final String TAG_RES = "jrs.extraRes";
    private int QOIV = 5;
    private int TIMEOUT = 0;
    protected Hashtable htSessions = new Hashtable();
    protected Hashtable htWaitSessions = new Hashtable();
    private Hashtable add = new Hashtable();
    private Authenticator addElement = null;
    private JRUserPreferenceManager addItem = null;
    private JRUserDHTMLPreferenceManager append = null;
    private long close = -1L;
    private long compareTo = -1L;
    private int contains = -1;
    private StringBuffer containsKey = new StringBuffer();
    protected OndemandListClearer ondemandlistclearer = null;
    private static Hashtable createNewFile = new Hashtable();
    private static Properties currentTimeMillis = new Properties();
    String delete = ServerEnv.homePath + "bin" + File.separator + "login.properties";
    String elements = ServerEnv.homePath + "bin" + File.separator + "logout.properties";

    public JRUserSessionManager(Authenticator authenticator) {
        this.setAuthenticator(authenticator);
        this.QOIV = ReportEnv.getUsers();
        int n = ServerEnv.getSessionTimeout();
        if (n < 0) {
            n = 0;
        } else if ((n *= 1000) < 0) {
            n = Integer.MAX_VALUE;
        }
        this.setDefaultMaxInactiveInterval(n);
        ServiceLogger.logEvent(4630035, String.valueOf(this.QOIV), 4);
        this.startOndemandListClearer();
        this.currentTimeMillis();
        this.delete();
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.addElement = authenticator;
    }

    public void bindingUserPreferenceManager(JRUserPreferenceManager jRUserPreferenceManager) {
        this.addItem = jRUserPreferenceManager;
        this.close = System.currentTimeMillis();
        this.contains = 0;
    }

    public void bindingUserDHTMLPreferenceManager(JRUserDHTMLPreferenceManager jRUserDHTMLPreferenceManager) {
        this.append = jRUserDHTMLPreferenceManager;
        this.compareTo = System.currentTimeMillis();
        this.contains = 0;
    }

    public Authenticator getAuthenticator() {
        return this.addElement;
    }

    public void setDefaultMaxInactiveInterval(int n) {
        JRUserSession.TIMEOUT = n;
    }

    public int getDefaultMaxInactiveInterval() {
        return JRUserSession.TIMEOUT;
    }

    public UserSession login(String string, String string2, String string3, Object object) throws TooManyUsersException {
        return this.login(string, string2, string3, object, false, false);
    }

    public UserSession loginExternalAuthorized(String string, String string2, Object object) throws TooManyUsersException {
        return this.login(string, string2, null, object, true, false);
    }

    public boolean isWait(String string) {
        UserSession userSession = null;
        if (string != null) {
            userSession = (UserSession)this.htWaitSessions.get(string);
            return userSession != null;
        }
        return false;
    }

    public void putSessions(UserSession userSession) {
        if (this.htWaitSessions.contains(userSession) && this.htSessions.size() < this.QOIV) {
            this.htWaitSessions.remove(userSession.getID());
            this.htSessions.put(userSession.getID(), userSession);
            Object object = this.getExtObj(userSession.getID());
            if (object != null) {
                this.add.put(userSession.getID(), object);
            }
        }
    }

    public void logout(UserSession userSession) {
        ServiceLogger.logEvent(5630036, new Object[]{userSession, this.toString()}, 5);
        if (userSession != null) {
            HttpSession httpSession;
            Object v = this.add.remove(userSession.getID());
            HttpSession httpSession2 = httpSession = v instanceof HttpSession ? (HttpSession)v : null;
            if (this.htWaitSessions.contains(userSession)) {
                this.htWaitSessions.remove(userSession.getID());
                userSession.invalidate();
            } else {
                this.htSessions.remove(userSession.getID());
                userSession.invalidate();
            }
            String string = userSession.getUserID();
            SecurityServiceImpl.removeKey(string + "$password");
            SecurityServiceImpl.removeKey(string);
            String string2 = userSession.getRealm();
            boolean bl = false;
            try {
                bl = UserDataToolkit.securityAdapter.isAdminUser(string2, string);
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException, 3);
            }
            if (bl) {
                if (this.isExtraSession(httpSession)) {
                    httpSession.removeValue(TAG_EXTRASESSION);
                } else {
                    --this.TIMEOUT;
                }
            } else {
                --this.TIMEOUT;
            }
        }
        try {
            ServiceLogger.logEvent(0x55E855, new Object[]{userSession, this.toString()}, 5);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (this.addItem != null && (System.currentTimeMillis() - this.close > 1800000L || this.contains++ > 50)) {
            this.addItem.removePreferencesByValidUserNames(this.QOIV());
            this.close = System.currentTimeMillis();
            this.contains = 0;
        }
        if (this.append != null && (System.currentTimeMillis() - this.compareTo > 1800000L || this.contains++ > 50)) {
            this.append.removePreferencesByValidUserNames(this.QOIV());
            this.compareTo = System.currentTimeMillis();
            this.contains = 0;
        }
        if (userSession != null) {
            this.contains(userSession.getUserID(), System.currentTimeMillis());
        }
    }

    private Enumeration QOIV() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.htSessions.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((JRUserSession)enumeration.nextElement()).getUserID();
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        return vector.elements();
    }

    public UserSession getUserSession(String string) {
        UserSession userSession = null;
        if (string != null && (userSession = (UserSession)this.htSessions.get(string)) != null) {
            return userSession;
        }
        if (string != null) {
            userSession = (UserSession)this.htWaitSessions.get(string);
            return userSession;
        }
        return userSession;
    }

    public Enumeration getAllUserSessions() {
        return this.htSessions.elements();
    }

    public Enumeration getAllWaitUserSessions() {
        return this.htWaitSessions.elements();
    }

    public void refreshLastAccessTime(String string) throws InvalidUserSessionException {
        UserSession userSession = null;
        if (string != null && (userSession = (UserSession)this.htSessions.get(string)) != null) {
            userSession.refreshLastAccessTime();
        }
        if (string != null && (userSession = (UserSession)this.htWaitSessions.get(string)) != null) {
            userSession.refreshLastAccessTime();
        }
    }

    public UserSession login(String string, String string2, String string3, Object object, boolean bl) throws TooManyUsersException {
        return this.login(string, string2, string3, object, bl, false);
    }

    public UserSession login(String string, String string2, String string3, Object object, boolean bl, boolean bl2) throws TooManyUsersException {
        return this.login(string, string2, string3, object, bl, bl2, false);
    }

    public UserSession login(String string, String string2, String string3, Object object, boolean bl, boolean bl2, boolean bl3) throws TooManyUsersException {
        try {
            ServiceLogger.logEvent(5630038, new Object[]{string, string2, object, String.valueOf(bl), this.toString()}, 5);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        UserSession userSession = null;
        if (bl || this.addElement.isValidUser(string, string2, string3)) {
            userSession = this.add(string, string2, string3, object, bl, bl2, bl3);
        } else if (!this.needSecurity()) {
            userSession = this.TIMEOUT(string, "", "", null, false, false);
        }
        this.compareTo(string2, System.currentTimeMillis());
        if (this.addItem != null) {
            this.addItem.loadPreference(string2);
        }
        if (this.append != null) {
            this.append.loadPreference(string2);
        }
        try {
            ServiceLogger.logEvent(5630039, new Object[]{string, string2, object, String.valueOf(bl), this.toString()}, 5);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.ondemandlistclearer.removeClearTime(string2);
        return userSession;
    }

    private UserSession TIMEOUT(String string, String string2, String string3, Object object, boolean bl, boolean bl2) throws TooManyUsersException {
        return this.add(string, string2, string3, object, bl, bl2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private UserSession add(String string, String string2, String string3, Object object, boolean bl, boolean bl2, boolean bl3) throws TooManyUsersException {
        JRUserSession jRUserSession = null;
        if (ServerEnv.isEnableMultipleLogin()) {
            if (this.TIMEOUT < this.QOIV || bl2 || this.QOIV <= 0) {
                jRUserSession = new JRUserSession(string, string2, bl);
                if (bl2) {
                    this.htWaitSessions.put(jRUserSession.getID(), jRUserSession);
                    ServiceLogger.logError(3630040, 3);
                    System.out.println("You have reach the maximum users limit of your license. Please contact our sales to purchase license for more users.");
                } else if (string2 != null) {
                    this.htSessions.put(jRUserSession.getID(), jRUserSession);
                    ++this.TIMEOUT;
                }
                if (object == null) return jRUserSession;
                this.add.put(jRUserSession.getID(), object);
                return jRUserSession;
            }
            if (!bl3 && this.addElement.isValidAdminUser(string, string2, string3) && object instanceof HttpSession) {
                UserSession userSession = this.append();
                if (userSession != null) {
                    Object object2 = this.getExtObj(userSession.getID());
                    HttpSession httpSession = object2 instanceof HttpSession ? (HttpSession)object2 : null;
                    this.containsKey.setLength(0);
                    this.containsKey.append("Session force terminating (").append(" user:").append(userSession.getRealm()).append("/").append(userSession.getUserID()).append(",").append(" userSessionID:").append(userSession.getID()).append(",").append(" httpSessionID:").append(httpSession == null ? "" : httpSession.getId()).append(",").append(" isExtraSession:true )");
                    ServiceLogger.logEvent(this.containsKey.toString(), 6);
                    if (!this.addElement((HttpSession)object)) {
                        return jRUserSession;
                    }
                    this.logout(userSession);
                    if (httpSession != null && ServerEnv.invalidateHttpSessionWhenLogout()) {
                        httpSession.invalidate();
                    }
                }
                jRUserSession = new JRUserSession(string, string2, bl);
                this.htSessions.put(jRUserSession.getID(), jRUserSession);
                ((HttpSession)object).putValue(TAG_EXTRASESSION, (Object)"true");
                this.add.put(jRUserSession.getID(), object);
                this.addItem((HttpSession)object);
                this.containsKey.setLength(0);
                this.containsKey.append("Created extra Session (").append(" user:").append(jRUserSession.getRealm()).append("/").append(jRUserSession.getUserID()).append(",").append(" userSessionID:").append(jRUserSession.getID()).append(",").append(" httpSessionID:").append(((HttpSession)object).getId()).append(",").append(" isExtraSession:true )");
                ServiceLogger.logEvent(this.containsKey.toString(), 6);
                return jRUserSession;
            }
            ServiceLogger.logError(3630040, 3);
            System.out.println("You have reach the maximum users limit of your license. Please contact our sales to purchase license for more users.");
            throw new TooManyUsersException(630087);
        }
        UserSession userSession = this.close(string2);
        if (userSession != null) {
            HttpSession httpSession;
            Object object3 = this.getExtObj(userSession.getID());
            HttpSession httpSession2 = httpSession = object3 instanceof HttpSession ? (HttpSession)object3 : null;
            if (httpSession != null) {
                httpSession.putValue("isUserSessionValid", (Object)"false");
            }
            this.containsKey.delete(0, this.containsKey.length());
            this.containsKey.append("Session force terminating (").append(" user:").append(userSession.getRealm()).append("/").append(userSession.getUserID()).append(",").append(" userSessionID:").append(userSession.getID()).append(",").append(" httpSessionID:").append(httpSession == null ? "" : httpSession.getId()).append(" )");
            ServiceLogger.logEvent(this.containsKey.substring(0));
            this.logout(userSession);
        }
        if (this.htSessions.size() >= this.QOIV && this.QOIV > 0) {
            ServiceLogger.logError(3630040, 3);
            System.out.println("You have reach the maximum users limit of your license. Please contact our sales to purchase license for more users.");
            throw new TooManyUsersException(630087);
        }
        jRUserSession = new JRUserSession(string, string2, bl);
        this.htSessions.put(jRUserSession.getID(), jRUserSession);
        if (object == null) return jRUserSession;
        this.add.put(jRUserSession.getID(), object);
        return jRUserSession;
    }

    protected boolean isExtraSession(HttpSession httpSession) {
        if (httpSession != null) {
            try {
                String string = (String)httpSession.getValue(TAG_EXTRASESSION);
                if (string != null && string.equals("true")) {
                    return true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                ServiceLogger.logError(illegalStateException, 3);
            }
        }
        return false;
    }

    private boolean addElement(HttpSession httpSession) throws TooManyUsersException {
        if (httpSession != null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)httpSession.getValue(TAG_REQ);
            HttpServletResponse httpServletResponse = (HttpServletResponse)httpSession.getValue(TAG_RES);
            if (httpServletRequest != null && httpServletResponse != null) {
                String string = httpServletRequest.getParameter(TAG_KICKOUT);
                if (string == null) {
                    StringBuffer stringBuffer = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
                    String string2 = httpServletRequest.getQueryString();
                    if (stringBuffer.indexOf("?") == -1) {
                        stringBuffer.append("?");
                        if (string2 != null) {
                            stringBuffer.append(string2);
                            if (!string2.endsWith("&")) {
                                stringBuffer.append("&");
                            }
                        }
                    } else if (!stringBuffer.toString().endsWith("&")) {
                        stringBuffer.append("&");
                    }
                    String string3 = "<html><head>" + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">" + "<title>Extra User Session</title>" + "<style type=\"text/css\"><!--" + ".style1 {font-size: 13px; color:#000000; font-family:Verdana, Arial, Helvetica, sans-serif;}" + ".button {font-size:11px; width:75px; font-family:Tahoma, Verdana, Arial, sans-serif; height:23px; padding-bottom:1px;}" + ".style4 {color: #CC0000}" + "--></style></head>" + "<body style=\"overflow:hidden; margin:0px; border-left: 1px solid #767676;\">" + "<div id=\"logout\" style=\"position: absolute; width:100%; height:100%;\"> " + "<table width=\"100%\" height=\"50%\" border=\"0\" align=\"left\" cellpadding=\"0\" cellspacing=\"0\">" + "  <tr>" + "    <td align=\"center\" valign=\"middle\">" + "<p align=\"center\" class=\"style1\">" + "\t     The maximum user/session limit has been reached, and an extra user/session has already logged on with a special channel.<br>" + "      <span class=\"style4\">Do you want to kick it out and re-logon with this admin user?</span><p>" + ("<form method=\"POST\" action=\"" + stringBuffer + "\">") + "            <input type=\"button\" name=\"jrs.kickOutOldSsn\" class=\"button\" value=\"Yes\" onclick=\"form.action=form.action + 'jrs.kickOutOldSsn=Yes';submit();\">" + "            <input type=\"button\" name=\"jrs.kickOutOldSsn\" class=\"button\" value=\"No\" onclick=\"form.action=form.action + 'jrs.kickOutOldSsn=No';submit();\">" + "    </form></td>" + "  </tr>" + "</table>" + "</div></body></html>";
                    try {
                        httpServletResponse.setStatus(200);
                        httpServletResponse.setContentType("text/html");
                        httpServletResponse.getWriter().write(string3);
                        httpServletResponse.getWriter().flush();
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(3630041, 3);
                        ServiceLogger.logError(iOException);
                    }
                } else {
                    if (string.equals("Yes")) {
                        return true;
                    }
                    String string4 = "<html><head>" + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">" + "<title>Max limited users</title>" + "<style type=\"text/css\"><!--" + ".style1 {font-size: 13px; color:#CC0000; font-family:Verdana, Arial, Helvetica, sans-serif;}" + ".button {font-size:11px; width:75px; font-family:Tahoma, Verdana, Arial, sans-serif; height:23px; padding-bottom:1px;}" + "--></style></head>" + "<body  style=\"overflow:hidden; margin:0px; border-left: 1px solid #767676;\">" + "<div id=\"logout\" style=\"position: absolute; width:100%; height:100%;\"> " + "<table width=\"100%\" height=\"50%\" border=\"0\" align=\"left\" cellpadding=\"0\" cellspacing=\"0\">" + "  <tr>" + "    <td align=\"center\" valign=\"middle\"><p align=\"center\" class=\"style1\">" + "\t   The maximum user/session limit has been reached, and an extra user/session has already logged on with a special channel.<br>If you want to re-logon with new admin user, you must select to kick out the old extra user/session at first." + "    </p></td>" + "  </tr>" + "</table></div>" + "</body></html>";
                    try {
                        httpServletResponse.setStatus(200);
                        httpServletResponse.setContentType("text/html");
                        httpServletResponse.getWriter().write(string4);
                        httpServletResponse.getWriter().flush();
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(3630042, 3);
                        ServiceLogger.logError(iOException);
                    }
                }
                httpSession.putValue(TAG_KICKOUT, (Object)"Yes");
                return false;
            }
            ServiceLogger.logError(3630040, 3);
            System.out.println("You have reach the maximum users limit of your license. Please contact our sales to purchase license for more users.");
            throw new TooManyUsersException(630087);
        }
        return false;
    }

    private void addItem(HttpSession httpSession) {
        HttpServletResponse httpServletResponse;
        if (httpSession != null && (httpServletResponse = (HttpServletResponse)httpSession.getValue(TAG_RES)) != null) {
            String string = "<script>alert('This is an extra user/session logged on with a special channel.\\nIt doesn\\'t have the right to run reports or submit a schedule.');</script>";
            try {
                httpServletResponse.getWriter().write(string);
                httpServletResponse.getWriter().flush();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(3630043, 3);
                ServiceLogger.logError(iOException);
            }
        }
    }

    private UserSession append() {
        UserSession userSession = null;
        Enumeration enumeration = this.htSessions.elements();
        while (enumeration.hasMoreElements()) {
            userSession = (UserSession)enumeration.nextElement();
            Object object = this.getExtObj(userSession.getID());
            if (!this.isExtraSession(object instanceof HttpSession ? (HttpSession)object : null)) continue;
            return userSession;
        }
        return null;
    }

    public Object getExtObj(String string) {
        Object var2_2 = null;
        if (string != null) {
            var2_2 = this.add.get(string);
        }
        return var2_2;
    }

    public String toString() {
        return super.toString() + "[maxSessions=" + this.QOIV + ", authenticator=" + this.addElement + ", Sessions=" + this.htSessions.toString() + "]";
    }

    private UserSession close(String string) {
        UserSession userSession = null;
        Enumeration enumeration = this.htSessions.elements();
        while (enumeration.hasMoreElements()) {
            userSession = (UserSession)enumeration.nextElement();
            if (!userSession.getUserID().equals(string)) continue;
            return userSession;
        }
        return null;
    }

    public boolean needSecurity() {
        return ServerEnv.needSecurity();
    }

    public Vector getUserSessions(String string) {
        if (string == null) {
            return new Vector();
        }
        Vector<UserSession> vector = new Vector<UserSession>();
        Enumeration enumeration = this.htSessions.elements();
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            UserSession userSession = (UserSession)enumeration.nextElement();
            string2 = userSession.getUserID();
            if (string2 == null || string2.compareTo(string) != 0) continue;
            vector.add(userSession);
        }
        return vector;
    }

    protected void startOndemandListClearer() {
        this.ondemandlistclearer = new OndemandListClearer();
        Thread thread = new Thread(this.ondemandlistclearer);
        thread.start();
    }

    protected void setUserOndemandClearTime(String string) {
        if (string == null) {
            return;
        }
        Vector vector = this.getUserSessions(string);
        if (vector.size() <= 1) {
            long l = System.currentTimeMillis();
            long l2 = ServerEnv.getOndemandLaggingTime() * 1000L;
            long l3 = l + l2;
            this.ondemandlistclearer.setClearTime(string, l3);
        }
    }

    public void quit() {
        this.ondemandlistclearer.stop();
        this.ondemandlistclearer = null;
        this.containsKey();
        this.createNewFile();
    }

    private void compareTo(String string, long l) {
        if (!createNewFile.containsKey(string)) {
            LoginQueue loginQueue = new LoginQueue();
            loginQueue.addItem(l);
            createNewFile.put(string, loginQueue);
        } else {
            LoginQueue loginQueue = (LoginQueue)createNewFile.get(string);
            loginQueue.addItem(l);
        }
    }

    private void contains(String string, long l) {
        currentTimeMillis.put(string, Long.toString(l));
    }

    public long getLastLoginTime(String string) {
        if (!createNewFile.containsKey(string)) {
            return 0L;
        }
        LoginQueue loginQueue = (LoginQueue)createNewFile.get(string);
        return loginQueue.getLastItem();
    }

    public long getLastLogoutTime(String string) {
        if (!currentTimeMillis.containsKey(string)) {
            return 0L;
        }
        return Long.parseLong((String)currentTimeMillis.get(string));
    }

    private void containsKey() {
        Object object;
        Object object2;
        Properties properties = new Properties();
        Enumeration enumeration = createNewFile.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (LoginQueue)createNewFile.get(object2);
            properties.setProperty((String)object2, Long.toString(((LoginQueue)object).getCurItem()));
        }
        object2 = null;
        try {
            object = new File(this.delete);
            if (((File)object).exists()) {
                ((File)object).createNewFile();
            }
            object2 = new FileOutputStream(this.delete);
            properties.store((OutputStream)object2, null);
            ((FileOutputStream)object2).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createNewFile() {
        try {
            File file = new File(this.delete);
            if (file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.elements);
            currentTimeMillis.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void currentTimeMillis() {
        File file = new File(this.delete);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.compareTo(string, Long.parseLong(properties.getProperty(string)));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void delete() {
        File file = new File(this.elements);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.elements);
                currentTimeMillis.load(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

