/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import jet.ReportEnv;
import jet.server.ServerEnv;
import jet.server.api.WebPageOptions;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationAdvanced;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;

public class JRWebPageOptions
implements WebPageOptions,
Serializable {
    private static Hashtable QOIV = new Hashtable(2);
    private boolean hasDbOption = true;
    private boolean hasEncoding = true;
    private boolean isShowNameWithPostfix = true;
    private boolean usePermissionDialog = false;
    private boolean hasStyleGroupOption = true;
    private boolean hasConvertEncOption = true;
    private boolean hasTaskListener = true;
    private boolean getToApplet = true;
    private boolean getToHtml = true;
    private boolean getToPdf = true;
    private boolean getToText = true;
    private boolean getToExcel = true;
    private boolean getToPs = true;
    private boolean getToRtf = true;
    private boolean getToXML = true;
    private boolean getToDHTML = true;
    private boolean needSecurity = true;
    private boolean isShowVersionParamContents = true;
    private boolean isPublishTempToVersion = false;
    private boolean isPipeline = true;
    private long reportWaitTimeouts = 500L;
    private String sendfileJSPWebApp = "";
    private String monitorServerWebURL = "";
    private String adhocReportJSPWebApp = "";
    private String dhtmlWebServletPath = "";
    private String dhtmlWebJspPath = "";
    private String helpWebServletPath = "";
    private String adhocServletPath = "";
    private String adhocJSPPath = "";
    private String jrservletPath = "";
    private boolean adhoc = false;
    private int scheme = 0;
    private String engineDefEncoding = "";
    private boolean useRelativeAppUrl = true;
    private boolean isEnableDynamicResource = false;
    private boolean showCatalogNode = false;
    private String webSiteUrl = "";
    private String helpUrl = "";
    private String tutorialUrl = "";
    private String skinDir = "";
    private String rootDirOfFolderSelector = "";
    private String delimiter = "";
    private boolean enableMonitorLink = true;
    private static ArrayList add;
    private int autoRecoverTaskMaxTimes;
    private long autoRecoverTaskInterval;
    private boolean autoRecoverTaskRedoAll;
    private boolean isEnableTaskDuration = false;
    private boolean isAdhoc = false;
    private int ondemandTaskInitPriority;
    private int scheduleTaskInitPriority;
    private boolean isMarkUnviewdResult = false;
    private boolean enablePLS = true;
    private Properties helpDocProp = null;

    public JRWebPageOptions() {
        this.init();
    }

    private void init() {
        this.hasDbOption = ServerEnv.hasDbOption();
        this.hasEncoding = ServerEnv.hasEncoding();
        this.isShowNameWithPostfix = ServerEnv.isShowNameWithPostfix();
        this.usePermissionDialog = ServerEnv.usePermissionDialog();
        this.hasStyleGroupOption = ServerEnv.hasStyleGroupOption();
        this.hasConvertEncOption = ServerEnv.hasConvertEncOption();
        this.hasTaskListener = ServerEnv.hasTaskListener();
        this.getToApplet = ServerEnv.getToApplet();
        this.getToHtml = ServerEnv.getToHtml();
        this.getToPdf = ServerEnv.getToPdf();
        this.getToText = ServerEnv.getToText();
        this.getToExcel = ServerEnv.getToExcel();
        this.getToPs = ServerEnv.getToPs();
        this.getToRtf = ServerEnv.getToRtf();
        this.getToXML = ServerEnv.getToXML();
        this.getToDHTML = ServerEnv.getToDHTML();
        this.needSecurity = ServerEnv.needSecurity();
        this.isShowVersionParamContents = ServerEnv.isShowVersionParamContents();
        this.isPublishTempToVersion = ServerEnv.isPublishTempToVersion();
        this.isPipeline = ServerEnv.isPipeline();
        this.reportWaitTimeouts = ServerEnv.getReportWaitTimeouts();
        this.sendfileJSPWebApp = ServerEnv.getJSPWebAppName("jsp.webapp.sendfile");
        this.monitorServerWebURL = ServerEnv.getJSPWebAppName("monitor.server.web.url");
        this.adhocReportJSPWebApp = ServerEnv.getJSPWebAppName("jsp.webapp.adhocreport");
        this.dhtmlWebServletPath = ServerEnv.getJSPWebAppName("jsp.webapp.dhtml");
        this.dhtmlWebJspPath = ServerEnv.getJSPWebAppName("jsp.webapp.dhtmljsp");
        this.helpWebServletPath = ServerEnv.getJSPWebAppName("jsp.webapp.help");
        this.adhocServletPath = ServerEnv.getAdhocServletPath();
        this.adhocJSPPath = ServerEnv.getAdhocJspPath();
        this.jrservletPath = ServerEnv.getJRServletPath();
        this.engineDefEncoding = ServerEnv.getEngineDefaultEncoding();
        if (this.engineDefEncoding == null) {
            System.getProperty("file.encoding");
        }
        this.useRelativeAppUrl = ServerEnv.useRelativeAppUrl();
        this.isEnableDynamicResource = ServerEnv.isEnableDynamicResource();
        this.showCatalogNode = ServerEnv.showCatalogNode();
        this.webSiteUrl = ServerEnv.getWebSiteUrl();
        this.helpUrl = ServerEnv.getHelpUrl();
        this.tutorialUrl = ServerEnv.getTutorialUrl();
        this.skinDir = ServerEnv.getSkinDir();
        this.rootDirOfFolderSelector = ServerEnv.getRootDirOfFolderSelector();
        this.delimiter = ServerEnv.getMultipleParameterValuesDelimiter();
        this.enableMonitorLink = ServerEnv.isEnableMonitorLink();
        this.autoRecoverTaskMaxTimes = ServerEnv.getAutoRecoverTaskMaxTimes();
        this.autoRecoverTaskInterval = ServerEnv.getAutoRecoverTaskInterval();
        this.autoRecoverTaskRedoAll = ServerEnv.getAutoRecoverTaskRedoAll();
        this.isEnableTaskDuration = ServerEnv.isEnableTaskDuration();
        this.isAdhoc = ReportEnv.isWebAdHoc();
        this.adhoc = ServerEnv.getAdHocUser() > 0;
        this.scheme = (Integer)QOIV.get(HttpUtil.getAuthScheme());
        this.ondemandTaskInitPriority = ServerEnv.getOndemandTaskInitPriority();
        this.scheduleTaskInitPriority = ServerEnv.getScheduleTaskInitPriority();
        this.isMarkUnviewdResult = ServerEnv.isMarkUnviewedResultVersion();
        this.enablePLS = ServerEnv.isEnablePLStoVersion();
        this.helpDocProp = ServerEnv.getHelpDocProperties();
    }

    public boolean hasDbOption() {
        return this.hasDbOption;
    }

    public boolean hasEncoding() {
        return this.hasEncoding;
    }

    public boolean isShowNameWithPostfix() {
        return this.isShowNameWithPostfix;
    }

    public boolean usePermissionDialog() {
        return this.usePermissionDialog;
    }

    public boolean hasStyleGroupOption() {
        return this.hasStyleGroupOption;
    }

    public boolean hasConvertEncOption() {
        return this.hasConvertEncOption;
    }

    public boolean hasTaskListener() {
        return this.hasTaskListener;
    }

    public boolean getToApplet() {
        return this.getToApplet;
    }

    public boolean getToHtml() {
        return this.getToHtml;
    }

    public boolean getToPdf() {
        return this.getToPdf;
    }

    public boolean getToText() {
        return this.getToText;
    }

    public boolean getToExcel() {
        return this.getToExcel;
    }

    public boolean getToPs() {
        return this.getToPs;
    }

    public boolean getToRtf() {
        return this.getToRtf;
    }

    public boolean getToXML() {
        return this.getToXML;
    }

    public boolean getToDHTML() {
        return this.getToDHTML;
    }

    public boolean hasNewWindowSameName() {
        return true;
    }

    public boolean needSecurity() {
        return this.needSecurity;
    }

    public boolean isShowVersionParamContents() {
        return this.isShowVersionParamContents;
    }

    public boolean isPublishTempToVersion() {
        return this.isPublishTempToVersion;
    }

    public boolean isPublishTempToVersion(String string) {
        if (string != null && this.isPipeline() && (string.endsWith("html") || string.endsWith("htm"))) {
            return false;
        }
        return this.isPublishTempToVersion();
    }

    public boolean isPipeline() {
        return this.isPipeline;
    }

    public long getReportWaitTimeouts() {
        return this.reportWaitTimeouts;
    }

    public String getJSPWebAppName(String string) {
        if (string.equals("jsp.webapp.sendfile")) {
            return this.sendfileJSPWebApp;
        }
        if (string.equals("monitor.server.web.url")) {
            return this.monitorServerWebURL;
        }
        if (string.equals("jsp.webapp.adhocreport")) {
            return this.adhocReportJSPWebApp;
        }
        if (string.equals("jsp.webapp.dhtml")) {
            return this.dhtmlWebServletPath;
        }
        if (string.equals("jsp.webapp.dhtmljsp")) {
            return this.dhtmlWebJspPath;
        }
        if (string.equals("jsp.webapp.help")) {
            return this.helpWebServletPath;
        }
        return "";
    }

    public String getAdhocServletPath() {
        return this.adhocServletPath;
    }

    public String getAdhocJspPath() {
        return this.adhocJSPPath;
    }

    public String getJRServletPath() {
        return this.jrservletPath;
    }

    public boolean getAdHoc() {
        return this.adhoc;
    }

    public int getActiveRealmScheme() {
        return this.scheme;
    }

    public String getEngineDefaultEncoding() {
        return this.engineDefEncoding;
    }

    public boolean useRelativeWebAppUrl() {
        return this.useRelativeAppUrl;
    }

    public boolean isEnableDynamicResource() {
        return this.isEnableDynamicResource;
    }

    public boolean showCatalogNode() {
        return this.showCatalogNode;
    }

    public String getWebSiteUrl() {
        return this.webSiteUrl;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public String getHelpPage(String string) {
        return this.helpDocProp.getProperty(string);
    }

    public String getTutorialUrl() {
        return this.tutorialUrl;
    }

    public String getSkinDir() {
        return ServerEnv.getSkinDir(null);
    }

    public String getSkinDir(HttpServletRequest httpServletRequest) {
        return ServerEnv.getSkinDir(httpServletRequest);
    }

    public String getRootDirOfFolderSelector() {
        return this.rootDirOfFolderSelector;
    }

    public boolean isEnableRoleBasedAuthorization() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isEnableRoleBasedAuthorization();
    }

    public boolean isEnableDispalyUserPermissionUI() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isEnableDispalyUserPermissionUI();
    }

    public boolean isEnableDispalyRolePermissionUI() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isEnableDispalyRolePermissionUI();
    }

    public boolean isEnableDispalyGroupPermissionUI() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isEnableDispalyGroupPermissionUI();
    }

    public String getMultipleParameterValuesDelimiter() {
        return this.delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMonitoringWebURL() {
        String string;
        String string2 = null;
        ArrayList arrayList = add;
        synchronized (arrayList) {
            int n = add.size() - 1;
            while (n >= 0) {
                string = (String)add.get(n);
                if (HttpUtil.isValidMonitoringURL(string)) {
                    string2 = string;
                    break;
                }
                add.remove(n);
                --n;
            }
        }
        if (string2 == null && !ServerEnv.isClusterAdminServer()) {
            String string3 = ServerEnv.getClusterAdminHost();
            string = ServerEnv.getClusterAdminRMIPort();
            string2 = HttpUtil.getValidMonitoringURL(string3, string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonitoringWebURL(String string) {
        ArrayList arrayList = add;
        synchronized (arrayList) {
            if (!add.contains(string)) {
                add.add(string);
            }
        }
    }

    public boolean isEnableMonitorLink() {
        return this.enableMonitorLink;
    }

    public int getAutoRecoverTaskMaxTimes() {
        return this.autoRecoverTaskMaxTimes;
    }

    public long getAutoRecoverTaskInterval() {
        return this.autoRecoverTaskInterval;
    }

    public boolean getAutoRecoverTaskRedoAll() {
        return this.autoRecoverTaskRedoAll;
    }

    public boolean isEnableTaskDuration() {
        return this.isEnableTaskDuration;
    }

    public boolean isWebAdHoc() {
        return this.isAdhoc;
    }

    public int getOndemandTaskInitPriority() {
        return this.ondemandTaskInitPriority;
    }

    public int getScheduleTaskInitPriority() {
        return this.scheduleTaskInitPriority;
    }

    public boolean isPromptTaskQueueFull() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isPromptTaskQueueFull();
    }

    public boolean isPromptActionQueueFull() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isPromptActionQueueFull();
    }

    public boolean isMarkUnviewedResultVersion() {
        return this.isMarkUnviewdResult;
    }

    public boolean isEnablePageLevelSecurity() {
        return this.enablePLS;
    }

    static {
        QOIV.put("Basic", new Integer(0));
        QOIV.put("Digest", new Integer(1));
        add = new ArrayList();
    }
}

