/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.api.admin.cfg.ConfigurationAdhocUpload;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;

public class JRConfigurationAdhocUpload
implements ConfigurationAdhocUpload {
    private Properties QOIV = new Properties();

    public JRConfigurationAdhocUpload() {
        this.QOIV();
    }

    private void QOIV() {
        try {
            this.QOIV.setProperty("upload.uppersize", "0");
            this.QOIV.setProperty("upload.img.jpg", "true");
            this.QOIV.setProperty("upload.img.gif", "true");
            this.QOIV.setProperty("upload.img.png", "true");
            Properties properties = SchdTools.loadBinProperties("adhoc-upload.properties");
            if (properties != null) {
                this.QOIV.putAll((Map<?, ?>)properties);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private void add() {
        try {
            SchdTools.saveBinProperties(this.QOIV, "adhoc-upload.properties");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String[] getUploadEnableFileTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Object> iterator = this.QOIV.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("upload.img.") || !CSUtil.getBoolean(this.QOIV.getProperty(string), false)) continue;
            arrayList.add(string.substring("upload.img.".length()));
        }
        return arrayList.toArray(new String[0]);
    }

    public int getUploadUpperSize() {
        return CSUtil.parseInt(this.QOIV.getProperty("upload.uppersize"), 0);
    }

    public void setUploadUpperSize(int n) {
        this.QOIV.setProperty("upload.uppersize", String.valueOf(n));
        this.add();
    }

    public boolean isUploadEnable(String string) {
        return CSUtil.getBoolean(this.QOIV.getProperty("upload.img." + string), false);
    }

    public void setUploadEnable(String string, boolean bl) {
        this.QOIV.setProperty("upload.img." + string, String.valueOf(bl));
        this.add();
    }
}

