/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.api.admin.cfg.ConfigurationFax;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRSFax;

public class JRConfigurationFax
implements ConfigurationFax {
    public static final String TAG_DIALING = "dialing";
    public static final String TAG_FLOW_CONTROL = "flow_control";
    public static final String TAG_FLOW_COMMAND = "flow_command";
    public static final String TAG_MODEM_CLASS = "modem_class";
    public static final String TAG_TIME_OUT = "time_out";
    public static final String TAG_MAX_RETRIES = "max_retries";
    public static final String TAG_PORT = "port";
    public static final String TAG_INIT_STRING = "init_string";
    public static final String TAG_VIA_FAX_SERVER = "via_fax_server";
    public static final String TAG_CONNECTOR = "connector";
    public static final String TAG_SPECIAL_PARAMETERS = "special_parameters";
    public static final String TAG_SERVER_IP = "server_ip";
    public static final String TAG_SERVER_PORT = "server_port";
    public static final String TAG_USER_ID = "user_id";
    public static final String TAG_PASSWORD = "password";
    public static final String TAG_USER_NAME = "user_name";
    Properties p = null;

    public JRConfigurationFax() {
        try {
            this.p = SchdTools.loadFaxConfig();
            int n = CSUtil.parseInt(this.p.getProperty(TAG_DIALING), 0);
            int n2 = CSUtil.parseInt(this.p.getProperty(TAG_FLOW_CONTROL), 0);
            int n3 = CSUtil.parseInt(this.p.getProperty(TAG_FLOW_COMMAND), 0);
            int n4 = CSUtil.parseInt(this.p.getProperty(TAG_MODEM_CLASS), 0);
            int n5 = CSUtil.parseInt(this.p.getProperty(TAG_TIME_OUT), 0);
            int n6 = CSUtil.parseInt(this.p.getProperty(TAG_MAX_RETRIES), 0);
            String string = this.p.getProperty(TAG_PORT);
            String string2 = this.p.getProperty(TAG_INIT_STRING);
            JRSFax.setDefaultValues(n, n2, n3, n4, n5, n6, string == null ? "" : string, string2 == null ? "" : string2);
        }
        catch (Exception exception) {
            this.p = new Properties();
            ServiceLogger.logError(exception);
        }
    }

    public void setDialing(int n) {
        this.p.put(TAG_DIALING, String.valueOf(n));
        this.QOIV();
    }

    public int getDialing() {
        return CSUtil.parseInt((String)this.p.get(TAG_DIALING), 0);
    }

    public void setModemClass(int n) {
        this.p.put(TAG_MODEM_CLASS, String.valueOf(n));
        this.QOIV();
    }

    public int getModemClass() {
        return CSUtil.parseInt((String)this.p.get(TAG_MODEM_CLASS), 0);
    }

    public void setFlowControl(int n) {
        this.p.put(TAG_FLOW_CONTROL, String.valueOf(n));
        this.QOIV();
    }

    public int getFlowControl() {
        return CSUtil.parseInt((String)this.p.get(TAG_FLOW_CONTROL), 0);
    }

    public void setFlowCommand(int n) {
        this.p.put(TAG_FLOW_COMMAND, String.valueOf(n));
        this.QOIV();
    }

    public int getFlowCommand() {
        return CSUtil.parseInt((String)this.p.get(TAG_FLOW_COMMAND), 0);
    }

    public void setPort(String string) {
        this.p.put(TAG_PORT, string == null ? "" : string);
        this.QOIV();
    }

    public String getPort() {
        return (String)this.p.get(TAG_PORT);
    }

    public void setInitString(String string) {
        this.p.put(TAG_INIT_STRING, string == null ? "" : string);
        this.QOIV();
    }

    public String getInitString() {
        return (String)this.p.get(TAG_INIT_STRING);
    }

    public void setViaFaxServer(boolean bl) {
        this.p.put(TAG_VIA_FAX_SERVER, bl ? "true" : "false");
        this.QOIV();
    }

    public boolean viaFaxServer() {
        return CSUtil.getBoolean((String)this.p.get(TAG_VIA_FAX_SERVER), false);
    }

    public void setConnector(String string) {
        this.p.put(TAG_CONNECTOR, string == null ? "" : string);
        this.QOIV();
    }

    public String getConnector() {
        if (this.p.get(TAG_CONNECTOR) == null && this.p.get("connetor") != null) {
            this.p.put(TAG_CONNECTOR, (String)this.p.get("connetor"));
            this.p.remove("connetor");
            this.QOIV();
        }
        return (String)this.p.get(TAG_CONNECTOR);
    }

    public void setServerIP(String string) {
        this.p.put(TAG_SERVER_IP, string == null ? "" : string);
        this.QOIV();
    }

    public String getServerIP() {
        return (String)this.p.get(TAG_SERVER_IP);
    }

    public void setServerPort(int n) {
        this.p.put(TAG_SERVER_PORT, String.valueOf(n));
        this.QOIV();
    }

    public int getServerPort() {
        return CSUtil.parseInt((String)this.p.get(TAG_SERVER_PORT), 0);
    }

    public void setUserID(String string) {
        this.p.put(TAG_USER_ID, string == null ? "" : string);
        this.QOIV();
    }

    public String getUserID() {
        return (String)this.p.get(TAG_USER_ID);
    }

    public void setPassword(String string) {
        this.p.put(TAG_PASSWORD, string == null ? "" : string);
        this.QOIV();
    }

    public String getPassword() {
        return (String)this.p.get(TAG_PASSWORD);
    }

    public void setUserName(String string) {
        this.p.put(TAG_USER_NAME, string == null ? "" : string);
        this.QOIV();
    }

    public String getUserName() {
        return (String)this.p.get(TAG_USER_NAME);
    }

    public void setSpecParameters(String string) {
        this.p.put(TAG_SPECIAL_PARAMETERS, string == null ? "" : string);
        this.QOIV();
    }

    public String getSpecParameters() {
        return (String)this.p.get(TAG_SPECIAL_PARAMETERS);
    }

    public void setTimeOut(int n) {
        this.p.put(TAG_TIME_OUT, String.valueOf(n));
        this.QOIV();
    }

    public int getTimeOut() {
        return CSUtil.parseInt((String)this.p.get(TAG_TIME_OUT), 0);
    }

    public void setMaxRetries(int n) {
        this.p.put(TAG_MAX_RETRIES, String.valueOf(n));
        this.QOIV();
    }

    public int getMaxRetries() {
        return CSUtil.parseInt((String)this.p.get(TAG_MAX_RETRIES), 0);
    }

    private void QOIV() {
        try {
            SchdTools.saveFaxConfig(this.p);
            int n = CSUtil.parseInt(this.p.getProperty(TAG_DIALING), 0);
            int n2 = CSUtil.parseInt(this.p.getProperty(TAG_FLOW_CONTROL), 0);
            int n3 = CSUtil.parseInt(this.p.getProperty(TAG_FLOW_COMMAND), 0);
            int n4 = CSUtil.parseInt(this.p.getProperty(TAG_MODEM_CLASS), 0);
            int n5 = CSUtil.parseInt(this.p.getProperty(TAG_TIME_OUT), 0);
            int n6 = CSUtil.parseInt(this.p.getProperty(TAG_MAX_RETRIES), 0);
            String string = this.p.getProperty(TAG_PORT);
            String string2 = this.p.getProperty(TAG_INIT_STRING);
            JRSFax.setDefaultValues(n, n2, n3, n4, n5, n6, string == null ? "" : string, string2 == null ? "" : string2);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

