/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import com.jinfonet.util.JRLogger;
import jet.JSvrResource;
import jet.server.api.admin.cfg.ConfigurationLog;
import jet.server.api.admin.cfg.logger.ConfigAppender;
import jet.server.api.admin.cfg.logger.ConfigFileAppender;
import jet.server.api.admin.cfg.logger.ConfigLogger;
import jet.server.api.admin.cfg.logger.ConfigRollingFileAppender;
import jet.server.api.admin.cfg.logger.ConfigSocketAppender;
import jet.server.log.JRLoggerConfigService;
import jet.server.log.LogConfigFactory;
import jet.server.log.ServiceLogger;

public class JRConfigurationLog
implements ConfigurationLog {
    private boolean DST_NAMES;
    LogConfigFactory LEVELS;
    private ConfigLogger[] LOG_NAMES;

    public ConfigLogger[] getLoggers() {
        this.load();
        return this.LEVELS.getLoggers();
    }

    public void load() {
        boolean bl = JRLoggerConfigService.instance().getConfigFile().load();
        if (bl || !this.DST_NAMES) {
            this.LEVELS = new LogConfigFactory();
        }
        this.DST_NAMES = true;
    }

    public boolean update() {
        boolean bl = false;
        bl = JRLoggerConfigService.instance().getConfigFile().save();
        JRLoggerConfigService.instance().update();
        return bl;
    }

    public String getDescription(int n) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            return configLogger.getDescription();
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00012", "" + n), 3);
        }
        return "";
    }

    public void setLogLevel(int n, int n2) {
        String string;
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null && (string = this.LEVELS(n2)) != null) {
            configLogger.setLevel(string);
            this.update();
            return;
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"setLogLevel", "" + n, "logLevel", "" + n2}), 3);
        }
    }

    public int getLogLevel(int n) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            return JRLogger.getLevelValue((String)configLogger.getLevel());
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00012", "" + n), 3);
        }
        return -1;
    }

    public void setLogToType(int n, int n2) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            int n3 = 0;
            while (n3 < configAppenderArray.length) {
                configAppenderArray[n3].setSelected(false);
                ++n3;
            }
            boolean bl = false;
            switch (n2) {
                case 0: {
                    configAppenderArray[0].setSelected(true);
                    bl = true;
                    break;
                }
                case 1: {
                    configAppenderArray[1].setSelected(true);
                    bl = true;
                    break;
                }
                case 2: {
                    configAppenderArray[3].setSelected(true);
                    bl = true;
                    break;
                }
                case 3: 
                case 4: {
                    configAppenderArray[8].setSelected(true);
                    bl = true;
                    break;
                }
                default: {
                    if (n2 < 0 || n2 >= configAppenderArray.length) break;
                    configAppenderArray[n2].setSelected(true);
                    bl = true;
                }
            }
            if (bl) {
                this.update();
                return;
            }
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"setLogToType", "" + n, "logToType", "" + n2}), 3);
        }
    }

    public int getLogToType(int n) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            int n2 = 0;
            while (n2 < configAppenderArray.length) {
                if (configAppenderArray[n2].isSelected()) {
                    return n2;
                }
                ++n2;
            }
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00012", "" + n), 3);
        }
        return -1;
    }

    public void setLogToFilename(int n, String string) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            int n2 = 0;
            while (n2 < 3) {
                ((ConfigFileAppender)configAppenderArray[n2]).setFileName(string);
                ++n2;
            }
            this.update();
            return;
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"setLogToFilename", "" + n, "logToFilename", string}), 3);
        }
    }

    public String getLogToFilename(int n) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            return ((ConfigFileAppender)configAppenderArray[0]).getFileName();
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00012", "" + n), 3);
        }
        return "";
    }

    public void setRolloverSize(int n, int n2) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            ((ConfigRollingFileAppender)configAppenderArray[1]).setMaxFileSize(n2);
            this.update();
            return;
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"setRolloverSize", "" + n, "rolloverSize", "" + n2}), 3);
        }
    }

    public int getRolloverSize(int n) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            return (int)((ConfigRollingFileAppender)configAppenderArray[1]).getMaxFileSize();
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00012", "" + n), 3);
        }
        return -1;
    }

    public void setBufferSize(int n, int n2) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            int n3 = 0;
            while (n3 < 3) {
                ((ConfigFileAppender)configAppenderArray[n3]).setBufferSize(n2);
                ++n3;
            }
            this.update();
            return;
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"setBufferSize", "" + n, "size", "" + n2}), 3);
        }
    }

    public int getBufferSize(int n) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            return ((ConfigFileAppender)configAppenderArray[0]).getBufferSize();
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00012", "" + n), 3);
        }
        return -1;
    }

    public void setFlushTime(int n, int n2) {
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"setFlushTime", "" + n, "flushTime", "" + n2}), 3);
        }
    }

    public int getFlushTime(int n) {
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"getFlushTime", "" + n, "", ""}), 3);
        }
        return -1;
    }

    public void setHost(int n, String string) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            ((ConfigSocketAppender)configAppenderArray[3]).setHost(string);
            this.update();
            return;
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"setHost", "" + n, "host", string}), 3);
        }
    }

    public String getHost(int n, String string) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            if (string == null || string.equals("socket")) {
                return ((ConfigSocketAppender)configAppenderArray[3]).getHost();
            }
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"getHost", "" + n, "logTo", string}), 3);
        }
        return "";
    }

    public void setPort(int n, int n2) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            ((ConfigSocketAppender)configAppenderArray[3]).setPort(n2);
            this.update();
            return;
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"setPort", "" + n, "port", "" + n2}), 3);
        }
    }

    public int getPort(int n, String string) {
        ConfigLogger configLogger = this.DST_NAMES(n);
        if (configLogger != null) {
            ConfigAppender[] configAppenderArray = configLogger.getAppenders();
            if (string == null || string.equals("socket")) {
                return ((ConfigSocketAppender)configAppenderArray[3]).getPort();
            }
        }
        if (ServiceLogger.isLoggable(2, 3)) {
            ServiceLogger.logError(JSvrResource.getMessage("LOGGING_M_00013", new String[]{"getPort", "" + n, "logTo", string}), 3);
        }
        return -1;
    }

    public String[] getTypeList() {
        return LogConfigFactory.LOG_NAMES;
    }

    public String[] getTypePromptList() {
        return LogConfigFactory.logPrompts;
    }

    public String[] getOutTypeList() {
        return LogConfigFactory.DST_NAMES;
    }

    public String[] getLogLevelList() {
        return ConfigLogger.LEVELS;
    }

    public void loadProperties() {
        this.LOG_NAMES = this.getLoggers();
    }

    private ConfigLogger DST_NAMES(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return this.LOG_NAMES[n + 2];
    }

    private String LEVELS(int n) {
        String string = null;
        try {
            string = JRLogger.getMappedLevel((int)n).toString();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return string;
    }
}

