/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.export.mail.mailconfig;
import jet.server.api.admin.cfg.ConfigurationMail;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;

public class JRConfigurationMail
implements ConfigurationMail {
    Properties p = null;

    public JRConfigurationMail() {
        try {
            this.p = SchdTools.loadMailConfig();
        }
        catch (Exception exception) {
            this.p = new Properties();
            ServiceLogger.logError(exception);
        }
    }

    public void setMailServer(String string) {
        if (mailconfig.SMTPServerIP != null) {
            this.p.put("smtp.server", string);
            this.saveProperty();
        }
    }

    public String getMailServer() {
        String string = this.p.getProperty("smtp.server");
        if (string == null) {
            string = mailconfig.SMTPServerIP == null ? "" : mailconfig.SMTPServerIP;
        }
        return string;
    }

    public void setMailPort(int n) {
        this.p.put("smtp.server.port", String.valueOf(n));
        this.saveProperty();
    }

    public int getMailPort() {
        int n = 25;
        String string = this.p.getProperty("smtp.server.port");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logError(numberFormatException, 3);
            }
        }
        return n;
    }

    public void setMailBox(String string) {
        if (mailconfig.MyMailAddress != null) {
            this.p.put("mailbox", string);
            this.saveProperty();
        }
    }

    public String getMailBox() {
        String string = this.p.getProperty("mailbox");
        if (string == null) {
            string = mailconfig.MyMailAddress == null ? "" : mailconfig.MyMailAddress;
        }
        return string;
    }

    public void setMailFormat(int n) {
        this.p.put("default.format", String.valueOf(n));
        this.saveProperty();
    }

    public int getDefaultMailFormat() {
        int n = CSUtil.parseInt(this.p.getProperty("default.format"), mailconfig.defaultIndex);
        return n;
    }

    public Vector getMailFormats() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < mailconfig.mailformat.length) {
            vector.addElement(mailconfig.mailformat[n]);
            ++n;
        }
        return vector;
    }

    public void setEnableCompress(boolean bl) {
        this.p.put("compress.mail", String.valueOf(bl));
        this.saveProperty();
    }

    public boolean getEnableCompress() {
        boolean bl = CSUtil.getBoolean(this.p.getProperty("compress.mail"), mailconfig.CompressMail);
        return bl;
    }

    public void saveProperty() {
        try {
            this.p = SchdTools.saveMailConfig(this.p);
            SchdTools.setMailConfig(this.p);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setMaxMailSize(int n) {
        this.p.put("Tag_MaxMailSize", String.valueOf(n));
        this.saveProperty();
    }

    public int getMaxMailSize() {
        int n = CSUtil.parseInt(this.p.getProperty("Tag_MaxMailSize"), mailconfig.maxMailSize);
        return n;
    }

    public void setMaxMailPage(int n) {
        this.p.put("Tag_MaxMailPage", String.valueOf(n));
        this.saveProperty();
    }

    public int getMaxMailPage() {
        int n = CSUtil.parseInt(this.p.getProperty("Tag_MaxMailPage"), -1);
        return n;
    }

    public void setSplitBy(int n) {
        this.p.put("Tag_SplitBy", String.valueOf(n));
        this.saveProperty();
    }

    public int getSplitBy() {
        int n = CSUtil.parseInt(this.p.getProperty("Tag_SplitBy"), 0);
        return n;
    }

    public boolean getAuthentication() {
        boolean bl = CSUtil.getBoolean(this.p.getProperty("smtp.authentication"), mailconfig.CompressMail);
        return bl;
    }

    public void setAuthentication(boolean bl) {
        this.p.put("smtp.authentication", String.valueOf(bl));
        this.saveProperty();
    }
}

