/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationService;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;

public class JRConfigurationService
implements ConfigurationService {
    private ExProperties DEFAULT_SSL_KEYSTORE = new ExProperties();
    private String QOIV = ServerEnv.getServPropName();
    private Properties addElement = new Properties();
    static Class class$jet$server$userman$Realm;

    public JRConfigurationService() {
        this.loadProperties();
    }

    public void loadProperties() {
        try {
            this.DEFAULT_SSL_KEYSTORE.load(this.QOIV);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public boolean setPort(int n) {
        boolean bl = false;
        try {
            int n2 = n;
            if (n2 <= 0 || n2 > 65535) {
                throw new Exception();
            }
            if (n2 != ServerEnv.getAdminPort()) {
                this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.port", n2);
                this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
                this.addElement.put("httpserver.port", String.valueOf(n2));
                bl = true;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    public int getPort() {
        String string = (String)this.addElement.get("httpserver.port");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getPort();
    }

    public void setAdminPort(int n) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.admin.port", n);
        this.addElement.put("httpserver.admin.port", String.valueOf(n));
        try {
            this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    public int getAdminPort() {
        String string = (String)this.addElement.get("httpserver.admin.port");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getAdminPort();
    }

    public boolean setMaxNumberOfHandler(int n) {
        boolean bl = false;
        try {
            int n2 = n;
            if (n2 < 0) {
                throw new Exception();
            }
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.max.handlers", n2);
            this.addElement.put("httpserver.max.handlers", String.valueOf(n2));
            this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
            bl = true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    public int getMaxNumberOfHandler() {
        String string = (String)this.addElement.get("httpserver.max.handlers");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMaxHandlers();
    }

    public boolean setMaxNumberOfConnection(int n) {
        boolean bl = false;
        try {
            int n2 = n;
            if (n2 < 0) {
                throw new Exception();
            }
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.max.connections", n2);
            this.addElement.put("httpserver.max.connections", String.valueOf(n2));
            this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
            bl = true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    public int getMaxNumberOfConnection() {
        String string = (String)this.addElement.get("httpserver.max.connections");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMaxConnections();
    }

    public boolean setConnectionTimeout(int n) {
        boolean bl = false;
        try {
            int n2 = n;
            if (n2 < 0) {
                throw new Exception();
            }
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.timeout", n2);
            this.addElement.put("httpserver.timeout", String.valueOf(n2));
            this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
            bl = true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return bl;
    }

    public int getConnectionTimeout() {
        String string = (String)this.addElement.get("httpserver.timeout");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getTimeout();
    }

    public boolean setServletPropertyFileName(String string) {
        boolean bl = false;
        try {
            String string2 = string;
            if (!new File(string2).exists()) {
                throw new Exception();
            }
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.servlet.propfile", string2);
            this.addElement.put("httpserver.servlet.propfile", string2);
            this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
            bl = true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    public String getServletPropertyFileName() {
        String string = (String)this.addElement.get("httpserver.servlet.propfile");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        String string2 = "";
        try {
            string2 = ServerEnv.getServerProps().getProperty("httpserver.servlet.propfile", System.getProperty("reporthome", ".") + File.separator + "bin" + File.separator + "servlet.properties");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return string2;
    }

    public void setActiveRealm(String string) {
        try {
            this.DEFAULT_SSL_KEYSTORE.setProperty("server.realm.active", string);
            this.addElement.put("server.realm.active", string);
            this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRealms() {
        Vector<String> vector = new Vector<String>();
        Class clazz = class$jet$server$userman$Realm == null ? (class$jet$server$userman$Realm = JRConfigurationService.class$("jet.server.userman.Realm")) : class$jet$server$userman$Realm;
        synchronized (clazz) {
            Iterator iterator = UserDataToolkit.getRealmNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                vector.addElement(string);
            }
        }
        return vector;
    }

    public String getActiveRealm() {
        String string = (String)this.addElement.get("server.realm.active");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        String string2 = ServerEnv.getActiveRealm();
        return string2;
    }

    public boolean getServiceOnAll() {
        String string = (String)this.addElement.get("httpserver.host.all");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.useAllHosts();
    }

    public void setServiceOnAll(boolean bl) {
        try {
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.host.all", bl);
            this.addElement.put("httpserver.host.all", String.valueOf(bl));
            this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public Vector getHostAddresses() {
        InetAddress[] inetAddressArray = ServerEnv.getHostAddrs();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < inetAddressArray.length) {
            String string = inetAddressArray[n].toString();
            vector.addElement(string);
            ++n;
        }
        return vector;
    }

    public String getHostName() {
        String string = (String)this.addElement.get("httpserver.host.name");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getHostName();
    }

    public void setHostName(String string) {
        try {
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.host.name", string);
            this.addElement.put("httpserver.host.name", string);
            this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private void DEFAULT_SSL_KEYSTORE() {
        try {
            this.DEFAULT_SSL_KEYSTORE.save(this.QOIV, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public boolean isEnableSSL() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.enable", false);
    }

    public void setEnableSSL(boolean bl) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.enable", bl);
        this.DEFAULT_SSL_KEYSTORE();
    }

    public int getSSLPort() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.port", 6888);
    }

    public void setSSLPort(int n) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.port", n);
        this.DEFAULT_SSL_KEYSTORE();
    }

    public int getSSLAdminPort() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.admin.port", 6889);
    }

    public void setSSLAdminPort(int n) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.admin.port", n);
        this.DEFAULT_SSL_KEYSTORE();
    }

    public String getSSLKeystoreFile() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.keystore", ServerEnv.DEFAULT_SSL_KEYSTORE);
    }

    public void setSSLKeystoreFile(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.keystore", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    public String getSSLKeystorePassword() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.keystore.password", "jinfonet");
    }

    public void setSSLKeystorePassword(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.keystore.password", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    public String getSSLKeystoreType() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.keystore.type", "JKS");
    }

    public void setSSLKeystoreType(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.keystore.type", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    public String getSSLAlgorithm() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.algorithm", "sunx509");
    }

    public void setSSLAlgorithm(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.algorithm", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    public String getSSLProtocol() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.protocol", "SSL");
    }

    public void setSSLProtocol(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.protocol", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

