/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.monitor;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.RptServer;
import jet.server.api.UserSession;
import jet.server.api.monitor.UserSessionMonitor;
import jet.server.jrserver.JRUserSessionManager;
import jet.server.log.ServiceLogger;
import toolkit.db.MiniSort;
import toolkit.db.SortCompareInterface;

public class JRUserSessionMonitor
implements UserSessionMonitor,
SortCompareInterface {
    private RptServer QOIV = null;
    private int[] addElement = new int[0];
    private ExProperties compareTo = new ExProperties();
    private String elementAt = ServerEnv.getServPropName();

    public JRUserSessionMonitor(RptServer rptServer) {
        this.QOIV = rptServer;
        try {
            this.compareTo.load(this.elementAt);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    public Vector getAllUserSessions() {
        Vector vector = new Vector();
        Enumeration enumeration = this.QOIV.getUserSessionManager().getAllUserSessions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getAllUserSessionsByUserID(String string) {
        UserSession userSession = null;
        Vector<UserSession> vector = new Vector<UserSession>();
        Vector vector2 = this.getAllUserSessions();
        int n = 0;
        int n2 = vector2.size();
        while (n < n2) {
            userSession = (UserSession)vector2.elementAt(n);
            if (userSession.getUserID().equalsIgnoreCase(string)) {
                vector.addElement(userSession);
            }
            ++n;
        }
        return vector;
    }

    public Vector getSortedUserSessions(Vector vector, int[] nArray) {
        this.addElement = nArray;
        return MiniSort.sort(vector, this);
    }

    public void removeUserSessionBySessionID(String string) {
        this.QOIV.getUserSessionManager().logout(this.QOIV.getUserSessionManager().getUserSession(string));
    }

    public void removeUserSessionsByUserID(String string) {
        Vector vector = this.getAllUserSessionsByUserID(string);
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            this.QOIV.getUserSessionManager().logout((UserSession)vector.elementAt(n));
            ++n;
        }
    }

    public void removeAllSelectedUserSessions(String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            this.QOIV.getUserSessionManager().logout(this.QOIV.getUserSessionManager().getUserSession(stringArray[n]));
            ++n;
        }
    }

    public void removeAllUserSessions() {
        Enumeration enumeration = this.QOIV.getUserSessionManager().getAllUserSessions();
        while (enumeration.hasMoreElements()) {
            this.QOIV.getUserSessionManager().logout((UserSession)enumeration.nextElement());
        }
    }

    public void setSessionTimeout(int n) {
        this.QOIV.getUserSessionManager().setDefaultMaxInactiveInterval(1000 * n);
        this.compareTo.setProperty("server.session.timeout", n);
        try {
            this.compareTo.save(this.elementAt, null);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    public int getSessionTimeout() {
        return this.QOIV.getUserSessionManager().getDefaultMaxInactiveInterval() / 1000;
    }

    public HttpSession getHttpSession(String string) {
        Object object = this.QOIV.getUserSessionManager();
        if (object instanceof JRUserSessionManager) {
            if ((object = ((JRUserSessionManager)object).getExtObj(string)) instanceof HttpSession) {
                return (HttpSession)object;
            }
            return null;
        }
        return null;
    }

    public String getHttpSessionID(String string) {
        HttpSession httpSession = this.getHttpSession(string);
        if (httpSession != null) {
            return httpSession.getId();
        }
        return null;
    }

    public boolean isExchangeSortOrder(Object object, Object object2) {
        if (object != null && object2 != null && object instanceof UserSession) {
            UserSession userSession = (UserSession)object;
            UserSession userSession2 = (UserSession)object2;
            if (this.QOIV(userSession, userSession2, this.addElement[0]) < 0) {
                return true;
            }
            if (this.QOIV(userSession, userSession2, this.addElement[0]) == 0 && this.addElement.length > 1) {
                if (this.QOIV(userSession, userSession2, this.addElement[1]) < 0) {
                    return true;
                }
                if (this.QOIV(userSession, userSession2, this.addElement[1]) == 0 && this.addElement.length > 2) {
                    if (this.QOIV(userSession, userSession2, this.addElement[2]) < 0) {
                        return true;
                    }
                    if (this.QOIV(userSession, userSession2, this.addElement[2]) == 0 && this.addElement.length > 3) {
                        if (this.QOIV(userSession, userSession2, this.addElement[3]) < 0) {
                            return true;
                        }
                        if (this.QOIV(userSession, userSession2, this.addElement[3]) == 0 && this.addElement.length > 4) {
                            if (this.QOIV(userSession, userSession2, this.addElement[4]) < 0) {
                                return true;
                            }
                            if (this.QOIV(userSession, userSession2, this.addElement[4]) == 0 && this.addElement.length > 5 && this.QOIV(userSession, userSession2, this.addElement[5]) < 0) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }

    private int QOIV(UserSession userSession, UserSession userSession2, int n) {
        switch (n) {
            case 0: {
                return userSession.getID().toUpperCase().compareTo(userSession2.getID().toUpperCase());
            }
            case 1: {
                return userSession.getUserID().toUpperCase().compareTo(userSession2.getUserID().toUpperCase());
            }
            case 2: {
                long l = userSession.getCreationTime();
                long l2 = userSession2.getCreationTime();
                if (l < l2) {
                    return -1;
                }
                if (l > l2) {
                    return 1;
                }
                return 0;
            }
            case 3: {
                long l = userSession.getLastAccessTime();
                long l3 = userSession2.getLastAccessTime();
                if (l < l3) {
                    return -1;
                }
                if (l > l3) {
                    return 1;
                }
                return 0;
            }
            case 4: {
                String string = this.getHttpSession(userSession.getID()) == null ? "" : this.getHttpSession(userSession.getID()).getId();
                String string2 = this.getHttpSession(userSession2.getID()) == null ? "" : this.getHttpSession(userSession2.getID()).getId();
                return string.toUpperCase().compareTo(string2.toUpperCase());
            }
            case 5: {
                String string = userSession.isExternalAuthorized() ? "External" : "Internal";
                String string3 = userSession2.isExternalAuthorized() ? "External" : "Internal";
                return string.toUpperCase().compareTo(string3.toUpperCase());
            }
        }
        return -1;
    }
}

