/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.InvalidUserSessionException;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.UserSessionManager;
import jet.server.api.rmi.RemoteAuthenticator;
import jet.server.api.rmi.RemoteUserSessionManager;
import jet.server.jrrmisvr.JRAuthenticator;
import jet.server.jrserver.JRUserSessionManager;
import jet.server.jrserver.rmi.JRRemoteAuthenticator;

public class JRRemoteUserSessionManager
extends UnicastRemoteObject
implements RemoteUserSessionManager {
    private UserSessionManager QOIV = null;
    private RemoteAuthenticator add = null;

    public JRRemoteUserSessionManager(UserSessionManager userSessionManager) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.QOIV = userSessionManager;
    }

    public void setAuthenticator(RemoteAuthenticator remoteAuthenticator) throws RemoteException {
        this.QOIV.setAuthenticator(new JRAuthenticator(remoteAuthenticator));
    }

    public RemoteAuthenticator getAuthenticator() throws RemoteException {
        if (this.add == null) {
            this.add = new JRRemoteAuthenticator(this.QOIV.getAuthenticator());
        }
        return this.add;
    }

    public void setDefaultMaxInactiveInterval(int n) throws RemoteException {
        this.QOIV.setDefaultMaxInactiveInterval(n);
    }

    public int getDefaultMaxInactiveInterval() throws RemoteException {
        return this.QOIV.getDefaultMaxInactiveInterval();
    }

    public UserSession login(String string, String string2, String string3) throws RemoteException, TooManyUsersException {
        return this.QOIV.login(string, string2, string3, null);
    }

    public UserSession login(String string, String string2, String string3, boolean bl, boolean bl2) throws RemoteException, TooManyUsersException {
        return ((JRUserSessionManager)this.QOIV).login(string, string2, string3, null, bl, bl2);
    }

    public UserSession loginExternalAuthorized(String string, String string2) throws RemoteException, TooManyUsersException {
        return this.QOIV.loginExternalAuthorized(string, string2, null);
    }

    public void logout(String string) throws RemoteException {
        UserSession userSession = this.QOIV.getUserSession(string);
        this.QOIV.logout(userSession);
    }

    public UserSession getUserSession(String string) throws RemoteException {
        return this.QOIV.getUserSession(string);
    }

    public Vector getAllUserSessions() throws RemoteException {
        Vector vector = new Vector();
        Enumeration enumeration = this.QOIV.getAllUserSessions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getAllWaitUserSessions() throws RemoteException {
        Vector vector = new Vector();
        Enumeration enumeration = this.QOIV.getAllWaitUserSessions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public void refreshLastAccessTime(String string) throws RemoteException, InvalidUserSessionException {
        this.QOIV.refreshLastAccessTime(string);
    }

    public boolean isWait(String string) {
        return this.QOIV.isWait(string);
    }

    public void putSessions(String string) {
        UserSession userSession = this.QOIV.getUserSession(string);
        this.QOIV.putSessions(userSession);
    }

    public boolean needSecurity() {
        return this.QOIV.needSecurity();
    }

    public long getLastLoginTime(String string) throws RemoteException {
        return this.QOIV.getLastLoginTime(string);
    }

    public long getLastLogoutTime(String string) throws RemoteException {
        return this.QOIV.getLastLogoutTime(string);
    }
}

