/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.rmi.cluster;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.api.rmi.cluster.RemoteClusterService;
import jet.server.api.rmi.cluster.RemoteLoadBalancer;
import jet.server.jrrmisvr.cluster.JRLoadBalancer;
import jet.server.jrserver.rmi.cluster.JRRemoteLoadBalancer;

public class JRRemoteClusterService
extends UnicastRemoteObject
implements RemoteClusterService {
    private ClusterService QOIV = null;

    public JRRemoteClusterService(ClusterService clusterService) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.QOIV = clusterService;
    }

    public String getClusterName() throws RemoteException {
        if (this.QOIV != null) {
            return this.QOIV.getClusterName();
        }
        return null;
    }

    public Member[] getAllMembers() throws RemoteException, ClusterException {
        if (this.QOIV != null) {
            return this.QOIV.getAllMembers();
        }
        return null;
    }

    public Member getLocalMember() throws RemoteException {
        if (this.QOIV != null) {
            return this.QOIV.getLocalMember();
        }
        return null;
    }

    public Member getAdminMember() throws RemoteException, ClusterException {
        if (this.QOIV != null) {
            return this.QOIV.getAdminMember();
        }
        return null;
    }

    public RemoteLoadBalancer getDefaultLoadBalancer() throws RemoteException {
        if (this.QOIV != null) {
            return new JRRemoteLoadBalancer(this.QOIV.getDefaultLoadBalancer());
        }
        return null;
    }

    public void setDefaultLoadBalancer(RemoteLoadBalancer remoteLoadBalancer) throws RemoteException {
        if (this.QOIV != null) {
            this.QOIV.setDefaultLoadBalancer(new JRLoadBalancer(remoteLoadBalancer));
        }
    }

    public synchronized Member getMember() throws RemoteException {
        if (this.QOIV != null) {
            return this.QOIV.getMember();
        }
        return null;
    }

    public void registerLocalMember() throws RemoteException, ClusterException {
        if (this.QOIV != null) {
            this.QOIV.registerLocalMember();
        }
    }

    public void removeLocalMember() throws RemoteException, ClusterException {
        if (this.QOIV != null) {
            this.QOIV.removeLocalMember();
        }
    }

    public boolean isAdminServerCrashed() throws RemoteException {
        if (this.QOIV != null) {
            return this.QOIV.isAdminServerCrashed();
        }
        return false;
    }

    public boolean isTaskQueueFull(int n) throws RemoteException {
        if (this.QOIV != null) {
            return this.QOIV.isTaskQueueFull(n);
        }
        return false;
    }
}

