/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jmx.mbeans;

import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import jet.server.monitor.api.jmx.mbeans.TaskRuntimeMBean;
import jet.server.monitor.api.task.TaskInfo;
import jet.server.monitor.api.task.TaskMonitor;
import jet.server.monitor.jmx.exception.InstantiateFailedException;
import jet.server.monitor.jmx.exception.InvalidArgumentsException;
import jet.server.monitor.jmx.utils.MBeanConstants;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.task.JRTaskInfo;
import jet.server.monitor.jrmon.task.JRTaskMonitor;

public class TaskRuntime
extends StandardMBean
implements TaskRuntimeMBean,
MBeanConstants,
Serializable {
    private static final long serialVersionUID = -6545903718840736856L;
    private String host;
    private int port;
    private TaskMonitor taskMonitor;
    static Class class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean;
    static Class class$java$lang$String;
    static Class class$jet$server$monitor$api$task$TaskMonitor;

    public TaskRuntime() throws InvalidArgumentsException, NotCompliantMBeanException {
        super(class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean == null ? (class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean = TaskRuntime.class$("jet.server.monitor.api.jmx.mbeans.TaskRuntimeMBean")) : class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean);
        throw new InvalidArgumentsException("Can't construct TaskRuntime MBean, Please specify the host and port as parameter!");
    }

    public TaskRuntime(String string, int n) throws InstantiateFailedException, NotCompliantMBeanException {
        super(class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean == null ? (class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean = TaskRuntime.class$("jet.server.monitor.api.jmx.mbeans.TaskRuntimeMBean")) : class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean);
        this.host = string;
        this.port = n;
        this.taskMonitor = MonitorEnv.getHttpMonitorServer().getMonitorService(string, n).getTaskMonitor();
        if (this.taskMonitor == null) {
            throw new InstantiateFailedException("There occurs an error to create TaskRuntime MBean, Can't obtain the underlying managed objects");
        }
    }

    public TaskRuntime(TaskMonitor taskMonitor) throws InstantiateFailedException, NotCompliantMBeanException {
        super(class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean == null ? (class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean = TaskRuntime.class$("jet.server.monitor.api.jmx.mbeans.TaskRuntimeMBean")) : class$jet$server$monitor$api$jmx$mbeans$TaskRuntimeMBean);
        if (taskMonitor == null) {
            throw new InstantiateFailedException("There occurs an error to create TaskRuntime MBean, Can't obtain the underlying managed objects");
        }
        this.taskMonitor = taskMonitor;
        this.host = ((JRTaskMonitor)taskMonitor).getMonitorService().getHost();
        this.port = ((JRTaskMonitor)taskMonitor).getMonitorService().getPort();
    }

    public String[] getAllRunningTaskStrings() {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getAllRunningTasks());
        return this.QOIV(vector);
    }

    public TaskInfo[] getAllRunningTaskInfos() {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getAllRunningTasks());
        int n = vector.size();
        TaskInfo[] taskInfoArray = new TaskInfo[n];
        int n2 = 0;
        while (n2 < n) {
            taskInfoArray[n2] = (TaskInfo)vector.elementAt(n2);
            ++n2;
        }
        return taskInfoArray;
    }

    private String[] QOIV(Vector vector) {
        String[] stringArray = new String[vector.size()];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.setLength(0);
            TaskInfo taskInfo = (TaskInfo)vector.elementAt(n);
            stringBuffer.append("taskID").append("=").append(taskInfo.getTaskID()).append(",").append("reportName").append("=").append(taskInfo.getReportName()).append(",").append("userID").append("=").append(taskInfo.getUserName()).append(",").append("taskStatus").append("=").append(taskInfo.getTaskStatus()).append(",").append("taskType").append("=").append(taskInfo.getTaskType()).append(",").append("startTime").append("=").append(taskInfo.getStartedTime()).append(",").append("submitTime").append("=").append(taskInfo.getSubmittedTime()).append(",").append("runHost").append("=").append(taskInfo.getRunHost()).append(",").append("runPort").append("=").append(taskInfo.getRunPort()).append(",").append("catalog").append("=").append(taskInfo.getReportSource());
            stringArray[n] = stringBuffer.toString();
            ++n;
        }
        return stringArray;
    }

    public String[] getRunningTaskStringsByUser(String string) {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getRunningTasksByUser(string));
        return this.QOIV(vector);
    }

    public TaskInfo[] getRunningTaskInfosByUser(String string) {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getRunningTasksByUser(string));
        int n = vector.size();
        TaskInfo[] taskInfoArray = new TaskInfo[n];
        int n2 = 0;
        while (n2 < n) {
            taskInfoArray[n2] = (TaskInfo)vector.elementAt(n2);
            ++n2;
        }
        return taskInfoArray;
    }

    public String[] getAllWaitingTaskStrings() {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getAllWaitingTasks());
        return this.addElement(vector);
    }

    public TaskInfo[] getAllWaitingTaskInfos() {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getAllWaitingTasks());
        int n = vector.size();
        TaskInfo[] taskInfoArray = new TaskInfo[n];
        int n2 = 0;
        while (n2 < n) {
            taskInfoArray[n2] = (TaskInfo)vector.elementAt(n2);
            ++n2;
        }
        return taskInfoArray;
    }

    private String[] addElement(Vector vector) {
        String[] stringArray = new String[vector.size()];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.setLength(0);
            TaskInfo taskInfo = (TaskInfo)vector.elementAt(n);
            stringBuffer.append("taskID").append("=").append(taskInfo.getTaskID()).append(",").append("reportName").append("=").append(taskInfo.getReportName()).append(",").append("userID").append("=").append(taskInfo.getUserName()).append(",").append("taskStatus").append("=").append(taskInfo.getTaskStatus()).append(",").append("taskType").append("=").append(taskInfo.getTaskType()).append(",").append("submitTime").append("=").append(taskInfo.getSubmittedTime()).append(",").append("catalog").append("=").append(taskInfo.getReportSource());
            stringArray[n] = stringBuffer.toString();
            ++n;
        }
        return stringArray;
    }

    public String[] getWaitingTaskStringsByUser(String string) {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getWaitingTasksByUser(string));
        return this.addElement(vector);
    }

    public TaskInfo[] getWaitingTaskInfosByUser(String string) {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getWaitingTasksByUser(string));
        int n = vector.size();
        TaskInfo[] taskInfoArray = new TaskInfo[n];
        int n2 = 0;
        while (n2 < n) {
            taskInfoArray[n2] = (TaskInfo)vector.elementAt(n2);
            ++n2;
        }
        return taskInfoArray;
    }

    public String[] getAllFinishedTaskStrings() {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getAllFinishedTasks());
        return this.append(vector);
    }

    public TaskInfo[] getAllFinishedTaskInfos() {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getAllFinishedTasks());
        int n = vector.size();
        TaskInfo[] taskInfoArray = new TaskInfo[n];
        int n2 = 0;
        while (n2 < n) {
            taskInfoArray[n2] = (TaskInfo)vector.elementAt(n2);
            ++n2;
        }
        return taskInfoArray;
    }

    private String[] append(Vector vector) {
        String[] stringArray = new String[vector.size()];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.setLength(0);
            TaskInfo taskInfo = (TaskInfo)vector.elementAt(n);
            stringBuffer.append("taskID").append("=").append(taskInfo.getTaskID()).append(",").append("reportName").append("=").append(taskInfo.getReportName()).append(",").append("userID").append("=").append(taskInfo.getUserName()).append(",").append("taskStatus").append("=").append(taskInfo.getTaskStatus()).append(",").append("taskType").append("=").append(taskInfo.getTaskType()).append(",").append("runHost").append("=").append(taskInfo.getRunHost()).append(",").append("runPort").append("=").append(taskInfo.getRunPort()).append(",").append("catalog").append("=").append(taskInfo.getReportSource()).append(",").append("resultFiles").append("=").append(taskInfo.getResultFileName()).append(",").append("reportPages").append("=").append(taskInfo.getReportPages()).append(",").append("submitTime").append("=").append(taskInfo.getSubmittedTime()).append(",").append("startTime").append("=").append(taskInfo.getStartedTime()).append(",").append("completeTime").append("=").append(taskInfo.getFinishedTime()).append(",").append("reason").append("=").append(taskInfo.getReason());
            stringArray[n] = stringBuffer.toString();
            ++n;
        }
        return stringArray;
    }

    public String[] getFinishedTaskStringsByUser(String string) {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getFinishedTasksByUser(string));
        return this.append(vector);
    }

    public TaskInfo[] getFinishedTaskInfosByUser(String string) {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getFinishedTasksByUser(string));
        int n = vector.size();
        TaskInfo[] taskInfoArray = new TaskInfo[n];
        int n2 = 0;
        while (n2 < n) {
            taskInfoArray[n2] = (TaskInfo)vector.elementAt(n2);
            ++n2;
        }
        return taskInfoArray;
    }

    public TaskInfo[] getAllFailedTaskInfos() {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getAllFailedTasks());
        int n = vector.size();
        TaskInfo[] taskInfoArray = new TaskInfo[n];
        int n2 = 0;
        while (n2 < n) {
            taskInfoArray[n2] = (TaskInfo)vector.elementAt(n2);
            ++n2;
        }
        return taskInfoArray;
    }

    public String[] getAllFailedTaskStrings() {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getAllFailedTasks());
        return this.class$(vector);
    }

    private String[] class$(Vector vector) {
        String[] stringArray = new String[vector.size()];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.setLength(0);
            TaskInfo taskInfo = (TaskInfo)vector.elementAt(n);
            stringBuffer.append("taskID").append("=").append(taskInfo.getTaskID()).append(",").append("reportName").append("=").append(taskInfo.getReportName()).append(",").append("userID").append("=").append(taskInfo.getUserName()).append(",").append("taskStatus").append("=").append(taskInfo.getTaskStatus()).append(",").append("taskType").append("=").append(taskInfo.getTaskType()).append(",").append("runHost").append("=").append(taskInfo.getRunHost()).append(",").append("runPort").append("=").append(taskInfo.getRunPort()).append(",").append("catalog").append("=").append(taskInfo.getReportSource()).append(",").append("resultFiles").append("=").append(taskInfo.getResultFileName()).append(",").append("reportPages").append("=").append(taskInfo.getReportPages()).append(",").append("submitTime").append("=").append(taskInfo.getSubmittedTime()).append(",").append("startTime").append("=").append(taskInfo.getStartedTime()).append(",").append("completeTime").append("=").append(taskInfo.getFinishedTime()).append(",").append("reason").append("=").append(taskInfo.getReason()).append(",").append("failedInfo").append("=").append(taskInfo.getFailedInfo());
            stringArray[n] = stringBuffer.toString();
            ++n;
        }
        return stringArray;
    }

    public TaskInfo[] getFailedTaskInfosByUser(String string) {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getFailedTasksByUser(string));
        int n = vector.size();
        TaskInfo[] taskInfoArray = new TaskInfo[n];
        int n2 = 0;
        while (n2 < n) {
            taskInfoArray[n2] = (TaskInfo)vector.elementAt(n2);
            ++n2;
        }
        return taskInfoArray;
    }

    public String[] getFailedTaskStringsByUser(String string) {
        Vector vector = this.class$java$lang$String(this.taskMonitor.getFailedTasksByUser(string));
        return this.class$(vector);
    }

    public void stopTask(String string) {
        this.taskMonitor.stopTask(this.taskMonitor.getTask(string));
    }

    private Vector class$java$lang$String(Vector vector) {
        Vector vector2 = new Vector();
        try {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                vector2.addElement(((JRTaskInfo)vector.elementAt(n)).clone());
                ++n;
            }
        }
        catch (Exception exception) {
            vector2 = vector;
        }
        return vector2;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDescription(MBeanInfo mBeanInfo) {
        return "This <B><code>TaskRuntime</code></B> MBean provides the ability to expose JREntServer Task's attributes and operations.";
    }

    public String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        String string = "";
        String string2 = mBeanAttributeInfo.getName();
        string = "AllRunningTaskInfos".equalsIgnoreCase(string2) ? "All currently Running Tasks information." : ("AllWaitingTaskInfos".equalsIgnoreCase(string2) ? "All currently Waiting Tasks information." : ("AllFinishedTaskInfos".equalsIgnoreCase(string2) ? "All successfully Completed Tasks information within the monitoring duration." : ("AllFailedTaskInfos".equalsIgnoreCase(string2) ? "All Failed Tasks information within the specified duration." : this.getDescription((MBeanFeatureInfo)mBeanAttributeInfo))));
        return string;
    }

    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return "The Constructor of <code>TaskRuntime</code> with the specified host and port or the underlying managed objects. Without any arguments will throw exceptions.";
    }

    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanParameterInfo.getType();
        if (n == 0) {
            if ((class$java$lang$String == null ? (class$java$lang$String = TaskRuntime.class$("java.lang.String")) : class$java$lang$String).getName().equalsIgnoreCase(string2)) {
                string = "The specified JREntServer\\'s host value (IP Address).";
            } else if ((class$jet$server$monitor$api$task$TaskMonitor == null ? (class$jet$server$monitor$api$task$TaskMonitor = TaskRuntime.class$("jet.server.monitor.api.task.TaskMonitor")) : class$jet$server$monitor$api$task$TaskMonitor).getName().equalsIgnoreCase(string2)) {
                string = "The underlying managed object of TaskMonitor";
            }
        } else {
            string = n == 1 ? "The specified JREntServer\\'s RMI port value." : mBeanParameterInfo.getDescription();
        }
        return string;
    }

    public String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        string = "getRunningTaskInfosByUser".equalsIgnoreCase(string2) ? "Get all currently Running Tasks information according to the specified User." : ("getWaitingTaskInfosByUser".equalsIgnoreCase(string2) ? "Get all currently Waiting Tasks information according to the specified User." : ("getFinishedTaskInfosByUser".equalsIgnoreCase(string2) ? "Get all Completed Tasks information according to the specified User and within the monitoring duration." : ("getFailedTaskInfosByUser".equalsIgnoreCase(string2) ? "Get all Failed Tasks information according to the specified User and within the monitoring duration." : ("stopTask".equalsIgnoreCase(string2) ? "Stop a task by its Task ID." : this.getDescription((MBeanFeatureInfo)mBeanOperationInfo)))));
        return string;
    }

    public String getDescription(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        string = n == 0 ? ("stopTask".equalsIgnoreCase(string2) ? "The specified task\\'s ID." : "The specified User Name.") : mBeanParameterInfo.getDescription();
        return string;
    }

    public String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanParameterInfo.getType();
        if (n == 0) {
            if ((class$java$lang$String == null ? (class$java$lang$String = TaskRuntime.class$("java.lang.String")) : class$java$lang$String).getName().equalsIgnoreCase(string2)) {
                string = "host";
            } else if ((class$jet$server$monitor$api$task$TaskMonitor == null ? (class$jet$server$monitor$api$task$TaskMonitor = TaskRuntime.class$("jet.server.monitor.api.task.TaskMonitor")) : class$jet$server$monitor$api$task$TaskMonitor).getName().equalsIgnoreCase(string2)) {
                string = "taskMonitor";
            }
        } else {
            string = n == 1 ? "port" : mBeanParameterInfo.getName();
        }
        return string;
    }

    public String getParameterName(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        string = n == 0 ? ("stopTask".equalsIgnoreCase(string2) ? "taskID" : "userName") : mBeanParameterInfo.getName();
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

