/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jmx.mbeans;

import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import jet.server.api.UserSession;
import jet.server.monitor.api.jmx.mbeans.UserSessionRuntimeMBean;
import jet.server.monitor.api.user.UserMonitor;
import jet.server.monitor.jmx.exception.InstantiateFailedException;
import jet.server.monitor.jmx.exception.InvalidArgumentsException;
import jet.server.monitor.jmx.utils.MBeanConstants;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.user.JRUserMonitor;

public class UserSessionRuntime
extends StandardMBean
implements UserSessionRuntimeMBean,
MBeanConstants,
Serializable {
    private static final long serialVersionUID = 7431996307397523538L;
    private String host;
    private int port;
    private UserMonitor userMonitor;
    static Class class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean;
    static Class class$java$lang$String;
    static Class class$jet$server$monitor$api$user$UserMonitor;

    public UserSessionRuntime() throws InvalidArgumentsException, NotCompliantMBeanException {
        super(class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean == null ? (class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean = UserSessionRuntime.class$("jet.server.monitor.api.jmx.mbeans.UserSessionRuntimeMBean")) : class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean);
        throw new InvalidArgumentsException("Can't construct UserSessionRuntime MBean, Please specify the host and port as parameter!");
    }

    public UserSessionRuntime(String string, int n) throws InstantiateFailedException, NotCompliantMBeanException {
        super(class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean == null ? (class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean = UserSessionRuntime.class$("jet.server.monitor.api.jmx.mbeans.UserSessionRuntimeMBean")) : class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean);
        this.host = string;
        this.port = n;
        this.userMonitor = MonitorEnv.getHttpMonitorServer().getMonitorService(string, n).getUserMonitor();
        if (this.userMonitor == null) {
            throw new InstantiateFailedException("There occurs an error to create UserSessionRuntime MBean, Can't obtain the underlying managed objects");
        }
    }

    public UserSessionRuntime(UserMonitor userMonitor) throws InstantiateFailedException, NotCompliantMBeanException {
        super(class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean == null ? (class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean = UserSessionRuntime.class$("jet.server.monitor.api.jmx.mbeans.UserSessionRuntimeMBean")) : class$jet$server$monitor$api$jmx$mbeans$UserSessionRuntimeMBean);
        if (userMonitor == null) {
            throw new InstantiateFailedException("There occurs an error to create UserSessionRuntime MBean, Can't obtain the underlying managed objects");
        }
        this.userMonitor = userMonitor;
        this.host = ((JRUserMonitor)userMonitor).getMonitorService().getHost();
        this.port = ((JRUserMonitor)userMonitor).getMonitorService().getPort();
    }

    public int getSessionTimeout() {
        return this.userMonitor.getSessionTimeout();
    }

    public void setSessionTimeout(int n) {
        this.userMonitor.setSessionTimeout(n);
    }

    public String[] getAllUserSessionsToString() {
        return this.QOIV(this.userMonitor.getAllUserSessions());
    }

    public UserSession[] getAllUserSessions() {
        Vector vector = this.userMonitor.getAllUserSessions();
        int n = vector.size();
        UserSession[] userSessionArray = new UserSession[n];
        int n2 = 0;
        while (n2 < n) {
            userSessionArray[n2] = (UserSession)vector.elementAt(n2);
            ++n2;
        }
        return userSessionArray;
    }

    private String[] QOIV(Vector vector) {
        String[] stringArray = new String[vector.size()];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.setLength(0);
            UserSession userSession = (UserSession)vector.elementAt(n);
            stringBuffer.append("sessionID").append("=").append(userSession.getID()).append(",").append("userID").append("=").append(userSession.getUserID()).append(",").append("createdTime").append("=").append(userSession.getCreationTime()).append(",").append("lastAccessedTime").append("=").append(userSession.getLastAccessTime()).append(",").append("httpSessionID").append("=").append(this.userMonitor.getHttpSessionID(userSession.getID())).append(",").append("authentication").append("=").append(userSession.isExternalAuthorized() ? "external" : "internal");
            stringArray[n] = stringBuffer.toString();
            ++n;
        }
        return stringArray;
    }

    public String[] getUserSessionsToStringByUser(String string) {
        return this.QOIV(this.userMonitor.getUserSessionsByUser(string));
    }

    public UserSession[] getUserSessionsByUser(String string) {
        Vector vector = this.userMonitor.getUserSessionsByUser(string);
        int n = vector.size();
        UserSession[] userSessionArray = new UserSession[n];
        int n2 = 0;
        while (n2 < n) {
            userSessionArray[n2] = (UserSession)vector.elementAt(n2);
            ++n2;
        }
        return userSessionArray;
    }

    public void removeUserSessionBySessionID(String string) {
        this.userMonitor.removeUserSessionBySessionID(string);
    }

    public void removeUserSessionsByUserID(String string) {
        this.userMonitor.removeUserSessionsByUserID(string);
    }

    public void removeAllUserSessions() {
        this.userMonitor.removeAllUserSessions();
    }

    public String getHttpSessionID(String string) {
        return this.userMonitor.getHttpSessionID(string);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDescription(MBeanInfo mBeanInfo) {
        return "This <B><code>UserSessionRuntime</code></B> MBean provides the ability to expose JREntServer UserSession's attributes and operations.";
    }

    public String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        String string = "";
        String string2 = mBeanAttributeInfo.getName();
        string = "SessionTimeout".equalsIgnoreCase(string2) ? "The UserSession\\'s default timeout value of JREntServer." : ("AllUserSessions".equalsIgnoreCase(string2) ? "All currently active UserSessions of JREntServer." : this.getDescription((MBeanFeatureInfo)mBeanAttributeInfo));
        return string;
    }

    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return "The Constructor of <code>UserSessionRuntime</code> with the specified host and port or the underlying managed objects. Without any arguments will throw exceptions.";
    }

    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanParameterInfo.getType();
        if (n == 0) {
            if ((class$java$lang$String == null ? (class$java$lang$String = UserSessionRuntime.class$("java.lang.String")) : class$java$lang$String).getName().equalsIgnoreCase(string2)) {
                string = "The specified JREntServer\\'s host value (IP Address).";
            } else if ((class$jet$server$monitor$api$user$UserMonitor == null ? (class$jet$server$monitor$api$user$UserMonitor = UserSessionRuntime.class$("jet.server.monitor.api.user.UserMonitor")) : class$jet$server$monitor$api$user$UserMonitor).getName().equalsIgnoreCase(string2)) {
                string = "The underlying managed object of UserMonitor";
            }
        } else {
            string = n == 1 ? "The specified JREntServer\\'s RMI port value." : mBeanParameterInfo.getDescription();
        }
        return string;
    }

    public String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        string = "getUserSessionsByUser".equalsIgnoreCase(string2) ? "Get all currently active UserSessions according to the specified User." : ("removeUserSessionBySessionID".equalsIgnoreCase(string2) ? "Remove the UserSession by its sessionID." : ("removeUserSessionsByUserID".equalsIgnoreCase(string2) ? "Remove all UserSessions associated to the specified userID." : ("removeAllUserSessions".equalsIgnoreCase(string2) ? "Remove all UserSessions of the associated JREntServer." : ("getHttpSessionID".equalsIgnoreCase(string2) ? "Get the HttpSession\\'s ID associated with the specified UserSession\\'s ID." : this.getDescription((MBeanFeatureInfo)mBeanOperationInfo)))));
        return string;
    }

    public String getDescription(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        if (n == 0) {
            if ("getUserSessionsByUser".equalsIgnoreCase(string2)) {
                string = "The specified User ID.";
            } else if ("removeUserSessionBySessionID".equalsIgnoreCase(string2)) {
                string = "The specified UserSession\\'s ID";
            } else if ("removeUserSessionsByUserID".equalsIgnoreCase(string2)) {
                string = "The specified User ID";
            } else if ("getHttpSessionID".equalsIgnoreCase(string2)) {
                string = "The specified UserSession\\'s ID";
            }
        } else {
            string = mBeanParameterInfo.getDescription();
        }
        return string;
    }

    public String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanParameterInfo.getType();
        if (n == 0) {
            if ((class$java$lang$String == null ? (class$java$lang$String = UserSessionRuntime.class$("java.lang.String")) : class$java$lang$String).getName().equalsIgnoreCase(string2)) {
                string = "host";
            } else if ((class$jet$server$monitor$api$user$UserMonitor == null ? (class$jet$server$monitor$api$user$UserMonitor = UserSessionRuntime.class$("jet.server.monitor.api.user.UserMonitor")) : class$jet$server$monitor$api$user$UserMonitor).getName().equalsIgnoreCase(string2)) {
                string = "userMonitor";
            }
        } else {
            string = n == 1 ? "port" : mBeanParameterInfo.getName();
        }
        return string;
    }

    public String getParameterName(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        if (n == 0) {
            if ("getUserSessionsByUser".equalsIgnoreCase(string2) || "removeUserSessionsByUserID".equalsIgnoreCase(string2)) {
                string = "userID";
            } else if ("removeUserSessionBySessionID".equalsIgnoreCase(string2) || "getHttpSessionID".equalsIgnoreCase(string2)) {
                string = "sessionID";
            }
        } else {
            string = mBeanParameterInfo.getName();
        }
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

