/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jmx.utils;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import javax.management.ObjectName;
import jet.server.api.cluster.Member;
import jet.server.log.ServiceLogger;
import jet.server.monitor.jmx.mbeans.ClusterRuntime;
import jet.server.monitor.jmx.mbeans.DatabaseRuntime;
import jet.server.monitor.jmx.mbeans.ServerRuntime;
import jet.server.monitor.jmx.mbeans.TaskRuntime;
import jet.server.monitor.jmx.mbeans.UserSessionRuntime;
import jet.server.monitor.jmx.utils.MBeanUtils;
import jet.server.monitor.jrmon.MonitorEnv;

public class MBeanFactory {
    private static MBeanFactory QOIV = null;
    private static boolean addShutdownHook = false;
    static Class class$jet$server$monitor$jmx$utils$MBeanFactory;

    private MBeanFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanFactory getInstance() {
        if (QOIV == null) {
            Class clazz = class$jet$server$monitor$jmx$utils$MBeanFactory == null ? (class$jet$server$monitor$jmx$utils$MBeanFactory = MBeanFactory.class$("jet.server.monitor.jmx.utils.MBeanFactory")) : class$jet$server$monitor$jmx$utils$MBeanFactory;
            synchronized (clazz) {
                if (QOIV == null) {
                    QOIV = new MBeanFactory();
                }
            }
        }
        return QOIV;
    }

    public void registerAllMBeans() {
        if (addShutdownHook) {
            return;
        }
        try {
            System.out.println("Creating all MBeans and registering them into the MBeanServer...");
            ClusterRuntime clusterRuntime = new ClusterRuntime();
            ObjectName objectName = MBeanUtils.createObjectName(clusterRuntime);
            if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                MBeanUtils.getMBeanServer().registerMBean(clusterRuntime, objectName);
            }
            Member[] memberArray = clusterRuntime.getPredefinedServers();
            int n = 0;
            while (n < memberArray.length) {
                String string = memberArray[n].getHost();
                int n2 = Integer.parseInt(memberArray[n].getPort());
                this.QOIV(string, n2).start();
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("\t>>>Failed to create and register JReport Server MBeans into MBeanServer: " + exception);
            ServiceLogger.logError(exception);
        }
        addShutdownHook = true;
    }

    public void unregisterAllMBeans() {
        if (!addShutdownHook) {
            return;
        }
        try {
            ClusterRuntime clusterRuntime = new ClusterRuntime();
            ObjectName objectName = MBeanUtils.createObjectName(clusterRuntime);
            if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                MBeanUtils.getMBeanServer().unregisterMBean(objectName);
            }
            Member[] memberArray = clusterRuntime.getPredefinedServers();
            int n = 0;
            while (n < memberArray.length) {
                String string = memberArray[n].getHost();
                int n2 = Integer.parseInt(memberArray[n].getPort());
                ServerRuntime serverRuntime = new ServerRuntime(string, n2);
                objectName = MBeanUtils.createObjectName(serverRuntime);
                if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                    MBeanUtils.getMBeanServer().unregisterMBean(objectName);
                }
                TaskRuntime taskRuntime = new TaskRuntime(string, n2);
                objectName = MBeanUtils.createObjectName(taskRuntime);
                if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                    MBeanUtils.getMBeanServer().unregisterMBean(objectName);
                }
                UserSessionRuntime userSessionRuntime = new UserSessionRuntime(string, n2);
                objectName = MBeanUtils.createObjectName(userSessionRuntime);
                if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                    MBeanUtils.getMBeanServer().unregisterMBean(objectName);
                }
                DatabaseRuntime databaseRuntime = new DatabaseRuntime(string, n2);
                objectName = MBeanUtils.createObjectName(databaseRuntime);
                if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                    MBeanUtils.getMBeanServer().unregisterMBean(objectName);
                }
                ++n;
            }
            System.out.println("<<<Unregistered all MBeans from MBeanServer successfully...!");
        }
        catch (Exception exception) {
            System.err.println("\t<<<Failed to unregister MBeans from MBeanServer: " + exception);
            ServiceLogger.logError(exception);
        }
        addShutdownHook = false;
    }

    private Thread QOIV(String string, int n) {
        return new Thread(this, string, n){
            private final String val$host;
            private final int val$port;
            private final MBeanFactory this$0;
            {
                this.this$0 = mBeanFactory;
                this.val$host = string;
                this.val$port = n;
            }

            public void run() {
                try {
                    ServerRuntime serverRuntime = new ServerRuntime(this.val$host, this.val$port);
                    ObjectName objectName = MBeanUtils.createObjectName(serverRuntime);
                    if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                        MBeanUtils.getMBeanServer().registerMBean(serverRuntime, objectName);
                    }
                    while (!MonitorEnv.getHttpMonitorServer().isStarting(this.val$host, this.val$port)) {
                        Thread.sleep(10000L);
                    }
                    TaskRuntime taskRuntime = new TaskRuntime(this.val$host, this.val$port);
                    objectName = MBeanUtils.createObjectName(taskRuntime);
                    if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                        MBeanUtils.getMBeanServer().registerMBean(taskRuntime, objectName);
                    }
                    UserSessionRuntime userSessionRuntime = new UserSessionRuntime(this.val$host, this.val$port);
                    objectName = MBeanUtils.createObjectName(userSessionRuntime);
                    if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                        MBeanUtils.getMBeanServer().registerMBean(userSessionRuntime, objectName);
                    }
                    DatabaseRuntime databaseRuntime = new DatabaseRuntime(this.val$host, this.val$port);
                    objectName = MBeanUtils.createObjectName(databaseRuntime);
                    if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                        MBeanUtils.getMBeanServer().registerMBean(databaseRuntime, objectName);
                    }
                }
                catch (Exception exception) {
                    System.err.println("\t<<<Failed to create and register JReport MBeans into MBeanServer: " + exception);
                    ServiceLogger.logError(exception);
                }
            }
        };
    }

    public boolean startHtmlAdaptorServer() {
        return this.startHtmlAdaptorServer(MBeanUtils.getHtmlAdaptor().getPort());
    }

    public boolean startHtmlAdaptorServer(int n) {
        HtmlAdaptorServer htmlAdaptorServer = MBeanUtils.getHtmlAdaptor(n);
        ObjectName objectName = MBeanUtils.getHtmlAdaptorObjectName();
        try {
            if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                return true;
            }
            System.out.println("Creating a new HTML protocol adaptor and registering it into the MBeanServer...");
            MBeanUtils.getMBeanServer().registerMBean(htmlAdaptorServer, objectName);
        }
        catch (Exception exception) {
            System.err.println("\n\t>>>Failed to register HTML protocol adaptor into MBeanServer!");
            ServiceLogger.logError(exception);
            return false;
        }
        htmlAdaptorServer.start();
        System.out.println("HTML adaptor has been successfully started [listening to port " + htmlAdaptorServer.getPort() + "]\n");
        Runtime.getRuntime().addShutdownHook(new Thread(this, htmlAdaptorServer, objectName){
            private final HtmlAdaptorServer val$hadaptor;
            private final ObjectName val$adaptorName;
            private final MBeanFactory this$0;
            {
                this.this$0 = mBeanFactory;
                this.val$hadaptor = htmlAdaptorServer;
                this.val$adaptorName = objectName;
            }

            public void run() {
                this.this$0.unregisterAllMBeans();
                if (this.val$hadaptor != null && MBeanUtils.getMBeanServer().isRegistered(this.val$adaptorName)) {
                    try {
                        MBeanUtils.getMBeanServer().unregisterMBean(this.val$adaptorName);
                        System.out.println("<<<Unregistered HtmlAdaptorServer from MBeanServer successfully...!");
                    }
                    catch (Exception exception) {
                        System.err.println("\t<<<Failed to unregister HtmlAdaptorServer from MBeanServer!");
                    }
                }
            }
        });
        return true;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

