/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon;

import java.io.IOException;
import java.io.ObjectOutput;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonMismatchException;
import jet.server.monitor.jrmon.JRMonitorCounter;

public final class JRMonitorCounter_Skel
implements Skeleton {
    private static final Operation[] operations = new Operation[]{new Operation("int getAvgProcessTimeByRpt()"), new Operation("int getAvgRptNumsSubmittedByUser()"), new Operation("int getAvgWaitTimeByRpt()"), new Operation("int getCurrentConnectionNums()"), new Operation("int getFinishedRptNums()"), new Operation("int getFinishedRptPages()"), new Operation("int getRunningRptNums()"), new Operation("int getValidUserSessionNums()"), new Operation("int getWaitingRptNums()")};
    private static final long interfaceHash = 6376837156525889837L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(Remote remote, RemoteCall remoteCall, int n, long l) throws Exception {
        if (n < 0) {
            if (l == 6307260858774863972L) {
                n = 0;
            } else if (l == 7670692790696544631L) {
                n = 1;
            } else if (l == 1705878548865208298L) {
                n = 2;
            } else if (l == -3080369325425151297L) {
                n = 3;
            } else if (l == -4475973451906241538L) {
                n = 4;
            } else if (l == 4266125428739373760L) {
                n = 5;
            } else if (l == -1264032088699998876L) {
                n = 6;
            } else if (l == -4540913546882579901L) {
                n = 7;
            } else {
                if (l != 7773113898592900900L) throw new UnmarshalException("invalid method hash");
                n = 8;
            }
        } else if (l != 6376837156525889837L) {
            throw new SkeletonMismatchException("interface hash mismatch");
        }
        JRMonitorCounter jRMonitorCounter = (JRMonitorCounter)remote;
        switch (n) {
            case 0: {
                remoteCall.releaseInputStream();
                int n2 = jRMonitorCounter.getAvgProcessTimeByRpt();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n2);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 1: {
                remoteCall.releaseInputStream();
                int n3 = jRMonitorCounter.getAvgRptNumsSubmittedByUser();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n3);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 2: {
                remoteCall.releaseInputStream();
                int n4 = jRMonitorCounter.getAvgWaitTimeByRpt();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n4);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 3: {
                remoteCall.releaseInputStream();
                int n5 = jRMonitorCounter.getCurrentConnectionNums();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n5);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 4: {
                remoteCall.releaseInputStream();
                int n6 = jRMonitorCounter.getFinishedRptNums();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n6);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 5: {
                remoteCall.releaseInputStream();
                int n7 = jRMonitorCounter.getFinishedRptPages();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n7);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 6: {
                remoteCall.releaseInputStream();
                int n8 = jRMonitorCounter.getRunningRptNums();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n8);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 7: {
                remoteCall.releaseInputStream();
                int n9 = jRMonitorCounter.getValidUserSessionNums();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n9);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 8: {
                remoteCall.releaseInputStream();
                int n10 = jRMonitorCounter.getWaitingRptNums();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n10);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            default: {
                throw new UnmarshalException("invalid method number");
            }
        }
    }

    public Operation[] getOperations() {
        return (Operation[])operations.clone();
    }
}

