/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import jet.JSRuntimeException;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.UserSession;
import jet.server.monitor.api.http.HttpMonitorServer;
import jet.server.monitor.jmx.utils.MBeanFactory;
import jet.server.monitor.jrmon.http.JRHttpMonitorServer;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.util.CreateDefExProperties;
import jet.server.util.MIMETypeTable;

public class MonitorEnv {
    public static final String ALL_MONITOR = "monitor.all";
    public static final String TASK_MONITOR = "monitor.task";
    public static final String USER_MONITOR = "monitor.user";
    public static final String CLUSTER_MONITOR = "monitor.cluster";
    public static final String DATABASE_MONITOR = "monitor.database";
    public static final String ADHOC_MONITOR = "monitor.adhoc";
    public static final String SERVLET_PROPERTY = "servlet.property";
    public static final String SERVER_PROPERTY = "server.property";
    public static final String MONITOR_SERVER = "monitor.report.server";
    public static final String MONITOR_CLUSTER = "monitor.cluster.server";
    public static final String WEB_ROOT = "web.root";
    public static final String MONITOR_SERVICE_PORT = "monitor.service.port";
    public static final String MONITOR_HOMEPAGE = "monitor.homepage";
    public static final String MONITOR_HOME = "monitor.home";
    public static final String INSTALL_ROOT = "monitor.install.root";
    public static final String MONITOR_RMI_PORT = "monitor.rmi.port";
    public static final int DEFAULT_MONITOR_RMI_PORT = 1248;
    public static final int DEFAULT_MONITOR_SERVICE_PORT = 8848;
    public static final String ADMIN_SERVER_HOST = "admin.server.host";
    public static final String ADMIN_SERVER_PORT = "admin.server.port";
    public static final String CLUSTER_MEMBERS = "cluster.Members";
    public static final String MONITOR_REFRESH_INTERVAL = "monitor.refresh.interval";
    public static final String MONITOR_MAX_REPORT_SAVE_NUMBER = "monitor.max.report.save.number";
    public static final String MONITOR_MAX_REPORT_SAVE_TIME = "monitor.max.report.save.time";
    public static final String STARTUP_MONITORING_JMX_FEATURES = "monitor.jmx.startup";
    public static final boolean DEFAULT_STARTUP_JMX_MONITORING = false;
    private static boolean QOIV = false;
    public static final String STARTUP_MONITOR_JMX_ADAPTOR = "monitor.jmx.htmladaptor.startup";
    public static final boolean DEFAULT_STARTUP_JMX_ADAPTOR = true;
    private static boolean addElement = true;
    public static final String JMX_HTMLADAPTOR_PORT = "monitor.jmx.htmladaptor.port";
    public static final int DEFAULT_JMX_HTMLADAPTOR_PORT = 8849;
    private static int append = 8849;
    public static final int DEFAULT_REFRESH_INTERVAL = 10000;
    public static final int DEFAULT_MAX_REPORT_SAVE_NUMBER = 2000;
    public static final int DEFAULT_MAX_REPORT_SAVE_TIME = 5;
    public static final String AUTH_SCHEME_BASIC = "Basic";
    public static final String AUTH_SCHEME_DIGEST = "Digest";
    public static final String IS_INTERNAL_SERVER = "isInternalServer";
    private static int close = 1248;
    public static final String SVRPROP_HTTP_OUTPUT_ENCODING = "server.http.output_encoding";
    public static final String PROP_OUTPUT_ENCODING = "output_encoding";
    private static String createNewFile = null;
    private static boolean elementAt = false;
    private static String endsWith = null;
    private static String equals = null;
    private static boolean equalsIgnoreCase = false;
    private static HttpMonitorServer err = null;
    private static ExProperties exists = null;
    private static boolean exit = true;
    private static boolean getAbsolutePath = false;
    public static final int DEFAULT_ADMIN_PORT = 1129;
    private static String getActiveRealm = null;
    private static int getAdminAddress = -1;
    private static RemoteMonitorService getAdminRemoteMonitorService = null;
    private static boolean getBoolean = false;
    private static MIMETypeTable getByName;
    private static boolean getBytes;
    private static boolean getDefaultMIMETypeTable;
    public static final String MONITOR_ISWAITFORADMIN = "monitor.server.is_wait_for_admin";
    public static final boolean DEFAULT_ISWAITFORADMIN = true;
    public static final boolean ADHOC_MONITOR_ENABLE = false;
    private static String getHomePath;
    private static String getHostAddress;
    private static String getHttpMonitorServer;

    public static void initMon(ExProperties exProperties) {
        Object object;
        if (equalsIgnoreCase || getDefaultMIMETypeTable) {
            return;
        }
        if (exProperties != null && exProperties.size() > 0) {
            exists.merge(exProperties);
        }
        if (exists.size() == 0) {
            object = System.getProperties();
            String string = null;
            Enumeration<Object> enumeration = ((Properties)object).keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                exists.setProperty(string, ((Properties)object).getProperty(string));
            }
        }
        MonitorEnv.QOIV();
        RemoteObjectFactory.setIsMonitorServer(true);
        RemoteObjectFactory.init(MonitorEnv.getMonitorServerRMIPort(), MonitorEnv.getHomePath());
        object = System.getProperty(IS_INTERNAL_SERVER);
        getBytes = object != null && ((String)object).equals("true");
        if (MonitorEnv.getAdminRemoteMonitorService() == null) {
            System.out.println("JReport Enterprise Server has not been started. Please start it before launching Monitor Server.");
            getDefaultMIMETypeTable = true;
            if (getBytes) {
                System.out.println("JReport Monitor Server will try 10 times to look for Standalone Admin Server...");
                int n = 1;
                boolean bl = false;
                while (n <= 10) {
                    block22: {
                        try {
                            Thread.sleep(6000L);
                            System.out.print("Attempt " + n + ".\r");
                            if (MonitorEnv.getAdminRemoteMonitorService() != null) {
                                break;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Exception exception) {
                            if (bl) break block22;
                            bl = true;
                            ServiceLogger.logError(exception);
                        }
                    }
                    ++n;
                }
                if (getAdminRemoteMonitorService == null && !MonitorEnv.isWaitForAdmin()) {
                    System.out.println("Monitor Server can't connect to JReport Enterprise Server [" + getActiveRealm + ":" + getAdminAddress + "]\n" + "Please make sure that JReport Enterprise Server has been started and is set up properly. Then, try again.\n" + "You can also set up 'monitor.server.is_wait_for_admin=true' in the file server.properties to enable Monitor Server to wait until JREntServer has been started.");
                    System.exit(1);
                }
            } else {
                do {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.print("Monitor Server is trying to look for Admin Server or Standalone Server...\r");
                } while (MonitorEnv.getAdminRemoteMonitorService() == null);
            }
        }
        err = new JRHttpMonitorServer();
        err.init(exists);
        err.start();
        getDefaultMIMETypeTable = false;
        equalsIgnoreCase = true;
        if (getAdminRemoteMonitorService == null) {
            System.out.println("Monitor Server can't connect to JReport Enterprise Server [" + getActiveRealm + ":" + getAdminAddress + "]\n" + "Monitor Server will wait until JReport Enterprise Server starts.\n");
            do {
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (MonitorEnv.getAdminRemoteMonitorService() == null);
        }
        System.out.println("Monitor Server has successfully connected to JReport Enterprise Server [" + getActiveRealm + ":" + getAdminAddress + "]");
        MonitorEnv.close();
        if (QOIV) {
            MBeanFactory.getInstance().registerAllMBeans();
            if (addElement) {
                MBeanFactory.getInstance().startHtmlAdaptorServer(append);
            }
        }
        MonitorEnv.savePropToFile();
    }

    public static boolean isInternalHttpServer() {
        return getBytes;
    }

    public static RemoteMonitorService getAdminRemoteMonitorService() {
        if (getAdminRemoteMonitorService == null) {
            try {
                getAdminRemoteMonitorService = (RemoteMonitorService)RemoteObjectFactory.getRemoteObject(getActiveRealm, getAdminAddress, MonitorEnv.getRemoteMonitorServiceName());
            }
            catch (Exception exception) {
                ServiceLogger.logError(2660219, new Object[]{getActiveRealm, String.valueOf(getAdminAddress), exception.getMessage()}, 2);
            }
        }
        return getAdminRemoteMonitorService;
    }

    private static void QOIV() {
        if (getAbsolutePath) {
            return;
        }
        exists.merge(MonitorEnv.getServerProperties());
        exists.setProperty("monitor.server.bin.path", MonitorEnv.getHomePath() + "bin");
        ServiceLogger.initErrorLog(exists);
        close = CSUtil.parseInt(exists.getProperty(MONITOR_RMI_PORT), 1248);
        exists.setProperty(MONITOR_RMI_PORT, close);
        exists.setProperty(SERVER_PROPERTY, MonitorEnv.getServPropName());
        if (equals != null) {
            if (equals.endsWith("\\")) {
                exists.setProperty(WEB_ROOT, equals.substring(0, equals.length() - 1));
            } else {
                exists.setProperty(WEB_ROOT, equals);
            }
        }
        if (exists.getProperty(MONITOR_HOMEPAGE) == null) {
            exists.setProperty(MONITOR_HOMEPAGE, "");
        }
        QOIV = exists.getProperty(STARTUP_MONITORING_JMX_FEATURES, false);
        exists.setProperty(STARTUP_MONITORING_JMX_FEATURES, QOIV);
        if (QOIV) {
            addElement = exists.getProperty(STARTUP_MONITOR_JMX_ADAPTOR, true);
            exists.setProperty(STARTUP_MONITOR_JMX_ADAPTOR, addElement);
            append = exists.getProperty(JMX_HTMLADAPTOR_PORT, 8849);
            exists.setProperty(JMX_HTMLADAPTOR_PORT, append);
        }
        MonitorEnv.getAdminAddress();
        MonitorEnv.getOutputEncoding();
        getAbsolutePath = true;
    }

    public static HttpMonitorServer getHttpMonitorServer() {
        if (err == null) {
            MonitorEnv.initMon(exists);
        }
        return err;
    }

    public static void restartMonitorServer() {
        err.restart(exists);
    }

    public static void shutdownMonitorServer() {
        equalsIgnoreCase = false;
        getAbsolutePath = false;
        RemoteObjectFactory.quit();
        err.shutdown();
    }

    public static String getPassword(String string, String string2) {
        String string3 = null;
        try {
            if (getAdminRemoteMonitorService != null) {
                string3 = getAdminRemoteMonitorService.getPassword(string, string2);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660011, new Object[]{getActiveRealm, String.valueOf(getAdminAddress)}, 3);
        }
        return string3;
    }

    public static boolean isAdminUser(String string, String string2, String string3) {
        boolean bl = false;
        try {
            if (getAdminRemoteMonitorService != null) {
                bl = getAdminRemoteMonitorService.isAdminUser(string, string2, string3);
                if (!bl) {
                    System.err.println("Only admin user can login Monitor Server!");
                }
                return bl;
            }
        }
        catch (Exception exception) {
            System.err.print("Admin Server is closed now!\r");
            ServiceLogger.logError(3660006, new Object[]{getActiveRealm, String.valueOf(getAdminAddress)}, 3);
        }
        return false;
    }

    public static String getActiveRealm() {
        String string = null;
        try {
            if (getAdminRemoteMonitorService != null) {
                string = getAdminRemoteMonitorService.getActiveRealm();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660012, new Object[]{getActiveRealm, String.valueOf(getAdminAddress)}, 3);
        }
        return string;
    }

    public static String getServPropName() {
        String string = System.getProperty(SERVER_PROPERTY);
        if (string == null) {
            string = "server.properties";
            string = MonitorEnv.getHomePath() + "bin" + File.separator + string;
        } else if (string.indexOf(File.separator) == -1) {
            string = MonitorEnv.getHomePath() + "bin" + File.separator + string;
        }
        return string;
    }

    public static String getWebPath() {
        return equals;
    }

    public static void setWebPath(String string) {
        File file = new File(string);
        if (file.isDirectory() && file.exists() && !(equals = string).endsWith(File.separator)) {
            equals = equals + File.separator;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getHomePath() {
        if (endsWith == null && (endsWith = System.getProperty(MONITOR_HOME)) == null) {
            endsWith = System.getProperty(INSTALL_ROOT);
        }
        if (endsWith == null) {
            System.err.println("Monitor properties have not been defined, please try with \"java -Dmonitor.home=path\"");
            if (!MonitorEnv.isInternalHttpServer()) throw new JSRuntimeException(600028);
            ServiceLogger.logError(3660013, 3);
            System.exit(1);
            return endsWith;
        } else {
            if (endsWith.endsWith(File.separator)) return endsWith;
            endsWith = endsWith + File.separator;
        }
        return endsWith;
    }

    public static String getAdminAddress() {
        if (getActiveRealm == null) {
            getActiveRealm = exists.getProperty(ADMIN_SERVER_HOST);
            if (getActiveRealm == null) {
                getActiveRealm = MonitorEnv.getMonitorServerHostName();
                exists.setProperty(ADMIN_SERVER_HOST, getActiveRealm);
                System.err.println("Warning: Admin host properties have not been set! \n\tMonitor Server will use the default value 'localhost' to lookup Admin Server.");
                if (ServiceLogger.isLoggable(2, 3)) {
                    ServiceLogger.logError(3660014, 3);
                }
            } else if (getActiveRealm.equalsIgnoreCase("localhost")) {
                getActiveRealm = MonitorEnv.getMonitorServerHostName();
                exists.setProperty(ADMIN_SERVER_HOST, getActiveRealm);
            }
        }
        if (getAdminAddress == -1 && (getAdminAddress = exists.getProperty(ADMIN_SERVER_PORT, -1)) == -1) {
            getAdminAddress = 1129;
            exists.setProperty(ADMIN_SERVER_PORT, getAdminAddress);
            System.err.println("Warning: Admin RMI port properties have not been set! \n\tMonitor Server will use the default value '1129' to lookup Admin Server.");
            if (ServiceLogger.isLoggable(2, 3)) {
                ServiceLogger.logError(3660015, 3);
            }
        }
        return getActiveRealm + ":" + getAdminAddress;
    }

    public static String getAdminHost() {
        return getActiveRealm;
    }

    public static int getAdminPort() {
        return getAdminAddress;
    }

    public static void setAdminHost(String string) {
        getActiveRealm = string;
    }

    public static void setAdminPort(int n) {
        getAdminAddress = n;
    }

    public static void savePropToFile() {
        String string = MonitorEnv.getServPropName();
        String string2 = null;
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            Vector vector = new Vector();
            Enumeration<Object> enumeration = exists.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            vector = APIUtil.sortAsCol(vector, null, true);
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                string2 = (String)vector.elementAt(n);
                printStream.println(string2 + "=" + exists.getProperty(string2));
                ++n;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660016, 3);
            ServiceLogger.logError(exception);
        }
    }

    public static void setProperties(ExProperties exProperties) {
        exists = exProperties;
    }

    public static ExProperties getProperties() {
        return exists;
    }

    public static int getDefaultRefreshInterval() {
        String string = exists.getProperty(MONITOR_REFRESH_INTERVAL);
        if (string != null) {
            return Integer.parseInt(string);
        }
        exists.setProperty(MONITOR_REFRESH_INTERVAL, 10000);
        return 10000;
    }

    public static void setDefaultRefreshInterval(int n) {
        if (n < 1000) {
            System.err.println("Please set default refresh interval value >= 1000 ms!");
            n = 1000;
        }
        try {
            exists.setProperty(MONITOR_REFRESH_INTERVAL, String.valueOf(n));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static int getMaxNumberSaveReport() {
        String string = exists.getProperty(MONITOR_MAX_REPORT_SAVE_NUMBER);
        if (string != null) {
            return Integer.parseInt(string);
        }
        exists.setProperty(MONITOR_MAX_REPORT_SAVE_NUMBER, 2000);
        return 2000;
    }

    public static void setMaxNumberSaveReport(int n) {
        if (n <= 0) {
            System.err.println("You set max report save number <= 0, it will be unlimited value!");
            n = 0;
        }
        try {
            exists.setProperty(MONITOR_MAX_REPORT_SAVE_NUMBER, String.valueOf(n));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static int getMaxTimeSaveReport() {
        String string = exists.getProperty(MONITOR_MAX_REPORT_SAVE_TIME);
        if (string != null) {
            return Integer.parseInt(string);
        }
        exists.setProperty(MONITOR_MAX_REPORT_SAVE_TIME, 5);
        return 5;
    }

    public static void setMaxTimeSaveReport(int n) {
        if (n <= 0) {
            System.err.println("You set max report save time <= 0, it will be unlimited value!");
            n = 0;
        }
        try {
            exists.setProperty(MONITOR_MAX_REPORT_SAVE_TIME, String.valueOf(n));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static ExProperties getServerProperties() {
        ExProperties exProperties = new ExProperties();
        try {
            String string = MonitorEnv.getServPropName();
            File file = new File(string);
            if (!file.exists()) {
                file.createNewFile();
            }
            exProperties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServiceLogger.logError(3660017, 3);
            ServiceLogger.logError(fileNotFoundException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(3660018, 3);
            ServiceLogger.logError(iOException);
        }
        return exProperties;
    }

    public static boolean isJspEnable() {
        return exit;
    }

    public static String getMonitorServerHostName() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
            ServiceLogger.logError(unknownHostException);
        }
        return string;
    }

    public static int getMonitorServerRMIPort() {
        return close;
    }

    public static String getUser(HttpServletRequest httpServletRequest) {
        String string = null;
        UserSession userSession = err.getHttpUserSessionManager().getUserSession(httpServletRequest);
        if (userSession != null) {
            string = userSession.getUserID();
        }
        return string == null ? "" : string;
    }

    public static String encodeEsc(String string, boolean bl) {
        return CSUtil.replWithEsc(string, bl);
    }

    public static String encodeEsc(String string) {
        return CSUtil.replWithEsc(string);
    }

    public static MIMETypeTable getMimeTypeTable() {
        return getByName;
    }

    private static void addElement() {
        String string = endsWith + "bin" + File.separator + "content-type.properties";
        try {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                getByName = new MIMETypeTable(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                getByName = MIMETypeTable.getDefaultMIMETypeTable();
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(string);
                    getByName.save(fileOutputStream);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("Failed on loading content-type file " + string + ". Default mime type table will be created.");
                ServiceLogger.logError(3660019, string, 2);
                getByName = MIMETypeTable.getDefaultMIMETypeTable();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    private static String append() {
        if (endsWith == null && (endsWith = System.getProperty(MONITOR_HOME)) == null) {
            endsWith = System.getProperty(INSTALL_ROOT);
        }
        if (endsWith == null) {
            return "monitor properties have not been defined, please try with \"java -Dmonitor.home=path\"";
        }
        if (!endsWith.endsWith(File.separator)) {
            endsWith = endsWith + File.separator;
        }
        return null;
    }

    public static void check() {
        if (getBoolean) {
            return;
        }
        String string = MonitorEnv.append();
        if (string != null) {
            System.err.println(string);
            throw new JSRuntimeException(string);
        }
        MonitorEnv.addElement();
        if (equals == null && endsWith != null) {
            File file;
            String string2 = System.getProperty(WEB_ROOT);
            if (string2 != null && (file = new File(string2)).isDirectory() && file.exists() && !(equals = file.getAbsolutePath()).endsWith(File.separator)) {
                equals = equals + File.separator;
            }
            if (equals == null) {
                equals = endsWith + "public_html" + File.separator;
            }
        }
        MonitorEnv.QOIV();
        getBoolean = true;
    }

    public static String getRemoteMonitorServiceName() {
        return "RemoteMonitorService";
    }

    public static String getMonitorCounterName() {
        return "MonitorCounter";
    }

    public static String getOutputEncoding() {
        if (!elementAt) {
            String string = null;
            try {
                string = exists.getProperty(SVRPROP_HTTP_OUTPUT_ENCODING, "");
                if (string == null) {
                    exists.setProperty(SVRPROP_HTTP_OUTPUT_ENCODING, "");
                }
                elementAt = true;
                if (string == null || string.trim().length() == 0) {
                    string = System.getProperty(PROP_OUTPUT_ENCODING);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            if (string != null && string.length() > 0) {
                try {
                    "a".getBytes(string);
                    createNewFile = string;
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6660020, new Object[]{SVRPROP_HTTP_OUTPUT_ENCODING, createNewFile}, 6);
            }
        }
        return createNewFile;
    }

    public static boolean isAdminServerStarted() {
        return MonitorEnv.getHttpMonitorServer().isStarting(getActiveRealm, getAdminAddress);
    }

    public static boolean isWaitForAdmin() {
        boolean bl = exists.getProperty(MONITOR_ISWAITFORADMIN, true);
        return bl;
    }

    public static String getLogsPath() {
        return MonitorEnv.getHomePath() + "logs";
    }

    public static boolean isAdminServer(String string, int n) {
        return getActiveRealm.equals(string) && getAdminAddress == n;
    }

    public static void setAdminRemoteMonService(RemoteMonitorService remoteMonitorService) {
        getAdminRemoteMonitorService = remoteMonitorService;
        MonitorEnv.close();
    }

    public static void setMonitorWebEntry(String string) {
        if (!string.equals(getHomePath)) {
            getHomePath = string;
            MonitorEnv.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void close() {
        if (getAdminRemoteMonitorService == null) return;
        if (getHomePath.equals("")) {
            getHomePath = exists.getProperty(MONITOR_HOMEPAGE);
            if (getHomePath == null || getHomePath.trim().length() == 0) {
                getHomePath = System.getProperty(MONITOR_HOMEPAGE);
            }
            if (getHomePath == null || getHomePath.trim().length() == 0) {
                System.err.println("Warning: The monitor homepage of the web entry has not been set!");
                if (ServiceLogger.isLoggable(2, 3)) {
                    ServiceLogger.logError(3660220, new Object[]{MONITOR_HOMEPAGE, MONITOR_HOMEPAGE}, 3);
                }
                if (!getBytes) {
                    System.err.println("\tSo the Monitor won't be possibly registered into JReport Server.");
                    return;
                }
                getHomePath = "http://" + MonitorEnv.getMonitorServerHostName() + ":" + exists.getProperty(MONITOR_SERVICE_PORT, 8848) + "/monitor/index.jsp";
                System.err.println("\tMonitor Server will use the default value '" + getHomePath + "' to register into its JReport Servers.");
                if (ServiceLogger.isLoggable(2, 3)) {
                    ServiceLogger.logError(3660221, getHomePath, 3);
                }
            } else {
                int n = getHomePath.indexOf(":", "http://".length());
                if (n > 0) {
                    String string = getHomePath.substring("http://".length(), n);
                    getHomePath = "http://" + MonitorEnv.getHostAddress(string) + getHomePath.substring(n);
                }
            }
        }
        try {
            getAdminRemoteMonitorService.setMonitorServerURL(getHomePath);
            if (!ServiceLogger.isLoggable(4, 6)) return;
            ServiceLogger.logDebug(6660222, new Object[]{getHomePath, getActiveRealm, String.valueOf(getAdminAddress)}, 6);
            return;
        }
        catch (Exception exception) {
            if (!ServiceLogger.isLoggable(2, 3)) return;
            ServiceLogger.logError(3660222, new Object[]{getActiveRealm, String.valueOf(getAdminAddress), exception.getMessage()}, 3);
        }
    }

    public static String getHostAddress(String string) {
        String string2 = null;
        try {
            string2 = string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1") ? MonitorEnv.getMonitorServerHostName() : InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = string;
        }
        return string2;
    }

    public static boolean isDisplayUserLastLoginTime() {
        String string = exists.getProperty(getHostAddress);
        if (string != null && string.trim().length() > 0) {
            return APIUtil.getBoolean(string, true);
        }
        exists.setProperty(getHostAddress, "true");
        try {
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return true;
    }

    public static boolean isDisplayUserLastLogoutTime() {
        String string = exists.getProperty(getHttpMonitorServer);
        if (string != null && string.trim().length() > 0) {
            return APIUtil.getBoolean(string, false);
        }
        exists.setProperty(getHttpMonitorServer, "false");
        try {
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return false;
    }

    public static void setDisplayUserLastLoginTime(boolean bl) {
        try {
            exists.setProperty(getHostAddress, String.valueOf(bl));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static void setDisplayUserLastLogoutTime(boolean bl) {
        try {
            exists.setProperty(getHttpMonitorServer, String.valueOf(bl));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static boolean getShowVirtualApplianceWelcomePage() {
        return VirtualApplianceEnv.getShowVirtualApplianceWelcomePage();
    }

    public static void setShowVirtualApplianceWelcomePage(boolean bl) {
        VirtualApplianceEnv.setShowVirtualApplianceWelcomePage(bl);
    }

    static {
        getBytes = true;
        getDefaultMIMETypeTable = false;
        getHomePath = "";
        getHostAddress = "last.user.login.time";
        getHttpMonitorServer = "last.user.logout.time";
        exists = new CreateDefExProperties(true);
    }

    static class VirtualApplianceEnv {
        private static Properties QOIV = new Properties();
        private static long append = 0L;

        VirtualApplianceEnv() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void QOIV() {
            File file = new File(MonitorEnv.getHomePath() + "bin", "virtualAppliance.properties");
            if (file.exists() && file.lastModified() > append) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        QOIV.load(fileInputStream);
                        Object var3_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        ((InputStream)fileInputStream).close();
                        throw throwable;
                    }
                    ((InputStream)fileInputStream).close();
                    {
                    }
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void append() {
            try {
                File file = new File(MonitorEnv.getHomePath() + "bin", "virtualAppliance.properties");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    QOIV.store(fileOutputStream, null);
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    ((OutputStream)fileOutputStream).close();
                    throw throwable;
                }
                ((OutputStream)fileOutputStream).close();
                append = file.lastModified();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }

        public static boolean getShowVirtualApplianceWelcomePage() {
            VirtualApplianceEnv.QOIV();
            return APIUtil.getBoolean(QOIV.getProperty("show_welcome_page"), false);
        }

        public static void setShowVirtualApplianceWelcomePage(boolean bl) {
            QOIV.setProperty("show_welcome_page", String.valueOf(bl));
            VirtualApplianceEnv.append();
        }
    }
}

