/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.cluster;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.server.api.cluster.Member;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.MonitorServer;
import jet.server.monitor.api.ServerStatus;
import jet.server.monitor.event.EventSubscriber;
import jet.server.monitor.event.MonitorEventHandler;
import jet.server.monitor.jrmon.JRMonitorServer;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.cluster.ClusterMonitorThread;
import jet.server.monitor.jrmon.cluster.JRServerStatus;
import jet.server.monitor.jrmon.intf.ClusterMonitor;

public class JRClusterMonitor
implements ClusterMonitor {
    private int QOIV = 0;
    private int Server_Type = 0;
    private ClusterMonitorThread activate = null;
    private Hashtable addElement = new Hashtable();
    private MonitorServer addSelector = null;
    private static boolean addSubscriber = false;

    public JRClusterMonitor() {
    }

    public JRClusterMonitor(MonitorServer monitorServer) {
        this();
        this.addSelector = monitorServer;
    }

    public JRClusterMonitor(MonitorServer monitorServer, int n) {
        this(monitorServer);
        this.QOIV = n;
    }

    public void resolveClusterServers() {
        Member[] memberArray = this.addSelector.getPredefinedServers();
        JRServerStatus jRServerStatus = null;
        String string = null;
        String string2 = null;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < memberArray.length) {
            string = memberArray[n3].getServerName();
            string2 = memberArray[n3].getHost();
            n = Integer.parseInt(memberArray[n3].getPort());
            n2 = memberArray[n3].getBackupPriority();
            n2 = n2 == -1 ? 3 : (MonitorEnv.isAdminServer(string2, n) ? 1 : 2);
            jRServerStatus = new JRServerStatus(string, string2, n, n2);
            if (this.addSelector.isStarted(string2, n)) {
                jRServerStatus.setStatus(1);
                jRServerStatus.setStartTime(System.currentTimeMillis());
            }
            this.addElement.put(string2 + ":" + n, jRServerStatus);
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllServerStatus() {
        Vector vector = new Vector();
        Hashtable hashtable = this.addElement;
        synchronized (hashtable) {
            Enumeration enumeration = this.addElement.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void QOIV(String[] stringArray) {
        Hashtable hashtable = this.addElement;
        synchronized (hashtable) {
            Enumeration enumeration = this.addElement.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = true;
                int n = 0;
                while (n < stringArray.length) {
                    if (string.equals(stringArray[n])) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (!bl) continue;
                if (ServiceLogger.isLoggable(4, 6)) {
                    ServiceLogger.logDebug(6660034, string, 6);
                }
                this.addElement.remove(string);
            }
        }
    }

    public ServerStatus getServerStatus(String string, int n) {
        ServerStatus serverStatus = (ServerStatus)this.addElement.get(string + ":" + n);
        if (serverStatus == null) {
            Member[] memberArray = this.addSelector.getPredefinedServers();
            String[] stringArray = new String[memberArray.length];
            int n2 = 0;
            while (n2 < memberArray.length) {
                String string2 = memberArray[n2].getHost();
                String string3 = memberArray[n2].getPort();
                stringArray[n2] = string2 + ":" + string3;
                int n3 = -1;
                try {
                    n3 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = -1;
                }
                if (string.equals(string2) && n == n3) {
                    int n4 = memberArray[n2].getBackupPriority();
                    n4 = n4 < 0 ? 3 : (MonitorEnv.isAdminServer(string, n) ? 1 : 2);
                    serverStatus = new JRServerStatus(memberArray[n2].getServerName(), string, n, n4);
                    if (this.addSelector.isStarting(string, n)) {
                        ((JRServerStatus)serverStatus).setStatus(1);
                        ((JRServerStatus)serverStatus).setStartTime(System.currentTimeMillis());
                    }
                    this.addElement.put(string + ":" + n, serverStatus);
                }
                ++n2;
            }
            this.QOIV(stringArray);
        } else if (((JRServerStatus)serverStatus).isAdminServer()) {
            this.Server_Type(serverStatus.getHost(), String.valueOf(serverStatus.getPort()), (JRServerStatus)serverStatus);
        }
        return serverStatus;
    }

    public ServerStatus getAdminServer() {
        ServerStatus serverStatus = null;
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            serverStatus = (ServerStatus)enumeration.nextElement();
            if (serverStatus != null && serverStatus.getType().equals(JRServerStatus.Server_Type[1])) break;
            serverStatus = null;
        }
        return serverStatus;
    }

    public Vector getAllBackupServers() {
        Vector<ServerStatus> vector = new Vector<ServerStatus>();
        ServerStatus serverStatus = null;
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            serverStatus = (ServerStatus)enumeration.nextElement();
            if (serverStatus == null || !serverStatus.getType().equals(JRServerStatus.Server_Type[2])) continue;
            vector.addElement(serverStatus);
        }
        return vector;
    }

    public Vector getAllSlaveServers() {
        Vector<ServerStatus> vector = new Vector<ServerStatus>();
        ServerStatus serverStatus = null;
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            serverStatus = (ServerStatus)enumeration.nextElement();
            if (serverStatus == null || !serverStatus.getType().equals(JRServerStatus.Server_Type[3])) continue;
            vector.addElement(serverStatus);
        }
        return vector;
    }

    public void setInterval(int n) {
        this.QOIV = n;
    }

    public int getInterval() {
        return this.QOIV;
    }

    public void setDuration(int n) {
        this.Server_Type = n;
    }

    public int getDuration() {
        return this.Server_Type;
    }

    public void start() {
        this.activate = new ClusterMonitorThread(this);
        this.resolveClusterServers();
        this.createSubscribers("ClusterService", -1);
        this.activate.start();
    }

    public void restart() {
        this.activate.destroy();
        this.start();
    }

    public void stop() {
        this.activate.stopRun();
    }

    public void addServerStatus(int n, Properties properties) {
        ServerStatus serverStatus = null;
        String string = properties.getProperty("serverHost") + ":" + properties.getProperty("serverPort");
        switch (n) {
            case 0: {
                String string2 = properties.getProperty("serverHost");
                int n2 = Integer.parseInt(properties.getProperty("serverPort"));
                int n3 = Integer.parseInt(properties.getProperty("serverType")) + 1;
                if (MonitorEnv.isAdminServer(string2, n2)) {
                    n3 = 1;
                } else if (n3 == 1) {
                    n3 = 2;
                }
                serverStatus = (ServerStatus)this.addElement.get(string);
                if (serverStatus != null) {
                    ((JRServerStatus)serverStatus).setStatus(1);
                    ((JRServerStatus)serverStatus).setType(n3);
                    ((JRServerStatus)serverStatus).setClosedTime(-1L);
                    break;
                }
                serverStatus = new JRServerStatus(properties.getProperty("serverName"), string2, n2, n3);
                ((JRServerStatus)serverStatus).setStartTime(Long.parseLong(properties.getProperty("startTime")));
                ((JRServerStatus)serverStatus).setStatus(1);
                this.addElement.put(string, serverStatus);
                break;
            }
            case 1: {
                serverStatus = (ServerStatus)this.addElement.get(string);
                ((JRServerStatus)serverStatus).setClosedTime(Long.parseLong(properties.getProperty("closeTime")));
                break;
            }
            case 2: {
                serverStatus = (ServerStatus)this.addElement.get(string);
                ((JRServerStatus)serverStatus).setClosedTime(Long.parseLong(properties.getProperty("closeTime")));
                ((JRServerStatus)serverStatus).setReason(properties.getProperty("crashReason"));
                break;
            }
            default: {
                if (!ServiceLogger.isLoggable(3, 6)) break;
                ServiceLogger.logEvent(6660035, String.valueOf(n), 6);
            }
        }
    }

    public void update() {
        JRServerStatus jRServerStatus = null;
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            jRServerStatus = (JRServerStatus)enumeration.nextElement();
            if (jRServerStatus == null) continue;
            boolean bl = this.addSelector.isStarting(jRServerStatus.getHost(), jRServerStatus.getPort());
            if (bl) {
                if (!jRServerStatus.isStarted()) {
                    jRServerStatus.setStatus(1);
                    jRServerStatus.setStartTime(System.currentTimeMillis());
                    jRServerStatus.setClosedTime(-1L);
                }
                this.addSelector.getMonitorService(jRServerStatus.getHost(), jRServerStatus.getPort());
                this.createSubscribers("ClusterService", -1);
                continue;
            }
            if (!jRServerStatus.isStarted()) continue;
            jRServerStatus.setStatus(5);
            jRServerStatus.setClosedTime(System.currentTimeMillis());
            ((JRMonitorServer)this.addSelector).stopMonitorService(jRServerStatus.getHost(), jRServerStatus.getPort());
            ((JRMonitorServer)this.addSelector).deleteRemoteMonitorService(jRServerStatus.getHost(), jRServerStatus.getPort());
        }
        if (!this.addSelector.isStarting(MonitorEnv.getAdminHost(), MonitorEnv.getAdminPort())) {
            MonitorEnv.setAdminRemoteMonService(null);
            addSubscriber = true;
            ServerStatus serverStatus = null;
            ServerStatus serverStatus2 = this.getAdminServer();
            if (serverStatus2 != null && serverStatus2.isStarted()) {
                ((JRServerStatus)serverStatus2).setStatus(6);
                ((JRServerStatus)serverStatus2).setClosedTime(System.currentTimeMillis());
                ((JRServerStatus)serverStatus2).setReason("Admin Server crashed!");
            }
            ((JRMonitorServer)this.addSelector).deleteRemoteMonitorService(MonitorEnv.getAdminHost(), MonitorEnv.getAdminPort());
            RemoteMonitorService remoteMonitorService = null;
            Vector vector = this.getAllBackupServers();
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                block16: {
                    serverStatus = (ServerStatus)vector.elementAt(n);
                    try {
                        remoteMonitorService = ((JRMonitorServer)this.addSelector).getRemoteMonitorService(serverStatus.getHost(), serverStatus.getPort());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (remoteMonitorService != null) {
                        try {
                            if (remoteMonitorService.isAdminServer()) {
                                addSubscriber = false;
                                ((JRServerStatus)serverStatus2).setType(2);
                                MonitorEnv.setAdminHost(serverStatus.getHost());
                                MonitorEnv.setAdminPort(serverStatus.getPort());
                                MonitorEnv.setAdminRemoteMonService(remoteMonitorService);
                                ((JRServerStatus)serverStatus).setType(1);
                                this.Server_Type(serverStatus.getHost(), String.valueOf(serverStatus.getPort()), (JRServerStatus)serverStatus);
                                return;
                            }
                        }
                        catch (RemoteException remoteException) {
                            if (!ServiceLogger.isLoggable(2, 3)) break block16;
                            ServiceLogger.logError(3660037, new Object[]{serverStatus.getHost(), String.valueOf(serverStatus.getPort()), remoteException.getMessage()}, 3);
                        }
                    }
                }
                ++n;
            }
        } else if (addSubscriber) {
            try {
                MonitorEnv.setAdminRemoteMonService(((JRMonitorServer)this.addSelector).getRemoteMonitorService(MonitorEnv.getAdminHost(), MonitorEnv.getAdminPort()));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            addSubscriber = false;
        }
    }

    private void Server_Type(String string, String string2, JRServerStatus jRServerStatus) {
        Member[] memberArray = this.addSelector.getPredefinedServers();
        int n = 0;
        while (n < memberArray.length) {
            if (string.equals(memberArray[n].getHost()) && string2.equals(memberArray[n].getPort())) {
                jRServerStatus.setName(memberArray[n].getServerName());
            }
            ++n;
        }
    }

    public boolean isStarted() {
        return true;
    }

    public void createSubscribers(String string, int n) {
        String string2 = MonitorEnv.getAdminHost();
        int n2 = MonitorEnv.getAdminPort();
        Subscriber subscriber = EventSubscriber.getEventSubscriber().getSubscriber(string2 + ":" + n2 + "_" + string);
        if (subscriber == null) {
            subscriber = EventSubscriber.getEventSubscriber().getEventService().createSubscriber(string2, n2, new MonitorEventHandler(this));
            EventSubscriber.getEventSubscriber().addSubscriber(string2 + ":" + n2 + "_" + string, subscriber);
        }
        SelectorImpl selectorImpl = new SelectorImpl(string, 3);
        if (n >= 0) {
            selectorImpl.enable(n);
        } else {
            selectorImpl.enableAll();
        }
        subscriber.addSelector(selectorImpl);
        try {
            subscriber.activate();
            subscriber.update();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

