/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.database;

import java.rmi.RemoteException;
import java.util.Properties;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.MonitorService;
import jet.server.monitor.api.database.DatabaseMonitor;
import jet.server.monitor.jrmon.JRMonitorService;
import jet.server.monitor.jrmon.database.DatabaseMonitorThread;

public class JRDatabaseMonitor
implements DatabaseMonitor {
    private int QOIV = 0;
    private int append = 0;
    private boolean destroy = false;
    private DatabaseMonitorThread disconnect = null;
    private MonitorService equals = null;
    private Properties[] getConnectionProperties = new Properties[0];

    public JRDatabaseMonitor() {
    }

    public JRDatabaseMonitor(MonitorService monitorService) {
        this(monitorService, monitorService.getDefaultInterval());
    }

    public JRDatabaseMonitor(MonitorService monitorService, int n) {
        this();
        this.equals = monitorService;
        this.QOIV = n;
    }

    public Properties[] getConnectionProperties() {
        Properties[] propertiesArray = new Properties[]{};
        try {
            RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.equals).getRemoteMonitorService();
            if (remoteMonitorService != null) {
                propertiesArray = remoteMonitorService.getConnectionProperties();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (propertiesArray != null) {
            this.getConnectionProperties = propertiesArray;
        } else {
            propertiesArray = this.getConnectionProperties;
        }
        return propertiesArray;
    }

    public void disconnect(String string) {
        Object object;
        try {
            object = ((JRMonitorService)this.equals).getRemoteMonitorService();
            if (object != null) {
                object.disconnect(string);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError("Failed to disconnect the database connecton [id=" + string + "], " + remoteException.getMessage());
        }
        if (this.getConnectionProperties.length > 0) {
            object = null;
            int n = -1;
            int n2 = 0;
            while (n2 < this.getConnectionProperties.length) {
                object = this.getConnectionProperties[n2].getProperty("id");
                if (((String)object).equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n >= 0) {
                Properties[] propertiesArray = new Properties[this.getConnectionProperties.length - 1];
                int n3 = 0;
                while (n3 < propertiesArray.length) {
                    propertiesArray[n3] = n3 < n ? this.getConnectionProperties[n3] : this.getConnectionProperties[n3 + 1];
                    ++n3;
                }
                this.getConnectionProperties = propertiesArray;
            }
        }
    }

    public int getCurrentConnectionNums() {
        return this.getConnectionProperties().length;
    }

    public void setInterval(int n) {
        this.QOIV = n;
    }

    public int getInterval() {
        return this.QOIV;
    }

    public void setDuration(int n) {
        this.append = n;
    }

    public int getDuration() {
        return this.append;
    }

    public void start() {
        this.disconnect = new DatabaseMonitorThread(this);
        this.disconnect.start();
        this.destroy = true;
    }

    public void restart() {
        this.disconnect.destroy();
        this.start();
    }

    public void stop() {
        this.disconnect.stopRun();
        this.destroy = false;
    }

    public void update() {
    }

    public boolean isStarted() {
        return this.destroy;
    }

    public MonitorService getMonitorService() {
        return this.equals;
    }
}

