/*
 * Decompiled with CFR 0.152.
 */
package jet.server.objectman;

import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import jet.JException;
import jet.cs.CSUtil;
import jet.objectman.Loader;
import jet.objectman.ObjectManager;
import jet.objectman.ResourceObject;
import jet.server.api.PathInfo;
import jet.server.api.ResourceManager;
import jet.server.api.ResultFiles;
import jet.server.api.ResultVersionRecord;
import jet.server.api.RptServerException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.UnknownResource;
import jet.server.log.ServiceLogger;

public final class ObjectManagerImpl
implements ObjectManager {
    private static ObjectManagerImpl QOIV;
    private Hashtable cancel = new Hashtable();
    private Hashtable clear = new Hashtable();
    private ResourceManager clone;
    private Timer destroy;
    private Hashtable get;

    public static ObjectManager getObjectManager(ResourceManager resourceManager) {
        if (QOIV == null) {
            QOIV = new ObjectManagerImpl(resourceManager);
        }
        return QOIV;
    }

    public static void clear() {
        QOIV.destroy();
        QOIV = null;
    }

    private ObjectManagerImpl(ResourceManager resourceManager) {
        this.clone = resourceManager;
        this.destroy = new Timer(false);
        this.get = new Hashtable();
    }

    public ResourceObject get(ResourceObject resourceObject) {
        Map map = resourceObject.getDependants();
        String string = (String)map.get("res.categorykey");
        String string2 = (String)map.get("res.rkey");
        Loader loader = (Loader)this.clear.get(resourceObject.getResourceType());
        try {
            Object object;
            if (string == null) {
                RemoveCategoryTask removeCategoryTask;
                String string3 = resourceObject.getResourceName();
                int n = CSUtil.parseInt((String)map.get("res.vers"), -1);
                String string4 = (String)map.get("res.user");
                PathInfo pathInfo = this.clone.getPathInfo(string4, string3);
                ResultVersionRecord resultVersionRecord = null;
                if (pathInfo.isReport()) {
                    resultVersionRecord = this.clone.getResultVersion(string4, string3, n);
                } else if (pathInfo.isResult()) {
                    resultVersionRecord = this.clone.getResultDocVersion(string4, string3, n);
                }
                Hashtable hashtable = resultVersionRecord.getAllReportResultFiles();
                ResultFiles resultFiles = (ResultFiles)hashtable.get("jrs.rsd_result");
                String string5 = this.clone.getHistFile(resultFiles.getRsdFileName());
                string = String.valueOf(string5.hashCode());
                resourceObject.putDependant("res.categorykey", string);
                Category category = (Category)this.cancel.get(string);
                if (category == null) {
                    object = loader.load(string5, map);
                    category = new Category(this, string, string5);
                    category.I(string2, object);
                    this.cancel.put(string, category);
                } else if (category.I(string2)) {
                    object = category.Z(string2);
                } else {
                    object = loader.load(string5, map);
                    category.I(string2, object);
                }
                if (category.Z() == 1 && (removeCategoryTask = (RemoveCategoryTask)this.get.remove(string)) != null) {
                    removeCategoryTask.cancel();
                }
            } else {
                Category category = (Category)this.cancel.get(string);
                if (category.I(string2)) {
                    object = category.Z(string2);
                } else {
                    loader = (Loader)this.clear.get(resourceObject.getResourceType());
                    object = loader.load(category.I(), map);
                    category.I(string2, object);
                }
            }
            resourceObject.setObject(loader.clone(object));
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError(rptServerException);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
        }
        catch (JException jException) {
            ServiceLogger.logError(jException);
        }
        return resourceObject;
    }

    public void registerLoader(String string, Loader loader) {
        this.clear.put(string, loader);
    }

    public void destroy() {
        this.cancel.clear();
        this.clear.clear();
        this.destroy.cancel();
        this.get.clear();
    }

    public void remove(ResourceObject resourceObject) {
        String string = (String)resourceObject.getDependant("res.categorykey");
        Category category = (Category)this.cancel.get(string);
        if (category.C() == 0) {
            RemoveCategoryTask removeCategoryTask = new RemoveCategoryTask(this, string, this.cancel);
            this.get.put(string, removeCategoryTask);
            this.destroy.schedule((TimerTask)removeCategoryTask, 1800000L);
        }
    }

    class RemoveCategoryTask
    extends TimerTask {
        private String QOIV;
        private Hashtable access$000;
        private final ObjectManagerImpl this$0;

        RemoveCategoryTask(ObjectManagerImpl objectManagerImpl, String string, Hashtable hashtable) {
            this.this$0 = objectManagerImpl;
            this.QOIV = string;
            this.access$000 = hashtable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Hashtable hashtable = this.access$000;
            synchronized (hashtable) {
                Category category = (Category)this.access$000.get(this.QOIV);
                if (Category.access$000(category) == 0) {
                    category.clear();
                    this.access$000.remove(this.QOIV);
                }
            }
        }
    }

    class Category {
        private String QOIV;
        private String add;
        private Hashtable clear;
        private Vector contains;
        private int get;
        private final ObjectManagerImpl this$0;

        Category(ObjectManagerImpl objectManagerImpl, String string, String string2) {
            this.this$0 = objectManagerImpl;
            this.QOIV = string;
            this.add = string2;
            this.clear = new Hashtable();
            this.contains = new Vector();
            this.get = 0;
        }

        String I() {
            return this.add;
        }

        synchronized int Z() {
            return ++this.get;
        }

        synchronized int C() {
            return --this.get;
        }

        void I(String string, Object object) {
            if (!this.contains.contains(string)) {
                this.contains.add(string);
                if (object != null) {
                    this.clear.put(string, object);
                }
            }
        }

        boolean I(String string) {
            return this.contains.contains(string);
        }

        Object Z(String string) {
            return this.clear.get(string);
        }

        void clear() {
            this.contains.clear();
            this.clear.clear();
        }

        static int access$000(Category category) {
            return category.get;
        }
    }
}

