/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling;

import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.Workspace;
import jet.server.api.profiling.CollectingAgency;
import jet.server.db.Connector;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.WorkspaceImpl;
import jet.server.db.core.WorkspaceManager;
import jet.server.db.transfer.ProfilingTransferHelp;
import jet.server.event.EventHandler;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.event.TopicEvent;
import jet.server.event.subscriber.SubscribeService;
import jet.server.log.ServiceLogger;
import jet.server.profiling.CounterCategory;
import jet.server.profiling.PerformanceCounter;
import jet.server.profiling.ProfilingReport;
import jet.server.profiling.ProfilingService;
import jet.server.profiling.jreport.DefProfilingReport;
import jet.server.profiling.net.RemoteFileSystemImpl;
import jet.server.rmi.RemoteObjectFactory;

public final class ProfilingServiceImpl
extends UnicastRemoteObject
implements ProfilingService,
jet.server.api.profiling.ProfilingService {
    private static final long serialVersionUID = -6081093301513897814L;
    private static ProfilingServiceImpl QOIV = null;
    private RemoteFileSystemImpl activate = null;
    private SubscribeService addSelector = null;
    private Connector append = null;
    private Database clone = null;
    private Hashtable close = new Hashtable();
    private CollectingAgency createSubscriber = null;

    public static ProfilingServiceImpl getInstance() {
        return QOIV;
    }

    public static ProfilingServiceImpl newInstance() {
        if (QOIV == null) {
            try {
                QOIV = new ProfilingServiceImpl();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                QOIV = null;
            }
        }
        return QOIV;
    }

    public void destroy() {
        if (QOIV != null) {
            if (this.createSubscriber != null) {
                this.createSubscriber.destroy();
            }
            if (this.clone != null) {
                ((DatabaseImpl)this.clone).close();
            }
            if (this.append != null) {
                this.append.destroy();
            }
            if (this.addSelector != null) {
                this.addSelector.destroyAllSubscribers();
            }
            this.activate = null;
            QOIV = null;
        }
    }

    public void registerToManager() {
        RemoteObjectFactory.register("42bab3c2-c4b4-471f-9b45-027a50f2f151", this);
        RemoteObjectFactory.register("8fc391bf-6f98-4c47-b6c2-9dd1c04a8413", this.activate);
    }

    public PerformanceCounter getPerformanceCounter(String string, String string2) throws RemoteException {
        return CounterCategory.getCounter(null, string, string2);
    }

    public PerformanceCounter[] getPerformanceCounters(String string) throws RemoteException {
        CounterCategory counterCategory = CounterCategory.getCategory(null, string);
        return counterCategory.getCounters();
    }

    public String[] getCategories() throws RemoteException {
        CounterCategory[] counterCategoryArray = CounterCategory.getCategories();
        String[] stringArray = new String[counterCategoryArray.length];
        int n = 0;
        while (n < counterCategoryArray.length) {
            stringArray[n] = counterCategoryArray[n].getCategoryName();
            ++n;
        }
        return stringArray;
    }

    public void registerProfilingReport(ProfilingReport profilingReport) {
        this.close.put(profilingReport.getProfileName(), profilingReport);
    }

    public String[] getProfileNames() throws RemoteException {
        String[] stringArray = new String[this.close.size()];
        Enumeration enumeration = this.close.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String runReport(String string, Properties properties) throws RemoteException {
        ProfilingReport profilingReport = (ProfilingReport)this.close.get(string);
        if (profilingReport != null && this.append != null) {
            properties.setProperty("jreport.rpthome", ServerEnv.homePath);
            properties.setProperty("jrs.param$jdbc_driver", this.append.getProperty("driver", ""));
            properties.setProperty("jrs.param$jdbc_url", this.append.getProperty("url", ""));
            properties.setProperty("jrs.param$jdbc_user", this.append.getProperty("user", ""));
            properties.setProperty("jrs.param$jdbc_password", this.append.getProperty("password", ""));
            try {
                Connection connection = this.append.getConnection(10000L);
                properties.put("profilingdb.connection", connection);
            }
            catch (SQLException sQLException) {
                throw new RemoteException("", sQLException);
            }
            try {
                return profilingReport.runReport(properties);
            }
            catch (Exception exception) {
                throw new RemoteException("", exception);
            }
        }
        throw new RemoteException("Can not found " + string + " profiling report.");
    }

    private ProfilingServiceImpl() throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        String string = ServerEnv.getActiveRealm();
        Workspace workspace = WorkspaceManager.getInstance().workspaces(string);
        if (workspace == null) {
            workspace = new WorkspaceImpl(string);
            this.clone = this.QOIV(workspace);
            WorkspaceManager.getInstance().append(workspace);
            WorkspaceManager.getInstance().saveConfig();
        } else {
            this.clone = workspace.databases("profiling");
            if (this.clone == null) {
                this.clone = this.QOIV(workspace);
                WorkspaceManager.getInstance().saveConfig();
            }
        }
        if (this.clone instanceof DatabaseImpl) {
            ((DatabaseImpl)this.clone).setTransferHelp(new ProfilingTransferHelp());
        }
        try {
            ((DatabaseImpl)this.clone).open();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new RemoteException(sQLException.getLocalizedMessage());
        }
        ServiceLogger.logDebug(4640002, new String[]{string, "profiling"}, 4);
        this.append = ((DatabaseImpl)this.clone).getConnector();
        this.activate = new RemoteFileSystemImpl();
        this.addSelector = SubscribeService.newInstance();
        Subscriber subscriber = this.addSelector.createSubscriber(new ProfileDataReceiver(this));
        SelectorImpl selectorImpl = new SelectorImpl("*", 32);
        selectorImpl.enableAll();
        subscriber.addSelector(selectorImpl);
        try {
            subscriber.activate();
            ServiceLogger.logEvent(6660002, 6);
        }
        catch (Exception exception) {
            ServiceLogger.logEvent(6660003, 6);
        }
        try {
            this.createSubscriber = (CollectingAgency)Class.forName("jet.server.profiling.jreport.RptServerCollectingAgency").newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        Properties properties = (Properties)this.clone.getProperties().clone();
        if (this.append != null) {
            properties.put("database", this.clone);
        }
        if (this.createSubscriber != null) {
            properties.put("restore.profiling", System.getProperty("restore.profiling", ""));
            this.createSubscriber.init(properties);
        }
        this.registerProfilingReport(new DefProfilingReport("Reports Running Profile", "RptProfile.cls", "TaskRunningStat"));
        this.registerProfilingReport(new DefProfilingReport("Frequently Accessed Reports", "FreqAccessStat.cls", "FreqAccessdStat"));
    }

    private Database QOIV(Workspace workspace) {
        String string = ServerEnv.originalHomePath;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        DatabaseImpl databaseImpl = new DatabaseImpl(workspace, "profiling");
        databaseImpl.setProperty("driver", "org.hsqldb.jdbcDriver");
        databaseImpl.setProperty("user", "sa");
        databaseImpl.setProperty("password", "");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jdbc:hsqldb:").append(string).append("profiling").append(File.separator).append("database").append(File.separator).append("profile");
        databaseImpl.setProperty("url", stringBuffer.substring(0));
        ((WorkspaceImpl)workspace).append(databaseImpl);
        return databaseImpl;
    }

    static CollectingAgency access$000(ProfilingServiceImpl profilingServiceImpl) {
        return profilingServiceImpl.createSubscriber;
    }

    private final class ProfileDataReceiver
    implements EventHandler {
        private final ProfilingServiceImpl this$0;

        public ProfileDataReceiver(ProfilingServiceImpl profilingServiceImpl) {
            this.this$0 = profilingServiceImpl;
        }

        public void process(TopicEvent topicEvent) {
            if ("TaskContext".equals(topicEvent.getTopic()) && ProfilingServiceImpl.access$000(this.this$0) != null) {
                ProfilingServiceImpl.access$000(this.this$0).collects((Hashtable)topicEvent.getData());
            }
        }
    }
}

