/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rc;

import java.io.IOException;
import java.security.acl.NotOwnerException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JSvrResource;
import jet.server.ServerEnv;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.log.ServiceLogger;
import jet.server.rc.ActionProcessor;
import jet.server.rc.HomeProcessor;
import jet.server.rc.RcToolkit;
import jet.server.userman.Realm;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.UserDataToolkit;

public class RealmProcessor
extends ActionProcessor {
    public static String IDS_REQUEST_SHUTDOWN = "RequestShutdown";
    public static String IDS_LIST_REALM = "ListRealm";
    public static String IDS_NEW_REALM = "NewRealm";
    public static String IDS_EDIT_REALM = "EditRealm";
    public static String IDS_SELECT_REALM = "SelectRealm";
    public static String IDS_REQUEST_NEW_REALM = "RequestNewRealm";
    public static String IDS_REQUEST_EDIT_REALM = "RequestEditRealm";
    public static String IDS_REMOVE_REALM = "RemoveRealm";
    public static String IDS_REQUEST_REMOVE_REALM = "RequestRemoveRealm";
    public static String IDS_REQUEST_RESTART = "RequestRestart";
    static Class class$jet$server$userman$Realm;

    public RealmProcessor() {
        this.actions.addElement(IDS_REQUEST_SHUTDOWN);
        this.actions.addElement(IDS_LIST_REALM);
        this.actions.addElement(IDS_NEW_REALM);
        this.actions.addElement(IDS_EDIT_REALM);
        this.actions.addElement(IDS_SELECT_REALM);
        this.actions.addElement(IDS_REQUEST_NEW_REALM);
        this.actions.addElement(IDS_REQUEST_EDIT_REALM);
        this.actions.addElement(IDS_REMOVE_REALM);
        this.actions.addElement(IDS_REQUEST_REMOVE_REALM);
        this.actions.addElement(IDS_REQUEST_RESTART);
    }

    public void processEvent(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        super.processEvent(string, properties, httpServletRequest, httpServletResponse);
        if (string.equalsIgnoreCase(IDS_LIST_REALM)) {
            this.IDS_NEW_REALM();
        } else if (string.equalsIgnoreCase(IDS_NEW_REALM)) {
            this.IDS_REMOVE_REALM();
        } else if (string.equalsIgnoreCase(IDS_EDIT_REALM)) {
            this.IDS_REQUEST_EDIT_REALM();
        } else if (string.equalsIgnoreCase(IDS_SELECT_REALM)) {
            this.IDS_REQUEST_NEW_REALM();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_NEW_REALM)) {
            this.IDS_REQUEST_REMOVE_REALM();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_EDIT_REALM)) {
            this.IDS_REQUEST_HOME();
        } else if (string.equalsIgnoreCase(IDS_REMOVE_REALM)) {
            this.IDS_REQUEST_RESTART();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_REMOVE_REALM)) {
            this.IDS_REQUEST_SHUTDOWN();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_SHUTDOWN)) {
            this.IDS_LIST_REALM();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_RESTART)) {
            this.IDS_EDIT_REALM();
        }
    }

    private void IDS_EDIT_REALM() throws IOException {
        String string = "Do you really want to restart the server?";
        String[] stringArray = new String[]{" Yes ", "Restart", " No ", HomeProcessor.IDS_REQUEST_HOME};
        this.printMessage(string, stringArray);
    }

    private void IDS_LIST_REALM() throws IOException {
        String string = "Do you really want to shut down the server?";
        String[] stringArray = new String[]{" Yes ", "Shutdown", " No ", HomeProcessor.IDS_REQUEST_HOME};
        this.printMessage(string, stringArray);
    }

    private void IDS_NEW_REALM() throws IOException {
        String string = "";
        String string2 = this.getCurEditRealm();
        string = string + "<table width=100% border=0>";
        string = string + "  <tbody>";
        string = string + "    <tr>";
        string = string + "      <td width=28%><strong><font face=Arial>&nbsp;&nbsp; Realm List</font></strong></td>";
        string = string + "      <td width=72%>";
        string = string + "        <div align=right>";
        string = string + "          <p><font face=Arial><small>Selected Realm: [" + string2 + "]</small></font></p>";
        string = string + "        </div>";
        string = string + "      </td>";
        string = string + "    </tr>";
        string = string + "  </tbody>";
        string = string + "</table>";
        string = string + "<hr>";
        string = string + "<p><font face=Arial size=2>&nbsp;<a href=" + IDS_REQUEST_NEW_REALM + "><img border=0 src=" + this.getImage("create") + " width=18 height=13>Create a new realm</a></font></p>";
        string = string + " <input type=\"hidden\" name=\"realm\" value=\"" + string2 + "\">";
        string = string + "<table width=100% border=1 bordercolor=#C0C0C0 cellspacing=0 cellpadding=0 bordercolorlight=#C0C0C0 bordercolordark=#C0C0C0>";
        string = string + "  <tbody>";
        string = string + "    <tr>";
        string = string + "      <td align=left bgcolor=#5095ba nowrap>";
        string = string + "        <p align=left><font face=Arial color=#FFFFFF><b style=\"font-size=12px\">&nbsp;Name</b></font></td>";
        string = string + "      <td align=left width = \"40%\" bgcolor=#5095ba nowrap>";
        string = string + "        <p align=left><font face=Arial color=#FFFFFF><b style=\"font-size=12px\">&nbsp;State</b></font></td>";
        string = string + "      <td align=center width=\"50\" bgcolor=#5095ba nowrap>&nbsp;</td>";
        string = string + "      <td align=center width=\"50\" bgcolor=#5095ba nowrap>&nbsp;</td>";
        string = string + "    </tr>";
        Enumeration enumeration = Realm.getRealmNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = "";
            string4 = string3.equalsIgnoreCase(ServerEnv.getActiveRealm()) ? "Active Realm" : (string3.equalsIgnoreCase(string2) ? "Selected Realm" : "");
            string = string + "    <tr>";
            string = string + "      <td vAlign=top align=left nowrap><font face=Arial size=2>&nbsp;" + string3 + "</a></font></td>";
            string = string + "      <td vAlign=top align=left nowrap><font face=Arial size=2>&nbsp;" + string4 + "</font></td>";
            string = string + "      <td vAlign=top align=center nowrap><font face=Arial size=2><a href=" + IDS_SELECT_REALM + "?name=" + string3 + ">Select</a></font></td>";
            string = string + "      <td vAlign=top align=center nowrap><a href=" + IDS_REQUEST_REMOVE_REALM + "?name=" + string3 + "><font face=Arial size=2>Delete</font></a></td>";
            string = string + "    </tr>";
        }
        string = string + "  </tbody>";
        string = string + "</table>";
        string = string + "<p><small><font face=Arial><strong>Note:</strong>&nbsp; <em>Select a realm to administer users, groups etc. in it.</em></font></small></p>";
        this.writeResponse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_REMOVE_REALM() throws IOException {
        String string;
        block15: {
            string = null;
            String string2 = this.getPropertyIgnoreCase("realm");
            if (string2.equals("")) {
                this.printMessage("Realm name cannot be NULL!", IDS_LIST_REALM);
                return;
            }
            try {
                if (!UserDataToolkit.isValidName(string2)) {
                    string = "Invalid realm name:" + string2 + "\n" + "Valid name can contains only \"_0-9a-zA-Z\"";
                    break block15;
                }
                Class clazz = class$jet$server$userman$Realm == null ? (class$jet$server$userman$Realm = RealmProcessor.class$("jet.server.userman.Realm")) : class$jet$server$userman$Realm;
                synchronized (clazz) {
                    try {
                        Realm.get(string2);
                    }
                    catch (NoSuchRealmException noSuchRealmException) {
                        SharedPasswordRealm sharedPasswordRealm = new SharedPasswordRealm(string2);
                        Realm.add(sharedPasswordRealm);
                        UserDataToolkit.initRealm(sharedPasswordRealm);
                        sharedPasswordRealm.save();
                        UserDataToolkit.addManager(string2);
                        this.logManageSuccessEvent("create realm " + string2);
                        this.IDS_NEW_REALM();
                        return;
                    }
                    string = JSvrResource.getMessage("SVR_53", string2);
                }
            }
            catch (InUseException inUseException) {
                string = "InUseException:" + inUseException;
            }
            catch (NoSuchUserException noSuchUserException) {
                string = "NoSuchUserException:" + noSuchUserException;
                ServiceLogger.logError(noSuchUserException);
            }
            catch (BadRealmException badRealmException) {
                string = "Realm " + string2 + " is invalid!";
                ServiceLogger.logError(badRealmException);
            }
            catch (NotOwnerException notOwnerException) {
                string = "NotOwnerException:" + (Object)((Object)notOwnerException);
                ServiceLogger.logError(notOwnerException);
            }
            catch (IOException iOException) {
                string = "Save realm " + string2 + " properties failed!";
                ServiceLogger.logError(iOException);
            }
            catch (Exception exception) {
                string = exception.toString();
                ServiceLogger.logError(exception);
            }
        }
        if (string != null) {
            this.printMessage(string, IDS_LIST_REALM);
        }
    }

    private void IDS_REQUEST_EDIT_REALM() throws IOException {
        try {
            String string = this.getPropertyIgnoreCase("realm");
            String string2 = this.getPropertyIgnoreCase("scheme");
            SharedPasswordRealm sharedPasswordRealm = (SharedPasswordRealm)Realm.get(string);
            if (string2.equalsIgnoreCase("digest")) {
                sharedPasswordRealm.setScheme(1);
            } else {
                sharedPasswordRealm.setScheme(0);
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError(badRealmException);
        }
    }

    private void IDS_REQUEST_HOME() throws IOException {
        String string = this.request.getParameter("name");
        String string2 = "";
        string2 = string2 + "<html>";
        string2 = string2 + "<head>";
        string2 = string2 + "<title>Edit Realm</title>";
        string2 = string2 + "</head>";
        string2 = string2 + "<body>";
        string2 = string2 + "<p align=left><font face=Arial><strong>Edit Realm:" + string + "</strong></font></p>";
        string2 = string2 + "<hr>";
        string2 = string2 + " <input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
        string2 = string2 + "<table height=37 cellSpacing=0 cellPadding=0 width=100% border=0>";
        string2 = string2 + "<tbody>";
        string2 = string2 + "    <tr>";
        string2 = string2 + "      <td vAlign=top align=right width=16% height=1>";
        string2 = string2 + "        <p align=right><u><small><font face=Arial>Realm Name:</font></small></u></p>";
        string2 = string2 + "      </td>";
        string2 = string2 + "      <td vAlign=top width=84% height=30>&nbsp; <input name=realm size=20 value=" + string + "></td>";
        string2 = string2 + "    </tr>";
        string2 = string2 + "    <tr>";
        string2 = string2 + "      <td vAlign=top align=right width=16% height=13><u><small><font face=Arial>Scheme:</font></small></u></td>";
        string2 = string2 + "      <td vAlign=top align=left width=84% height=1><font face=Arial><small><input type=radio CHECKED value=basic name=scheme>Basic Authentication<br>";
        string2 = string2 + "        <input type=radio value=digest name=scheme>Digest Authentication</small></font></td>";
        string2 = string2 + "    </tr>";
        string2 = string2 + "    <tr>";
        string2 = string2 + "      <td vAlign=top align=right width=16% height=48></td>";
        string2 = string2 + "      <td vAlign=bottom align=left width=84% height=36>&nbsp; <input type=submit value=OK name=buttonNewRealm>";
        string2 = string2 + "        <input type=submit value=Cancel name=buttonListRealm></td>";
        string2 = string2 + "    </tr>";
        string2 = string2 + "  </tbody>";
        string2 = string2 + "</table>";
        string2 = string2 + "</body>";
        string2 = string2 + "</html>";
        this.writeResponse(string2);
    }

    private void IDS_REQUEST_NEW_REALM() throws IOException {
        String string;
        RcToolkit.curRealmName = string = this.request.getParameter("name");
        this.IDS_NEW_REALM();
    }

    private void IDS_REQUEST_REMOVE_REALM() throws IOException {
        String string = "";
        string = string + "<html>";
        string = string + "<head>";
        string = string + "<title>New Realm</title>";
        string = string + "</head>";
        string = string + "<body>";
        string = string + "<p align=left><font face=Arial><strong>New Realm</strong></font></p>";
        string = string + "<hr>";
        string = string + "<table height=37 cellSpacing=0 cellPadding=0 width=100% border=0>";
        string = string + "<tbody>";
        string = string + "    <tr>";
        string = string + "      <td vAlign=top align=right width=16% height=1>";
        string = string + "        <p align=right><u><small><font face=Arial>Realm Name:</font></small></u></p>";
        string = string + "      </td>";
        string = string + "      <td vAlign=top width=84% height=30>&nbsp; <input name=realm size=20 maxlength=32></td>";
        string = string + "    </tr>";
        string = string + "    <tr>";
        string = string + "      <td vAlign=top align=right width=16% height=13><u><small><font face=Arial>Scheme:</font></small></u></td>";
        string = string + "      <td vAlign=top align=left width=84% height=1><font face=Arial><small><input type=radio CHECKED value=basic name=scheme>Basic Authentication<br>";
        string = string + "        <input type=radio value=digest name=scheme>Digest Authentication</small></font></td>";
        string = string + "    </tr>";
        string = string + "    <tr>";
        string = string + "      <td vAlign=top align=right width=16% height=48></td>";
        string = string + "      <td vAlign=bottom align=left width=84% height=36>&nbsp; <input type=submit value=OK name=buttonNewRealm>";
        string = string + "        <input type=submit value=Cancel name=buttonListRealm></td>";
        string = string + "    </tr>";
        string = string + "  </tbody>";
        string = string + "</table>";
        string = string + "</body>";
        string = string + "</html>";
        this.writeResponse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_REQUEST_RESTART() throws IOException {
        String string = null;
        String string2 = this.getPropertyIgnoreCase("realm");
        if (string2.equals(ServerEnv.getActiveRealm())) {
            string = JSvrResource.getMessage("SVR_51", string2);
            this.logManageFailEvent("delete realm " + string2, 5);
        } else {
            Class clazz = class$jet$server$userman$Realm == null ? (class$jet$server$userman$Realm = RealmProcessor.class$("jet.server.userman.Realm")) : class$jet$server$userman$Realm;
            synchronized (clazz) {
                Realm.remove(string2);
                UserDataToolkit.htManager.remove(string2);
            }
            UserDataToolkit.deleteRealmData(string2);
            RcToolkit.curRealmName = ServerEnv.getActiveRealm();
            this.logManageSuccessEvent("delete realm " + string2);
            this.IDS_NEW_REALM();
        }
        if (string != null) {
            this.printMessage(string, IDS_LIST_REALM);
        }
    }

    private void IDS_REQUEST_SHUTDOWN() throws IOException {
        String string = this.request.getParameter("name");
        if (string.equals(ServerEnv.getActiveRealm())) {
            String string2 = "Realm " + string + " is active and active realm cannot be deleted!";
            this.printMessage(string2, IDS_LIST_REALM);
        } else {
            String string3 = " Do you confirm to delete realm \"" + string + "\"?";
            String[] stringArray = new String[]{"realm", string};
            String[] stringArray2 = new String[]{" Yes ", IDS_REMOVE_REALM, " No ", IDS_LIST_REALM};
            this.printMessage(stringArray, string3, stringArray2);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

