/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rc;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JSvrResource;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.log.ServiceLogger;
import jet.server.rc.ActionProcessor;
import jet.server.rc.RealmProcessor;
import jet.server.userman.AuditInfo;
import jet.server.userman.Realm;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.UserAuthenticator;
import jet.server.userman.UserDataToolkit;
import jet.server.userman.UserImpl;
import jet.util.MiscTools;

public class UserProcessor
extends ActionProcessor {
    public static String IDS_LIST_USER = "ListUser";
    public static String IDS_LIST_AUDIT = "ListAudit";
    public static String IDS_CHANGE_AUDIT = "ChangeAudit";
    public static String IDS_NEW_USER = "NewUser";
    public static String IDS_REQUEST_NEW_USER = "RequestNewUser";
    public static String IDS_REQUEST_EDIT_USER = "RequestEditUser";
    public static String IDS_EDIT_USER = "EditUser";
    public static String IDS_REMOVE_USER = "RemoveUser";
    public static String IDS_REQUEST_REMOVE_USER = "RequestRemoveUser";
    public static String IDS_REQUEST_CHANGE_PASSWORD = "RequestChangePassword";
    public static String IDS_CHANGE_PASSWORD = "ChangePassword";

    public UserProcessor() {
        this.actions.addElement(IDS_LIST_USER);
        this.actions.addElement(IDS_LIST_AUDIT);
        this.actions.addElement(IDS_CHANGE_AUDIT);
        this.actions.addElement(IDS_NEW_USER);
        this.actions.addElement(IDS_EDIT_USER);
        this.actions.addElement(IDS_REQUEST_NEW_USER);
        this.actions.addElement(IDS_REQUEST_EDIT_USER);
        this.actions.addElement(IDS_REMOVE_USER);
        this.actions.addElement(IDS_REQUEST_REMOVE_USER);
        this.actions.addElement(IDS_REQUEST_CHANGE_PASSWORD);
        this.actions.addElement(IDS_CHANGE_PASSWORD);
    }

    public void processEvent(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        super.processEvent(string, properties, httpServletRequest, httpServletResponse);
        if (string.equalsIgnoreCase(IDS_LIST_USER)) {
            this.IDS_CHANGE_AUDIT();
        } else if (string.equalsIgnoreCase(IDS_LIST_AUDIT)) {
            this.IDS_REQUEST_NEW_USER();
        } else if (string.equalsIgnoreCase(IDS_CHANGE_AUDIT)) {
            this.IDS_REQUEST_REMOVE_USER();
        } else if (string.equalsIgnoreCase(IDS_NEW_USER)) {
            this.IDS_CHANGE_PASSWORD(true);
        } else if (string.equalsIgnoreCase(IDS_REQUEST_NEW_USER)) {
            this.IDS_LIST_AUDIT();
        } else if (string.equalsIgnoreCase(IDS_REMOVE_USER)) {
            this.IDS_LIST_REALM();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_REMOVE_USER)) {
            this.IDS_LIST_USER();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_EDIT_USER)) {
            this.IDS_NEW_USER();
        } else if (string.equalsIgnoreCase(IDS_EDIT_USER)) {
            this.IDS_CHANGE_PASSWORD(false);
        } else if (string.equalsIgnoreCase(IDS_REQUEST_CHANGE_PASSWORD)) {
            this.IDS_REMOVE_USER();
        } else if (string.equalsIgnoreCase(IDS_CHANGE_PASSWORD)) {
            this.IDS_REQUEST_CHANGE_PASSWORD();
        }
    }

    private void IDS_CHANGE_AUDIT() throws IOException {
        String string = "";
        try {
            String string2 = this.getCurEditRealm();
            SharedPasswordRealm sharedPasswordRealm = (SharedPasswordRealm)Realm.get(string2);
            string = string + "<head>";
            string = string + "</head>";
            string = string + "<body>";
            string = string + "<table width=100% border=0>";
            string = string + "  <tbody>";
            string = string + "    <tr>";
            string = string + "      <td width=28%><strong><font face=Arial>User List</font></strong></td>";
            string = string + "      <td width=72%>";
            string = string + "        <p align=right><small><font face=Arial>Selected Realm: [</font></small><font face=Arial><small>" + string2 + "</small></font><small><font face=Arial>]</font></small></p>";
            string = string + "      </td>";
            string = string + "    </tr>";
            string = string + "  </tbody>";
            string = string + "</table>";
            string = string + "<hr>";
            string = string + "<p align=left>&nbsp;<a href=" + IDS_REQUEST_NEW_USER + "?realm=" + string2 + "><font face=Arial size=2><img border=0 src=" + this.getImage("create") + " width=18 height=13>Create a new user</font></a></p>";
            string = string + " <input type=\"hidden\" name=\"realm\" value=\"" + string2 + "\">";
            string = string + "<table border=1 bordercolor=#C0C0C0 cellspacing=0 cellpadding=0 bordercolorlight=#C0C0C0 bordercolordark=#C0C0C0 width=100% >";
            string = string + "  <tr>";
            string = string + "    <td height=16 bgcolor=#5095ba ><b style=\"font-size:12px\"><font face=Arial color=#FFFFFF>&nbsp;User ID</font></b></td>";
            string = string + "    <td height=16 bgcolor=#5095ba ><b style=\"font-size:12px\"><font face=Arial color=#FFFFFF>&nbsp;Full Name</font></b></td>";
            string = string + "    <td height=16 bgcolor=#5095ba width=60 align=center >&nbsp;</td>";
            string = string + "    <td height=16 bgcolor=#5095ba width=120 align=center >&nbsp;</td>";
            string = string + "    <td height=16 bgcolor=#5095ba align=center width=\"50\" >&nbsp;</td>";
            string = string + "  </tr>";
            Enumeration enumeration = sharedPasswordRealm.getUsers();
            while (enumeration.hasMoreElements()) {
                UserImpl userImpl = (UserImpl)enumeration.nextElement();
                String string3 = userImpl.getFullname();
                String string4 = userImpl.getName();
                string = string + "  <tr>";
                string = string + "    <td height=16><font face=Arial size=2>&nbsp;<a href=" + IDS_REQUEST_EDIT_USER + "?user=" + string4 + "&realm=" + string2 + ">" + string4 + "</a></font></td>";
                string = string + "    <td height=16><font face=Arial size=2>&nbsp;" + string3 + "</font></td>";
                string = string + "    <td align=center height=16><font size=2 face=Arial><a href=" + IDS_LIST_AUDIT + "?user=" + string4 + "&realm=" + string2 + ">Auditing</a></font></td>";
                string = string + "    <td align=center height=16><font size=2 face=Arial><a href=" + IDS_REQUEST_CHANGE_PASSWORD + "?user=" + string4 + "&realm=" + string2 + ">Change Password</a></font></td>";
                if (!string4.equalsIgnoreCase("admin") && !string4.equalsIgnoreCase("guest")) {
                    string = string + "    <td align=center height=16><a href=" + IDS_REQUEST_REMOVE_USER + "?user=" + string4 + "&realm=" + string2 + "><font face=Arial size=2>Delete</font></a></td>";
                }
                string = string + "  </tr>";
            }
            string = string + "</table>";
            string = string + "</body>";
            string = string + "</html>";
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError(badRealmException);
        }
        this.writeResponse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_CHANGE_PASSWORD(boolean bl) throws IOException {
        String string;
        String string2;
        String string3 = null;
        String string4 = IDS_LIST_USER;
        String string5 = this.request.getParameter("user");
        String string6 = this.request.getParameter("realm");
        SharedPasswordRealm sharedPasswordRealm = null;
        UserImpl userImpl = null;
        try {
            sharedPasswordRealm = (SharedPasswordRealm)Realm.get(string6);
            if (!bl) {
                userImpl = (UserImpl)sharedPasswordRealm.getUser(string5);
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string3 = "Realm " + string6 + " does not exist!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string3 = "Realm " + string6 + " is invalid!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchUserException noSuchUserException) {
            string3 = "User " + string5 + " does not exist in realm " + string6 + "!";
            ServiceLogger.logError(noSuchUserException);
        }
        if (sharedPasswordRealm.isGroupExist(string5)) {
            string3 = "User name is the same as a group name";
        }
        if (string3 == null) {
            string3 = this.IDS_EDIT_USER(this.props, userImpl != null ? userImpl.passwordInfo.getName() : null);
            if (bl && !(string2 = this.getPropertyIgnoreCase("password")).equals(string = this.getPropertyIgnoreCase("confirmPassword"))) {
                string3 = JSvrResource.getMessage("SVR_28");
                string4 = IDS_REQUEST_NEW_USER;
            }
        }
        if (string3 == null && bl) {
            if (sharedPasswordRealm.isUserExist(string5)) {
                string3 = JSvrResource.getMessage("SVR_25", string5);
            }
            if (sharedPasswordRealm.isGroupExist(string5)) {
                string3 = JSvrResource.getMessage("SVR_57", string5);
            }
        }
        if (string3 == null) {
            string2 = this.getPropertyIgnoreCase("fullName");
            string = this.getPropertyIgnoreCase("description");
            String string7 = this.getPropertyIgnoreCase("email");
            String string8 = bl ? this.getPropertyIgnoreCase("password") : "";
            boolean bl2 = this.getPropertyIgnoreCase("accountDisabled") != null;
            String string9 = this.getPropertyIgnoreCase("passwordLife");
            int n = 30;
            String string10 = this.getPropertyIgnoreCase("expireTime");
            try {
                n = Integer.parseInt(string10);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logError(numberFormatException, 3);
            }
            int n2 = 6;
            String string11 = this.getPropertyIgnoreCase("passwordLength");
            String string12 = this.getPropertyIgnoreCase("minLength");
            try {
                n2 = Integer.parseInt(string12);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logError(numberFormatException, 3);
            }
            try {
                SharedPasswordRealm sharedPasswordRealm2 = sharedPasswordRealm;
                synchronized (sharedPasswordRealm2) {
                    if (bl) {
                        sharedPasswordRealm.createUser(string5, string8);
                        userImpl = (UserImpl)sharedPasswordRealm.getUser(string5);
                    }
                    if (!bl) {
                        string8 = userImpl.passwordInfo.getName();
                    }
                    userImpl.setFullname(string2);
                    userImpl.setDescription(string);
                    userImpl.setEmail(string7);
                    userImpl.passwordInfo.setNeverExpireFlag(string9.equals("neverExpire"));
                    userImpl.passwordInfo.setExpireTime(n);
                    userImpl.passwordInfo.setPermitBlankFlag(string11.equals("blank"));
                    userImpl.passwordInfo.setMinLength(n2);
                    userImpl.setDisabled(bl2);
                }
                UserDataToolkit.saveUserProperties(userImpl);
                this.logManageSuccessEvent("create user " + sharedPasswordRealm.getName() + ":" + string5);
                this.IDS_CHANGE_AUDIT();
                return;
            }
            catch (BadRealmException badRealmException) {
                string3 = "Realm " + string6 + " does not exist!";
                string4 = RealmProcessor.IDS_LIST_REALM;
                ServiceLogger.logError(badRealmException);
            }
            catch (NoSuchUserException noSuchUserException) {
                string3 = "User " + string5 + " does not exist in realm " + string6 + "!";
                ServiceLogger.logError(noSuchUserException);
            }
            catch (InUseException inUseException) {
                string3 = "User " + string5 + " already exist!";
            }
            catch (IOException iOException) {
                string3 = "Save user " + string5 + " properties failed!";
                ServiceLogger.logError(iOException);
            }
        }
        this.printMessage(new String[]{"realm", string6}, string3, string4);
    }

    private String IDS_EDIT_USER(Properties properties, String string) {
        String string2;
        String string3;
        block16: {
            String string4 = this.getPropertyIgnoreCase("user");
            if (string4.length() == 0) {
                return JSvrResource.getMessage("SVR_21");
            }
            if (!UserDataToolkit.isValidName(string4)) {
                return "Invalid user name:" + string4 + "\n" + "Valid name can contains only \"_0-9a-zA-Z\"";
            }
            String string5 = this.getPropertyIgnoreCase("fullName");
            if (MiscTools.containChar((String)string5, (String)":")) {
                return JSvrResource.getMessage("SVR_23", "\":\"");
            }
            String string6 = this.getPropertyIgnoreCase("description");
            if (MiscTools.containChar((String)string6, (String)":")) {
                return JSvrResource.getMessage("SVR_24", "\":\"");
            }
            String string7 = this.getPropertyIgnoreCase("email");
            if (MiscTools.containChar((String)string7, (String)":")) {
                return JSvrResource.getMessage("SVR_73", "\":\"");
            }
            String string8 = string3 = string == null ? this.getPropertyIgnoreCase("password") : string;
            if (MiscTools.containChar((String)string3, (String)" :")) {
                return JSvrResource.getMessage("SVR_26", "space and ':'");
            }
            String string9 = this.getPropertyIgnoreCase("passwordLife");
            if (string9.equals("expire")) {
                string2 = this.getPropertyIgnoreCase("expireTime");
                int n = 30;
                if (string2.length() != 0) {
                    try {
                        n = Integer.parseInt(string2);
                        if (n < 0) {
                            return JSvrResource.getMessage("SVR_29");
                        }
                        break block16;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "Expire time format is invalid: " + string2;
                    }
                }
                return "You didn't input time to expire.";
            }
        }
        if (!(string2 = this.getPropertyIgnoreCase("passwordLength")).equals("blank")) {
            String string10 = this.getPropertyIgnoreCase("minLength");
            int n = 0;
            try {
                n = Integer.parseInt(string10);
                if (n < 0) {
                    return JSvrResource.getMessage("SVR_31");
                }
            }
            catch (NumberFormatException numberFormatException) {
                return "Min password length format is invalid: " + string10;
            }
            if (string3.length() < n) {
                return JSvrResource.getMessage("SVR_32", "" + n);
            }
        }
        return null;
    }

    private void IDS_LIST_AUDIT() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = "";
        string2 = string2 + "<input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
        string2 = string2 + " <table border=\"0\" width=\"100%\">";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"28%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; New User</font></strong></td>";
        string2 = string2 + "   <td width=\"72%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "]</font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + " </table>";
        string2 = string2 + " <hr>";
        string2 = string2 + " <table border=\"0\" width=\"100%\" height=\"310\">";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">User Name:</font></small></u></td>";
        string2 = string2 + "   <td width=\"80%\" height=\"25\"><small><font face=\"Arial\">";
        string2 = string2 + "   <input type=\"text\" name=\"user\" size=\"20\" maxlength=\"32\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Full Name:</font></small></u></td>";
        string2 = string2 + "   <td width=\"80%\" height=\"25\"><small><font face=\"Arial\">";
        string2 = string2 + "   <input type=\"text\" name=\"fullName\" size=\"20\" maxlength=\"32\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Description</font></small></u></td>";
        string2 = string2 + "   <td width=\"80%\" height=\"25\"><small><font face=\"Arial\">";
        string2 = string2 + "   <input type=\"text\" name=\"description\" size=\"20\" maxlength=\"64\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Email</font></small></u></td>";
        string2 = string2 + "   <td width=\"80%\" height=\"25\"><small><font face=\"Arial\">";
        string2 = string2 + "   <input type=\"text\" name=\"email\" size=\"20\" maxlength=\"64\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Password:</font></small></u></td>";
        string2 = string2 + "   <td width=\"80%\" height=\"25\"><small><font face=\"Arial\">";
        string2 = string2 + "   <input type=\"password\" name=\"password\" size=\"20\" maxlength=\"32\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "    <td width=\"20%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Confirm Password:</font></small></u></td>";
        string2 = string2 + "    <td width=\"80%\" height=\"25\"><small><font face=\"Arial\">";
        string2 = string2 + "    <input type=\"password\" name=\"confirmPassword\" size=\"20\" maxlength=\"32\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"21\"></td>";
        string2 = string2 + "   <td width=\"80%\" height=\"21\"><small><font face=\"Arial\">";
        string2 = string2 + "   <input type=\"checkbox\" name=\"accountDisabled\" value=\"ON\">Account Disabled</font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "    <td width=\"20%\" valign=\"top\" align=\"right\" height=\"44\"><u><small><font face=\"Arial\">Password Life:</font></small></u></td>";
        string2 = string2 + "    <td width=\"80%\" height=\"44\"><small><font face=\"Arial\">";
        string2 = string2 + "    <input type=\"radio\" value=\"neverExpire\" checked name=\"passwordLife\">Password Never Expires<br>";
        string2 = string2 + "    <input type=\"radio\" value=\"expire\" name=\"passwordLife\">Expires in ";
        string2 = string2 + "    <input type=\"text\" name=\"expireTime\" size=\"4\" value=\"30\">days</font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "    <td width=\"20%\" valign=\"top\" align=\"right\" height=\"44\"><u><small><font face=\"Arial\">Password Length:</font></small></u></td>";
        string2 = string2 + "    <td width=\"80%\" height=\"44\"><small><font face=\"Arial\">";
        string2 = string2 + "    <input type=\"radio\" value=\"blank\" name=\"passwordLength\" checked>Permit Blank<br>";
        string2 = string2 + "    <input type=\"radio\" value=\"minValue\" name=\"passwordLength\">Minimum Length ";
        string2 = string2 + "    <input type=\"text\" name=\"minLength\" size=\"4\" value=\"6\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"40\"></td>";
        string2 = string2 + "   <td width=\"80%\" valign=\"bottom\" height=\"40\">&nbsp;";
        string2 = string2 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_NEW_USER + "\">";
        string2 = string2 + "    <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_USER + "\"></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + " </table>";
        this.writeResponse(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_LIST_REALM() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("user");
        String string3 = null;
        if (string2.equals("admin")) {
            string3 = "User admin cannot be deleted!";
        } else {
            try {
                Realm realm;
                Realm realm2 = realm = Realm.get(string);
                synchronized (realm2) {
                    UserImpl userImpl = (UserImpl)realm.getUser(string2);
                    realm.deleteUser(string2);
                    UserDataToolkit.deleteUserData(userImpl);
                }
                this.logManageSuccessEvent("delete user " + string + ":" + string2);
                this.IDS_CHANGE_AUDIT();
                return;
            }
            catch (NoSuchRealmException noSuchRealmException) {
                string3 = "Realm " + string + " does not exist!";
                ServiceLogger.logError(noSuchRealmException);
            }
            catch (BadRealmException badRealmException) {
                string3 = "Realm " + string + " is invalid!";
                ServiceLogger.logError(badRealmException);
            }
            catch (NoSuchUserException noSuchUserException) {
                string3 = "User " + string2 + " does not exist!";
                ServiceLogger.logError(noSuchUserException);
            }
            catch (InUseException inUseException) {
                String string4 = inUseException.toString();
                string3 = string4.substring(string4.indexOf(": ") + 2);
                ServiceLogger.logError(inUseException);
            }
        }
        if (string3 != null) {
            this.printMessage(new String[]{"realm", string}, string3, IDS_LIST_USER);
        }
    }

    private void IDS_LIST_USER() throws IOException {
        String string = this.request.getParameter("realm");
        String string2 = this.request.getParameter("user");
        String string3 = "Do you really want to delete user " + string2 + "?";
        String[] stringArray = new String[]{"realm", string, "user", string2};
        String[] stringArray2 = new String[]{" Yes ", IDS_REMOVE_USER, " No ", IDS_LIST_USER};
        this.printMessage(stringArray, string3, stringArray2);
    }

    private void IDS_NEW_USER() throws IOException {
        String string = null;
        String string2 = IDS_LIST_USER;
        String string3 = this.request.getParameter("realm");
        String string4 = this.request.getParameter("user");
        try {
            Realm realm = Realm.get(string3);
            UserImpl userImpl = (UserImpl)realm.getUser(string4);
            String string5 = "";
            string5 = string5 + " <input type=\"hidden\" name=\"realm\" value=\"" + string3 + "\">";
            string5 = string5 + " <input type=\"hidden\" name=\"user\" value=\"" + string4 + "\">";
            string5 = string5 + " <table border=\"0\" width=\"100%\">";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Edit User Properties </font></strong></td>";
            string5 = string5 + "   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string3 + "] &nbsp;";
            string5 = string5 + "   User Name: [" + string4 + "]</font></small></td>";
            string5 = string5 + "  <tr>";
            string5 = string5 + " </table>";
            string5 = string5 + " <hr>";
            string5 = string5 + " <table border=\"0\" width=\"100%\" height=\"201\">";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"1\"><u><small><font face=\"Arial\">Full Name:</font></small></u></td>";
            string5 = string5 + "   <td width=\"80%\" height=\"1\"><small><font face=\"Arial\">";
            string5 = string5 + "   <input type=\"text\" name=\"fullName\" size=\"20\" maxlength=\"32\" value=\"" + userImpl.getFullname() + "\"></font></small></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Description</font></small></u></td>";
            string5 = string5 + "   <td width=\"80%\" height=\"25\"><small><font face=\"Arial\">";
            string5 = string5 + "   <input type=\"text\" name=\"description\" size=\"52\" maxlength=\"64\" value=\"" + userImpl.getDescription() + "\"></font></small></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Email</font></small></u></td>";
            string5 = string5 + "   <td width=\"80%\" height=\"25\"><small><font face=\"Arial\">";
            string5 = string5 + "   <input type=\"text\" name=\"email\" size=\"52\" maxlength=\"64\" value=\"" + userImpl.getEmail() + "\"></font></small></td>";
            string5 = string5 + "  </tr>";
            if (!string4.equals("admin")) {
                string5 = string5 + "  <tr>";
                string5 = string5 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"21\"></td>";
                string5 = string5 + "   <td width=\"80%\" height=\"21\"><small><font face=\"Arial\">";
                string5 = string5 + "   <input type=\"checkbox\" name=\"accountDisabled\" value=\"ON\" " + (userImpl.isDisabled() ? "checked" : "") + ">Account Disabled</font></small></td>";
                string5 = string5 + "  </tr>";
            }
            boolean bl = userImpl.passwordInfo.getNeverExpireFlag();
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"44\"><u><small><font face=\"Arial\">Password Life:</font></small></u></td>";
            string5 = string5 + "   <td width=\"80%\" height=\"44\"><small><font face=\"Arial\">";
            string5 = string5 + "   <input type=\"radio\" value=\"neverExpire\" " + (bl ? "checked " : "") + "name=\"passwordLife\">Password Never Expires<br>";
            string5 = string5 + "   <input type=\"radio\" value=\"expire\" " + (!bl ? "checked " : "") + "name=\"passwordLife\">Expires in ";
            string5 = string5 + "   <input type=\"text\" name=\"expireTime\" size=\"4\" value=\"" + userImpl.passwordInfo.getExpireTime() + "\">days</font></small></td>";
            string5 = string5 + "  </tr>";
            bl = userImpl.passwordInfo.getPermitBlankFlag();
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"44\"><u><small><font face=\"Arial\">Password Length:</font></small></u></td>";
            string5 = string5 + "   <td width=\"80%\" height=\"44\"><small><font face=\"Arial\">";
            string5 = string5 + "   <input type=\"radio\" name=\"passwordLength\" value=\"blank\" " + (bl ? "checked" : "") + ">Permit Blank<br>";
            string5 = string5 + "   <input type=\"radio\" name=\"passwordLength\" value=\"length\" " + (!bl ? "checked" : "") + ">Minimum Length";
            string5 = string5 + "   <input type=\"text\" name=\"minLength\" size=\"4\" value=\"" + userImpl.passwordInfo.getMinLength() + "\"></font></small></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"20%\" valign=\"top\" align=\"right\" height=\"40\"></td>";
            string5 = string5 + "   <td width=\"80%\" valign=\"bottom\" height=\"40\">&nbsp;";
            string5 = string5 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_EDIT_USER + "\">";
            string5 = string5 + "    <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_USER + "\"></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + " </table>";
            this.writeResponse(string5);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = "Realm " + string3 + " does not exist!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string = "Realm " + string3 + " is invalid!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchUserException noSuchUserException) {
            string = "User " + string4 + " does not exist!";
            ServiceLogger.logError(noSuchUserException);
        }
        if (string != null) {
            this.printMessage(new String[]{"realm", string3}, string, string2);
        }
    }

    private void IDS_REMOVE_USER() throws IOException {
        String string = this.request.getParameter("realm");
        String string2 = this.request.getParameter("user");
        String string3 = "";
        string3 = string3 + "<input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
        string3 = string3 + "<input type=\"hidden\" name=\"user\" value=\"" + string2 + "\">";
        string3 = string3 + " <table border=\"0\" width=\"100%\">";
        string3 = string3 + "  <tr>";
        string3 = string3 + "   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Change Password</font></strong></td>";
        string3 = string3 + "   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "] &nbsp;";
        string3 = string3 + "   User Name: [" + string2 + "]</font></small></td>";
        string3 = string3 + "  </tr>";
        string3 = string3 + " </table>";
        string3 = string3 + " <hr>";
        string3 = string3 + " <table border=\"0\" width=\"100%\" height=\"129\">";
        string3 = string3 + "  <tr>";
        string3 = string3 + "   <td width=\"26%\" valign=\"top\" align=\"right\" height=\"14\"><u><small><font face=\"Arial\">Executor Password:</font></small></u></td>";
        string3 = string3 + "   <td width=\"74%\" height=\"14\" valign=\"top\">";
        string3 = string3 + "   <input type=\"password\" name=\"oldPassword\" size=\"20\" maxlength=\"32\"></td>";
        string3 = string3 + "  </tr>";
        string3 = string3 + "  <tr>";
        string3 = string3 + "   <td width=\"26%\" valign=\"top\" align=\"right\" height=\"23\"><u><font face=\"Arial\"><small>New Password:</small></font></u></td>";
        string3 = string3 + "   <td width=\"74%\" height=\"23\" valign=\"top\">";
        string3 = string3 + "   <input type=\"password\" name=\"newPassword\" size=\"20\" maxlength=\"32\"></td>";
        string3 = string3 + "  </tr>";
        string3 = string3 + "  <tr>";
        string3 = string3 + "   <td width=\"26%\" valign=\"top\" align=\"right\" height=\"65\" rowspan=\"2\"><small><u><font face=\"Arial\">Confirm New Password:</font></u></small></td>";
        string3 = string3 + "   <td width=\"74%\" valign=\"top\" height=\"22\">";
        string3 = string3 + "   <input type=\"password\" name=\"confirmPassword\" size=\"20\" maxlength=\"32\"></td>";
        string3 = string3 + "  </tr>";
        string3 = string3 + "  <tr>";
        string3 = string3 + "   <td width=\"74%\" valign=\"bottom\" height=\"43\">";
        string3 = string3 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_CHANGE_PASSWORD + "\">";
        string3 = string3 + "    <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_USER + "\"></td>";
        string3 = string3 + "  </tr>";
        string3 = string3 + " </table>";
        this.writeResponse(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_REQUEST_CHANGE_PASSWORD() throws IOException {
        String string = null;
        String string2 = IDS_REQUEST_CHANGE_PASSWORD;
        String string3 = this.getPropertyIgnoreCase("realm");
        String string4 = this.getPropertyIgnoreCase("user");
        String string5 = this.getPropertyIgnoreCase("oldPassword");
        String string6 = this.getPropertyIgnoreCase("newPassword");
        try {
            UserImpl userImpl;
            Realm realm = Realm.get(string3);
            UserImpl userImpl2 = userImpl = (UserImpl)realm.getUser(string4);
            synchronized (userImpl2) {
                string = this.remoteUser != null ? this.IDS_REQUEST_EDIT_USER(string3, this.remoteUser, userImpl, this.props) : this.IDS_REQUEST_EDIT_USER(string3, this.currentUser, userImpl, this.props);
                if (string == null) {
                    UserAuthenticator userAuthenticator = UserDataToolkit.authenticator;
                    string = this.remoteUser != null ? userAuthenticator.changePassword(string3, this.remoteUser, string4, string5, string6) : userAuthenticator.changePassword(string3, this.currentUser, string4, string5, string6);
                }
            }
            if (string == null) {
                this.logManageSuccessEvent("user " + string3 + ":" + string4 + " change password.");
                this.IDS_CHANGE_AUDIT();
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = "Realm " + string3 + " does not exist!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string = "Realm " + string3 + " is invalid!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchUserException noSuchUserException) {
            string = "User " + string4 + " does not exist!";
            ServiceLogger.logError(noSuchUserException);
        }
        catch (IOException iOException) {
            string = "Save user " + string4 + " properties failed!";
            ServiceLogger.logError(iOException);
        }
        if (string != null) {
            this.printMessage(new String[]{"realm", string3, "user", string4}, string, string2);
        }
    }

    private String IDS_REQUEST_EDIT_USER(String string, String string2, UserImpl userImpl, Properties properties) {
        String string3;
        UserAuthenticator userAuthenticator = UserDataToolkit.authenticator;
        String string4 = this.getPropertyIgnoreCase("oldPassword");
        if (!userAuthenticator.isValidAdminUser(string, string2, string4)) {
            try {
                if (!string4.equals((String)userImpl.getAuthInfo())) {
                    return JSvrResource.getMessage("SVR_69");
                }
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError(noSuchUserException);
            }
        }
        if (MiscTools.containChar((String)(string3 = this.getPropertyIgnoreCase("newPassword")), (String)" :")) {
            return JSvrResource.getMessage("SVR_26", "space and ':'");
        }
        String string5 = this.getPropertyIgnoreCase("confirmPassword");
        if (!string3.equals(string5)) {
            return JSvrResource.getMessage("SVR_28");
        }
        boolean bl = userImpl.passwordInfo.getPermitBlankFlag();
        if (string3.length() == 0) {
            if (bl) {
                return null;
            }
            return JSvrResource.getMessage("SVR_27");
        }
        if (bl) {
            return null;
        }
        int n = userImpl.passwordInfo.getMinLength();
        if (string3.length() < n) {
            return JSvrResource.getMessage("SVR_32", "" + n);
        }
        return null;
    }

    private void IDS_REQUEST_NEW_USER() throws IOException {
        String string = this.request.getParameter("realm");
        String string2 = this.request.getParameter("user");
        String string3 = null;
        String string4 = IDS_LIST_USER;
        try {
            Realm realm = Realm.get(string);
            UserImpl userImpl = (UserImpl)realm.getUser(string2);
            AuditInfo auditInfo = userImpl.auditInfo;
            if (auditInfo == null) {
                auditInfo = new AuditInfo();
            }
            String string5 = "";
            string5 = string5 + "<input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
            string5 = string5 + "<input type=\"hidden\" name=\"user\" value=\"" + string2 + "\">";
            string5 = string5 + " <table border=\"0\" width=\"100%\">";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Auditing</font></strong></td>";
            string5 = string5 + "   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "] &nbsp;";
            string5 = string5 + "   User Name: [" + string2 + "]</font></small></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + " </table>";
            string5 = string5 + " <hr>";
            string5 = string5 + " <div align=\"center\"><center><table border=\"1\" width=\"87%\">";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"100%\"><small><font face=\"Arial\"><strong>Note</strong>: <em>If you select";
            string5 = string5 + "   Disable Auditing on all events, none events will be audited on matter success or failure";
            string5 = string5 + "   events.</em></font></small></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + " </table>";
            string5 = string5 + " </center></div><p>&nbsp;</p>";
            string5 = string5 + " <table border=\"0\" width=\"100%\" height=\"188\">";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"26%\" valign=\"top\" align=\"right\" height=\"25\"></td>";
            string5 = string5 + "   <td width=\"74%\" height=\"25\" valign=\"top\"><small><font face=\"Arial\">";
            string5 = string5 + "    <input type=\"checkbox\" name=\"audit\" " + (auditInfo.isNoAudit() ? "checked" : "") + " value=\"ON\">Disable Auditing on all events</font></small></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"26%\" valign=\"top\" align=\"right\" height=\"49\"><u><font face=\"Arial\"><small>Auditing the events of</small> <br>";
            string5 = string5 + "   <small>the accessed resources:</small></font></u></td>";
            string5 = string5 + "   <td width=\"74%\" height=\"49\" valign=\"top\"><font face=\"Arial\"><small>";
            string5 = string5 + "    <input type=\"checkbox\" name=\"success0\" value=\"ON\" " + (auditInfo.isAuditFileAccessSuccess() ? "checked" : "") + ">Success<br>";
            string5 = string5 + "    <input type=\"checkbox\" name=\"fail0\" value=\"ON\" " + (auditInfo.isAuditFileAccessFail() ? "checked" : "") + ">Failure</small></font></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"26%\" valign=\"top\" align=\"right\" height=\"87\" rowspan=\"2\"><u><font face=\"Arial\"><small>Auditing the events of </small><br>";
            string5 = string5 + "   <small>management:</small></font></u></td>";
            string5 = string5 + "   <td width=\"74%\" valign=\"top\" height=\"44\"><font face=\"Arial\"><small>";
            string5 = string5 + "    <input type=\"checkbox\" name=\"success1\" value=\"ON\" " + (auditInfo.isAuditManageSuccess() ? "checked" : "") + ">Success<br>";
            string5 = string5 + "    <input type=\"checkbox\" name=\"fail1\" value=\"ON\" " + (auditInfo.isAuditManageFail() ? "checked" : "") + ">Failure</small></font></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + "  <tr>";
            string5 = string5 + "   <td width=\"74%\" valign=\"bottom\" height=\"43\">";
            string5 = string5 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_CHANGE_AUDIT + "\">";
            string5 = string5 + "    <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_USER + "\"></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + " </table>";
            this.writeResponse(string5);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string3 = "Realm " + string + " does not exist!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string3 = "Realm " + string + " is invalid!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchUserException noSuchUserException) {
            string3 = "User " + string2 + " does not exist!";
            ServiceLogger.logError(noSuchUserException);
        }
        if (string3 != null) {
            this.printMessage(new String[]{"realm", string}, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_REQUEST_REMOVE_USER() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("user");
        String string3 = null;
        String string4 = IDS_LIST_USER;
        try {
            UserImpl userImpl;
            Realm realm = Realm.get(string);
            UserImpl userImpl2 = userImpl = (UserImpl)realm.getUser(string2);
            synchronized (userImpl2) {
                if (userImpl.auditInfo == null) {
                    return;
                }
                userImpl.auditInfo.setNoAudit(this.getPropertyIgnoreCase("audit") != null);
                userImpl.auditInfo.setAuditFileAccessSuccess(this.getPropertyIgnoreCase("success0") != null);
                userImpl.auditInfo.setAuditFileAccessFail(this.getPropertyIgnoreCase("fail0") != null);
                userImpl.auditInfo.setAuditManageSuccess(this.getPropertyIgnoreCase("success1") != null);
                userImpl.auditInfo.setAuditManageFail(this.getPropertyIgnoreCase("fail1") != null);
            }
            UserDataToolkit.saveUserProperties(userImpl);
            this.IDS_CHANGE_AUDIT();
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string3 = "Realm " + string + " does not exist!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string3 = "Realm " + string + " is invalid!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchUserException noSuchUserException) {
            string3 = "User " + string2 + " does not exist!";
            ServiceLogger.logError(noSuchUserException);
        }
        catch (IOException iOException) {
            string3 = "Save user " + string2 + " properties failed!";
            ServiceLogger.logError(iOException);
        }
        if (string3 != null) {
            this.printMessage(new String[]{"realm", string}, string3, string4);
        }
    }
}

