/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resource;

import guitools.GuiUtil;
import guitools.UIResource;
import guitools.tree.TreeNode;
import java.awt.Color;
import java.awt.Image;
import java.util.Hashtable;
import java.util.Vector;
import jet.JSvrResource;

public class AliasNode
implements TreeNode {
    protected AliasNode parent = null;
    protected Vector subNodes = null;
    protected Hashtable subNodeHash = null;
    protected String rscName = null;
    protected String name = null;
    protected int status = 0;
    protected AliasNode dfltAlias = null;

    public AliasNode(String string, String string2) {
        this.name = string;
        this.rscName = string2;
    }

    public void setResourceName(String string) {
        this.rscName = string;
    }

    public String getResourceName() {
        return this.rscName;
    }

    public boolean isHidden() {
        return (this.status & 1) != 0;
    }

    public void hide(boolean bl) {
        this.status = bl ? (this.status |= 1) : (this.status &= 0xFFFFFFFE);
    }

    public boolean contentEquals(AliasNode aliasNode) {
        String string = aliasNode.getResourceName();
        boolean bl = aliasNode.isHidden();
        return GuiUtil.areEqual((String)string, (String)this.rscName) && bl == this.isHidden();
    }

    public void setDefaultAlias(AliasNode aliasNode) {
        this.dfltAlias = aliasNode;
    }

    public boolean isDefaultNode() {
        return this.dfltAlias != null;
    }

    public AliasNode getDefaultAliasNode() {
        return this.dfltAlias;
    }

    public AliasNode insert(AliasNode aliasNode, int n) {
        if (this.subNodes != null && this.subNodes.contains(aliasNode)) {
            return aliasNode;
        }
        if (this.subNodes == null) {
            this.subNodes = new Vector(1);
            this.subNodeHash = new Hashtable(1);
        }
        if (n >= 0 && n < this.subNodes.size()) {
            this.subNodes.insertElementAt(aliasNode, n);
        } else {
            this.subNodes.addElement(aliasNode);
        }
        aliasNode.parent = this;
        this.subNodeHash.put(aliasNode.getText(), aliasNode);
        return aliasNode;
    }

    public boolean remove(AliasNode aliasNode) {
        if (this.subNodes == null) {
            return false;
        }
        if (!this.subNodes.contains(aliasNode)) {
            return false;
        }
        this.subNodes.removeElement(aliasNode);
        aliasNode.parent = null;
        this.subNodeHash.remove(aliasNode.getText());
        return true;
    }

    public AliasNode getSubNode(String string) {
        if (this.subNodes == null) {
            return null;
        }
        return (AliasNode)this.subNodeHash.get(string);
    }

    public boolean hasNode(String string) {
        return this.getSubNode(string) != null;
    }

    public boolean hasSubNodes() {
        return this.subNodes != null && this.subNodes.size() > 0;
    }

    public String getFullName() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        AliasNode aliasNode = this.parent;
        while (aliasNode != null) {
            if (aliasNode.getParent() != null) {
                stringBuffer.insert(0, '/');
            }
            stringBuffer.insert(0, aliasNode.getText());
            aliasNode = aliasNode.parent;
        }
        return stringBuffer.toString();
    }

    public void refreshSubNodes() {
    }

    public Vector getSubNodes() {
        return this.subNodes;
    }

    public void rehash(String string) {
        AliasNode aliasNode = (AliasNode)this.subNodeHash.get(string);
        if (aliasNode != null) {
            this.subNodeHash.remove(string);
            this.subNodeHash.put(aliasNode.getText(), aliasNode);
        }
    }

    public int numberOfSubNodes() {
        return this.subNodes == null ? 0 : this.subNodes.size();
    }

    public int indexOfSubNode(TreeNode treeNode) {
        return this.subNodes == null ? -1 : this.subNodes.indexOf(treeNode);
    }

    public TreeNode getSubNode(int n) {
        return this.subNodes == null ? null : (TreeNode)this.subNodes.elementAt(n);
    }

    public String getText() {
        return this.name;
    }

    public Color getFontColor() {
        if (this.isHidden()) {
            return UIResource.getColor((Object)"Inactive Text");
        }
        return UIResource.getColor((Object)"Text Color");
    }

    public Image getImage() {
        if (this.isDefaultNode()) {
            if (this.isHidden()) {
                return JSvrResource.getImage("DfltRptRsc_Disabled");
            }
            return JSvrResource.getImage("DfltRptRsc");
        }
        if (this.isHidden()) {
            return JSvrResource.getImage("RptRsc_Disabled");
        }
        return JSvrResource.getImage("RptRsc");
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isEditable() {
        return !this.isDefaultNode();
    }

    public boolean needSort() {
        return true;
    }

    public int compare(TreeNode treeNode, TreeNode treeNode2) {
        return treeNode.getText().toUpperCase().compareTo(treeNode2.getText().toUpperCase());
    }

    public boolean isTextValid(String string) {
        if (!this.isDefaultNode()) {
            return !this.parent.hasNode(string);
        }
        return false;
    }

    public void setText(String string) {
        String string2 = this.name;
        this.name = string;
        this.parent.rehash(string2);
    }

    public void deleted() {
        if (!this.isDefaultNode()) {
            this.parent.remove(this);
        } else {
            this.hide(true);
        }
    }
}

