/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resource;

import guitools.toolkit.JDebug;
import guitools.toolkit.StringSorter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.api.exception.UnknownMIMEType;
import jet.server.api.exception.UnknownResource;
import jet.server.log.ServiceLogger;
import jet.server.resource.InvalidResources;
import jet.server.resource.JRptUtil;
import jet.server.resource.NodeInfo;
import jet.server.resource.RptResourceNode;
import jet.server.resource.RptResourceRoot;
import jet.server.util.MIMETypeTable;
import jet.util.WildcardMatcher;

public class ResourceTreeMan {
    private MIMETypeTable INFO = null;
    private RptResourceRoot QOIV = null;
    private InvalidResources WARNING;
    public static final int FORMATEDNODE_CATRPT = 0;
    public static final int FORMATEDNODE_WORKING = 1;
    public static final int FORMATEDNODE_ALL = 2;

    public ResourceTreeMan(MIMETypeTable mIMETypeTable, ExProperties exProperties, ExProperties exProperties2) {
        this.INFO = mIMETypeTable;
        this.QOIV(exProperties, exProperties2);
    }

    public InvalidResources getInvalidResources() {
        return this.WARNING;
    }

    public RptResourceRoot getResourceRoot() {
        return this.QOIV;
    }

    public MIMETypeTable getMIMETypeTable() {
        return this.INFO;
    }

    public InvalidResources reloadResource(ExProperties exProperties, ExProperties exProperties2) {
        this.QOIV(exProperties, exProperties2);
        return this.WARNING;
    }

    public RptResourceNode getResourceNode(String string) {
        if (string == null || !string.startsWith("/")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        RptResourceNode rptResourceNode = this.QOIV;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if ((rptResourceNode = rptResourceNode.getRscByName(string2)) != null) continue;
            return null;
        }
        return rptResourceNode;
    }

    public String getRscNodeReferInfo(RptResourceNode rptResourceNode) {
        File file;
        boolean bl = false;
        if (rptResourceNode.hasRscSubNodes() && !rptResourceNode.isCatNode()) {
            bl = true;
        }
        String string = "0";
        String string2 = rptResourceNode.getRealPath();
        if (string2 != null && (file = rptResourceNode.getFile()) != null) {
            if (file.isDirectory()) {
                bl = true;
                string = "1";
            } else {
                string = "2";
            }
        }
        return string + (bl ? "1" : "0");
    }

    public String getRscNodeInfo(RptResourceNode rptResourceNode) {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Get Resource node info...");
        boolean bl = false;
        if (rptResourceNode.hasRscSubNodes() || rptResourceNode.isCatNode()) {
            JDebug.INFO((String)" The resource node has sub nodes, or it is catalog.");
            bl = true;
        }
        String string = rptResourceNode.getRealPath();
        JDebug.INFO((String)(" The real path of this resource node..." + string));
        if (string != null) {
            File file = rptResourceNode.getFile();
            String string2 = "application/octet-stream";
            JDebug.INFO((String)(" The file this node refers to..." + file));
            if (file != null) {
                if (file.isDirectory()) {
                    bl = true;
                    JDebug.INFO((String)" The file is directory.");
                } else {
                    int n = file.getName().lastIndexOf(".");
                    if (n != -1) {
                        String string3 = file.getName().substring(n);
                        string2 = this.INFO.getMimeType(string3);
                    }
                }
            }
            return string2 + (bl ? "1" : "0");
        }
        return bl ? "1" : "0";
    }

    public void getSubRscNodsInType(RptResourceNode rptResourceNode, String string, Vector vector) {
        Vector vector2 = rptResourceNode.getRscNodes();
        int n = vector2 == null ? 0 : vector2.size();
        RptResourceNode rptResourceNode2 = null;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            rptResourceNode2 = (RptResourceNode)vector2.elementAt(n2);
            String string2 = this.getRscNodeInfo(rptResourceNode2);
            boolean bl = string2.charAt((n3 = string2.length()) - 1) == '1';
            boolean bl2 = string2.substring(0, n3 - 1).equals(string);
            if ((bl || bl2) && !this.copyInto(vector, rptResourceNode2.getName())) {
                vector.addElement(rptResourceNode2.getName() + (bl ? "1" : "0") + (bl2 ? "1" : "0"));
            }
            ++n2;
        }
    }

    public void getSubpathsAndFilesInType(RptResourceNode rptResourceNode, String string, Vector vector) {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"RptResourceManager.getSubpathsAndFilesInType()");
        JDebug.INFO((String)(" rscNode..." + rptResourceNode.getFullName()));
        JDebug.INFO((String)(" mimeType.." + string));
        Vector vector2 = rptResourceNode.getRscNodes();
        int n = vector2 == null ? 0 : vector2.size();
        RptResourceNode rptResourceNode2 = null;
        JDebug.INFO((String)(" number of sub rsc nodes..." + n));
        JDebug.INFO((String)" Retruning the sub res node info...");
        int n2 = 0;
        while (n2 < n) {
            int n3;
            rptResourceNode2 = (RptResourceNode)vector2.elementAt(n2);
            String string2 = this.getRscNodeInfo(rptResourceNode2);
            boolean bl = string2.charAt((n3 = string2.length()) - 1) == '1';
            boolean bl2 = string2.substring(0, n3 - 1).equals(string);
            boolean bl3 = string2.substring(0, n3 - 1).equals("application/x-jrreport");
            JDebug.INFO((String)("  " + rptResourceNode2.getText() + " = " + string2));
            JDebug.INFO((String)("  dir..." + bl));
            JDebug.INFO((String)("  mime type match..." + bl2));
            if (bl || bl2 || bl3) {
                if (!this.copyInto(vector, rptResourceNode2.getName())) {
                    vector.addElement(rptResourceNode2.getName() + (bl ? "1" : "0") + (bl2 ? "1" : "0") + "1");
                } else {
                    JDebug.INFO((String)" The rsc name has been included.");
                }
            }
            ++n2;
        }
        File file = rptResourceNode.getFile();
        if (file != null) {
            this.getSubpathsAndFilesInType(file, string, rptResourceNode, vector);
        }
    }

    public void getSubpathsAndFilesInType(File file, String string, RptResourceNode rptResourceNode, Vector vector) {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"RptResourceManager.getSubpathsAndFilesInType()");
        JDebug.INFO((String)(" file......." + file));
        JDebug.INFO((String)(" mimeType..." + string));
        JDebug.INFO((String)(" rscNode...." + (rptResourceNode == null ? "null" : rptResourceNode.getFullName())));
        if (file.isDirectory()) {
            String string2;
            int n;
            JDebug.INFO((String)" The file is directory.");
            String[] stringArray = null;
            stringArray = file.list((FilenameFilter)new WildcardMatcher("*.clx", true, 2));
            int n2 = n = stringArray == null ? 0 : stringArray.length;
            if (n > 0) {
                vector.addElement("120");
            }
            n = (stringArray = file.list((FilenameFilter)new WildcardMatcher("*", true, 4))) == null ? 0 : stringArray.length;
            JDebug.INFO((String)" Adding sub directories...");
            int n3 = 0;
            while (n3 < n) {
                string2 = stringArray[n3];
                JDebug.INFO((String)("  " + string2));
                if (!this.copyInto(vector, string2) && (rptResourceNode == null || rptResourceNode.isVrtFileReachable(string2))) {
                    vector.addElement(string2 + "100");
                } else {
                    JDebug.INFO((String)"  The name of the directory has been included");
                }
                ++n3;
            }
            String[] stringArray2 = this.INFO.getExts(string);
            int n4 = stringArray2 == null ? 0 : stringArray2.length;
            JDebug.INFO((String)" Adding files that matches mime type...");
            int n5 = 0;
            while (n5 < n4) {
                JDebug.INFO((String)("  ext..." + stringArray2[n5]));
                stringArray = file.list((FilenameFilter)new WildcardMatcher("*" + stringArray2[n5], true, 2));
                n = stringArray == null ? 0 : stringArray.length;
                int n6 = 0;
                while (n6 < n) {
                    string2 = stringArray[n6];
                    JDebug.INFO((String)("   " + string2));
                    if (!this.copyInto(vector, string2) && (rptResourceNode == null || rptResourceNode.isVrtFileReachable(string2))) {
                        vector.addElement(string2 + "110");
                    } else {
                        JDebug.INFO((String)"   The file name has been included");
                    }
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public void getSubRscRefFileOrDir(RptResourceNode rptResourceNode, Vector vector) {
        Vector vector2 = rptResourceNode.getRscNodes();
        int n = vector2 == null ? 0 : vector2.size();
        RptResourceNode rptResourceNode2 = null;
        int n2 = 0;
        while (n2 < n) {
            rptResourceNode2 = (RptResourceNode)vector2.elementAt(n2);
            String string = this.getRscNodeReferInfo(rptResourceNode2);
            if (!(string.charAt(0) != '1' && string.charAt(1) != '1' || this.copyInto(vector, rptResourceNode2.getName()))) {
                vector.addElement(rptResourceNode2.getName() + string);
            }
            ++n2;
        }
    }

    public void getSubpathsAndFileSysDirs(RptResourceNode rptResourceNode, Vector vector) {
        Vector vector2 = rptResourceNode.getRscNodes();
        int n = vector2 == null ? 0 : vector2.size();
        RptResourceNode rptResourceNode2 = null;
        int n2 = 0;
        while (n2 < n) {
            rptResourceNode2 = (RptResourceNode)vector2.elementAt(n2);
            String string = this.getRscNodeReferInfo(rptResourceNode2);
            if (!(string.charAt(0) != '1' && string.charAt(1) != '1' || this.copyInto(vector, rptResourceNode2.getName()))) {
                vector.addElement(rptResourceNode2.getName() + string + "1");
            }
            ++n2;
        }
        File file = rptResourceNode.getFile();
        if (file != null) {
            this.getSubpathsAndFileSysDirs(file, rptResourceNode, vector);
        }
    }

    public void getSubpathsAndFileSysDirs(File file, RptResourceNode rptResourceNode, Vector vector) {
        if (file.isDirectory()) {
            String[] stringArray = null;
            stringArray = file.list((FilenameFilter)new WildcardMatcher("*", true, 4));
            int n = stringArray == null ? 0 : stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!this.copyInto(vector, string) && (rptResourceNode == null || rptResourceNode.isVrtFileReachable(string))) {
                    vector.addElement(string + "110");
                }
                ++n2;
            }
        }
    }

    public NodeInfo getNodeInfo(String string) throws UnknownMIMEType {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Getting node info...");
        JDebug.INFO((String)(" fullFmtdName..." + string));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = "/";
        RptResourceNode rptResourceNode = this.QOIV;
        RptResourceNode rptResourceNode2 = null;
        boolean bl = true;
        JDebug.INFO((String)" Searching to the last RptResourceNode...");
        while (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
            JDebug.INFO((String)("  token    = " + string2));
            JDebug.INFO((String)("  first    = " + bl));
            if (bl) {
                bl = false;
                continue;
            }
            n = string2.indexOf(")");
            string3 = string2.substring(1, n);
            string4 = string2.substring(n + 1);
            JDebug.INFO((String)("  lastIndexOfParenthese   = " + n));
            JDebug.INFO((String)("  tag                     = " + string3));
            JDebug.INFO((String)("  name                    = " + string4));
            if (string3.equals("R")) {
                rptResourceNode2 = rptResourceNode.getRscByName(string4);
                JDebug.INFO((String)("  The resource node got..." + rptResourceNode2));
                if (rptResourceNode2 == null) {
                    return null;
                }
                rptResourceNode = rptResourceNode2;
                continue;
            }
            JDebug.INFO((String)"  Break because of meeting Virtual resource node.");
            break;
        }
        if (string3 != null && !string3.equals("R")) {
            JDebug.INFO((String)" Searing for virtual resource node...");
            File file = rptResourceNode.getFile();
            boolean bl2 = rptResourceNode.isVrtFileReachableAtLast(string4);
            int n2 = bl2 ? 1 : 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string4);
            while (true) {
                JDebug.INFO((String)"");
                JDebug.INFO((String)("  file                     = " + file));
                JDebug.INFO((String)("  reachable                = " + bl2));
                JDebug.INFO((String)("  unknownReachable         = " + n2));
                JDebug.INFO((String)("  token                    = " + string2));
                JDebug.INFO((String)("  lastIndexOfParenthese    = " + n));
                JDebug.INFO((String)("  tag                      = " + string3));
                JDebug.INFO((String)("  name                     = " + string4));
                if (file == null) {
                    JDebug.INFO((String)"  Return null, because file is null.");
                    return null;
                }
                if (string3.startsWith("C")) {
                    JDebug.INFO((String)"  The current node should be catalog.");
                    if (!file.isDirectory()) {
                        JDebug.INFO((String)"  Return null, bacause parent file is not a directory.");
                        return null;
                    }
                    if (!(file = new File(file, string4)).exists() || !this.INFO.mimeCheck("application/x-jrcatalog", string4)) {
                        JDebug.INFO((String)"  Return null, because the catalog file does not exists or it is not a catalog at all.");
                        return null;
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        NodeInfo nodeInfo = new NodeInfo();
                        nodeInfo.nodetype = "C" + (bl2 ? "" : "H");
                        nodeInfo.name = string4;
                        nodeInfo.fullFmtdName = string;
                        nodeInfo.rscNode = rptResourceNode;
                        nodeInfo.reachable = n2;
                        nodeInfo.relativePath = stringBuffer.toString();
                        JDebug.INFO((String)("  Return catalog node info..." + nodeInfo));
                        return nodeInfo;
                    }
                } else {
                    if (string3.startsWith("Rpt")) {
                        JDebug.INFO((String)"  The current node should be a report.");
                        if (!this.INFO.mimeCheck("application/x-jrcatalog", file.getName()) || !JRptUtil.isRptBelongsToCat(file, string4, this.INFO) || stringTokenizer.hasMoreElements()) {
                            JDebug.INFO((String)"  Return null, because the parent file is not a catalog file, or it is not report belogns to that catalog, or there are still tokens after it.");
                            return null;
                        }
                        NodeInfo nodeInfo = new NodeInfo();
                        nodeInfo.nodetype = "Rpt" + (bl2 ? "" : "H");
                        nodeInfo.name = string4;
                        nodeInfo.fullFmtdName = string;
                        nodeInfo.rscNode = rptResourceNode;
                        nodeInfo.reachable = n2;
                        nodeInfo.relativePath = stringBuffer.toString();
                        JDebug.INFO((String)("  Return report node info..." + nodeInfo));
                        return nodeInfo;
                    }
                    if (string3.startsWith("D")) {
                        JDebug.INFO((String)"  The current node should be directory...");
                        if (!file.isDirectory()) {
                            JDebug.INFO((String)"  Return null, because the parent file is not a directory.");
                            return null;
                        }
                        if (!(file = new File(file, string4)).exists() || !file.isDirectory()) {
                            JDebug.INFO((String)"  Return null, because the node deos not exists or it is not a diretory at all.");
                            return null;
                        }
                        if (!stringTokenizer.hasMoreElements()) {
                            NodeInfo nodeInfo = new NodeInfo();
                            nodeInfo.nodetype = "D" + (bl2 ? "" : "H");
                            nodeInfo.name = string4;
                            nodeInfo.fullFmtdName = string;
                            nodeInfo.rscNode = rptResourceNode;
                            nodeInfo.reachable = n2;
                            nodeInfo.relativePath = stringBuffer.toString();
                            JDebug.INFO((String)("  Return directory node info..." + nodeInfo));
                            return nodeInfo;
                        }
                    } else if (string3.startsWith("F")) {
                        JDebug.INFO((String)"  The current node should be a normal file.");
                        if (!file.isDirectory()) {
                            JDebug.INFO((String)"  Return null, because the parent file is not a directory.");
                            return null;
                        }
                        if (!(file = new File(file, string4)).exists() || file.isDirectory() || stringTokenizer.hasMoreElements()) {
                            JDebug.INFO((String)"  Return null, because the file does not exists, or the file is not a normal file, or there are still tokens after it.");
                            return null;
                        }
                        NodeInfo nodeInfo = new NodeInfo();
                        nodeInfo.nodetype = "F" + (bl2 ? "" : "H");
                        nodeInfo.name = string4;
                        nodeInfo.fullFmtdName = string;
                        nodeInfo.rscNode = rptResourceNode;
                        nodeInfo.reachable = n2;
                        nodeInfo.relativePath = stringBuffer.toString();
                        JDebug.INFO((String)("  Return normal file info..." + nodeInfo));
                        return nodeInfo;
                    }
                }
                string2 = (String)stringTokenizer.nextElement();
                n = string2.indexOf(")");
                string3 = string2.substring(1, n);
                string4 = string2.substring(n + 1);
                n2 = -1;
                stringBuffer.append("/" + string4);
            }
        }
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.nodetype = "R";
        nodeInfo.name = string4;
        nodeInfo.fullFmtdName = string;
        nodeInfo.rscNode = rptResourceNode;
        JDebug.INFO((String)(" Return RptResourceNode Info..." + nodeInfo));
        return nodeInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getFormatedSubnodeNames(String string, int n, StringBuffer stringBuffer) throws UnknownResource, IOException, UnknownMIMEType {
        Vector vector;
        StringBuffer stringBuffer2;
        block18: {
            RptResourceNode rptResourceNode;
            JDebug.INFO((String)"");
            JDebug.INFO((String)"RptResourceNode.getFormatedSubnodeNames()...");
            JDebug.INFO((String)(" resoruce node name..." + string));
            JDebug.INFO((String)(" list type............" + n));
            if (string == null || !string.startsWith("/")) {
                throw new UnknownResource(string);
            }
            stringBuffer2 = new StringBuffer("(R)/");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = null;
            RptResourceNode rptResourceNode2 = rptResourceNode = this.QOIV;
            JDebug.INFO((String)" Searching Resource Node...");
            JDebug.INFO((String)("  cur parent node..." + rptResourceNode.getText()));
            JDebug.INFO((String)("  cur node..." + rptResourceNode2.getText()));
            int n2 = stringTokenizer.countTokens();
            int n3 = 0;
            boolean bl = true;
            while (stringTokenizer.hasMoreElements()) {
                string2 = (String)stringTokenizer.nextElement();
                JDebug.INFO((String)("  token..." + string2));
                rptResourceNode2 = rptResourceNode.getRscByName(string2);
                if (rptResourceNode2 == null) {
                    if (!stringTokenizer.hasMoreElements() || !bl) break;
                    stringBuffer2.deleteCharAt(3);
                    break;
                }
                JDebug.INFO((String)("  current node... " + rptResourceNode2.getText()));
                rptResourceNode = rptResourceNode2;
                if (n3 >= n2) continue;
                if (bl) {
                    stringBuffer2.append("(R)" + string2);
                    bl = false;
                } else {
                    stringBuffer2.append("/(R)" + string2);
                }
                ++n3;
            }
            JDebug.INFO((String)(" The Resouce Node found out..." + (rptResourceNode2 == null ? "null" : rptResourceNode2.getFullName())));
            JDebug.INFO((String)(" tmpRet..." + stringBuffer2));
            if (rptResourceNode2 != null) {
                Vector vector2 = new Vector(0);
                this.countTokens(rptResourceNode2, vector2, n);
                stringBuffer.append(stringBuffer2.toString());
                return vector2;
            }
            String string3 = string2;
            vector = new Vector(0);
            boolean bl2 = rptResourceNode.isVrtFileReachable(string2);
            if (rptResourceNode.isDirectory()) {
                JDebug.INFO((String)" The last found out Resource Node rerfers to a directory...");
                File file = rptResourceNode.getFile();
                File file2 = new File(file, string2);
                JDebug.INFO((String)(" current file...(" + file + ", " + string2 + ")"));
                while (file2.exists()) {
                    JDebug.INFO((String)" The current file exists...");
                    if (this.INFO.mimeCheck("application/x-jrcatalog", file2.getName())) {
                        JDebug.INFO((String)" The current file is a catalog file...");
                        stringBuffer2.append((bl2 ? "/(C)" : "/(CH)") + file2.getName());
                        if (stringTokenizer.hasMoreElements()) {
                            string2 = (String)stringTokenizer.nextElement();
                            JDebug.INFO((String)(" next token..." + string2));
                            stringBuffer2.append((bl2 ? "/(Rpt)" : "/(RptH)") + string2);
                            if (!JRptUtil.isRptBelongsToCat(file2, string2, this.INFO)) throw new UnknownResource(string);
                            JDebug.INFO((String)" The token is the report of that catalog...");
                            if (stringTokenizer.hasMoreElements()) {
                                throw new UnknownResource(string);
                            }
                        } else {
                            JDebug.INFO((String)" There is no more tokens...");
                            this.deleteCharAt(file2, rptResourceNode, string3, n, vector);
                        }
                    } else {
                        JDebug.INFO((String)" The current file is not a catalog file...");
                        if (stringTokenizer.hasMoreElements()) {
                            stringBuffer2.append((bl2 ? "/(D)" : "/(DH)") + string2);
                            string2 = (String)stringTokenizer.nextElement();
                            JDebug.INFO((String)(" The next token..." + string2));
                            JDebug.INFO((String)(" Current File...(" + file2 + ", " + string2 + ")"));
                            file2 = new File(file2, string2);
                            stringBuffer2.append((bl2 ? "/(D)" : "/(DH)") + string2);
                            continue;
                        }
                        JDebug.INFO((String)" There isn't next token");
                        if (file2.isDirectory()) {
                            JDebug.INFO((String)" The current file is directory...");
                            this.equals(file2, rptResourceNode, string3, n, vector);
                            stringBuffer2.append((bl2 ? "/(D)" : "/(DH)") + string2);
                        } else {
                            stringBuffer2.append((bl2 ? "/(F)" : "/(FH)") + string2);
                        }
                    }
                    break block18;
                }
                JDebug.INFO((String)" The current file does not exits");
                throw new UnknownResource(string);
            }
            if (!rptResourceNode.isCatNode()) throw new UnknownResource(string);
            JDebug.INFO((String)" The last found out resource node refers to a catalog file...");
            if (!JRptUtil.isRptBelongsToCat(rptResourceNode.getFile(), string2, this.INFO)) {
                throw new UnknownResource(string);
            }
            if (stringTokenizer.hasMoreElements()) {
                throw new UnknownResource(string);
            }
            stringBuffer2.append((bl2 ? "/(Rpt)" : "/(RptH)") + string2);
        }
        stringBuffer.append(stringBuffer2);
        return vector;
    }

    public Vector getFmtdSbndNmsOfSpcNd(String string, int n) throws UnknownResource, IOException, UnknownMIMEType {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Getting formated sub nodes name of specified node.");
        JDebug.INFO((String)(" rscNodeName..." + string));
        JDebug.INFO((String)(" type.........." + n));
        NodeInfo nodeInfo = this.getNodeInfo(string);
        if (nodeInfo == null) {
            throw new UnknownResource(string);
        }
        Vector vector = new Vector();
        if (nodeInfo.nodetype.equals("R")) {
            this.countTokens(nodeInfo.rscNode, vector, n);
        } else {
            String string2 = nodeInfo.nodetype;
            if (string2.startsWith("C")) {
                String string3 = nodeInfo.relativePath;
                JDebug.INFO((String)(" subpath..." + string3));
                File file = new File(nodeInfo.rscNode.getFile(), string3);
                this.elementAt(file, string2.equals("C"), n, vector);
            } else if (string2.startsWith("D")) {
                String string4 = nodeInfo.relativePath;
                JDebug.INFO((String)(" subpath..." + string4));
                File file = new File(nodeInfo.rscNode.getFile(), string4);
                this.exists(file, string2.equals("D"), n, vector);
                return vector;
            }
        }
        return vector;
    }

    public Vector getFmtdSbndNmsOfSpcRscNd(String string, int n) throws UnknownResource, IOException, UnknownMIMEType {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Getting formated name of sub nodes of the resource node");
        JDebug.INFO((String)(" Resource Node name..." + string));
        JDebug.INFO((String)(" list type............" + n));
        RptResourceNode rptResourceNode = this.getResourceNode(string);
        if (rptResourceNode == null) {
            throw new UnknownResource(string);
        }
        Vector vector = new Vector(0);
        this.countTokens(rptResourceNode, vector, n);
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getFmtdSbndNmsOfSpcVrtNd(String string, char c, int n) throws UnknownResource, IllegalArgumentException, UnknownMIMEType, IOException {
        RptResourceNode rptResourceNode;
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Getting formated name of the sub nodes of specified type of Virtual Resource Node...");
        JDebug.INFO((String)(" name..........." + string));
        JDebug.INFO((String)(" virtual type..." + c));
        JDebug.INFO((String)(" list type......" + n));
        if (string == null || !string.startsWith("/")) {
            throw new UnknownResource(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = null;
        RptResourceNode rptResourceNode2 = rptResourceNode = this.QOIV;
        while (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
            rptResourceNode2 = rptResourceNode.getRscByName(string2);
            if (rptResourceNode2 == null) break;
            rptResourceNode = rptResourceNode2;
        }
        JDebug.INFO((String)(" parent node..." + rptResourceNode.getFullName()));
        JDebug.INFO((String)(" current node..." + (rptResourceNode2 == null ? "null" : rptResourceNode2.getFullName())));
        Vector vector = new Vector(0);
        if (rptResourceNode2 != null) {
            rptResourceNode = (RptResourceNode)rptResourceNode2.getParent();
            switch (c) {
                case 'C': {
                    if (rptResourceNode.isDirectory()) {
                        JDebug.INFO((String)" parent node is directory.");
                        String string3 = rptResourceNode2.getText();
                        File file = new File(rptResourceNode.getFile(), string3);
                        JDebug.INFO((String)(" catalog file ?" + file));
                        if (file.exists() && this.INFO.mimeCheck("application/x-jrcatalog", string3)) {
                            JDebug.INFO((String)" the virtual node is a catalog file");
                            this.deleteCharAt(file, rptResourceNode, string3, n, vector);
                            return vector;
                        }
                        JDebug.INFO((String)" The virutal node does not exists or it is not a catalog file");
                        throw new UnknownResource(string);
                    }
                    JDebug.INFO((String)" parent node is not a directory");
                    throw new UnknownResource(string);
                }
                case 'R': {
                    if (rptResourceNode.isCatNode()) {
                        JDebug.INFO((String)" The parent node is a catalog node");
                        if (JRptUtil.isRptBelongsToCat(rptResourceNode.getFile(), rptResourceNode2.getText(), this.INFO)) return vector;
                        JDebug.INFO((String)" The virtual node is not a report belong to the parent catalog");
                        throw new UnknownResource(string);
                    }
                    JDebug.INFO((String)" The parent node is not a catalog node");
                    throw new UnknownResource(string);
                }
                case 'D': {
                    if (rptResourceNode.isDirectory()) {
                        JDebug.INFO((String)" The parent node is a directory");
                        String string4 = rptResourceNode2.getText();
                        File file = new File(rptResourceNode.getFile(), string4);
                        if (file.exists() && file.isDirectory()) {
                            JDebug.INFO((String)" The virtual node is a directory.");
                            this.equals(file, rptResourceNode, string4, n, vector);
                            return vector;
                        }
                        JDebug.INFO((String)" The virtual node does not exists or it is not a directory.");
                        throw new UnknownResource(string);
                    }
                    JDebug.INFO((String)" The parent node is not a directory");
                    throw new UnknownResource(string);
                }
                case 'F': {
                    if (rptResourceNode.isDirectory()) {
                        JDebug.INFO((String)" The parent node is a directory");
                        File file = new File(rptResourceNode.getFile(), rptResourceNode2.getText());
                        if (file.exists() && !file.isDirectory()) return vector;
                        JDebug.INFO((String)" The virtual node does not exists or is not a file.");
                        throw new UnknownResource(string);
                    }
                    JDebug.INFO((String)" The parent node is not a directory.");
                    throw new UnknownResource(string);
                }
                default: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Internal Error. Unknown type of Virtual Resource Node '" + c + "'");
                    JDebug.WARNING((Throwable)illegalArgumentException);
                    throw illegalArgumentException;
                }
            }
        }
        switch (c) {
            case 'C': {
                if (rptResourceNode.isDirectory()) {
                    JDebug.INFO((String)"The parent node is a directory.");
                    String string5 = this.getDescription(stringTokenizer);
                    String string6 = string2 + (string5.length() == 0 ? "" : "/" + string5);
                    JDebug.INFO((String)(" subpath..." + string6));
                    File file = new File(rptResourceNode.getFile(), string6);
                    if (file.exists() && this.INFO.mimeCheck("application/x-jrcatalog", file.getName())) {
                        JDebug.INFO((String)" The virtual node is a catalog.");
                        this.deleteCharAt(file, rptResourceNode, string2, n, vector);
                        return vector;
                    }
                    JDebug.INFO((String)" The virtual node does not exists or it is not a catalog.");
                    throw new UnknownResource(string);
                }
                JDebug.INFO((String)"The parent node is NOT a directory.");
                throw new UnknownResource(string);
            }
            case 'R': {
                if (rptResourceNode.isDirectory()) {
                    JDebug.INFO((String)"The parent node is a directory.");
                    String string7 = string2;
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    JDebug.INFO((String)("  The backup token..." + string2));
                    if (stringTokenizer.hasMoreElements()) {
                        JDebug.INFO((String)"  Has more tokens...");
                        String string8 = (String)stringTokenizer.nextElement();
                        while (stringTokenizer.hasMoreElements()) {
                            stringBuffer.append("/" + string8);
                            string8 = (String)stringTokenizer.nextElement();
                        }
                        File file = new File(rptResourceNode.getFile(), stringBuffer.toString());
                        JDebug.INFO((String)("  catalog file ?..." + file));
                        if (file.exists() && this.INFO.mimeCheck("application/x-jrcatalog", file.getName())) {
                            JDebug.INFO((String)("  It is a catalog file..." + file));
                            if (JRptUtil.isRptBelongsToCat(file, string8, this.INFO)) return vector;
                            JDebug.INFO((String)"  The virtual node is not a report of that catalog");
                            throw new UnknownResource(string);
                        }
                        JDebug.INFO((String)("  It is not a catalog file..." + file));
                        throw new UnknownResource(string);
                    }
                    JDebug.INFO((String)" Even if the virtual node was a report, parent node is not a catalog file");
                    throw new UnknownResource(string);
                }
                if (rptResourceNode.isCatNode()) {
                    JDebug.INFO((String)" Parent node is a catalog");
                    if (!stringTokenizer.hasMoreElements()) {
                        JDebug.INFO((String)" No more tokens...");
                        if (JRptUtil.isRptBelongsToCat(rptResourceNode.getFile(), string2, this.INFO)) return vector;
                        JDebug.INFO((String)" The virtual node is not a report belong to the catalog.");
                        throw new UnknownResource(string);
                    }
                    JDebug.INFO((String)" Extra token founded.");
                    throw new UnknownResource(string);
                }
                JDebug.INFO((String)" Parent node is neither directory nor catalog file.");
                throw new UnknownResource(string);
            }
            case 'D': {
                if (rptResourceNode.isDirectory()) {
                    JDebug.INFO((String)" The parent node is directory");
                    String string9 = string2 + "/" + this.getDescription(stringTokenizer);
                    File file = new File(rptResourceNode.getFile(), string9);
                    JDebug.INFO((String)(" subpath..." + string9));
                    if (file.exists() && file.isDirectory()) {
                        JDebug.INFO((String)" The virtual node is a directory.");
                        this.equals(file, rptResourceNode, string2, n, vector);
                        return vector;
                    }
                    JDebug.INFO((String)" The virtual node does not exists or it is not a directory.");
                    throw new UnknownResource(string);
                }
                JDebug.INFO((String)" The parent node is not a directory.");
                throw new UnknownResource(string);
            }
            case 'F': {
                if (rptResourceNode.isDirectory()) {
                    JDebug.INFO((String)" The Parent node is a directory");
                    String string10 = string2 + "/" + this.getDescription(stringTokenizer);
                    File file = new File(rptResourceNode.getFile(), string10);
                    JDebug.INFO((String)(" subpath..." + string10));
                    if (file.exists() && !file.isDirectory()) return vector;
                    JDebug.INFO((String)" The virtual resource node does not exists or it is not a file.");
                    throw new UnknownResource(string);
                }
                JDebug.INFO((String)" The parent node is not a directory.");
                throw new UnknownResource(string);
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Internal Error. Unknown type of Virtual Resource Node '" + c + "'");
                JDebug.WARNING((Throwable)illegalArgumentException);
                throw illegalArgumentException;
            }
        }
    }

    public RptResourceNode getRptRscNodeAsParent(String string, StringBuffer stringBuffer) throws UnknownMIMEType {
        JDebug.INFO((String)"");
        JDebug.INFO((String)("(RptResoruceManager) Getting parent of virtual node '" + string + "', and whose parent is RptResourceNode "));
        JDebug.INFO((String)(" fullNameOfVrtName..." + string));
        int n = string.lastIndexOf("/");
        JDebug.INFO((String)(" lastIndexOfSlash..." + n));
        String string2 = null;
        if (n == 0) {
            if (string.length() == 1) {
                return null;
            }
            string2 = "/";
            stringBuffer.append(string.substring(1));
        } else {
            string2 = string.substring(0, n);
            stringBuffer.append(string.substring(n + 1));
        }
        JDebug.INFO((String)(" parent........" + string2));
        JDebug.INFO((String)(" retNodeName..." + stringBuffer.toString()));
        RptResourceNode rptResourceNode = this.getResourceNode(string2);
        if (rptResourceNode == null) {
            return null;
        }
        if (rptResourceNode.isDirectory()) {
            JDebug.INFO((String)" The resource node is a directory.");
            String[] stringArray = rptResourceNode.getFile().list((FilenameFilter)new WildcardMatcher(stringBuffer.toString(), true));
            JDebug.INFO((String)(" files..." + (stringArray == null ? "null" : "" + stringArray.length)));
            if (stringArray != null && stringArray.length > 0) {
                return rptResourceNode;
            }
        } else if (rptResourceNode.isCatNode()) {
            JDebug.INFO((String)" the resource node is a catalog file.");
            if (JRptUtil.isRptBelongsToCat(rptResourceNode.getFile(), stringBuffer.toString(), this.INFO)) {
                return rptResourceNode;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doesVrtNodeSetReachable(String string, char c) throws UnknownResource, UnknownMIMEType, IllegalArgumentException {
        RptResourceNode rptResourceNode;
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Checking if vritual node is set reachable...");
        JDebug.INFO((String)(" rscFullName..." + string));
        JDebug.INFO((String)(" type.........." + c));
        int n = -1;
        if (string == null) throw new UnknownResource(string);
        if (!string.startsWith("/")) {
            throw new UnknownResource(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = null;
        RptResourceNode rptResourceNode2 = rptResourceNode = this.QOIV;
        while (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
            rptResourceNode2 = rptResourceNode.getRscByName(string2);
            if (rptResourceNode2 == null) break;
            rptResourceNode = rptResourceNode2;
        }
        JDebug.INFO((String)(" parent node..." + rptResourceNode.getFullName()));
        JDebug.INFO((String)(" current node..." + (rptResourceNode2 == null ? "null" : rptResourceNode2.getFullName())));
        if (rptResourceNode2 != null) {
            rptResourceNode = (RptResourceNode)rptResourceNode2.getParent();
            switch (c) {
                case 'C': {
                    if (rptResourceNode.isDirectory()) {
                        JDebug.INFO((String)" parent node is directory.");
                        String string3 = rptResourceNode2.getText();
                        File file = new File(rptResourceNode.getFile(), string3);
                        JDebug.INFO((String)(" catalog file ?" + file));
                        if (file.exists() && this.INFO.mimeCheck("application/x-jrcatalog", string3)) {
                            JDebug.INFO((String)" the virtual node is a catalog file");
                            if (!rptResourceNode.isVrtFileReachable(string3)) return 0;
                            return 1;
                        }
                        JDebug.INFO((String)" The virutal node does not exists or it is not a catalog file");
                        throw new UnknownResource(string);
                    }
                    JDebug.INFO((String)" parent node is not a directory");
                    throw new UnknownResource(string);
                }
                case 'R': {
                    if (rptResourceNode.isCatNode()) {
                        JDebug.INFO((String)" The parent node is a catalog node");
                        if (!JRptUtil.isRptBelongsToCat(rptResourceNode.getFile(), rptResourceNode2.getText(), this.INFO)) {
                            JDebug.INFO((String)" The virtual node is not a report belong to the parent catalog");
                            throw new UnknownResource(string);
                        }
                        if (!rptResourceNode.isVrtFileReachable(rptResourceNode2.getText())) return 0;
                        return 1;
                    }
                    JDebug.INFO((String)" The parent node is not a catalog node");
                    throw new UnknownResource(string);
                }
                case 'D': {
                    if (rptResourceNode.isDirectory()) {
                        JDebug.INFO((String)" The parent node is a directory");
                        String string4 = rptResourceNode2.getText();
                        File file = new File(rptResourceNode.getFile(), string4);
                        if (file.exists() && file.isDirectory()) {
                            JDebug.INFO((String)" The virtual node is a directory.");
                            if (!rptResourceNode.isVrtFileReachable(string4)) return 0;
                            return 1;
                        }
                        JDebug.INFO((String)" The virtual node does not exists or it is not a directory.");
                        throw new UnknownResource(string);
                    }
                    JDebug.INFO((String)" The parent node is not a directory");
                    throw new UnknownResource(string);
                }
                case 'F': {
                    if (rptResourceNode.isDirectory()) {
                        JDebug.INFO((String)" The parent node is a directory");
                        File file = new File(rptResourceNode.getFile(), rptResourceNode2.getText());
                        if (!file.exists() || file.isDirectory()) {
                            JDebug.INFO((String)" The virtual node does not exists or is not a file.");
                            throw new UnknownResource(string);
                        }
                        if (!rptResourceNode.isVrtFileReachable(rptResourceNode2.getText())) return 0;
                        return 1;
                    }
                    JDebug.INFO((String)" The parent node is not a directory.");
                    throw new UnknownResource(string);
                }
                default: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Internal Error. Unknown type of Virtual Resource Node '" + c + "'");
                    JDebug.WARNING((Throwable)illegalArgumentException);
                    throw illegalArgumentException;
                }
            }
        }
        switch (c) {
            case 'C': {
                if (rptResourceNode.isDirectory()) {
                    JDebug.INFO((String)"The parent node is a directory.");
                    String string5 = this.getDescription(stringTokenizer);
                    String string6 = string2 + (string5.length() == 0 ? "" : "/" + string5);
                    JDebug.INFO((String)(" subpath..." + string6));
                    File file = new File(rptResourceNode.getFile(), string6);
                    if (file.exists() && this.INFO.mimeCheck("application/x-jrcatalog", file.getName())) {
                        JDebug.INFO((String)" The virtual node is a catalog.");
                        if (string5.length() != 0) return n;
                        JDebug.INFO((String)" It is the node under the parent resource node");
                        if (!rptResourceNode.isVrtFileReachable(string2)) return 0;
                        return 1;
                    }
                    JDebug.INFO((String)" The virtual node does not exists or it is not a catalog.");
                    throw new UnknownResource(string);
                }
                JDebug.INFO((String)"The parent node is NOT a directory.");
                throw new UnknownResource(string);
            }
            case 'R': {
                if (rptResourceNode.isDirectory()) {
                    JDebug.INFO((String)"The parent node is a directory.");
                    String string7 = string2;
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    JDebug.INFO((String)("  The backup token..." + string2));
                    if (stringTokenizer.hasMoreElements()) {
                        JDebug.INFO((String)"  Has more tokens...");
                        String string8 = (String)stringTokenizer.nextElement();
                        while (stringTokenizer.hasMoreElements()) {
                            stringBuffer.append("/" + string8);
                            string8 = (String)stringTokenizer.nextElement();
                        }
                        File file = new File(rptResourceNode.getFile(), stringBuffer.toString());
                        JDebug.INFO((String)("  catalog file ?..." + file));
                        if (file.exists() && this.INFO.mimeCheck("application/x-jrcatalog", file.getName())) {
                            JDebug.INFO((String)("  It is a catalog file..." + file));
                            if (JRptUtil.isRptBelongsToCat(file, string8, this.INFO)) return n;
                            JDebug.INFO((String)"  The virtual node is not a report of that catalog");
                            throw new UnknownResource(string);
                        }
                        JDebug.INFO((String)("  It is not a catalog file..." + file));
                        throw new UnknownResource(string);
                    }
                    JDebug.INFO((String)" Even if the virtual node was a report, parent node is not a catalog file");
                    throw new UnknownResource(string);
                }
                if (rptResourceNode.isCatNode()) {
                    JDebug.INFO((String)" Parent node is a catalog");
                    if (!stringTokenizer.hasMoreElements()) {
                        JDebug.INFO((String)" No more tokens...");
                        if (!JRptUtil.isRptBelongsToCat(rptResourceNode.getFile(), string2, this.INFO)) {
                            JDebug.INFO((String)" The virtual node is not a report belong to the catalog.");
                            throw new UnknownResource(string);
                        }
                        if (!rptResourceNode.isVrtFileReachable(string2)) return 0;
                        return 1;
                    }
                    JDebug.INFO((String)" Extra token founded.");
                    throw new UnknownResource(string);
                }
                JDebug.INFO((String)" Parent node is neither directory nor catalog file.");
                throw new UnknownResource(string);
            }
            case 'D': {
                if (rptResourceNode.isDirectory()) {
                    JDebug.INFO((String)" The parent node is directory");
                    String string9 = this.getDescription(stringTokenizer);
                    String string10 = string2 + (string9.length() == 0 ? "" : "/") + string9;
                    File file = new File(rptResourceNode.getFile(), string10);
                    JDebug.INFO((String)(" subpath..." + string10));
                    if (file.exists() && file.isDirectory()) {
                        JDebug.INFO((String)" The virtual node is a directory.");
                        if (string9.length() != 0) return n;
                        JDebug.INFO((String)" And it is the virtual node under parent resource node");
                        if (!rptResourceNode.isVrtFileReachable(string2)) return 0;
                        return 1;
                    }
                    JDebug.INFO((String)" The virtual node does not exists or it is not a directory.");
                    throw new UnknownResource(string);
                }
                JDebug.INFO((String)" The parent node is not a directory.");
                throw new UnknownResource(string);
            }
            case 'F': {
                if (rptResourceNode.isDirectory()) {
                    JDebug.INFO((String)" The Parent node is a directory");
                    String string11 = this.getDescription(stringTokenizer);
                    String string12 = string2 + (string11.length() == 0 ? "" : "/") + string11;
                    File file = new File(rptResourceNode.getFile(), string12);
                    JDebug.INFO((String)(" subpath..." + string12));
                    if (!file.exists() || file.isDirectory()) {
                        JDebug.INFO((String)" The virtual resource node does not exists or it is not a file.");
                        throw new UnknownResource(string);
                    }
                    if (string11.length() != 0) return n;
                    JDebug.INFO((String)" And it is the virtual node under that parent resource node.");
                    if (!rptResourceNode.isVrtFileReachable(string2)) return 0;
                    return 1;
                }
                JDebug.INFO((String)" The parent node is not a directory.");
                throw new UnknownResource(string);
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Internal Error. Unknown type of Virtual Resource Node '" + c + "'");
                JDebug.WARNING((Throwable)illegalArgumentException);
                throw illegalArgumentException;
            }
        }
    }

    public RptResourceNode declare(RptResourceNode rptResourceNode, String string, boolean bl) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            File file = rptResourceNode.getFile();
            if (rptResourceNode.isCatNode()) {
                file = new File(file.getParent());
            }
            File file2 = new File(file, string2);
            String string3 = file2.getCanonicalPath();
            String string4 = string2;
            if (rptResourceNode.getRscByName(string2) != null) {
                int n = 0;
                string4 = string2 + n;
                while (rptResourceNode.getRscByName(string4) != null) {
                    string4 = string4 + ++n;
                }
            }
            RptResourceNode rptResourceNode2 = new RptResourceNode(string4, string3, bl);
            rptResourceNode.insert(rptResourceNode2, -1);
            rptResourceNode = rptResourceNode2;
        }
        return rptResourceNode;
    }

    public RptResourceNode declare(RptResourceNode rptResourceNode, String string, String string2, boolean bl) throws IOException {
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string3 = file.getCanonicalPath();
        if (rptResourceNode.getRscByName(string) == null) {
            RptResourceNode rptResourceNode2 = new RptResourceNode(string, string3, bl);
            rptResourceNode.insert(rptResourceNode2, -1);
            rptResourceNode = rptResourceNode2;
        }
        return rptResourceNode;
    }

    public void export(ExProperties exProperties, ExProperties exProperties2) {
        this.export(exProperties, exProperties2, this.QOIV, -1);
        this.append(exProperties, exProperties2, this.QOIV);
    }

    private void INFO() {
        this.QOIV = new RptResourceRoot(this, null, false);
    }

    private void QOIV(ExProperties exProperties, ExProperties exProperties2) {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Load Resource...");
        if (this.WARNING != null) {
            this.WARNING.clear();
            this.WARNING = null;
        }
        JDebug.INFO((String)(" Resource Properties..." + exProperties));
        if (exProperties == null) {
            this.INFO();
        } else {
            int n = exProperties.size();
            String[] stringArray = new String[n];
            Enumeration<?> enumeration = exProperties.propertyNames();
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)enumeration.nextElement();
                ++n2;
            }
            StringSorter.sortString((String[])stringArray);
            RptResourceNode rptResourceNode = null;
            String string = null;
            String string2 = null;
            RptResourceNode rptResourceNode2 = null;
            boolean bl = false;
            String string3 = null;
            int n3 = 0;
            while (n3 < n) {
                string = stringArray[n3];
                if (rptResourceNode != null) {
                    rptResourceNode2 = rptResourceNode;
                    string2 = rptResourceNode.getFullName();
                    string3 = string2.equals("/") ? string2 : string2 + "/";
                    while (!string.startsWith(string3)) {
                        if ((rptResourceNode2 = (RptResourceNode)rptResourceNode2.getParent()) == null) break;
                        string2 = rptResourceNode2.getFullName();
                        String string4 = string3 = string2.equals("/") ? string2 : string2 + "/";
                    }
                    if (rptResourceNode2 != null) {
                        string = string.substring(string2.length());
                        rptResourceNode = this.WARNING(rptResourceNode2, string);
                    } else {
                        bl = true;
                    }
                } else if (string.startsWith("/")) {
                    rptResourceNode = this.WARNING(null, string);
                } else {
                    bl = true;
                }
                if (bl) {
                    if (this.WARNING == null) {
                        this.WARNING = new InvalidResources();
                    }
                    this.WARNING.add(stringArray[n3], (short)1);
                    bl = false;
                } else {
                    Object object;
                    String string5 = exProperties.getProperty(stringArray[n3]);
                    if (string5 != null && string5.length() > 0) {
                        object = new File(string5);
                        try {
                            string5 = ((File)object).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            ServiceLogger.logError(iOException, 3);
                        }
                    } else {
                        string5 = null;
                    }
                    if (string5 != null && (object = (RptResourceNode)rptResourceNode.getParent()) != null && ((RptResourceNode)object).isCatNode() && !JRptUtil.isRptBelongsToCat(((RptResourceNode)object).getRealPath(), string5, this.INFO)) {
                        bl = true;
                    }
                    if (bl) {
                        if (this.WARNING == null) {
                            this.WARNING = new InvalidResources();
                        }
                        this.WARNING.add(stringArray[n3], (short)2);
                        this.addElement(rptResourceNode, exProperties2, rptResourceNode2);
                        bl = false;
                    } else {
                        rptResourceNode.setRealPath(string5);
                        this.addElement(rptResourceNode, exProperties2, rptResourceNode2);
                    }
                    JDebug.INFO((String)(" buff.name     = " + rptResourceNode.getText()));
                    JDebug.INFO((String)(" buff.realpath = " + rptResourceNode.getRealPath()));
                }
                ++n3;
            }
            if (this.QOIV == null) {
                this.INFO();
            }
        }
    }

    private RptResourceNode WARNING(RptResourceNode rptResourceNode, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (rptResourceNode == null) {
            this.QOIV = new RptResourceRoot(this, null, false);
            rptResourceNode = this.QOIV;
        }
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            RptResourceNode rptResourceNode2 = rptResourceNode.getRscByName(string2);
            if (rptResourceNode2 == null) {
                rptResourceNode2 = new RptResourceNode(string2, null, false);
                rptResourceNode.insert(rptResourceNode2, -1);
            }
            rptResourceNode = rptResourceNode2;
        }
        return rptResourceNode;
    }

    private void addElement(RptResourceNode rptResourceNode, ExProperties exProperties, RptResourceNode rptResourceNode2) {
        if (exProperties != null) {
            Object object;
            String string = rptResourceNode.getFullName();
            rptResourceNode.setDefReachableOfSubnodes(exProperties.getProperty(this.charAt(string, "DefaultReachable"), 0));
            rptResourceNode.setMapSharedDisk(exProperties.getProperty(this.charAt(string, "MapSharedDisk"), false));
            rptResourceNode.setDescription(exProperties.getProperty(this.charAt(string, "Description"), null));
            boolean bl = exProperties.getProperty(this.charAt(string, "ReachableOfExcpFiles"), false);
            boolean bl2 = exProperties.getProperty(this.charAt(string, "needSort"), true);
            String string2 = exProperties.getProperty(this.charAt(string, "ExcpFiles"), null);
            int n = exProperties.getProperty(this.charAt(string, "oRdiDx"), -1);
            Vector<Object> vector = null;
            if (string2 != null) {
                object = new StringTokenizer(string2, ",");
                vector = new Vector<Object>();
                while (((StringTokenizer)object).hasMoreElements()) {
                    vector.addElement(((StringTokenizer)object).nextElement());
                }
            }
            if (rptResourceNode2 != null && n >= 0) {
                object = rptResourceNode2.getRscNodes();
                ((Vector)object).removeElement(rptResourceNode);
                int n2 = object == null ? 0 : ((Vector)object).size();
                int n3 = 0;
                while (n3 < n2) {
                    RptResourceNode rptResourceNode3 = (RptResourceNode)((Vector)object).elementAt(n3);
                    int n4 = rptResourceNode3.getOrder();
                    if (n < n4) {
                        ((Vector)object).insertElementAt(rptResourceNode, n3);
                        rptResourceNode.setOrder(n);
                        break;
                    }
                    ++n3;
                }
                if (n3 >= n2) {
                    ((Vector)object).addElement(rptResourceNode);
                    rptResourceNode.setOrder(n);
                }
            }
            rptResourceNode.setReachableFiles(vector, bl);
            if (!bl2) {
                rptResourceNode.setNeedSort(false);
            }
        }
    }

    private void append(ExProperties exProperties, ExProperties exProperties2, RptResourceNode rptResourceNode) {
        Vector vector = rptResourceNode.getRscNodes();
        int n = vector == null ? 0 : vector.size();
        boolean bl = rptResourceNode.needSort();
        int n2 = 0;
        while (n2 < n) {
            RptResourceNode rptResourceNode2 = (RptResourceNode)vector.elementAt(n2);
            this.export(exProperties, exProperties2, rptResourceNode2, bl ? -1 : n2);
            this.append(exProperties, exProperties2, rptResourceNode2);
            ++n2;
        }
    }

    private void export(ExProperties exProperties, ExProperties exProperties2, RptResourceNode rptResourceNode, int n) {
        Vector vector;
        int n2;
        String string = rptResourceNode.getFullName();
        exProperties.put(string, rptResourceNode.getRealPath() == null ? "" : rptResourceNode.getRealPath());
        exProperties2.setProperty(this.charAt(string, "DefaultReachable"), rptResourceNode.getDefReachableOfSubnodes());
        exProperties2.setProperty(this.charAt(string, "ReachableOfExcpFiles"), rptResourceNode.isExcpFilesReachable());
        exProperties2.setProperty(this.charAt(string, "MapSharedDisk"), rptResourceNode.isMapSharedDisk());
        exProperties2.setProperty(this.charAt(string, "Description"), rptResourceNode.getDescription());
        if (!rptResourceNode.needSort()) {
            exProperties2.setProperty(this.charAt(string, "needSort"), false);
        }
        if (n >= 0) {
            exProperties2.setProperty(this.charAt(string, "oRdiDx"), n);
        }
        int n3 = n2 = (vector = rptResourceNode.getExcpFiles()) == null ? 0 : vector.size();
        if (n2 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (n4 < n2) {
                stringBuffer.append(vector.elementAt(n4));
                if (n4 < n2 - 1) {
                    stringBuffer.append(",");
                }
                ++n4;
            }
            exProperties2.setProperty(this.charAt(string, "ExcpFiles"), stringBuffer.toString());
        }
    }

    RptResourceNode I(RptResourceNode rptResourceNode, String string, StringBuffer stringBuffer) {
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        boolean bl = false;
        RptResourceNode rptResourceNode2 = rptResourceNode;
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            rptResourceNode2 = rptResourceNode.getRscByName(string3);
            if (rptResourceNode2 == null) break;
            rptResourceNode = rptResourceNode2;
            string2 = string2.substring(string2.indexOf(string3) + string3.length());
        }
        if (stringBuffer != null) {
            stringBuffer.append(string2);
        }
        return rptResourceNode;
    }

    private String charAt(String string, String string2) {
        return string + "." + string2;
    }

    private boolean copyInto(Vector vector, String string) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.elementAt(n2);
            if ((string2 = string2.substring(0, string2.length() - 3)).equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void countTokens(RptResourceNode rptResourceNode, Vector vector, int n) throws UnknownMIMEType, IOException {
        Vector vector2 = rptResourceNode.getRscNodes();
        int n2 = vector2 == null ? 0 : vector2.size();
        JDebug.INFO((String)(" Adding sub Resource Nodes..." + n2));
        int n3 = 0;
        while (n3 < n2) {
            vector.addElement("(R)" + ((RptResourceNode)vector2.elementAt(n3)).getText());
            ++n3;
        }
        JDebug.INFO((String)" Adding sub Virtual Resource Nodes that are reachable...");
        if (rptResourceNode.isDirectory()) {
            JDebug.INFO((String)" The Resource Node refers to a directory...");
            switch (n) {
                case 0: {
                    JDebug.INFO((String)" Adding formated catalogs in this directory...");
                    this.fullFmtdName(rptResourceNode.getFile(), vector, true, rptResourceNode);
                    break;
                }
                case 1: {
                    JDebug.INFO((String)" Adding all the reachable files and sub directories in this directory...");
                    this.getDefReachableOfSubnodes(rptResourceNode.getFile(), vector, true, rptResourceNode);
                    break;
                }
                case 2: {
                    JDebug.INFO((String)" Adding all the files and subdirectories in this directory...");
                    this.getDefReachableOfSubnodes(rptResourceNode.getFile(), vector, false, rptResourceNode);
                }
            }
        } else if (rptResourceNode.isCatNode()) {
            JDebug.INFO((String)" The Resource Node refers to a catalog file ...");
            switch (n) {
                case 0: 
                case 1: {
                    JDebug.INFO((String)" Adding all of its reachable reports...");
                    this.getCanonicalPath(rptResourceNode.getFile(), vector, true, rptResourceNode);
                    break;
                }
                case 2: {
                    JDebug.INFO((String)" Adding all of its reports...");
                    this.getCanonicalPath(rptResourceNode.getFile(), vector, false, rptResourceNode);
                }
            }
        }
    }

    private void deleteCharAt(File file, RptResourceNode rptResourceNode, String string, int n, Vector vector) throws IOException {
        boolean bl = rptResourceNode.isVrtFileReachableAtLast(string);
        this.elementAt(file, bl, n, vector);
    }

    private void elementAt(File file, boolean bl, int n, Vector vector) throws IOException {
        if (bl) {
            this.getCanonicalPath(file, vector, true, null);
        } else if (n == 2) {
            this.getCanonicalPath(file, vector, bl, null);
        }
    }

    private void equals(File file, RptResourceNode rptResourceNode, String string, int n, Vector vector) throws UnknownMIMEType {
        boolean bl = rptResourceNode.isVrtFileReachableAtLast(string);
        this.exists(file, bl, n, vector);
    }

    private void exists(File file, boolean bl, int n, Vector vector) throws UnknownMIMEType {
        if (n == 0) {
            if (bl) {
                this.fullFmtdName(file, vector, true, null);
            }
        } else if (n == 1) {
            if (bl) {
                this.getDefReachableOfSubnodes(file, vector, true, null);
            }
        } else if (n == 2) {
            this.getDefReachableOfSubnodes(file, vector, bl, null);
        }
    }

    private void fullFmtdName(File file, Vector vector, boolean bl, RptResourceNode rptResourceNode) {
        int n;
        Vector<String> vector2 = null;
        Vector<String> vector3 = null;
        Vector<String> vector4 = null;
        Vector<String> vector5 = null;
        String[] stringArray = this.INFO.getExts("application/x-jrcatalog");
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] stringArray2 = file.list((FilenameFilter)new WildcardMatcher("*" + stringArray[n3], true, 2));
            int n4 = stringArray2 == null ? 0 : stringArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                String string = stringArray2[n5];
                if (rptResourceNode == null) {
                    if (bl) {
                        if (vector2 == null) {
                            vector2 = new Vector<String>(1);
                        }
                        vector2.addElement("(C)" + string);
                    } else {
                        if (vector4 == null) {
                            vector4 = new Vector<String>(1);
                        }
                        vector4.addElement("(CH)" + string);
                    }
                } else {
                    n = rptResourceNode.isVrtFileReachableAtLast(string) ? 1 : 0;
                    if (n != 0) {
                        if (vector2 == null) {
                            vector2 = new Vector(1);
                        }
                        vector2.addElement("(C)" + string);
                    } else if (!bl) {
                        if (vector4 == null) {
                            vector4 = new Vector(1);
                        }
                        vector4.addElement("(CH)" + string);
                    }
                }
                ++n5;
            }
            ++n3;
        }
        String[] stringArray3 = file.list((FilenameFilter)new WildcardMatcher("*", true, 4));
        n = stringArray3 == null ? 0 : stringArray3.length;
        int n6 = 0;
        while (n6 < n) {
            String string = stringArray3[n6];
            if (rptResourceNode == null) {
                if (bl) {
                    if (vector3 == null) {
                        vector3 = new Vector<String>(1);
                    }
                    vector3.addElement("(D)" + string);
                } else {
                    if (vector5 == null) {
                        vector5 = new Vector<String>(1);
                    }
                    vector5.addElement("(DH)" + string);
                }
            } else {
                boolean bl2 = rptResourceNode.isVrtFileReachableAtLast(string);
                if (bl2) {
                    if (vector3 == null) {
                        vector3 = new Vector(1);
                    }
                    vector3.addElement("(D)" + string);
                } else if (!bl) {
                    if (vector5 == null) {
                        vector5 = new Vector(1);
                    }
                    vector5.addElement("(DH)" + string);
                }
            }
            ++n6;
        }
        this.getExcpFiles(vector2, vector);
        this.getExcpFiles(vector3, vector);
        this.getExcpFiles(vector4, vector);
        this.getExcpFiles(vector5, vector);
    }

    private void getCanonicalPath(File file, Vector vector, boolean bl, RptResourceNode rptResourceNode) throws IOException {
        Vector<String> vector2 = null;
        Vector<String> vector3 = null;
        Vector vector4 = JRptUtil.getRptFiles(file, this.INFO);
        int n = vector4 == null ? 0 : vector4.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector4.elementAt(n2);
            if (rptResourceNode == null) {
                if (bl) {
                    if (vector2 == null) {
                        vector2 = new Vector<String>(1);
                    }
                    vector2.addElement("(Rpt)" + string);
                } else {
                    if (vector3 == null) {
                        vector3 = new Vector<String>(1);
                    }
                    vector3.addElement("(RptH)" + string);
                }
            } else {
                boolean bl2 = rptResourceNode.isVrtFileReachableAtLast(string);
                if (bl2) {
                    if (vector2 == null) {
                        vector2 = new Vector(1);
                    }
                    vector2.addElement("(Rpt)" + string);
                } else if (!bl) {
                    if (vector3 == null) {
                        vector3 = new Vector(1);
                    }
                    vector3.addElement("(RptH)" + string);
                }
            }
            ++n2;
        }
        this.getExcpFiles(vector2, vector);
        this.getExcpFiles(vector3, vector);
    }

    private void getDefReachableOfSubnodes(File file, Vector vector, boolean bl, RptResourceNode rptResourceNode) throws UnknownMIMEType {
        int n;
        Vector<String> vector2 = null;
        Vector<String> vector3 = null;
        Vector<String> vector4 = null;
        Vector<String> vector5 = null;
        Vector<String> vector6 = null;
        Vector<String> vector7 = null;
        String[] stringArray = file.list((FilenameFilter)new WildcardMatcher("*", true, 4));
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (rptResourceNode == null) {
                if (bl) {
                    if (vector2 == null) {
                        vector2 = new Vector<String>(1);
                    }
                    vector2.addElement("(D)" + stringArray[n3]);
                } else {
                    if (vector5 == null) {
                        vector5 = new Vector<String>(1);
                    }
                    vector5.addElement("(DH)" + stringArray[n3]);
                }
            } else {
                n = rptResourceNode.isVrtFileReachableAtLast(stringArray[n3]);
                if (n != 0) {
                    if (vector2 == null) {
                        vector2 = new Vector(1);
                    }
                    vector2.addElement("(D)" + stringArray[n3]);
                } else if (!bl) {
                    if (vector5 == null) {
                        vector5 = new Vector(1);
                    }
                    vector5.addElement("(DH)" + stringArray[n3]);
                }
            }
            ++n3;
        }
        stringArray = file.list((FilenameFilter)new WildcardMatcher("*", true, 2));
        n2 = stringArray == null ? 0 : stringArray.length;
        n = 0;
        while (n < n2) {
            if (rptResourceNode == null) {
                if (bl) {
                    if (this.INFO.mimeCheck("application/x-jrcatalog", stringArray[n])) {
                        if (vector3 == null) {
                            vector3 = new Vector<String>(1);
                        }
                        vector3.addElement("(C)" + stringArray[n]);
                    } else {
                        if (vector4 == null) {
                            vector4 = new Vector<String>(1);
                        }
                        vector4.addElement("(F)" + stringArray[n]);
                    }
                } else if (this.INFO.mimeCheck("application/x-jrcatalog", stringArray[n])) {
                    if (vector6 == null) {
                        vector6 = new Vector<String>(1);
                    }
                    vector6.addElement("(CH)" + stringArray[n]);
                } else {
                    if (vector7 == null) {
                        vector7 = new Vector<String>(1);
                    }
                    vector7.addElement("(FH)" + stringArray[n]);
                }
            } else {
                boolean bl2 = rptResourceNode.isVrtFileReachableAtLast(stringArray[n]);
                if (bl2) {
                    if (this.INFO.mimeCheck("application/x-jrcatalog", stringArray[n])) {
                        if (vector3 == null) {
                            vector3 = new Vector(1);
                        }
                        vector3.addElement("(C)" + stringArray[n]);
                    } else {
                        if (vector4 == null) {
                            vector4 = new Vector(1);
                        }
                        vector4.addElement("(F)" + stringArray[n]);
                    }
                } else if (!bl) {
                    if (this.INFO.mimeCheck("application/x-jrcatalog", stringArray[n])) {
                        if (vector6 == null) {
                            vector6 = new Vector(1);
                        }
                        vector6.addElement("(CH)" + stringArray[n]);
                    } else {
                        if (vector7 == null) {
                            vector7 = new Vector(1);
                        }
                        vector7.addElement("(FH)" + stringArray[n]);
                    }
                }
            }
            ++n;
        }
        this.getExcpFiles(vector3, vector);
        this.getExcpFiles(vector2, vector);
        this.getExcpFiles(vector4, vector);
        this.getExcpFiles(vector6, vector);
        this.getExcpFiles(vector5, vector);
        this.getExcpFiles(vector7, vector);
    }

    private String getDescription(StringTokenizer stringTokenizer) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (stringTokenizer.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append("/" + stringTokenizer.nextElement());
                continue;
            }
            stringBuffer.append(stringTokenizer.nextElement());
        }
        return stringBuffer.toString();
    }

    private void getExcpFiles(Vector vector, Vector vector2) {
        if (vector != null) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            StringSorter.sortString((String[])objectArray, (boolean)true);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                vector2.addElement(objectArray[n2]);
                ++n2;
            }
        }
    }
}

