/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resource;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.api.exception.NoSuchUserException;
import jet.server.resource.AliasInfoForDefaultUser;
import jet.server.resource.AliasInfoForNormalUser;
import jet.server.resource.AliasInfoWithoutSecurity;
import jet.server.resource.AliasTableError;
import jet.server.resource.GenericAliasInfo;
import jet.server.resource.ResourceInfo;
import jet.server.resource.RptResourceManager;

public class UsersAliasManager {
    private Hashtable QOIV = new Hashtable();
    private String checkCatAlias = null;
    private RptResourceManager createHashtable = null;
    private AliasInfoWithoutSecurity equals = null;

    public UsersAliasManager(RptResourceManager rptResourceManager) {
        this.createHashtable = rptResourceManager;
        this.checkCatAlias = rptResourceManager.getResourceInfo().getDefaultUserName(rptResourceManager.getRealm());
        if (!rptResourceManager.needSecurity()) {
            this.equals = new AliasInfoWithoutSecurity(rptResourceManager.getResourceTreeMan());
        }
        this.createHashtable();
    }

    public ResourceInfo getResourceInfo() {
        return this.createHashtable.getResourceInfo();
    }

    public String getRealm() {
        return this.createHashtable.getRealm();
    }

    public RptResourceManager getResourceManager() {
        return this.createHashtable;
    }

    public void createHashtable() {
        ResourceInfo resourceInfo = this.createHashtable.getResourceInfo();
        String string = this.createHashtable.getRealm();
        ExProperties exProperties = resourceInfo.getDefaultAliasTab(string);
        ExProperties exProperties2 = resourceInfo.getDefaultAliasPropValue(string);
        try {
            AliasInfoForDefaultUser aliasInfoForDefaultUser = new AliasInfoForDefaultUser(this.createHashtable.getResourceInfo(), string, this.checkCatAlias, this.createHashtable.getResourceTreeMan(), exProperties, exProperties2);
            this.QOIV.put(this.checkCatAlias, aliasInfoForDefaultUser);
        }
        catch (AliasTableError aliasTableError) {
            this.QOIV.put(this.checkCatAlias, aliasTableError);
        }
    }

    public GenericAliasInfo getAliasInfoAcrdToSecurity(String string) throws NoSuchUserException, AliasTableError {
        if (this.createHashtable.needSecurity()) {
            return this.getAliasInfo(string);
        }
        return this.equals;
    }

    public GenericAliasInfo getAliasInfo(String string) throws NoSuchUserException, AliasTableError {
        GenericAliasInfo genericAliasInfo = (GenericAliasInfo)this.QOIV.get(string);
        if (genericAliasInfo == null) {
            ResourceInfo resourceInfo = this.createHashtable.getResourceInfo();
            String string2 = this.createHashtable.getRealm();
            ExProperties exProperties = resourceInfo.getAliasTable(string2, string);
            ExProperties exProperties2 = resourceInfo.getAliasPropValue(string2, string);
            Object v = this.QOIV.get(this.checkCatAlias);
            AliasInfoForDefaultUser aliasInfoForDefaultUser = null;
            if (v instanceof AliasInfoForDefaultUser) {
                aliasInfoForDefaultUser = (AliasInfoForDefaultUser)v;
            }
            AliasInfoForNormalUser aliasInfoForNormalUser = new AliasInfoForNormalUser(this.createHashtable.getResourceInfo(), string2, string, this.createHashtable.getResourceTreeMan(), exProperties, exProperties2, aliasInfoForDefaultUser);
            this.QOIV.put(string, aliasInfoForNormalUser);
            return aliasInfoForNormalUser;
        }
        return genericAliasInfo;
    }

    public GenericAliasInfo reload(String string) throws NoSuchUserException, AliasTableError {
        this.QOIV.remove(string);
        return this.getAliasInfo(string);
    }

    public void resetNormalUserAliasTree() {
        Enumeration enumeration = this.QOIV.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (this.QOIV.get(k) instanceof AliasInfoForDefaultUser) continue;
            this.QOIV.remove(k);
        }
    }

    public GenericAliasInfo createNewAliasInfo(String string) {
        try {
            if (string.equals(this.checkCatAlias)) {
                return new AliasInfoForDefaultUser(this.createHashtable.getResourceInfo(), this.createHashtable.getRealm(), string, this.createHashtable.getResourceTreeMan(), null, null);
            }
            Object v = this.QOIV.get(this.checkCatAlias);
            AliasInfoForDefaultUser aliasInfoForDefaultUser = null;
            if (v instanceof AliasInfoForDefaultUser) {
                aliasInfoForDefaultUser = (AliasInfoForDefaultUser)v;
            }
            return new AliasInfoForNormalUser(this.createHashtable.getResourceInfo(), this.createHashtable.getRealm(), string, this.createHashtable.getResourceTreeMan(), null, null, aliasInfoForDefaultUser);
        }
        catch (AliasTableError aliasTableError) {
            return null;
        }
    }

    public void setAliasInfo(GenericAliasInfo genericAliasInfo) {
        this.QOIV.put(genericAliasInfo.getUserName(), genericAliasInfo);
    }

    public boolean isAuthorized(String string) {
        String[] stringArray = this.createHashtable.getResourceInfo().getAllUsers(this.createHashtable.getRealm());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                this.getAliasInfo(stringArray[n2]);
            }
            catch (AliasTableError aliasTableError) {
            }
            catch (NoSuchUserException noSuchUserException) {
                // empty catch block
            }
            ++n2;
        }
        Enumeration enumeration = this.QOIV.keys();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            GenericAliasInfo genericAliasInfo;
            String string2;
            Object v = this.QOIV.get(enumeration.nextElement());
            if (!(v instanceof GenericAliasInfo) || (string2 = (genericAliasInfo = (GenericAliasInfo)v).getResourceName(string, stringBuffer)) == null) continue;
            return true;
        }
        return false;
    }

    public String[] checkAlias(String string, Vector vector, Vector vector2, boolean bl) {
        Enumeration enumeration = this.QOIV.keys();
        Object var8_6 = null;
        String[] stringArray = null;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            GenericAliasInfo genericAliasInfo = (GenericAliasInfo)this.QOIV.get(string2);
            stringArray = genericAliasInfo.checkCatAlias(string, vector, vector2, bl);
            if (stringArray != null) break;
        }
        return stringArray;
    }
}

