/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rmi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.Random;
import java.util.Vector;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.rmi.JRRMISocketFactory;
import jet.server.rmi.RemoteObjectProxy;
import jet.server.rmi.RemoteObjectProxyImpl;

public class RemoteObjectFactory {
    private static String QOIV = "rmi.auth";
    private static String addElement = null;
    private static RemoteObjectProxyImpl append = null;
    private static Registry arraycopy = null;
    private static Object bind = null;
    private static boolean contains = false;
    private static Vector createRegistry = null;
    private static boolean currentTimeMillis = false;

    public static String getRandomAuthString() {
        int n = 32;
        byte[] byArray = new byte[n];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(byArray);
        String string = RemoteObjectFactory.QOIV(byArray);
        append.I(string);
        return string;
    }

    private static String QOIV(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(byArray[n]);
            stringBuffer.append(",");
            ++n;
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return "";
    }

    private static Object addElement(String string) {
        byte[] byArray;
        block8: {
            String string2 = System.getProperty("jrs.rmi.auth_string");
            byArray = null;
            if (string2 == null) {
                String string3 = System.getProperty("jrs.rmi.auth_file");
                if (string3 != null) {
                    byArray = RemoteObjectFactory.append(string3);
                }
            } else {
                try {
                    byArray = string2.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!ServiceLogger.isLoggable(2, 3)) break block8;
                    ServiceLogger.logError(unsupportedEncodingException, 3);
                }
            }
        }
        if (byArray == null && addElement != null) {
            byArray = RemoteObjectFactory.append(addElement);
        }
        if (byArray == null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            byArray = RemoteObjectFactory.append(string + "bin" + File.separator + QOIV);
        }
        return byArray;
    }

    private static byte[] append(String string) {
        byte[] byArray;
        block6: {
            byArray = null;
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] byArray2 = new byte[1024];
                    int n = fileInputStream.read(byArray2);
                    if (n == -1) break block6;
                    if (n < 1024) {
                        byArray = new byte[n];
                        System.arraycopy(byArray2, 0, byArray, 0, n);
                        break block6;
                    }
                    byArray = byArray2;
                }
                catch (Exception exception) {
                    if (ServiceLogger.isLoggable(2, 3)) {
                        ServiceLogger.logError(exception, 3);
                    }
                    break block6;
                }
            }
            if (ServiceLogger.isLoggable(2, 3)) {
                ServiceLogger.logError(3670005, string, 3);
            }
        }
        return byArray;
    }

    public static void initAuthInfo(String string) {
        if (contains && bind != null) {
            return;
        }
        bind = RemoteObjectFactory.addElement(string);
    }

    public static void init(int n, String string) {
        if (contains) {
            return;
        }
        if (!currentTimeMillis) {
            try {
                RMISocketFactory.setSocketFactory((RMISocketFactory)((Object)new JRRMISocketFactory()));
            }
            catch (IOException iOException) {
                ServiceLogger.logError(2670006, 2);
            }
            catch (SecurityException securityException) {
                ServiceLogger.logError(2670007, 2);
            }
        }
        RemoteObjectFactory.initAuthInfo(string);
        append = RemoteObjectProxyImpl.newInstance(bind, currentTimeMillis);
        try {
            block9: {
                try {
                    arraycopy = LocateRegistry.createRegistry(n);
                }
                catch (RemoteException remoteException) {
                    if (HttpUtil.isStandaloneServer()) break block9;
                    arraycopy = LocateRegistry.getRegistry(n);
                }
            }
            arraycopy.list();
            arraycopy.bind("JReportRemoteObjectProxy", append);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 1);
            return;
        }
        createRegistry = new Vector();
        contains = true;
    }

    public static boolean isStartedRMI() {
        return contains;
    }

    public static void quit() {
        block4: {
            bind = null;
            if (!contains) {
                return;
            }
            try {
                arraycopy.unbind("JReportRemoteObjectProxy");
                int n = 0;
                while (n < createRegistry.size()) {
                    arraycopy.unbind((String)createRegistry.elementAt(n));
                    ++n;
                }
            }
            catch (Exception exception) {
                if (!ServiceLogger.isLoggable(2, 3)) break block4;
                ServiceLogger.logError(exception, 3);
            }
        }
        append = null;
        RemoteObjectProxyImpl.releaseInstance();
        arraycopy = null;
        createRegistry.removeAllElements();
        createRegistry = null;
        contains = false;
    }

    public static void register(String string, Remote remote) {
        RemoteObjectFactory.register(string, remote, false);
    }

    public static void register(String string, Remote remote, boolean bl) {
        if (contains) {
            append.register(string, remote);
            if (bl) {
                try {
                    arraycopy.bind(string, remote);
                    createRegistry.addElement(string);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
        }
    }

    public static void unregister(String string) {
        block3: {
            append.unregister(string);
            if (createRegistry.contains(string)) {
                try {
                    arraycopy.unbind(string);
                }
                catch (Exception exception) {
                    if (!ServiceLogger.isLoggable(2, 2)) break block3;
                    ServiceLogger.logError(exception, 2);
                }
            }
        }
    }

    public static Remote getRemoteObject(String string) throws RemoteException {
        Remote remote = append.getRemoteObject(string, bind);
        if (remote == null) {
            throw new RemoteException("No such remote object: " + string);
        }
        return remote;
    }

    public static Remote getRemoteObject(String string, int n, String string2) throws MalformedURLException, NotBoundException, RemoteException {
        String string3 = "//" + string + ":" + n + "/" + "JReportRemoteObjectProxy";
        RemoteObjectProxy remoteObjectProxy = (RemoteObjectProxy)Naming.lookup(string3);
        Remote remote = remoteObjectProxy.getRemoteObject(string2, bind);
        if (remote == null) {
            throw new NotBoundException("//" + string + ":" + n + "/" + string2);
        }
        return remote;
    }

    public static void setAuthFile(String string) {
        addElement = string;
    }

    public static void setIsMonitorServer(boolean bl) {
        currentTimeMillis = bl;
    }
}

