/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectProxy;

public class RemoteObjectProxyImpl
extends UnicastRemoteObject
implements RemoteObjectProxy {
    private static final long serialVersionUID = 1600477764005861940L;
    private static RemoteObjectProxyImpl QOIV = null;
    private byte[] addElement = null;
    private Hashtable clear = new Hashtable(12);
    private Vector contains = new Vector();

    public static RemoteObjectProxyImpl newInstance(Object object, boolean bl) {
        if (QOIV == null) {
            try {
                QOIV = bl ? new RemoteObjectProxyImpl(object, bl) : new RemoteObjectProxyImpl(object);
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
            }
        }
        return QOIV;
    }

    public static void releaseInstance() {
        if (QOIV != null) {
            QOIV.quit();
            QOIV = null;
        }
    }

    private RemoteObjectProxyImpl(Object object) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.addElement = (byte[])object;
    }

    private RemoteObjectProxyImpl(Object object, boolean bl) throws RemoteException {
        this.addElement = (byte[])object;
    }

    public void register(String string, Remote remote) {
        this.clear.put(string, remote);
    }

    public void unregister(String string) {
        this.clear.remove(string);
    }

    public Remote getRemoteObject(String string, Object object) throws RemoteException {
        if (this.isPassed(string, object)) {
            return (Remote)this.clear.get(string);
        }
        throw new RemoteException("Fail to pass authInfo check");
    }

    private boolean isPassed(String string, Object object) {
        boolean bl;
        block12: {
            bl = false;
            if (string.startsWith("MonitorCounter")) {
                if (this.contains.contains(object)) {
                    bl = true;
                    this.contains.remove(object);
                }
            } else if (this.addElement == null) {
                if (object == null) {
                    bl = true;
                }
            } else if (object != null) {
                try {
                    byte[] byArray = (byte[])object;
                    if (this.addElement.length == byArray.length) {
                        int n = 0;
                        while (n < byArray.length) {
                            if (this.addElement[n] != byArray[n]) break;
                            ++n;
                        }
                        if (n >= byArray.length) {
                            bl = true;
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    if (!ServiceLogger.isLoggable(2, 3)) break block12;
                    ServiceLogger.logError(classCastException, 3);
                }
            }
        }
        return bl;
    }

    void I(Object object) {
        this.contains.addElement(object);
    }

    private void quit() {
        if (this.clear != null) {
            Enumeration enumeration = this.clear.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Remote remote = (Remote)this.clear.get(string);
                try {
                    UnicastRemoteObject.unexportObject(remote, true);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    ServiceLogger.logDebug(4670124, remote, 4);
                }
            }
        }
        try {
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            ServiceLogger.logDebug(4670124, this, 4);
        }
        QOIV = null;
        this.addElement = null;
        this.clear.clear();
        this.clear = null;
        if (this.contains != null) {
            this.contains.clear();
            this.contains = null;
        }
    }
}

