/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.schedule.Committer;

public class CommitRunner
implements Runnable {
    private Committer QOIV = null;
    long commit;
    boolean currentTimeMillis = false;
    private boolean getCommitInterval = false;
    private long logError = 0L;
    private Object logEvent = new Object();
    private long setPriority = 0L;

    public CommitRunner(Committer committer) {
        this.QOIV = committer;
        this.commit = (long)ServerEnv.getCommitInterval() * 1000L;
        if (this.commit > 600000L) {
            this.commit = 600000L;
        }
        ServiceLogger.logEvent(5610001, new Object[]{committer, new Long(this.commit)}, 5);
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServiceLogger.logEvent(5610002, 5);
        while (!this.currentTimeMillis) {
            try {
                Object object = this.logEvent;
                synchronized (object) {
                    this.logEvent.wait(this.commit);
                }
                this.commit();
                if (!this.currentTimeMillis) continue;
                break;
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    public void stop() {
        this.currentTimeMillis = true;
    }

    private void commit() throws Exception {
        if (this.QOIV()) {
            this.QOIV.commit();
            this.getCommitInterval = false;
        }
    }

    private boolean QOIV() {
        if (!this.getCommitInterval) {
            return false;
        }
        return System.currentTimeMillis() - this.logError >= this.commit;
    }

    public void notifyCommit() {
        this.logError = System.currentTimeMillis();
        this.getCommitInterval = true;
    }
}

