/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.io.File;
import java.rmi.RemoteException;
import java.util.Vector;
import jet.cs.util.APIUtil;
import jet.server.api.ResultFiles;
import jet.server.api.http.HttpUtil;
import jet.server.jrrmisvr.ServiceLogger;

public class JRResultFiles
implements ResultFiles {
    public static final int RST_FORMAT = 0;
    public static final int HTML_FORMAT = 1;
    public static final int PDF_FORMAT = 2;
    public static final int TEXT_FORMAT = 3;
    public static final int EXCEL_FORMAT = 4;
    public static final int POSTSCRIPT_FORMAT = 5;
    public static final int RTF_FORMAT = 6;
    public static final int XML_FORMAT = 7;
    public static final int AST_FORMAT = 8;
    public static final int CSV_FORMAT = 9;
    public static final int TIFF_FORMAT = 10;
    public static final int SVG_FORMAT = 11;
    public static final int RSD_FORMAT = 12;
    private String QOIV = null;
    private String addElement = null;
    public static final String[] suffixs = new String[]{".rst", ".html", ".pdf", ".txt", ".xls", ".ps", ".rtf", ".xml", ".ast", ".csv", ".tiff", ".svg", ".rsd"};
    private String addFormat = null;
    private long append = 0L;
    private long endsWith = 0L;
    private long equalsIgnoreCase = 0L;
    private long exists = 0L;
    private int getHistFile = -1;
    private String[] getHtmlFileName = new String[13];

    public static int getFormat(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return n;
            }
            case 8: {
                return 12;
            }
        }
        return -1;
    }

    public JRResultFiles(String string, String string2) {
        this(string, string2, 0L, 0L, 0L);
    }

    public JRResultFiles(String string, String string2, long l, long l2, long l3) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        this.addFormat = string;
        this.endsWith = l;
        this.equalsIgnoreCase = l2;
        this.exists = l3;
        this.addFormat(this.getIndexOfFormat(string2));
    }

    public JRResultFiles(String string, long l, long l2, long l3, long l4, int n) {
        this.addFormat = string;
        this.append = l;
        this.endsWith = l2;
        this.equalsIgnoreCase = l3;
        this.exists = l4;
        this.getHistFile = n;
        int n2 = 0;
        while (n2 < 13) {
            if (this.addElement(l, n2)) {
                this.getHtmlFileName[n2] = string + suffixs[n2];
            }
            ++n2;
        }
    }

    public String getSharedPrefix() {
        return this.addFormat;
    }

    public long getResultFormats() {
        return this.append;
    }

    public long getFormatViewedStatus() {
        return this.endsWith;
    }

    public Vector getResultFileNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < 13) {
            if (this.getHtmlFileName[n] != null) {
                if (n == 1) {
                    vector.addElement(this.getHtmlFileName());
                } else {
                    vector.addElement(this.getHtmlFileName[n]);
                }
            }
            ++n;
        }
        return vector;
    }

    public void addFormat(int n) {
        this.QOIV(n, null);
    }

    private void QOIV(int n, String string) {
        String string2;
        if (n < 0 || n >= 13) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        if (string == null) {
            string = this.addFormat;
        }
        if (!(string2 = string).endsWith(suffixs[n])) {
            if (string2.toLowerCase().endsWith(suffixs[n])) {
                int n2 = string2.lastIndexOf(".");
                string2 = string2.substring(0, n2) + suffixs[n];
            } else {
                string2 = string2 + suffixs[n];
            }
        }
        this.getHtmlFileName[n] = string2;
        this.append = this.addFormat(this.append, n, true);
    }

    public void removeFormat(int n) {
        if (n < 0 || n >= 13) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.getHtmlFileName[n] = null;
        this.append = this.addFormat(this.append, n, false);
    }

    public void setFormat(int n, boolean bl) {
        if (n < 0 || n >= 13) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.append = this.addFormat(this.append, n, bl);
    }

    public void setFormatViewed(int n) {
        if (n < 0 || n >= 13) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.endsWith = this.addFormat(this.endsWith, n, true);
    }

    public void setPLSResult(int n) {
        if (n < 0 || n >= 13) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.equalsIgnoreCase = this.addFormat(this.equalsIgnoreCase, n, true);
    }

    public void setSecConstraint(int n) {
        if (n < 0 || n >= 13) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.exists = this.addFormat(this.exists, n, true);
    }

    public int getIndexOfFormat(String string) {
        int n = 0;
        while (n < 13 && !suffixs[n].equalsIgnoreCase(string)) {
            ++n;
        }
        return n;
    }

    private boolean addElement(long l, int n) {
        return (l & (long)(1 << n)) != 0L;
    }

    private long addFormat(long l, int n, boolean bl) {
        if (bl) {
            return l | (long)(1 << n);
        }
        return l & (long)(~(1 << n));
    }

    public boolean hasRstFile() {
        return this.addElement(this.append, 0);
    }

    public String getRstFileName() {
        return this.getHtmlFileName[0];
    }

    public boolean hasHtmlFile() {
        return this.addElement(this.append, 1);
    }

    public String getHtmlFileName() {
        String string = this.getHtmlFileName[1];
        if (string != null) {
            String string2 = HttpUtil.getHttpRptServer().getResourceManager().getHistFile(string);
            if (HttpUtil.isRemoteServer()) {
                try {
                    if (!HttpUtil.getRemoteFileService().exists(string2)) {
                        string = APIUtil.removeExtName(string) + "_1" + ".html";
                    }
                }
                catch (RemoteException remoteException) {
                    ServiceLogger.logError(remoteException);
                }
            } else if (!new File(string2).exists()) {
                string = APIUtil.removeExtName(string) + "_1" + ".html";
            }
        }
        return string;
    }

    public boolean hasPdfFile() {
        return this.addElement(this.append, 2);
    }

    public String getPdfFileName() {
        return this.getHtmlFileName[2];
    }

    public boolean hasExcelFile() {
        return this.addElement(this.append, 4);
    }

    public String getExcelFileName() {
        return this.getHtmlFileName[4];
    }

    public boolean hasXmlFile() {
        return this.addElement(this.append, 7);
    }

    public String getXmlFileName() {
        return this.getHtmlFileName[7];
    }

    public boolean hasPostScriptFile() {
        return this.addElement(this.append, 5);
    }

    public String getPostScriptFileName() {
        return this.getHtmlFileName[5];
    }

    public boolean hasTextFile() {
        boolean bl = false;
        bl = this.addElement(this.append, 3);
        if (!bl) {
            bl = this.addElement(this.append, 9);
        }
        return bl;
    }

    public String getTextFileName() {
        return this.getHtmlFileName[3] == null ? this.getHtmlFileName[9] : this.getHtmlFileName[3];
    }

    public boolean hasRtfFile() {
        return this.addElement(this.append, 6);
    }

    public String getRtfFileName() {
        return this.getHtmlFileName[6];
    }

    public boolean hasAstFile() {
        return this.addElement(this.append, 8);
    }

    public String getAstFileName() {
        return this.getHtmlFileName[8];
    }

    public String toString() {
        return "JRResultFiles[" + this.addFormat + ":" + this.append + ", " + this.getHistFile + "]";
    }

    public boolean hasTiffFile() {
        return this.addElement(this.append, 10);
    }

    public String getTiffFileName() {
        return this.getHtmlFileName[10];
    }

    public boolean hasSvgFile() {
        return this.addElement(this.append, 11);
    }

    public String getSvgFileName() {
        return this.getHtmlFileName[11];
    }

    public boolean hasRsdFile() {
        return this.addElement(this.append, 12);
    }

    public String getRsdFileName() {
        return this.getHtmlFileName[12];
    }

    public boolean isAnalysisResult() {
        return this.getHistFile != -1;
    }

    public int getAnalysisReportAmount() {
        return this.getHistFile;
    }

    public String getReportName() {
        return this.QOIV;
    }

    public String getReportDisplayName() {
        return this.addElement;
    }

    public void setReportName(String string) {
        this.QOIV = string;
    }

    public void setReportDisplayName(String string) {
        this.addElement = string;
    }

    public boolean isViewedExcelFile() {
        return this.addElement(this.endsWith, 4);
    }

    public boolean isViewedHtmlFile() {
        return this.addElement(this.endsWith, 1);
    }

    public boolean isViewedPdfFile() {
        return this.addElement(this.endsWith, 2);
    }

    public boolean isViewedPostScriptFile() {
        return this.addElement(this.endsWith, 5);
    }

    public boolean isViewedRsdFile() {
        return this.addElement(this.endsWith, 12);
    }

    public boolean isViewedRstFile() {
        return this.addElement(this.endsWith, 0);
    }

    public boolean isViewedRtfFile() {
        return this.addElement(this.endsWith, 6);
    }

    public boolean isViewedTextFile() {
        boolean bl = this.addElement(this.endsWith, 3);
        if (!bl) {
            bl = this.addElement(this.endsWith, 9);
        }
        return bl;
    }

    public boolean isViewedXmlFile() {
        return this.addElement(this.endsWith, 7);
    }

    public boolean isPLSHtmlFile() {
        return this.addElement(this.equalsIgnoreCase, 1);
    }

    public boolean isPLSRsdFile() {
        return this.addElement(this.equalsIgnoreCase, 12);
    }

    public boolean isSecurityConstraintHtmlFile() {
        return this.addElement(this.exists, 1);
    }

    public boolean isSecurityConstraintRsdFile() {
        return this.addElement(this.exists, 12);
    }

    public long getPlsResultBits() {
        return this.equalsIgnoreCase;
    }

    public long getSecConstraintBits() {
        return this.exists;
    }
}

