/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import jet.server.api.trigger.Trigger;
import jet.server.api.trigger.TriggerManager;
import jet.server.event.EventHandler;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.event.TopicEvent;
import jet.server.event.TopicEventImpl;
import jet.server.event.subscriber.SubscribeService;
import jet.server.jrc.JRSchedulingService;
import jet.server.log.ServiceLogger;
import jet.server.schedule.RepeatLaunchableObj;
import jet.server.schedule.ScheduledTask;
import jet.server.schedule.ScheduledTaskImpl;
import jet.server.schedule.Scheduler;
import jet.server.schedule.TimeLaunchableObj;
import jet.server.schedule.TriggerLaunchableObj;
import jet.server.trigger.ReferencableObj;
import jet.server.trigger.TriggerManagerImpl;

public final class ScheduleController
implements EventHandler {
    private static ScheduleController QOIV = null;
    private JRSchedulingService activate = null;
    private Scheduler add = null;
    private Subscriber addSelector = null;
    private List addTask = new ArrayList();
    private ScheduleControlBlock clear = new ScheduleControlBlock(this);

    public static ScheduleController getInstance() {
        return QOIV;
    }

    public ScheduleController(JRSchedulingService jRSchedulingService, Scheduler scheduler) {
        if (jRSchedulingService == null) {
            throw new IllegalArgumentException("schService can not be null.");
        }
        if (scheduler == null) {
            throw new IllegalArgumentException("scheduler can not be null.");
        }
        this.activate = jRSchedulingService;
        this.add = scheduler;
        SubscribeService subscribeService = SubscribeService.newInstance();
        this.addSelector = subscribeService.createSubscriber(this);
        SelectorImpl selectorImpl = new SelectorImpl("TRIGGER_FIRE", 32);
        selectorImpl.enableAll();
        this.addSelector.addSelector(selectorImpl);
        if (this.addSelector.isValid()) {
            this.start();
        }
        this.clear = new ScheduleControlBlock(this);
        QOIV = this;
    }

    public void start() {
        if (this.isStart()) {
            return;
        }
        try {
            this.addSelector.activate();
            ServiceLogger.logEvent("Subscriber for topic 'TRIGGER_FIRE' is activated.");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public boolean isStart() {
        return this.addSelector.isActive();
    }

    public void stop() {
        if (!this.isStart()) {
            return;
        }
        try {
            this.addSelector.deactivate();
            ServiceLogger.logEvent("Subscriber for topic 'TRIGGER_FIRE' is deactivated.");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        this.clear.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ScheduledTask scheduledTask) {
        if (scheduledTask != null) {
            ScheduleControlBlock scheduleControlBlock = this.clear;
            synchronized (scheduleControlBlock) {
                this.clear.addTask(scheduledTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delTask(ScheduledTask scheduledTask) {
        if (scheduledTask != null) {
            ScheduleControlBlock scheduleControlBlock = this.clear;
            synchronized (scheduleControlBlock) {
                this.clear.delTask(scheduledTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledTask getTask(String string) {
        ScheduleControlBlock scheduleControlBlock = this.clear;
        synchronized (scheduleControlBlock) {
            ScheduledTask scheduledTask = this.clear.getTask(string);
            return scheduledTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllTasks() {
        ArrayList arrayList = new ArrayList();
        ScheduleControlBlock scheduleControlBlock = this.clear;
        synchronized (scheduleControlBlock) {
            Iterator iterator = this.clear.I.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.startsWith("CRONAT_")) continue;
                HashSet hashSet = (HashSet)this.clear.I.get(string);
                Iterator iterator2 = hashSet.iterator();
                arrayList.add(iterator2.next());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllTasksBindTrigger(String string) {
        ArrayList arrayList = new ArrayList();
        ScheduleControlBlock scheduleControlBlock = this.clear;
        synchronized (scheduleControlBlock) {
            HashSet hashSet = (HashSet)this.clear.I.get(string);
            if (hashSet != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(TopicEvent topicEvent) {
        ScheduleControlBlock scheduleControlBlock = this.clear;
        synchronized (scheduleControlBlock) {
            Properties properties = (Properties)topicEvent.getData();
            String string = properties.getProperty("trigger.name");
            Object object = properties.get("trigger.data");
            HashSet hashSet = (HashSet)this.clear.I.get(string);
            if (hashSet == null) {
                return;
            }
            this.addTask.clear();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.addTask.add(iterator.next());
            }
            iterator = this.addTask.iterator();
            while (iterator.hasNext()) {
                ScheduledTask scheduledTask = (ScheduledTask)iterator.next();
                if (!scheduledTask.isEnabled()) continue;
                scheduledTask.setFlag(string, object);
                TimeLaunchableObj timeLaunchableObj = ((ScheduledTaskImpl)scheduledTask).getTimeLaunchableObj();
                if (scheduledTask.isReady()) {
                    this.activate.runTask(scheduledTask.getTaskDetail());
                    scheduledTask.resetAllFlags();
                    long l = System.currentTimeMillis();
                    if (!(timeLaunchableObj instanceof TriggerLaunchableObj)) {
                        if (!(timeLaunchableObj instanceof RepeatLaunchableObj)) {
                            this.delTask(scheduledTask);
                            continue;
                        }
                        if (!this.add.getAllLaunchables().contains(timeLaunchableObj)) {
                            this.delTask(scheduledTask);
                            continue;
                        }
                        ((RepeatLaunchableObj)timeLaunchableObj).setLastExeTime(l);
                        this.activate.updateLastExeTime(scheduledTask.getTaskId(), l);
                        continue;
                    }
                    ((TriggerLaunchableObj)timeLaunchableObj).setLastExeTime(l);
                    continue;
                }
                String string2 = timeLaunchableObj.getTask().getProperty("jrs.triggers.logic", "OR");
                if (!string.startsWith("CRONAT_") || !"AND2".equals(string2)) continue;
                if (!(timeLaunchableObj instanceof RepeatLaunchableObj)) {
                    this.delTask(scheduledTask);
                    continue;
                }
                if (this.add.getAllLaunchables().contains(timeLaunchableObj)) continue;
                this.delTask(scheduledTask);
            }
        }
    }

    public void fireTaskTimeReady(String string) {
        ScheduledTaskImpl scheduledTaskImpl = (ScheduledTaskImpl)this.getTask(string);
        if (scheduledTaskImpl != null) {
            Properties properties = new Properties();
            properties.setProperty("trigger.name", scheduledTaskImpl.getTimeFlagName());
            TopicEventImpl topicEventImpl = new TopicEventImpl("TRIGGER_FIRE", 0, properties);
            this.process(topicEventImpl);
        }
    }

    public void finalize() throws Throwable {
        this.addSelector.destroy();
        this.clear.clear();
        this.clear = null;
        this.activate = null;
        this.add = null;
        QOIV = null;
        super.finalize();
    }

    private class ScheduleControlBlock {
        Hashtable I;
        private final ScheduleController this$0;

        public ScheduleControlBlock(ScheduleController scheduleController) {
            this.this$0 = scheduleController;
            this.I = new Hashtable();
        }

        public void addTask(ScheduledTask scheduledTask) {
            Iterator iterator = scheduledTask.getAllFlagsName().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                HashSet hashSet = null;
                if (this.I.containsKey(string)) {
                    hashSet = (HashSet)this.I.get(string);
                } else {
                    hashSet = new HashSet();
                    this.I.put(string, hashSet);
                }
                hashSet.add(scheduledTask);
            }
        }

        public void delTask(ScheduledTask scheduledTask) {
            TriggerManager triggerManager = TriggerManagerImpl.getInstance();
            Iterator iterator = scheduledTask.getAllFlagsName().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.I.containsKey(string)) continue;
                HashSet hashSet = (HashSet)this.I.get(string);
                hashSet.remove(scheduledTask);
                Trigger trigger = triggerManager.getTrigger(string);
                if (trigger != null) {
                    ((ReferencableObj)((Object)trigger)).decRef();
                }
                if (!hashSet.isEmpty()) continue;
                this.I.remove(string);
            }
        }

        public ScheduledTask getTask(String string) {
            String string2 = "CRONAT_" + Integer.toHexString(string.hashCode());
            HashSet hashSet = (HashSet)this.I.get(string2);
            if (hashSet != null) {
                Iterator iterator = hashSet.iterator();
                return (ScheduledTask)iterator.next();
            }
            return null;
        }

        public void clear() {
            Iterator iterator = this.I.values().iterator();
            while (iterator.hasNext()) {
                HashSet hashSet = (HashSet)iterator.next();
                hashSet.clear();
            }
            this.I.clear();
        }
    }
}

