/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import jet.server.api.trigger.Trigger;
import jet.server.api.trigger.TriggerManager;
import jet.server.schedule.JetLch;
import jet.server.schedule.ScheduledTask;
import jet.server.schedule.TimeLaunchableObj;
import jet.server.schedule.TriggerLaunchableObj;
import jet.server.trigger.ReferencableObj;
import jet.server.trigger.TriggerManagerImpl;
import jet.server.util.StringUtil;

public class ScheduledTaskImpl
implements ScheduledTask {
    public static final String TRIGGERS_ARRAY = "jrs.triggers";
    public static final String TRIGGERS_LOGIC = "jrs.triggers.logic";
    public static final String TRIGGERS_STATE = "jrs.triggers.state";
    private TimeLaunchableObj QOIV = null;
    private HashMap append = new HashMap();
    private String clear = null;
    public static final String OP_ONLY = "ONLY";
    public static final String OP_OR = "OR";
    public static final String OP_AND = "AND";
    public static final String OP_AND2 = "AND2";
    public static final String TIME_FLAG = "CRONAT_";

    public ScheduledTaskImpl(TimeLaunchableObj timeLaunchableObj) {
        this.QOIV = timeLaunchableObj;
        this.clear = this.append();
        this.QOIV(this.getTaskDetail());
        if (timeLaunchableObj instanceof TriggerLaunchableObj) {
            this.setFlag(this.getTimeFlagName(), null);
        }
    }

    public final void setFlag(String string, Object object) {
        Flag flag = (Flag)this.append.get(string);
        if (flag != null) {
            flag.set();
            if (object != null) {
                this.getTaskDetail().put("TRGDATA_" + string, object);
            }
        }
        this.clear();
    }

    public final void resetAllFlags() {
        Iterator iterator = this.append.values().iterator();
        Properties properties = this.getTaskDetail();
        while (iterator.hasNext()) {
            Flag flag = (Flag)iterator.next();
            flag.reset();
            properties.remove("TRGDATA_" + flag.I);
        }
        if (this.QOIV instanceof TriggerLaunchableObj) {
            this.setFlag(this.getTimeFlagName(), null);
        }
        this.clear();
    }

    public final boolean isReady() {
        String string = this.getTaskDetail().getProperty(TRIGGERS_LOGIC);
        if (string == null || string.trim().length() == 0) {
            string = OP_OR;
            this.getTaskDetail().setProperty(TRIGGERS_LOGIC, string);
        }
        if (OP_ONLY.equals(string)) {
            Iterator iterator = this.append.values().iterator();
            while (iterator.hasNext()) {
                Flag flag = (Flag)iterator.next();
                if (!flag.isReady()) continue;
                return true;
            }
            return false;
        }
        if (OP_OR.equals(string)) {
            Iterator iterator = this.append.values().iterator();
            while (iterator.hasNext()) {
                Flag flag = (Flag)iterator.next();
                if (!flag.isReady()) continue;
                return true;
            }
            return false;
        }
        if (OP_AND.equals(string)) {
            Iterator iterator = this.append.values().iterator();
            while (iterator.hasNext()) {
                Flag flag = (Flag)iterator.next();
                if (flag.isReady()) continue;
                return false;
            }
            return true;
        }
        if (OP_AND2.equals(string)) {
            Flag flag;
            boolean bl = true;
            Iterator iterator = this.append.values().iterator();
            while (iterator.hasNext()) {
                flag = (Flag)iterator.next();
                if (flag.isReady()) continue;
                bl = false;
                break;
            }
            if (!bl && (flag = (Flag)this.append.get(this.getTimeFlagName())).isReady()) {
                flag.reset();
            }
            return bl;
        }
        return false;
    }

    public final Set getAllFlagsName() {
        return this.append.keySet();
    }

    public final String getTaskId() {
        return this.QOIV.getTaskId();
    }

    public final void setEnabled(boolean bl) {
        this.QOIV.setEnabled(bl);
    }

    public final boolean isEnabled() {
        return this.QOIV.isEnabled();
    }

    public final Properties getTaskDetail() {
        return this.QOIV.getTask();
    }

    public JetLch createJetLaunchable(Vector vector) {
        return this.getTimeLaunchableObj().createJetLaunchable(vector);
    }

    protected String getTimeFlagName() {
        return this.clear;
    }

    public TimeLaunchableObj getTimeLaunchableObj() {
        return this.QOIV;
    }

    protected void finalize() throws Throwable {
        this.append.clear();
        this.append = null;
        this.QOIV = null;
        super.finalize();
    }

    private void QOIV(Properties properties) {
        String[] stringArray;
        TriggerManager triggerManager = TriggerManagerImpl.getInstance();
        String string = properties.getProperty(TRIGGERS_ARRAY);
        if (string != null && string.trim().length() > 0) {
            stringArray = StringUtil.split(string, ",");
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                int n2 = Integer.parseInt(properties.getProperty("jrs.triggers.state$" + string2, "0"));
                Trigger trigger = null;
                trigger = triggerManager.getTrigger(string2);
                if (trigger != null) {
                    ((ReferencableObj)((Object)trigger)).incRef();
                    Flag flag = new Flag(this, string2);
                    if (n2 == 0) {
                        flag.reset();
                    } else {
                        flag.set();
                    }
                    this.append.put(string2, flag);
                }
                ++n;
            }
        }
        stringArray = new Flag(this, this.getTimeFlagName());
        this.append.put(stringArray.I, stringArray);
    }

    private String append() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TIME_FLAG).append(Integer.toHexString(this.getTaskId().hashCode()));
        return stringBuffer.toString();
    }

    private void clear() {
        Iterator iterator = this.append.values().iterator();
        Properties properties = this.getTaskDetail();
        while (iterator.hasNext()) {
            String string;
            Flag flag = (Flag)iterator.next();
            String string2 = flag.I;
            String string3 = string = flag.isReady() ? "1" : "0";
            if (string2.startsWith(TIME_FLAG)) continue;
            properties.setProperty("jrs.triggers.state$" + string2, string);
        }
    }

    private final class Flag {
        String I;
        boolean QOIV;
        private final ScheduledTaskImpl this$0;

        public Flag(ScheduledTaskImpl scheduledTaskImpl, String string) {
            this.this$0 = scheduledTaskImpl;
            this.QOIV = false;
            this.I = string;
        }

        public synchronized void set() {
            this.QOIV = true;
        }

        public synchronized void reset() {
            this.QOIV = false;
        }

        public synchronized boolean isReady() {
            return this.QOIV;
        }

        public String toString() {
            return this.I + ":" + (this.isReady() ? "1" : "0");
        }
    }
}

