/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.bursting;

import com.jinfonet.dataservice.relational.IRelationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.JREngine;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataBlockSet;
import jet.dataengine.api.DataBlockSetIDGenerator;
import jet.dataengine.api.DataBurstor;
import jet.dataengine.api.DataEngineFactory;
import jet.dataengine.api.JDataEngine;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.IOperatorInforFactory;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.jetc.ReadFailureException;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientSchema;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientServerInformation;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.reportLogic.objectInfo.bursting.RecipientMappingIdentifier;
import jet.rptservice.api.RawDataQueryCreator;
import jet.rptservice.api.exception.JRScheduleException;
import jet.server.schedule.bursting.RawDataQueryCreatorImpl;
import jet.universe.JetUUniverse;

public class BurstingExecutor {
    private JREngine QOIV;
    private boolean add;
    private String addElement;
    private Properties addSortInformation;
    private BurstingSchema[] burst = null;
    private boolean close;
    private boolean contains;
    private DataBlockSetIDGenerator createDataEngine;
    DataBlockSet createRawDataQuery;
    private final DataBlockSet createReference;
    private DataBurstor createSortExp;
    private int createSortInfo = 3000;
    private DataBlockSet createSortInfoCollector;
    Object createSortOp = new Object();
    private JDataEngine get;
    private int getBurstingDataSetNames = 0;

    public BurstingExecutor(JREngine jREngine, String string, boolean bl, Properties properties, BurstingSchema[] burstingSchemaArray, boolean bl2, boolean bl3, DataBlockSetIDGenerator dataBlockSetIDGenerator) {
        this.QOIV = jREngine;
        this.addElement = string;
        this.add = bl;
        this.addSortInformation = properties;
        this.burst = burstingSchemaArray;
        this.contains = bl2;
        this.close = bl3;
        this.createDataEngine = dataBlockSetIDGenerator;
        this.createRawDataQuery = this.createReference = new DataBlockSet(0, null, null, null, null);
    }

    public void setMaxFileNumberInFolder(int n) {
        this.createSortInfo = n;
    }

    public void init() throws DSException, JRScheduleException, JRStopEngineException, ReadFailureException {
        try {
            this.get = DataEngineFactory.createDataEngine();
            String[] stringArray = this.QOIV(this.burst);
            IRelationData[] iRelationDataArray = new IRelationData[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                iRelationDataArray[n] = this.contains(stringArray[n], this.burst);
                ++n;
            }
            IRelationData[] iRelationDataArray2 = new IRelationData[this.burst.length];
            int n2 = 0;
            while (n2 < iRelationDataArray2.length) {
                iRelationDataArray2[n2] = this.addElement(this.burst[n2]);
                ++n2;
            }
            this.createSortExp = new DataBurstor(this.createSortInfo);
            this.createSortExp.burst(iRelationDataArray, stringArray, iRelationDataArray2, this.burst, this.createReference, this.contains, this.createDataEngine, this.close);
            this.createSortInfoCollector = this.createSortExp.getNormalResult();
        }
        catch (DSException dSException) {
            this.createReference.setNext(this.createReference);
            throw dSException;
        }
        catch (JRScheduleException jRScheduleException) {
            this.createReference.setNext(this.createReference);
            throw jRScheduleException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            this.createReference.setNext(this.createReference);
            throw jRStopEngineException;
        }
        catch (Throwable throwable) {
            this.createReference.setNext(this.createReference);
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBlockSet getNextBurstingDataBlockSet() throws DSException {
        Object object = this.createSortOp;
        synchronized (object) {
            block4: {
                if (this.createRawDataQuery.getNext() != this.createReference) break block4;
                DataBlockSet dataBlockSet = null;
                return dataBlockSet;
            }
            DataBlockSet dataBlockSet = this.createRawDataQuery = this.createRawDataQuery.getNext();
            return dataBlockSet;
        }
    }

    public DataBlockSet getNonBurstingDataBlockSet() {
        return this.createSortInfoCollector;
    }

    public void runBurstingDataBlockFinished(int n) {
        this.createSortExp.releaseDataBlock(n);
    }

    public void exit() {
        this.createSortExp.close();
        this.QOIV = null;
    }

    private String[] QOIV(BurstingSchema[] burstingSchemaArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < burstingSchemaArray.length) {
            String[] stringArray = burstingSchemaArray[n].getBurstingDataSetNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!vector.contains(stringArray[n2])) {
                    vector.addElement(stringArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return vector.toArray(new String[vector.size()]);
    }

    private synchronized int add() {
        return ++this.getBurstingDataSetNames;
    }

    private IRelationData addElement(BurstingSchema burstingSchema) throws DSException, JRScheduleException, JRStopEngineException, ReadFailureException {
        JetUUniverse jetUUniverse = this.QOIV.getCurUniverse();
        BurstingRecipientSchema burstingRecipientSchema = burstingSchema.getBurstingRecipientSchema();
        String string = burstingRecipientSchema.getDatasourceName();
        String string2 = burstingRecipientSchema.getQueryName();
        String[] stringArray = this.burst(burstingRecipientSchema);
        Date date = this.QOIV.getEngineTools().getModifyDate();
        RawDataQueryCreatorImpl rawDataQueryCreatorImpl = new RawDataQueryCreatorImpl(jetUUniverse, string, string2, stringArray, this.addElement, date, this.addSortInformation, this.add);
        int n = this.add();
        JRawDataQuery jRawDataQuery = rawDataQueryCreatorImpl.createRawDataQuery(this.get, n, null);
        this.get.prepareQuery(new JQuery[]{jRawDataQuery});
        return this.get.getRelation(n);
    }

    private JRawDataQuery addSortInformation(String string, ISortExpression iSortExpression) throws DSException, JRScheduleException {
        RawDataQueryCreator rawDataQueryCreator = this.QOIV.getRawDataQueryCreator(string);
        if (rawDataQueryCreator == null) {
            return null;
        }
        int n = this.add();
        JRawDataQuery jRawDataQuery = rawDataQueryCreator.createRawDataQuery(this.get, n, iSortExpression);
        return jRawDataQuery;
    }

    private String[] burst(BurstingRecipientSchema burstingRecipientSchema) {
        ArrayList arrayList = new ArrayList();
        RecipientMappingIdentifier[] recipientMappingIdentifierArray = burstingRecipientSchema.getRecipientMappingIdentifiers();
        if (recipientMappingIdentifierArray != null) {
            int n = 0;
            while (n < recipientMappingIdentifierArray.length) {
                String string = recipientMappingIdentifierArray[n].getRecipientColumn();
                this.close(arrayList, string);
                ++n;
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(burstingRecipientSchema.getRecipientMappingMail());
        arrayList2.add(burstingRecipientSchema.getRecipientMappingFTP());
        arrayList2.add(burstingRecipientSchema.getRecipientMappingDisk());
        arrayList2.add(burstingRecipientSchema.getRecipientMappingServerVersionSystem());
        arrayList2.add((String)burstingRecipientSchema.getRecipientServerInformationUser());
        arrayList2.add((String)burstingRecipientSchema.getRecipientServerInformationGroup());
        arrayList2.add((String)burstingRecipientSchema.getRecipientServerInformationRole());
        int n = 0;
        while (n < arrayList2.size()) {
            Object e = arrayList2.get(n);
            if (e != null) {
                BurstingRecipientServerInformation burstingRecipientServerInformation;
                if (e instanceof String) {
                    this.close(arrayList, (String)e);
                } else if (e instanceof BurstingRecipientServerInformation && (burstingRecipientServerInformation = (BurstingRecipientServerInformation)e) != null) {
                    this.close(arrayList, burstingRecipientServerInformation.getRecipientMapping());
                }
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void close(List list, String string) {
        String string2 = string.toUpperCase();
        if (!list.contains(string2)) {
            list.add(string2);
        }
    }

    private IRelationData contains(String string, BurstingSchema[] burstingSchemaArray) throws ConditionException, DSException, JRScheduleException, JRStopEngineException {
        ISortExpression iSortExpression = this.createDataEngine(burstingSchemaArray);
        JRawDataQuery jRawDataQuery = this.addSortInformation(string, iSortExpression);
        if (iSortExpression != null) {
            jRawDataQuery.setSorter(iSortExpression);
        }
        this.get.prepareQuery(new JQuery[]{jRawDataQuery});
        return this.get.getRelation(jRawDataQuery.getQueryId());
    }

    private ISortExpression createDataEngine(BurstingSchema[] burstingSchemaArray) throws ConditionException {
        ISortExpression iSortExpression;
        Object object;
        String[][] stringArray = new String[burstingSchemaArray.length][];
        int n = 0;
        while (n < burstingSchemaArray.length) {
            stringArray[n] = this.createRawDataQuery(burstingSchemaArray[n]);
            ++n;
        }
        String[] stringArray2 = this.createReference(stringArray);
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        IOperatorFactory iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
        IOperatorInforFactory iOperatorInforFactory = ExpressionFactoryCreator.getIOperatorInforFactory();
        ISortInformationCollector iSortInformationCollector = iOperatorInforFactory.createSortInfoCollector();
        int n2 = 0;
        int n3 = stringArray2.length;
        while (n2 < n3) {
            object = stringArray2[n2];
            iSortExpression = iExpressionFactory.createReference((String)object);
            ISortInformation iSortInformation = iOperatorInforFactory.createSortInfo((IReference)iSortExpression, 1, false);
            iSortInformationCollector.addSortInformation(iSortInformation);
            ++n2;
        }
        object = iOperatorFactory.createSortOp(iSortInformationCollector);
        iSortExpression = iExpressionFactory.createSortExp(object);
        return iSortExpression;
    }

    private String[] createRawDataQuery(BurstingSchema burstingSchema) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BurstingRecipientSchema burstingRecipientSchema = burstingSchema.getBurstingRecipientSchema();
        RecipientMappingIdentifier[] recipientMappingIdentifierArray = burstingRecipientSchema.getRecipientMappingIdentifiers();
        if (recipientMappingIdentifierArray != null) {
            int n = 0;
            while (n < recipientMappingIdentifierArray.length) {
                String string = recipientMappingIdentifierArray[n].getBurstingKeyColumn().toUpperCase();
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                }
                ++n;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] createReference(String[][] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                int n2 = 0;
                while (n2 < stringArray[n].length) {
                    if (!vector.contains(stringArray[n][n2])) {
                        vector.addElement(stringArray[n][n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return vector.toArray(new String[vector.size()]);
    }
}

